/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.viewer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.animation.AnimationTimer;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.util.Pair;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.BoundingBoxMeshView;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.OcTreeMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.PlanarRegionsIntersectionsMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.PlanarRegionsMeshBuilder;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class SegmentationMeshViewer {
    private static final int SLOW_PACE_UPDATE_PERIOD = 2000;
    private static final int MEDIUM_PACE_UPDATE_PERIOD = 100;
    private static final int HIGH_PACE_UPDATE_PERIOD = 10;
    private final Group root = new Group();
    private final List<ScheduledFuture<?>> meshBuilderScheduledFutures = new ArrayList();
    private final MeshView planarRegionMeshView = new MeshView();
    private final MeshView intersectionsMeshView = new MeshView();
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)2, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CANCEL_AND_REPORT);
    private final AnimationTimer renderMeshAnimation;
    private final OcTreeMeshBuilder ocTreeViewer;
    private final PlanarRegionsMeshBuilder planarRegionsMeshBuilder;
    private final PlanarRegionsIntersectionsMeshBuilder intersectionsMeshBuilder;
    private final BoundingBoxMeshView boundingBoxMeshView;

    public SegmentationMeshViewer(REAUIMessager uiMessager) {
        this.ocTreeViewer = new OcTreeMeshBuilder(uiMessager, SegmentationModuleAPI.OcTreeEnable, SegmentationModuleAPI.OcTreeClear, SegmentationModuleAPI.RequestOcTree, SegmentationModuleAPI.RequestPlanarRegionSegmentation, SegmentationModuleAPI.UIOcTreeDepth, SegmentationModuleAPI.UIOcTreeColoringMode, SegmentationModuleAPI.UIOcTreeDisplayType, SegmentationModuleAPI.UIPlanarRegionHideNodes, SegmentationModuleAPI.OcTreeState, SegmentationModuleAPI.PlanarRegionsSegmentationState);
        this.planarRegionsMeshBuilder = new PlanarRegionsMeshBuilder(uiMessager, SegmentationModuleAPI.PlanarRegionsState, SegmentationModuleAPI.OcTreeEnable, SegmentationModuleAPI.PlanarRegionsPolygonizerClear, SegmentationModuleAPI.OcTreeClear, SegmentationModuleAPI.RequestPlanarRegions);
        this.intersectionsMeshBuilder = new PlanarRegionsIntersectionsMeshBuilder(uiMessager, SegmentationModuleAPI.OcTreeEnable, SegmentationModuleAPI.OcTreeClear, SegmentationModuleAPI.RequestPlanarRegionsIntersections, SegmentationModuleAPI.PlanarRegionsIntersectionState);
        this.boundingBoxMeshView = new BoundingBoxMeshView(uiMessager, SegmentationModuleAPI.UIOcTreeBoundingBoxShow, SegmentationModuleAPI.RequestBoundingBox, SegmentationModuleAPI.OcTreeBoundingBoxState);
        this.ocTreeViewer.getRoot().setMouseTransparent(true);
        this.boundingBoxMeshView.setMouseTransparent(true);
        this.root.getChildren().addAll((Object[])new Node[]{this.ocTreeViewer.getRoot(), this.planarRegionMeshView, this.intersectionsMeshView, this.boundingBoxMeshView});
        this.renderMeshAnimation = new AnimationTimer(){

            public void handle(long now) {
                SegmentationMeshViewer.this.ocTreeViewer.render();
                if (SegmentationMeshViewer.this.planarRegionsMeshBuilder.hasNewMeshAndMaterial()) {
                    SegmentationMeshViewer.this.updateMeshView(SegmentationMeshViewer.this.planarRegionMeshView, (Pair<Mesh, Material>)SegmentationMeshViewer.this.planarRegionsMeshBuilder.pollMeshAndMaterial());
                }
                if (SegmentationMeshViewer.this.intersectionsMeshBuilder.hasNewMeshAndMaterial()) {
                    SegmentationMeshViewer.this.updateMeshView(SegmentationMeshViewer.this.intersectionsMeshView, (Pair<Mesh, Material>)SegmentationMeshViewer.this.intersectionsMeshBuilder.pollMeshAndMaterial());
                }
            }
        };
        uiMessager.registerModuleMessagerStateListener(isMessagerOpen -> {
            if (isMessagerOpen) {
                this.start();
            } else {
                this.sleep();
            }
        });
    }

    public void start() {
        if (!this.meshBuilderScheduledFutures.isEmpty()) {
            return;
        }
        this.renderMeshAnimation.start();
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.ocTreeViewer, 0L, 2000L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.planarRegionsMeshBuilder, 0L, 100L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.intersectionsMeshBuilder, 0L, 100L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.boundingBoxMeshView, 0L, 100L, TimeUnit.MILLISECONDS));
    }

    public void sleep() {
        if (this.meshBuilderScheduledFutures.isEmpty()) {
            return;
        }
        this.renderMeshAnimation.stop();
        for (ScheduledFuture<?> scheduledFuture : this.meshBuilderScheduledFutures) {
            scheduledFuture.cancel(true);
        }
        this.meshBuilderScheduledFutures.clear();
    }

    public void stop() {
        this.sleep();
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void updateMeshView(MeshView meshViewToUpdate, Pair<Mesh, Material> meshMaterial) {
        meshViewToUpdate.setMesh((Mesh)meshMaterial.getKey());
        meshViewToUpdate.setMaterial((Material)meshMaterial.getValue());
    }

    public Node getRoot() {
        return this.root;
    }
}

