/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.properties;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import us.ihmc.tools.property.DoubleStoredPropertyKey;
import us.ihmc.tools.property.StoredPropertySet;

public abstract class ParametersProperty<T>
extends SimpleObjectProperty<T> {
    private final Map<InvalidationListener, Field> fieldInvalidationListeners = new HashMap<InvalidationListener, Field>();
    private final Map<InvalidationListener, EnumField> enumFieldInvalidationListeners = new HashMap<InvalidationListener, EnumField>();

    public ParametersProperty() {
    }

    public ParametersProperty(T initialValue) {
        super(initialValue);
    }

    public ParametersProperty(Object bean, String name) {
        super(bean, name);
    }

    public ParametersProperty(Object bean, String name, T initialValue) {
        super(bean, name, initialValue);
    }

    protected void bindFieldBidirectionalToNumberProperty(Property<? extends Number> property, Field field) {
        NumberBidirectionalBind binding = new NumberBidirectionalBind(property, field);
        this.setNumberValue(property, field);
        property.addListener((InvalidationListener)binding);
        field.addListener(binding);
    }

    protected void bindFieldBidirectionalToConditionalNumberProperty(Condition condition, Property<? extends Number> property, Field field) {
        ConditionalNumberBidirectionalBind binding = new ConditionalNumberBidirectionalBind(condition, property, field);
        this.setNumberValue(property, field);
        property.addListener((InvalidationListener)binding);
        field.addListener(binding);
    }

    protected void bindFieldBidirectionalToBooleanProperty(Property<Boolean> property, Field field) {
        BooleanBidirectionalBind binding = new BooleanBidirectionalBind(property, field);
        this.setBooleanValue(property, field);
        property.addListener((InvalidationListener)binding);
        field.addListener(binding);
    }

    protected <E extends Enum<E>> void bindFieldBidirectionalToEnumProperty(Property<E> property, EnumField<E> field) {
        EnumBidirectionalBind binding = new EnumBidirectionalBind(property, field);
        property.setValue(field.getEnum(this.getValue()));
        property.addListener(binding);
        field.addListener(binding);
    }

    protected abstract T getValueCopy(T var1);

    private void setNumberValue(Property<? extends Number> numberProperty, Field field) {
        if (numberProperty.getValue() instanceof Double) {
            numberProperty.setValue((Object)new Double(field.getNumber(this.getValue()).doubleValue()));
        } else if (numberProperty.getValue() instanceof Integer) {
            numberProperty.setValue((Object)new Integer(field.getNumber(this.getValue()).intValue()));
        } else if (numberProperty.getValue() instanceof Float) {
            numberProperty.setValue((Object)new Float(field.getNumber(this.getValue()).floatValue()));
        } else if (numberProperty.getValue() instanceof Long) {
            numberProperty.setValue((Object)new Long(field.getNumber(this.getValue()).longValue()));
        } else if (numberProperty.getValue() instanceof Short) {
            numberProperty.setValue((Object)new Short(field.getNumber(this.getValue()).shortValue()));
        } else if (numberProperty.getValue() instanceof Byte) {
            numberProperty.setValue((Object)new Byte(field.getNumber(this.getValue()).byteValue()));
        } else {
            throw new RuntimeException("Unhandled instance of Number: " + ((Number)numberProperty.getValue()).getClass().getSimpleName());
        }
    }

    private void setBooleanValue(Property<Boolean> booleanProperty, Field field) {
        booleanProperty.setValue((Object)ParametersProperty.getNumberAsBoolean(field.getNumber(this.getValue())));
    }

    private static Number getBooleanAsNumber(Boolean bool) {
        return bool != false ? 1 : 0;
    }

    private static boolean getNumberAsBoolean(Number number) {
        int intValue = number.intValue();
        if (intValue == 1) {
            return true;
        }
        if (intValue == 0) {
            return false;
        }
        throw new RuntimeException("Unhandled number to set as boolean: " + intValue);
    }

    protected void fireValueChangedEvent() {
        super.fireValueChangedEvent();
        for (Map.Entry<InvalidationListener, Field> entry : this.fieldInvalidationListeners.entrySet()) {
            entry.getKey().invalidated((Observable)entry.getValue());
        }
        for (Map.Entry<InvalidationListener, Object> entry : this.enumFieldInvalidationListeners.entrySet()) {
            entry.getKey().invalidated((Observable)entry.getValue());
        }
    }

    private class BooleanBidirectionalBind
    implements InvalidationListener {
        private final Property<Boolean> booleanProperty;
        private final Field field;

        private BooleanBidirectionalBind(Property<Boolean> booleanProperty, Field field) {
            this.booleanProperty = booleanProperty;
            this.field = field;
        }

        public void invalidated(Observable observable) {
            if ((Boolean)this.booleanProperty.getValue() == ParametersProperty.getNumberAsBoolean(this.field.getNumber(ParametersProperty.this.getValue()))) {
                return;
            }
            if (observable == this.booleanProperty) {
                Object newParameters = ParametersProperty.this.getValueCopy(ParametersProperty.this.getValue());
                this.field.setNumber(newParameters, ParametersProperty.getBooleanAsNumber((Boolean)this.booleanProperty.getValue()));
                ParametersProperty.this.set(newParameters);
            } else {
                this.booleanProperty.setValue((Object)ParametersProperty.getNumberAsBoolean(this.field.getNumber(ParametersProperty.this.getValue())));
            }
        }
    }

    private class EnumBidirectionalBind<E extends Enum<E>>
    implements InvalidationListener {
        private final Property<E> enumProperty;
        private final EnumField<E> field;

        private EnumBidirectionalBind(Property<E> numberProperty, EnumField<E> field) {
            this.enumProperty = numberProperty;
            this.field = field;
        }

        public void invalidated(Observable observable) {
            if (this.enumProperty.getValue() == this.field.getEnum(ParametersProperty.this.getValue())) {
                return;
            }
            if (observable == this.enumProperty) {
                Object newParameters = ParametersProperty.this.getValueCopy(ParametersProperty.this.getValue());
                this.field.setEnum(newParameters, (Enum)this.enumProperty.getValue());
                ParametersProperty.this.set(newParameters);
            } else {
                this.enumProperty.setValue(this.field.getEnum(ParametersProperty.this.getValue()));
            }
        }
    }

    private class ConditionalNumberBidirectionalBind
    implements InvalidationListener {
        private final Condition condition;
        private final Property<? extends Number> numberProperty;
        private final Field field;

        private ConditionalNumberBidirectionalBind(Condition condition, Property<? extends Number> numberProperty, Field field) {
            this.condition = condition;
            this.numberProperty = numberProperty;
            this.field = field;
        }

        public void invalidated(Observable observable) {
            if (!this.condition.checkCondition()) {
                return;
            }
            if (((Number)this.numberProperty.getValue()).doubleValue() == this.field.getNumber(ParametersProperty.this.getValue()).doubleValue()) {
                return;
            }
            if (observable == this.numberProperty) {
                Object newParameters = ParametersProperty.this.getValueCopy(ParametersProperty.this.getValue());
                this.field.setNumber(newParameters, (Number)this.numberProperty.getValue());
                ParametersProperty.this.set(newParameters);
            } else {
                ParametersProperty.this.setNumberValue((Property<Number>)this.numberProperty, this.field);
            }
        }
    }

    private class NumberBidirectionalBind
    extends ConditionalNumberBidirectionalBind {
        private NumberBidirectionalBind(Property<? extends Number> numberProperty, Field field) {
            super(() -> true, numberProperty, field);
        }
    }

    protected static interface Condition {
        public boolean checkCondition();
    }

    protected static interface BooleanSetter<T>
    extends NumberSetter<T> {
        public void set(T var1, boolean var2);

        @Override
        default public void setNumber(T parameters, Number value) {
            this.set(parameters, ParametersProperty.getNumberAsBoolean(value));
        }
    }

    protected static interface BooleanGetter<T>
    extends NumberGetter<T> {
        public boolean get(T var1);

        @Override
        default public Number getNumber(T parameters) {
            return ParametersProperty.getBooleanAsNumber(this.get(parameters));
        }
    }

    protected class BooleanField
    extends Field
    implements Observable,
    NumberGetter<T>,
    NumberSetter<T> {
        public BooleanField(BooleanGetter<T> booleanGetter, BooleanSetter<T> booleanSetter) {
            super(booleanGetter, booleanSetter);
        }
    }

    protected class EnumField<E extends Enum<E>>
    implements Observable,
    EnumGetter<E, T>,
    EnumSetter<E, T> {
        private EnumGetter<E, T> enumGetter;
        private EnumSetter<E, T> enumSetter;

        public EnumField(EnumGetter<E, T> numberGetter, EnumSetter<E, T> numberSetter) {
            this.enumGetter = numberGetter;
            this.enumSetter = numberSetter;
        }

        @Override
        public E getEnum(T parameters) {
            return this.enumGetter.getEnum(parameters);
        }

        @Override
        public void setEnum(T parameters, E value) {
            this.enumSetter.setEnum(parameters, value);
        }

        public void addListener(InvalidationListener listener) {
            ParametersProperty.this.enumFieldInvalidationListeners.put(listener, this);
        }

        public void removeListener(InvalidationListener listener) {
            ParametersProperty.this.enumFieldInvalidationListeners.remove(listener);
        }
    }

    protected static interface IntegerSetter<T>
    extends NumberSetter<T> {
        public void set(T var1, int var2);

        @Override
        default public void setNumber(T parameters, Number value) {
            this.set(parameters, value.intValue());
        }
    }

    protected static interface IntegerGetter<T>
    extends NumberGetter<T> {
        public int get(T var1);

        @Override
        default public Number getNumber(T parameters) {
            return new Integer(this.get(parameters));
        }
    }

    protected class IntegerField
    extends Field
    implements Observable,
    NumberGetter<T>,
    NumberSetter<T> {
        public IntegerField(IntegerGetter<T> integerGetter, IntegerSetter<T> integerSetter) {
            super(integerGetter, integerSetter);
        }
    }

    protected static interface FloatSetter<T>
    extends NumberSetter<T> {
        public void set(T var1, float var2);

        @Override
        default public void setNumber(T parameters, Number value) {
            this.set(parameters, value.floatValue());
        }
    }

    protected static interface FloatGetter<T>
    extends NumberGetter<T> {
        public float get(T var1);

        @Override
        default public Number getNumber(T parameters) {
            return new Float(this.get(parameters));
        }
    }

    protected class FloatField
    extends Field
    implements Observable,
    NumberGetter<T>,
    NumberSetter<T> {
        public FloatField(FloatGetter<T> floatGetter, FloatSetter<T> floatSetter) {
            super(floatGetter, floatSetter);
        }
    }

    protected static interface DoubleSetter<T>
    extends NumberSetter<T> {
        public void set(T var1, double var2);

        @Override
        default public void setNumber(T parameters, Number value) {
            this.set(parameters, value.doubleValue());
        }
    }

    protected static interface DoubleGetter<T>
    extends NumberGetter<T> {
        public double get(T var1);

        @Override
        default public Number getNumber(T parameters) {
            return new Double(this.get(parameters));
        }
    }

    protected class DoubleField
    extends Field
    implements Observable,
    NumberGetter<T>,
    NumberSetter<T> {
        public DoubleField(DoubleGetter<T> doubleGetter, DoubleSetter<T> doubleSetter) {
            super(doubleGetter, doubleSetter);
        }

        public DoubleField(DoubleStoredPropertyKey key, StoredPropertySet set) {
            super((T parameters) -> set.get(key), (T parameters, Number value) -> set.set(key, value.doubleValue()));
        }
    }

    public static interface EnumSetter<E extends Enum<E>, T> {
        public void setEnum(T var1, E var2);
    }

    public static interface EnumGetter<E extends Enum<E>, T> {
        public E getEnum(T var1);
    }

    private static interface NumberSetter<T> {
        public void setNumber(T var1, Number var2);
    }

    private static interface NumberGetter<T> {
        public Number getNumber(T var1);
    }

    protected abstract class Field
    implements Observable,
    NumberGetter<T>,
    NumberSetter<T> {
        private NumberGetter<T> numberGetter;
        private NumberSetter<T> numberSetter;

        public Field(NumberGetter<T> numberGetter, NumberSetter<T> numberSetter) {
            this.numberGetter = numberGetter;
            this.numberSetter = numberSetter;
        }

        @Override
        public Number getNumber(T parameters) {
            return this.numberGetter.getNumber(parameters);
        }

        @Override
        public void setNumber(T parameters, Number value) {
            this.numberSetter.setNumber(parameters, value);
        }

        public void addListener(InvalidationListener listener) {
            ParametersProperty.this.fieldInvalidationListeners.put(listener, this);
        }

        public void removeListener(InvalidationListener listener) {
            ParametersProperty.this.fieldInvalidationListeners.remove(listener);
        }
    }
}

