/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.StereoPointCloudCompression;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMFrameState;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.StereoVisionPointCloudViewer;

public class SLAMFrameStateViewer
implements Runnable {
    private static final Color LATEST_ORIGINAL_POINT_CLOUD_COLOR = Color.BEIGE;
    private static final Color SOURCE_POINT_CLOUD_COLOR = Color.RED;
    private static final Color LATEST_POINT_CLOUD_COLOR = Color.LIME;
    private final Group root = new Group();
    private final AtomicReference<SLAMFrameState> newMessageToRender;
    private final AtomicReference<Boolean> enable;
    private final StereoVisionPointCloudViewer uncorrectedPointCloudViewer;
    private final REAUIMessager uiMessager;

    public SLAMFrameStateViewer(REAUIMessager uiMessager, MessagerAPIFactory.Topic<Boolean> enableTopic, MessagerAPIFactory.Topic<Boolean> clearTopic, MessagerAPIFactory.Topic<Integer> sizeTopic) {
        this.uiMessager = uiMessager;
        this.newMessageToRender = uiMessager.createInput(SLAMModuleAPI.IhmcSLAMFrameState);
        this.enable = uiMessager.createInput(enableTopic, false);
        this.uncorrectedPointCloudViewer = new StereoVisionPointCloudViewer(SLAMModuleAPI.UIStereoSLAMPointCloud, uiMessager, enableTopic, clearTopic, sizeTopic);
        this.root.getChildren().addAll((Object[])new Node[]{this.uncorrectedPointCloudViewer.getRoot()});
    }

    @Override
    public void run() {
        if (!this.enable.get().booleanValue()) {
            return;
        }
        if (this.newMessageToRender.get() == null) {
            return;
        }
        this.unpackPointCloud(this.newMessageToRender.getAndSet(null));
        this.uncorrectedPointCloudViewer.run();
    }

    public void render() {
        this.uncorrectedPointCloudViewer.render();
    }

    public void clear() {
        this.uncorrectedPointCloudViewer.clear();
    }

    public Node getRoot() {
        return this.root;
    }

    private StereoVisionPointCloudMessage createLatestFrameStereoVisionPointCloudMessage(Point3DReadOnly[] uncorrectedPointCloudBuffer, Point3DReadOnly[] correspondingPointCloudBuffer, List<? extends Point3DReadOnly> correctedPointCloudBuffer) {
        int i;
        int numberOfPointsToPack = uncorrectedPointCloudBuffer.length + correspondingPointCloudBuffer.length + correctedPointCloudBuffer.size();
        Point3D[] pointCloudBuffer = new Point3D[numberOfPointsToPack];
        int[] colorBuffer = new int[numberOfPointsToPack];
        for (i = 0; i < uncorrectedPointCloudBuffer.length; ++i) {
            pointCloudBuffer[i] = new Point3D((Tuple3DReadOnly)uncorrectedPointCloudBuffer[i]);
            colorBuffer[i] = StereoVisionPointCloudViewer.colorToInt(LATEST_ORIGINAL_POINT_CLOUD_COLOR);
        }
        for (i = uncorrectedPointCloudBuffer.length; i < uncorrectedPointCloudBuffer.length + correspondingPointCloudBuffer.length; ++i) {
            pointCloudBuffer[i] = new Point3D((Tuple3DReadOnly)correspondingPointCloudBuffer[i - uncorrectedPointCloudBuffer.length]);
            colorBuffer[i] = StereoVisionPointCloudViewer.colorToInt(SOURCE_POINT_CLOUD_COLOR);
        }
        for (i = uncorrectedPointCloudBuffer.length + correspondingPointCloudBuffer.length; i < numberOfPointsToPack; ++i) {
            pointCloudBuffer[i] = new Point3D((Tuple3DReadOnly)correctedPointCloudBuffer.get(i - uncorrectedPointCloudBuffer.length - correspondingPointCloudBuffer.length));
            colorBuffer[i] = StereoVisionPointCloudViewer.colorToInt(LATEST_POINT_CLOUD_COLOR);
        }
        return StereoPointCloudCompression.compressPointCloud(19870612L, (Point3DReadOnly[])pointCloudBuffer, colorBuffer, numberOfPointsToPack, 0.001, null);
    }

    private void unpackPointCloud(SLAMFrameState message) {
        Point3DReadOnly[] uncorrectedPointCloudBuffer = message.getUncorrectedPointCloudInWorld();
        List<? extends Point3DReadOnly> correctedPointCloudBuffer = message.getCorrectedPointCloudInWorld();
        Point3DReadOnly[] correspondingPointCloudBuffer = message.setCorrespondingPointsInWorld();
        StereoVisionPointCloudMessage convertedMessage = this.createLatestFrameStereoVisionPointCloudMessage(uncorrectedPointCloudBuffer, correspondingPointCloudBuffer, correctedPointCloudBuffer);
        this.uiMessager.broadcastMessage(SLAMModuleAPI.UIStereoSLAMPointCloud, convertedMessage);
    }
}

