/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.shape.Mesh;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.jOctoMap.iterators.OcTreeIterable;
import us.ihmc.jOctoMap.iterators.OcTreeIteratorFactory;
import us.ihmc.jOctoMap.key.OcTreeKey;
import us.ihmc.jOctoMap.node.baseImplementation.AbstractOcTreeNode;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette1D;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.packets.NormalOcTreeMessage;
import us.ihmc.robotEnvironmentAwareness.ui.UIOcTree;
import us.ihmc.robotEnvironmentAwareness.ui.UIOcTreeNode;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.OcTreeMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.UIOcTreeNodeMeshView;

public class OccupancyMapMeshBuilder
implements Runnable {
    private static final double DEFAULT_CELL_SIZE_RATIO = 1.0;
    private static final int FX_NODE_DEPTH = 8;
    private final Group root = new Group();
    private final ObservableList<Node> children = this.root.getChildren();
    private final JavaFXMultiColorMeshBuilder meshBuilder;
    private final TextureColorPalette1D normalBasedColorPalette1D = new TextureColorPalette1D();
    private final AtomicReference<NormalOcTreeMessage> ocTreeState;
    private final AtomicReference<Double> confidenceFactorState;
    private final AtomicReference<Boolean> occupancyEnable;
    private final AtomicReference<Boolean> normalVectorEnable;
    private final AtomicReference<Boolean> clear;
    private final REAUIMessager uiMessager;
    private final AtomicReference<UIOcTree> uiOcTree = new AtomicReference<Object>(null);
    private final Map<OcTreeKey, Integer> nodeKeyToColorMap = new HashMap<OcTreeKey, Integer>();
    private final AtomicReference<Set<UIOcTreeNodeMeshView>> newSubOcTreeMeshViews = new AtomicReference<Object>(null);
    private final Deque<UIOcTreeNodeMeshView> meshViewsBeingProcessed = new ArrayDeque<UIOcTreeNodeMeshView>();
    private final Point3D hitLocation = new Point3D();
    private final Vector3D normalVector = new Vector3D();
    private final Point3D normalVectorEnd = new Point3D();

    public OccupancyMapMeshBuilder(REAUIMessager uiMessager) {
        this.uiMessager = uiMessager;
        this.ocTreeState = uiMessager.createInput(SLAMModuleAPI.SLAMOctreeMapState);
        this.confidenceFactorState = uiMessager.createInput(SLAMModuleAPI.LatestFrameConfidenceFactor, 1.0);
        this.occupancyEnable = uiMessager.createInput(SLAMModuleAPI.ShowSLAMOctreeMap, true);
        this.normalVectorEnable = uiMessager.createInput(SLAMModuleAPI.ShowSLAMOctreeNormalMap, false);
        this.clear = uiMessager.createInput(SLAMModuleAPI.SLAMClear, false);
        this.meshBuilder = new JavaFXMultiColorMeshBuilder((TextureColorPalette)this.normalBasedColorPalette1D);
    }

    public void render() {
        if (this.clear.getAndSet(false).booleanValue()) {
            this.children.clear();
            this.nodeKeyToColorMap.clear();
            this.newSubOcTreeMeshViews.set(null);
            this.meshViewsBeingProcessed.clear();
            return;
        }
        Set newMeshViews = this.newSubOcTreeMeshViews.getAndSet(null);
        if (newMeshViews != null) {
            List newChildren = this.children.stream().filter(newMeshViews::contains).collect(Collectors.toList());
            this.children.clear();
            this.children.addAll(newChildren);
            this.meshViewsBeingProcessed.clear();
            this.meshViewsBeingProcessed.addAll(newMeshViews);
        }
        if (this.meshViewsBeingProcessed.isEmpty()) {
            return;
        }
        UIOcTreeNodeMeshView newMeshView = this.meshViewsBeingProcessed.pop();
        this.children.remove((Object)newMeshView);
        this.children.add((Object)newMeshView);
    }

    @Override
    public void run() {
        if (this.newSubOcTreeMeshViews.get() != null) {
            LogTools.warn((String)"Rendering job is not done, waiting before creating new meshes.");
            return;
        }
        if (this.occupancyEnable.get().booleanValue()) {
            NormalOcTreeMessage newMessage = this.ocTreeState.get();
            if (newMessage == null) {
                return;
            }
            this.uiOcTree.set(new UIOcTree(this.ocTreeState.getAndSet(null), this.nodeKeyToColorMap));
            this.buildUIOcTreeMesh(this.uiOcTree.get());
        }
    }

    private void buildUIOcTreeMesh(UIOcTree ocTree) {
        HashSet<UIOcTreeNodeMeshView> meshViews = new HashSet<UIOcTreeNodeMeshView>();
        ArrayList rootNodes = new ArrayList();
        OcTreeIteratorFactory.createLeafIterable((AbstractOcTreeNode)ocTree.getRoot(), (int)8).forEach(rootNodes::add);
        for (UIOcTreeNode rootNode : rootNodes) {
            meshViews.add(this.createSubTreeMeshView(rootNode));
        }
        this.newSubOcTreeMeshViews.set(meshViews);
    }

    private UIOcTreeNodeMeshView createSubTreeMeshView(UIOcTreeNode subTreeRoot) {
        this.meshBuilder.clear();
        OcTreeIterable iterable = OcTreeIteratorFactory.createLeafIterable((AbstractOcTreeNode)subTreeRoot, (int)16);
        int newFrameColorValue = this.confidenceFactorToColor(this.confidenceFactorState.get());
        for (UIOcTreeNode node : iterable) {
            this.addNodeMesh(this.meshBuilder, node, newFrameColorValue);
        }
        OcTreeKey rootKey = subTreeRoot.getKeyCopy();
        Mesh mesh = this.meshBuilder.generateMesh();
        Material material = this.meshBuilder.generateMaterial();
        UIOcTreeNodeMeshView meshView = new UIOcTreeNodeMeshView(rootKey, mesh, material);
        this.meshBuilder.clear();
        return meshView;
    }

    private int confidenceFactorToColor(double confidenceFactor) {
        if (confidenceFactor < 0.0) {
            return 255;
        }
        int red = (int)((1.0 - confidenceFactor) * 255.0) << 16;
        int green = (int)(confidenceFactor * 255.0) << 8;
        return red | green;
    }

    private void addNodeMesh(JavaFXMultiColorMeshBuilder meshBuilder, UIOcTreeNode node, int newFrameColorValue) {
        Color color = null;
        OcTreeKey keyCopy = node.getKeyCopy();
        if (this.nodeKeyToColorMap.containsKey(keyCopy)) {
            color = OcTreeMeshBuilder.getRegionColor(this.nodeKeyToColorMap.get(keyCopy));
        } else {
            this.nodeKeyToColorMap.put(keyCopy, newFrameColorValue);
            color = OcTreeMeshBuilder.getRegionColor(newFrameColorValue);
        }
        double size = 0.02;
        node.getHitLocation(this.hitLocation);
        meshBuilder.addTetrahedron(size, (Tuple3DReadOnly)this.hitLocation, color);
        if (this.normalVectorEnable.get().booleanValue()) {
            node.getNormal(this.normalVector);
            this.normalVectorEnd.set((Tuple3DReadOnly)this.normalVector);
            this.normalVectorEnd.scaleAdd(0.02, (Tuple3DReadOnly)this.hitLocation);
            meshBuilder.addLine((Tuple3DReadOnly)this.hitLocation, (Tuple3DReadOnly)this.normalVectorEnd, 0.002, Color.BEIGE);
        }
    }

    public Node getRoot() {
        return this.root;
    }
}

