/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.shape.Mesh;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.lists.SupplierBuilder;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;
import us.ihmc.jOctoMap.iterators.OcTreeIterable;
import us.ihmc.jOctoMap.iterators.OcTreeIteratorFactory;
import us.ihmc.jOctoMap.key.OcTreeKey;
import us.ihmc.jOctoMap.node.baseImplementation.AbstractOcTreeNode;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette1D;
import us.ihmc.log.LogTools;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.packets.NormalOcTreeMessage;
import us.ihmc.robotEnvironmentAwareness.communication.packets.PlanarRegionSegmentationMessage;
import us.ihmc.robotEnvironmentAwareness.geometry.IntersectionPlaneBoxCalculator;
import us.ihmc.robotEnvironmentAwareness.ui.UIOcTree;
import us.ihmc.robotEnvironmentAwareness.ui.UIOcTreeNode;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.UIOcTreeNodeMeshView;

public class OcTreeMeshBuilder
implements Runnable {
    private static final int FX_NODE_DEPTH = 8;
    private static final javafx.scene.paint.Color DEFAULT_COLOR = javafx.scene.paint.Color.DARKCYAN;
    private final AtomicReference<Boolean> enable;
    private final AtomicReference<Boolean> clear;
    private final Property<ColoringType> coloringType;
    private final Property<DisplayType> displayType;
    private final Property<Integer> treeDepthForDisplay;
    private final Property<Boolean> hidePlanarRegionNodes;
    private final Group root = new Group();
    private final ObservableList<Node> children = this.root.getChildren();
    private final JavaFXMultiColorMeshBuilder meshBuilder;
    private final TextureColorPalette1D normalBasedColorPalette1D = new TextureColorPalette1D();
    private final RecyclingArrayList<Point3D> plane = new RecyclingArrayList(0, SupplierBuilder.createFromEmptyConstructor(Point3D.class));
    private final IntersectionPlaneBoxCalculator intersectionPlaneBoxCalculator = new IntersectionPlaneBoxCalculator();
    private final AtomicReference<NormalOcTreeMessage> ocTreeState;
    private final AtomicReference<PlanarRegionSegmentationMessage[]> planarRegionSegmentationState;
    private final AtomicBoolean processChange = new AtomicBoolean(false);
    private final AtomicReference<Set<UIOcTreeNodeMeshView>> newSubOcTreeMeshViews = new AtomicReference<Object>(null);
    private final Deque<UIOcTreeNodeMeshView> meshViewsBeingProcessed = new ArrayDeque<UIOcTreeNodeMeshView>();
    private final REAUIMessager uiMessager;
    private final AtomicReference<UIOcTree> uiOcTree = new AtomicReference<Object>(null);
    private final MessagerAPIFactory.Topic<Boolean> requestOcTreeTopic;
    private final MessagerAPIFactory.Topic<Boolean> requestPlanarRegionSegmentationTopic;

    public OcTreeMeshBuilder(REAUIMessager uiMessager, MessagerAPIFactory.Topic<Boolean> ocTreeEnableTopic, MessagerAPIFactory.Topic<Boolean> ocTreeClearTopic, MessagerAPIFactory.Topic<Boolean> requestOcTreeTopic, MessagerAPIFactory.Topic<Boolean> requestPlanarRegionSegmentationTopic, MessagerAPIFactory.Topic<Integer> uiOcTreeDepthTopic, MessagerAPIFactory.Topic<ColoringType> uiOcTreeColoringModeTopic, MessagerAPIFactory.Topic<DisplayType> uiOcTreeDisplayTypeTopic, MessagerAPIFactory.Topic<Boolean> uiPlanarRegionHideNodesTopic, MessagerAPIFactory.Topic<NormalOcTreeMessage> ocTreeStateTopic, MessagerAPIFactory.Topic<PlanarRegionSegmentationMessage[]> planarRegionsSegmentationStateTopic) {
        this.uiMessager = uiMessager;
        this.requestOcTreeTopic = requestOcTreeTopic;
        this.requestPlanarRegionSegmentationTopic = requestPlanarRegionSegmentationTopic;
        this.enable = uiMessager.createInput(ocTreeEnableTopic, false);
        this.clear = uiMessager.createInput(ocTreeClearTopic, false);
        this.treeDepthForDisplay = uiMessager.createPropertyInput(uiOcTreeDepthTopic, Integer.MAX_VALUE);
        this.treeDepthForDisplay.addListener(this::setProcessChange);
        this.coloringType = uiMessager.createPropertyInput(uiOcTreeColoringModeTopic, ColoringType.DEFAULT);
        this.coloringType.addListener(this::setProcessChange);
        this.displayType = uiMessager.createPropertyInput(uiOcTreeDisplayTypeTopic, DisplayType.PLANE);
        this.displayType.addListener(this::setProcessChange);
        this.hidePlanarRegionNodes = uiMessager.createPropertyInput(uiPlanarRegionHideNodesTopic, false);
        this.hidePlanarRegionNodes.addListener(this::setProcessChange);
        this.ocTreeState = uiMessager.createInput(ocTreeStateTopic);
        this.planarRegionSegmentationState = uiMessager.createInput(planarRegionsSegmentationStateTopic);
        this.normalBasedColorPalette1D.setHueBased(0.9, 0.8);
        this.meshBuilder = new JavaFXMultiColorMeshBuilder((TextureColorPalette)this.normalBasedColorPalette1D);
    }

    private <T> void setProcessChange(ObservableValue<? extends T> observableValue, T oldValue, T newValue) {
        try {
            this.processChange.set(!oldValue.equals(newValue));
        }
        catch (NullPointerException e) {
            this.processChange.set(oldValue != newValue);
        }
    }

    public void render() {
        if (this.clear.getAndSet(false).booleanValue()) {
            this.children.clear();
            this.newSubOcTreeMeshViews.set(null);
            this.meshViewsBeingProcessed.clear();
            return;
        }
        Set newMeshViews = this.newSubOcTreeMeshViews.getAndSet(null);
        if (newMeshViews != null) {
            List newChildren = this.children.stream().filter(newMeshViews::contains).collect(Collectors.toList());
            this.children.clear();
            this.children.addAll(newChildren);
            this.meshViewsBeingProcessed.clear();
            this.meshViewsBeingProcessed.addAll(newMeshViews);
        }
        if (this.meshViewsBeingProcessed.isEmpty()) {
            return;
        }
        UIOcTreeNodeMeshView newMeshView = this.meshViewsBeingProcessed.pop();
        this.children.remove((Object)newMeshView);
        this.children.add((Object)newMeshView);
    }

    @Override
    public void run() {
        if (this.newSubOcTreeMeshViews.get() != null) {
            LogTools.warn((String)"Rendering job is not done, waiting before creating new meshes.");
            return;
        }
        if (this.displayType.getValue() == DisplayType.HIDE) {
            return;
        }
        if (this.enable.get().booleanValue()) {
            this.uiMessager.submitStateRequestToModule(this.requestOcTreeTopic);
            this.uiMessager.submitStateRequestToModule(this.requestPlanarRegionSegmentationTopic);
            NormalOcTreeMessage newMessage = this.ocTreeState.get();
            Map<OcTreeKey, Integer> nodeKeyToRegionIdMap = this.createNodeKeyToRegionIdMap(this.planarRegionSegmentationState.getAndSet(null));
            if (newMessage == null || nodeKeyToRegionIdMap == null) {
                return;
            }
            this.uiOcTree.set(new UIOcTree(this.ocTreeState.getAndSet(null), nodeKeyToRegionIdMap));
            this.buildUIOcTreeMesh(this.uiOcTree.get());
        } else if (this.processChange.getAndSet(false) && this.uiOcTree.get() != null) {
            this.buildUIOcTreeMesh(this.uiOcTree.get());
        }
    }

    private void buildUIOcTreeMesh(UIOcTree ocTree) {
        HashSet<UIOcTreeNodeMeshView> meshViews = new HashSet<UIOcTreeNodeMeshView>();
        ArrayList rootNodes = new ArrayList();
        OcTreeIteratorFactory.createLeafIterable((AbstractOcTreeNode)ocTree.getRoot(), (int)8).forEach(rootNodes::add);
        for (UIOcTreeNode rootNode : rootNodes) {
            meshViews.add(this.createSubTreeMeshView(rootNode));
        }
        this.newSubOcTreeMeshViews.set(meshViews);
    }

    private UIOcTreeNodeMeshView createSubTreeMeshView(UIOcTreeNode subTreeRoot) {
        this.meshBuilder.clear();
        OcTreeIterable iterable = OcTreeIteratorFactory.createLeafIterable((AbstractOcTreeNode)subTreeRoot, (int)((Integer)this.treeDepthForDisplay.getValue()));
        for (UIOcTreeNode node : iterable) {
            if (node.isPartOfRegion() && ((Boolean)this.hidePlanarRegionNodes.getValue()).booleanValue()) continue;
            this.addNodeMesh(this.meshBuilder, (DisplayType)((Object)this.displayType.getValue()), (ColoringType)((Object)this.coloringType.getValue()), node);
        }
        OcTreeKey rootKey = subTreeRoot.getKeyCopy();
        Mesh mesh = this.meshBuilder.generateMesh();
        Material material = this.meshBuilder.generateMaterial();
        UIOcTreeNodeMeshView meshView = new UIOcTreeNodeMeshView(rootKey, mesh, material);
        this.meshBuilder.clear();
        return meshView;
    }

    private void addNodeMesh(JavaFXMultiColorMeshBuilder meshBuilder, DisplayType displayType, ColoringType coloringType, UIOcTreeNode node) {
        javafx.scene.paint.Color color = this.getNodeColor(coloringType, node);
        double size = node.getSize();
        switch (displayType) {
            case CELL: {
                meshBuilder.addCube(size, node.getX(), node.getY(), node.getZ(), color);
                break;
            }
            case PLANE: {
                if (!node.isNormalSet()) break;
                meshBuilder.addMesh(this.createNormalBasedPlane(node), color);
                break;
            }
            case HIT_LOCATION: {
                if (!node.isHitLocationSet()) break;
                Point3D hitLocation = new Point3D();
                node.getHitLocation(hitLocation);
                meshBuilder.addTetrahedron(0.0075, (Tuple3DReadOnly)hitLocation, color);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected value for display type: " + (Object)((Object)displayType));
            }
        }
    }

    private javafx.scene.paint.Color getNodeColor(ColoringType coloringType, UIOcTreeNode node) {
        switch (coloringType) {
            case REGION: {
                if (node.isPartOfRegion()) {
                    return OcTreeMeshBuilder.getRegionColor(node.getRegionId());
                }
                return DEFAULT_COLOR;
            }
            case HAS_CENTER: {
                return node.isHitLocationSet() ? javafx.scene.paint.Color.DARKGREEN : javafx.scene.paint.Color.RED;
            }
            case NORMAL: {
                if (node.isNormalSet()) {
                    Vector3D normal = new Vector3D();
                    node.getNormal(normal);
                    Vector3D zUp = new Vector3D(0.0, 0.0, 1.0);
                    normal.normalize();
                    double angle = Math.abs(zUp.dot((Vector3DReadOnly)normal));
                    double hue = 120.0 * angle;
                    return javafx.scene.paint.Color.hsb((double)hue, (double)1.0, (double)1.0);
                }
                return DEFAULT_COLOR;
            }
        }
        return DEFAULT_COLOR;
    }

    public static javafx.scene.paint.Color getRegionColor(int regionId) {
        Color awtColor = new Color(regionId);
        return javafx.scene.paint.Color.rgb((int)awtColor.getRed(), (int)awtColor.getGreen(), (int)awtColor.getBlue());
    }

    private MeshDataHolder createNormalBasedPlane(UIOcTreeNode node) {
        if (!node.isNormalSet() || !node.isHitLocationSet()) {
            return null;
        }
        Vector3D planeNormal = new Vector3D();
        Point3D pointOnPlane = new Point3D();
        double size = node.getSize();
        node.getNormal(planeNormal);
        node.getHitLocation(pointOnPlane);
        this.intersectionPlaneBoxCalculator.setCube(size, node.getX(), node.getY(), node.getZ());
        this.intersectionPlaneBoxCalculator.setPlane(pointOnPlane, planeNormal);
        this.intersectionPlaneBoxCalculator.computeIntersections(this.plane);
        if (this.plane.size() < 3) {
            return null;
        }
        int numberOfTriangles = this.plane.size() - 2;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        int j = 2;
        while (j < this.plane.size()) {
            triangleIndices[index++] = 0;
            triangleIndices[index++] = j - 1;
            triangleIndices[index++] = j++;
        }
        Point3D32[] vertices = new Point3D32[this.plane.size()];
        TexCoord2f[] texCoords = new TexCoord2f[this.plane.size()];
        Vector3D32[] normals = new Vector3D32[this.plane.size()];
        for (int i = 0; i < this.plane.size(); ++i) {
            vertices[i] = new Point3D32((Tuple3DReadOnly)this.plane.get(i));
            texCoords[i] = new TexCoord2f();
            normals[i] = new Vector3D32((Tuple3DReadOnly)planeNormal);
        }
        return new MeshDataHolder(vertices, texCoords, triangleIndices, normals);
    }

    private Map<OcTreeKey, Integer> createNodeKeyToRegionIdMap(PlanarRegionSegmentationMessage[] planarRegionSegmentationMessages) {
        if (planarRegionSegmentationMessages == null) {
            return null;
        }
        HashMap<OcTreeKey, Integer> nodeKeyToRegionIdMap = new HashMap<OcTreeKey, Integer>();
        for (PlanarRegionSegmentationMessage planarRegionSegmentationMessage : planarRegionSegmentationMessages) {
            this.registerNodeKeysIntoMap(nodeKeyToRegionIdMap, planarRegionSegmentationMessage);
        }
        return nodeKeyToRegionIdMap;
    }

    private void registerNodeKeysIntoMap(Map<OcTreeKey, Integer> nodeKeyToRegionIdMap, PlanarRegionSegmentationMessage planarRegionSegmentationMessage) {
        for (int i = 0; i < planarRegionSegmentationMessage.getNumberOfNodes(); ++i) {
            OcTreeKey nodeKey = new OcTreeKey();
            planarRegionSegmentationMessage.getNodeKey(i, nodeKey);
            nodeKeyToRegionIdMap.put(nodeKey, planarRegionSegmentationMessage.getRegionId());
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public static enum DisplayType {
        HIDE,
        CELL,
        PLANE,
        HIT_LOCATION;

    }

    public static enum ColoringType {
        DEFAULT,
        NORMAL,
        HAS_CENTER,
        REGION;

    }
}

