/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.ToggleButton;
import us.ihmc.javaFXToolkit.messager.MessageBidirectionalBinding;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.properties.BoundingBoxParametersProperty;

public class LIDARFilterAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enableBoundingBoxButton;
    @FXML
    private ToggleButton showBoundingBoxButton;
    @FXML
    private Spinner<Double> boundingBoxMinXSpinner;
    @FXML
    private Spinner<Double> boundingBoxMaxXSpinner;
    @FXML
    private Spinner<Double> boundingBoxMinYSpinner;
    @FXML
    private Spinner<Double> boundingBoxMaxYSpinner;
    @FXML
    private Spinner<Double> boundingBoxMinZSpinner;
    @FXML
    private Spinner<Double> boundingBoxMaxZSpinner;
    private final BoundingBoxParametersProperty boundingBoxParametersProperty = new BoundingBoxParametersProperty(this, "boundingBoxParameters");
    @FXML
    private Slider lidarMinRange;
    @FXML
    private Slider lidarMaxRange;
    private final MessageBidirectionalBinding.PropertyToMessageTypeConverter<Double, Number> converter = new MessageBidirectionalBinding.PropertyToMessageTypeConverter<Double, Number>(){

        public Double convert(Number propertyValue) {
            return propertyValue.doubleValue();
        }

        public Number interpret(Double messageContent) {
            return (double)messageContent;
        }
    };

    private void setupControls() {
        this.boundingBoxMinXSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(0.0));
        this.boundingBoxMaxXSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(5.0));
        this.boundingBoxMinYSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(-2.0));
        this.boundingBoxMaxYSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(2.0));
        this.boundingBoxMinZSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(-1.0));
        this.boundingBoxMaxZSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(1.0));
    }

    @Override
    public void bindControls() {
        this.setupControls();
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.OcTreeBoundingBoxEnable, this.enableBoundingBoxButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.LidarMinRange, this.lidarMinRange.valueProperty(), this.converter);
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.LidarMaxRange, this.lidarMaxRange.valueProperty(), this.converter);
        this.boundingBoxParametersProperty.binBidirectionalMinX((Property<? extends Number>)this.boundingBoxMinXSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMinY((Property<? extends Number>)this.boundingBoxMinYSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMinZ((Property<? extends Number>)this.boundingBoxMinZSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMaxX((Property<? extends Number>)this.boundingBoxMaxXSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMaxY((Property<? extends Number>)this.boundingBoxMaxYSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMaxZ((Property<? extends Number>)this.boundingBoxMaxZSpinner.getValueFactory().valueProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.OcTreeBoundingBoxParameters, this.boundingBoxParametersProperty);
        this.load();
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UIOcTreeBoundingBoxShow, this.showBoundingBoxButton.selectedProperty(), true);
    }

    @FXML
    public void save() {
        this.uiMessager.submitStateRequestToModule(REAModuleAPI.SaveMainUpdaterConfiguration);
        this.saveUIControlProperty(REAModuleAPI.UIOcTreeBoundingBoxShow, this.showBoundingBoxButton);
    }

    public void load() {
        this.loadUIControlProperty(REAModuleAPI.UIOcTreeBoundingBoxShow, this.showBoundingBoxButton);
    }

    private SpinnerValueFactory.DoubleSpinnerValueFactory createBoundingBoxValueFactory(double initialValue) {
        double min = -100.0;
        double max = 100.0;
        double amountToStepBy = 0.1;
        return new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, initialValue, amountToStepBy);
    }
}

