/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import controller_msgs.msg.dds.Image32;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.stage.Window;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.messager.SharedMemoryJavaFXMessager;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.converters.StereoPointCloudCompression;
import us.ihmc.robotEnvironmentAwareness.fusion.tools.LidarImageFusionDataLoader;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionDataImporter;

public class DataImporterAnchorPaneController {
    private Window window;
    private REAUIMessager reaMessager;
    private JavaFXMessager messager = null;
    private static final String imageFileNameHeader = "image_";
    private static final String stereoDataFileNameHeader = "stereovision_pointcloud_";
    private static final String imageFileExtension = ".jpg";
    private static final String stereoDataFileExtension = ".txt";
    private static final int DEFAULT_STEREO_POINT_COLOR = 65280;
    private final List<BufferedImage> loadedImages = new ArrayList<BufferedImage>();
    private final List<Point3D[]> loadedStereoData = new ArrayList<Point3D[]>();
    @FXML
    private TextField tfDataIndex;
    @FXML
    private TextField tfRollDegree;
    @FXML
    private TextField tfPitchDegree;
    @FXML
    private TextField tfYawDegree;

    public void initialize(REAUIMessager reaMessager, SharedMemoryJavaFXMessager messager, Window window) {
        this.reaMessager = reaMessager;
        if (messager != null) {
            this.messager = messager;
        }
        this.window = window;
    }

    public void loadFromFile() {
        String dataFileRootPath = PlanarRegionDataImporter.chooseFile(this.window).getAbsolutePath() + "\\";
        System.out.println("file root path " + dataFileRootPath);
        this.loadedImages.clear();
        this.loadedStereoData.clear();
        int numberOfFiles = 0;
        while (true) {
            boolean fileIsAvailable;
            String imageFilePath = dataFileRootPath + imageFileNameHeader + numberOfFiles + imageFileExtension;
            String stereoDataFilePath = dataFileRootPath + stereoDataFileNameHeader + numberOfFiles + stereoDataFileExtension;
            File imageFile = new File(imageFilePath);
            File stereoDataFile = new File(stereoDataFilePath);
            boolean bl = fileIsAvailable = imageFile.canRead() && stereoDataFile.canRead();
            if (!fileIsAvailable) break;
            this.loadedImages.add(LidarImageFusionDataLoader.readImage(imageFile));
            this.loadedStereoData.add(LidarImageFusionDataLoader.readPointCloud(stereoDataFile));
            ++numberOfFiles;
        }
        System.out.println("The Number Of Files is " + numberOfFiles);
    }

    public void publishMessages() {
        int dataIndex = Integer.parseInt(this.tfDataIndex.getText());
        double roll = Double.parseDouble(this.tfRollDegree.getText()) / 180.0 * Math.PI;
        double pitch = Double.parseDouble(this.tfPitchDegree.getText()) / 180.0 * Math.PI;
        double yaw = Double.parseDouble(this.tfYawDegree.getText()) / 180.0 * Math.PI;
        if (dataIndex < 0 || dataIndex >= this.loadedStereoData.size()) {
            System.out.println("Put proper index to publish.");
            return;
        }
        RigidBodyTransform manualTransform = new RigidBodyTransform();
        manualTransform.appendYawRotation(yaw);
        manualTransform.appendPitchRotation(pitch);
        manualTransform.appendRollRotation(roll);
        Point3D[] pointCloud = this.loadedStereoData.get(dataIndex);
        int numberOfPoints = pointCloud.length;
        long timestamp = 870612L;
        Point3D[] pointCloudBuffer = new Point3D[numberOfPoints];
        int[] colorsInteger = new int[numberOfPoints];
        for (int i = 0; i < numberOfPoints; ++i) {
            Point3D scanPoint = new Point3D((Tuple3DReadOnly)pointCloud[i]);
            manualTransform.transform((Point3DBasics)scanPoint);
            pointCloudBuffer[i] = scanPoint;
            colorsInteger[i] = 65280;
        }
        double minimumResolution = 0.001;
        StereoVisionPointCloudMessage dummyMessage = StereoPointCloudCompression.compressPointCloud(timestamp, (Point3DReadOnly[])pointCloudBuffer, colorsInteger, numberOfPoints, minimumResolution, null);
        this.reaMessager.submitMessageToModule(REAModuleAPI.StereoVisionPointCloudState, dummyMessage);
        if (this.messager != null) {
            this.messager.submitMessage(LidarImageFusionAPI.CameraOrientationState, (Object)new Quaternion((Orientation3DReadOnly)manualTransform.getRotation()));
            BufferedImage bufferedImage = this.loadedImages.get(dataIndex);
            int height = bufferedImage.getHeight();
            int width = bufferedImage.getWidth();
            Image32 message = new Image32();
            message.setHeight(height);
            message.setWidth(width);
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    message.getRgbdata().add(bufferedImage.getRGB(j, i));
                }
            }
            this.messager.submitMessage(LidarImageFusionAPI.ImageState, (Object)message);
        }
    }

    public void exportPlanarRegions() {
        this.reaMessager.submitMessageInternal(REAModuleAPI.UIPlanarRegionDataExportRequest, true);
    }
}

