/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui;

import controller_msgs.msg.dds.LidarScanMessage;
import controller_msgs.msg.dds.StampedPosePacket;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.io.File;
import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.robotEnvironmentAwareness.communication.KryoMessager;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionUI;
import us.ihmc.robotEnvironmentAwareness.ui.UIConnectionHandler;
import us.ihmc.robotEnvironmentAwareness.ui.controller.CustomRegionMergeAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.DataExporterAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.LIDARFilterAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.NormalEstimationAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.OcTreeBasicsAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.PointCloudAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.PolygonizerAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.RegionSegmentationAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.SurfaceNormalFilterAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionDataExporter;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionSegmentationDataExporter;
import us.ihmc.robotEnvironmentAwareness.ui.io.StereoVisionPointCloudDataExporter;
import us.ihmc.robotEnvironmentAwareness.ui.viewer.REAMeshViewer;
import us.ihmc.robotEnvironmentAwareness.ui.viewer.SensorFrameViewer;

public class LIDARBasedEnvironmentAwarenessUI
implements PerceptionUI {
    private static final String UI_CONFIGURATION_FILE_NAME = "./Configurations/defaultREAUIConfiguration.txt";
    private final BorderPane mainPane;
    private final REAUIMessager uiMessager;
    private final REAMeshViewer reaMeshViewer;
    private final SensorFrameViewer<LidarScanMessage> lidarFrameViewer;
    private final SensorFrameViewer<StereoVisionPointCloudMessage> stereoFrameViewer;
    private final SensorFrameViewer<StereoVisionPointCloudMessage> depthFrameViewer;
    private final SensorFrameViewer<StampedPosePacket> trackingFrameViewer;
    @FXML
    private PointCloudAnchorPaneController pointCloudAnchorPaneController;
    @FXML
    private OcTreeBasicsAnchorPaneController ocTreeBasicsAnchorPaneController;
    @FXML
    private SurfaceNormalFilterAnchorPaneController surfaceNormalFilterAnchorPaneController;
    @FXML
    private LIDARFilterAnchorPaneController lidarFilterAnchorPaneController;
    @FXML
    private NormalEstimationAnchorPaneController normalEstimationAnchorPaneController;
    @FXML
    private RegionSegmentationAnchorPaneController regionSegmentationAnchorPaneController;
    @FXML
    private CustomRegionMergeAnchorPaneController customRegionMergeAnchorPaneController;
    @FXML
    private PolygonizerAnchorPaneController polygonizerAnchorPaneController;
    @FXML
    private DataExporterAnchorPaneController dataExporterAnchorPaneController;
    private final Stage primaryStage;
    private final UIConnectionHandler uiConnectionHandler;
    private final StereoVisionPointCloudDataExporter stereoVisionPointCloudDataExporter;

    private LIDARBasedEnvironmentAwarenessUI(REAUIMessager uiMessager, Stage primaryStage) throws Exception {
        this(uiMessager, primaryStage, true);
    }

    public LIDARBasedEnvironmentAwarenessUI(REAUIMessager uiMessager, Stage primaryStage, boolean startMessager) throws Exception {
        this.primaryStage = primaryStage;
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        this.mainPane = (BorderPane)loader.load();
        this.uiMessager = uiMessager;
        if (startMessager) {
            uiMessager.startMessager();
        }
        this.reaMeshViewer = new REAMeshViewer(uiMessager);
        this.lidarFrameViewer = new SensorFrameViewer<LidarScanMessage>(uiMessager, REAModuleAPI.LidarScanState, null, SensorFrameViewer.createLidarScanSensorFrameExtractor(), REAModuleAPI.UISensorPoseHistoryClear);
        this.stereoFrameViewer = new SensorFrameViewer<StereoVisionPointCloudMessage>(uiMessager, REAModuleAPI.StereoVisionPointCloudState, REAModuleAPI.UISensorPoseHistoryFrames, SensorFrameViewer.createStereoVisionSensorFrameExtractor(), REAModuleAPI.UISensorPoseHistoryClear);
        this.depthFrameViewer = new SensorFrameViewer<StereoVisionPointCloudMessage>(uiMessager, REAModuleAPI.DepthPointCloudState, REAModuleAPI.UISensorPoseHistoryFrames, SensorFrameViewer.createStereoVisionSensorFrameExtractor(), REAModuleAPI.UISensorPoseHistoryClear);
        this.trackingFrameViewer = new SensorFrameViewer<StampedPosePacket>(uiMessager, REAModuleAPI.TrackingCameraMessageState, REAModuleAPI.UISensorPoseHistoryFrames, SensorFrameViewer.createStampedPosePacketSensorFrameExtractor(), REAModuleAPI.UISensorPoseHistoryClear);
        new PlanarRegionSegmentationDataExporter(uiMessager);
        new PlanarRegionDataExporter(uiMessager);
        this.stereoVisionPointCloudDataExporter = new StereoVisionPointCloudDataExporter(uiMessager);
        this.initializeControllers(uiMessager);
        View3DFactory view3dFactory = View3DFactory.createSubscene();
        view3dFactory.addCameraController(true);
        view3dFactory.addWorldCoordinateSystem(0.3);
        this.mainPane.setCenter((Node)view3dFactory.getSubSceneWrappedInsidePane());
        view3dFactory.addNodeToView(this.reaMeshViewer.getRoot());
        view3dFactory.addNodeToView(this.lidarFrameViewer.getRoot());
        view3dFactory.addNodeToView(this.stereoFrameViewer.getRoot());
        view3dFactory.addNodeToView(this.depthFrameViewer.getRoot());
        view3dFactory.addNodeToView(this.trackingFrameViewer.getRoot());
        this.uiConnectionHandler = new UIConnectionHandler((Window)primaryStage, uiMessager);
        this.uiConnectionHandler.start();
        uiMessager.notifyModuleMessagerStateListeners();
        primaryStage.setTitle(this.getClass().getSimpleName());
        primaryStage.setMaximized(true);
        Scene mainScene = new Scene((Parent)this.mainPane, 600.0, 400.0);
        mainScene.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F5) {
                this.refreshModuleState();
            }
        });
        primaryStage.setScene(mainScene);
        primaryStage.setOnCloseRequest(event -> this.stop());
    }

    private void refreshModuleState() {
        this.uiMessager.submitStateRequestToModule(REAModuleAPI.RequestEntireModuleState);
    }

    private void initializeControllers(REAUIMessager uiMessager) {
        File configurationFile = new File(UI_CONFIGURATION_FILE_NAME);
        try {
            configurationFile.getParentFile().mkdirs();
            configurationFile.createNewFile();
        }
        catch (IOException e) {
            System.out.println(configurationFile.getAbsolutePath());
            e.printStackTrace();
        }
        this.pointCloudAnchorPaneController.setConfigurationFile(configurationFile);
        this.pointCloudAnchorPaneController.attachREAMessager(uiMessager);
        this.pointCloudAnchorPaneController.bindControls();
        this.ocTreeBasicsAnchorPaneController.setConfigurationFile(configurationFile);
        this.ocTreeBasicsAnchorPaneController.attachREAMessager(uiMessager);
        this.ocTreeBasicsAnchorPaneController.bindControls();
        this.surfaceNormalFilterAnchorPaneController.setConfigurationFile(configurationFile);
        this.surfaceNormalFilterAnchorPaneController.attachREAMessager(uiMessager);
        this.surfaceNormalFilterAnchorPaneController.bindControls();
        this.lidarFilterAnchorPaneController.setConfigurationFile(configurationFile);
        this.lidarFilterAnchorPaneController.attachREAMessager(uiMessager);
        this.lidarFilterAnchorPaneController.bindControls();
        this.normalEstimationAnchorPaneController.setConfigurationFile(configurationFile);
        this.normalEstimationAnchorPaneController.attachREAMessager(uiMessager);
        this.normalEstimationAnchorPaneController.bindControls();
        this.regionSegmentationAnchorPaneController.setConfigurationFile(configurationFile);
        this.regionSegmentationAnchorPaneController.attachREAMessager(uiMessager);
        this.regionSegmentationAnchorPaneController.bindControls();
        this.customRegionMergeAnchorPaneController.setConfigurationFile(configurationFile);
        this.customRegionMergeAnchorPaneController.attachREAMessager(uiMessager);
        this.customRegionMergeAnchorPaneController.bindControls();
        this.polygonizerAnchorPaneController.setConfigurationFile(configurationFile);
        this.polygonizerAnchorPaneController.attachREAMessager(uiMessager);
        this.polygonizerAnchorPaneController.bindControls();
        this.dataExporterAnchorPaneController.setConfigurationFile(configurationFile);
        this.dataExporterAnchorPaneController.attachREAMessager(uiMessager);
        this.dataExporterAnchorPaneController.setMainWindow((Window)this.primaryStage);
        this.dataExporterAnchorPaneController.bindControls();
    }

    @Override
    public void show() {
        this.refreshModuleState();
        this.primaryStage.show();
    }

    @Override
    public void stop() {
        try {
            this.uiConnectionHandler.stop();
            this.uiMessager.closeMessager();
            this.reaMeshViewer.stop();
            this.lidarFrameViewer.stop();
            this.stereoFrameViewer.stop();
            this.stereoVisionPointCloudDataExporter.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LIDARBasedEnvironmentAwarenessUI creatIntraprocessUI(Stage primaryStage) throws Exception {
        return LIDARBasedEnvironmentAwarenessUI.creatIntraprocessUI(primaryStage, NetworkPorts.REA_MODULE_UI_PORT);
    }

    public static LIDARBasedEnvironmentAwarenessUI creatIntraprocessUI(Stage primaryStage, NetworkPorts networkPort) throws Exception {
        KryoMessager moduleMessager = KryoMessager.createIntraprocess(REAModuleAPI.API, networkPort, REACommunicationProperties.getPrivateNetClassList());
        REAUIMessager uiMessager = new REAUIMessager(moduleMessager);
        return new LIDARBasedEnvironmentAwarenessUI(uiMessager, primaryStage);
    }

    public static LIDARBasedEnvironmentAwarenessUI creatRemoteUI(Stage primaryStage, String host) throws Exception {
        KryoMessager moduleMessager = KryoMessager.createTCPClient(REAModuleAPI.API, host, NetworkPorts.REA_MODULE_UI_PORT, REACommunicationProperties.getPrivateNetClassList());
        REAUIMessager uiMessager = new REAUIMessager(moduleMessager);
        return new LIDARBasedEnvironmentAwarenessUI(uiMessager, primaryStage);
    }
}

