/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.tools;

import controller_msgs.msg.dds.LidarScanMessage;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.LidarPointCloudCompression;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class ConstantPointCloudPublisher {
    public ConstantPointCloudPublisher() {
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)this.getClass().getSimpleName());
        IHMCROS2Publisher publisher = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, (ROS2Topic)ROS2Tools.MULTISENSE_LIDAR_SCAN);
        LidarScanMessage lidarScanMessage = new LidarScanMessage();
        lidarScanMessage.getLidarPosition().set(0.0, 0.0, 0.7);
        lidarScanMessage.getLidarOrientation().setToPitchOrientation(0.5);
        ConstantPointCloudPublisher.packSquarePoints(lidarScanMessage);
        AtomicBoolean stop = new AtomicBoolean();
        Scanner keyboard = new Scanner(System.in);
        LogTools.info((String)"Starting to publish pointcloud. Enter a letter followed by enter to cancel...");
        new Thread(() -> {
            while (!stop.get()) {
                ThreadTools.sleep((long)300L);
                lidarScanMessage.setRobotTimestamp(System.nanoTime());
                lidarScanMessage.setSequenceId(lidarScanMessage.getSequenceId() + 1L);
                publisher.publish((Object)lidarScanMessage);
            }
            ros2Node.destroy();
        }).start();
        new Thread(() -> {
            keyboard.next();
            stop.set(true);
        }).start();
    }

    private static void packSquarePoints(LidarScanMessage lidarScanMessage) {
        float spacing = 0.0035f;
        int numPointsWidth = 80;
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        for (int i2 = 0; i2 < numPointsWidth; ++i2) {
            for (int j2 = 0; j2 < numPointsWidth; ++j2) {
                double x = 0.4f + 0.2f * spacing * (float)j2;
                double y = ((float)i2 - 0.5f * (float)numPointsWidth) * spacing;
                double z = ((float)j2 - 0.5f * (float)numPointsWidth) * spacing + 0.6f;
                points.add(new Point3D(x, y, z));
            }
        }
        LidarPointCloudCompression.compressPointCloud((int)points.size(), (LidarScanMessage)lidarScanMessage, (i, j) -> ((Point3D)points.get(i)).getElement32(j));
    }

    private static void packRandomPoints(LidarScanMessage lidarScanMessage) {
        int numPoints = 8000;
        Random random = new Random(920L);
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        for (int i2 = 0; i2 < 3 * numPoints; ++i2) {
            double x = (float)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.7);
            double y = (float)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.7);
            double z = (float)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.7);
            points.add(new Point3D(x, y, z));
        }
        LidarPointCloudCompression.compressPointCloud((int)points.size(), (LidarScanMessage)lidarScanMessage, (i, j) -> ((Point3D)points.get(i)).getElement32(j));
    }

    public static void main(String[] args) {
        new ConstantPointCloudPublisher();
    }
}

