/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullDecomposition;
import us.ihmc.robotEnvironmentAwareness.tools.ConcaveHullMergerListener;
import us.ihmc.robotics.geometry.PlanarRegion;

public class ConcaveHullMerger {
    private static final double minimumDistanceBetweenHullPointsSquared = 2.5E-5;
    private static final double minimumDistanceSquared = 4.0E-6;
    private static final double amountToMove = 0.0025;
    private static final double maximumDotProductBetweenSkinnyEdges = Math.cos(Math.toRadians(0.5));
    private static final Random randomForWiggling = new Random(238949L);
    private static final double depthThresholdForConcaveHullDecomposition = 0.001;

    public static ArrayList<PlanarRegion> mergePlanarRegions(PlanarRegion regionOne, PlanarRegion regionTwo, double maximumProjectionDistance) {
        return ConcaveHullMerger.mergePlanarRegions(regionOne, regionTwo, maximumProjectionDistance, null);
    }

    public static ArrayList<PlanarRegion> mergePlanarRegions(PlanarRegion regionOne, PlanarRegion regionTwo, double maximumProjectionDistance, ConcaveHullMergerListener listener) {
        RigidBodyTransform transformTwoToWorld = new RigidBodyTransform();
        regionTwo.getTransformToWorld(transformTwoToWorld);
        RigidBodyTransform transformWorldToOne = new RigidBodyTransform();
        regionOne.getTransformToLocal(transformWorldToOne);
        RigidBodyTransform transformTwoToOne = new RigidBodyTransform((RigidBodyTransformReadOnly)transformWorldToOne);
        transformTwoToOne.multiply((RigidBodyTransformReadOnly)transformTwoToWorld);
        List concaveHullTwoVertices = regionTwo.getConcaveHull();
        ArrayList<Point2D> concaveHullTwoVerticesTransformed = new ArrayList<Point2D>(concaveHullTwoVertices.size());
        for (int i = 0; i < concaveHullTwoVertices.size(); ++i) {
            Point3D point3D = new Point3D((Tuple2DReadOnly)concaveHullTwoVertices.get(i));
            transformTwoToOne.transform((Point3DBasics)point3D);
            if (Math.abs(point3D.getZ()) > maximumProjectionDistance) {
                return new ArrayList<PlanarRegion>();
            }
            concaveHullTwoVerticesTransformed.add(new Point2D((Tuple3DReadOnly)point3D));
        }
        List concaveHullOneVertices = regionOne.getConcaveHull();
        List<Point2D> mergedConcaveHull = ConcaveHullMerger.mergeConcaveHulls(concaveHullOneVertices, concaveHullTwoVerticesTransformed, listener);
        if (mergedConcaveHull == null) {
            return null;
        }
        if (mergedConcaveHull.isEmpty()) {
            return new ArrayList<PlanarRegion>();
        }
        ArrayList<ConvexPolygon2D> newPolygonsFromConcaveHull = new ArrayList<ConvexPolygon2D>();
        ConcaveHullDecomposition.recursiveApproximateDecomposition(mergedConcaveHull, 0.001, newPolygonsFromConcaveHull);
        RigidBodyTransform transformOneToWorld = new RigidBodyTransform();
        regionOne.getTransformToWorld(transformOneToWorld);
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformOneToWorld, mergedConcaveHull, newPolygonsFromConcaveHull);
        planarRegion.setRegionId(regionOne.getRegionId());
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        planarRegions.add(planarRegion);
        return planarRegions;
    }

    public static List<Point2D> mergeConcaveHulls(List<Point2D> hullOneIn, List<Point2D> hullTwoIn, ConcaveHullMergerListener listener) {
        BoundingBox2D finalBoundingBox;
        Point2D vertex;
        int i;
        BoundingBox2D hullTwoBoundingBox;
        boolean hullTwoListIsValid;
        if (listener != null) {
            listener.originalHulls(hullOneIn, hullTwoIn);
        }
        double minimumDistance = 1.0E-5;
        double infinitesimalDistance = 1.0E-14;
        Vector2D tempVector = null;
        for (Point2D a : hullOneIn) {
            for (Point2D b : hullTwoIn) {
                double distance = a.distance((Point2DReadOnly)b);
                if (distance < infinitesimalDistance) {
                    double randomAngle = randomForWiggling.nextDouble() * 2.0 * Math.PI;
                    double moveAmount = minimumDistance;
                    b.addX(moveAmount * Math.cos(randomAngle));
                    b.addY(moveAmount * Math.sin(randomAngle));
                    continue;
                }
                if (!(distance < minimumDistance)) continue;
                if (tempVector == null) {
                    tempVector = new Vector2D();
                }
                double moveAmount = (minimumDistance - distance) / 2.0;
                tempVector.sub((Tuple2DReadOnly)a, (Tuple2DReadOnly)b);
                tempVector.normalize();
                tempVector.scale(moveAmount);
                a.addX(tempVector.getX());
                a.addY(tempVector.getY());
                tempVector.negate();
                b.addX(tempVector.getX());
                b.addY(tempVector.getY());
            }
        }
        List<Point2D> originalHullOne = hullOneIn;
        List<Point2D> originalHullTwo = hullTwoIn;
        List<Point2D> hullOneList = hullOneIn;
        List<Point2D> hullTwoList = hullTwoIn;
        hullOneList = ConcaveHullMerger.preprocessHullByRemovingPoints(hullOneList);
        hullTwoList = ConcaveHullMerger.preprocessHullByRemovingPoints(hullTwoList);
        boolean hullOneListIsValid = hullOneList != null && hullOneList.size() >= 3 && !ConcaveHullMerger.isConcaveHullSelfIntersecting(hullOneList);
        boolean bl = hullTwoListIsValid = hullTwoList != null && hullTwoList.size() >= 3 && !ConcaveHullMerger.isConcaveHullSelfIntersecting(hullTwoList);
        if (!hullOneListIsValid && !hullTwoListIsValid) {
            ConcaveHullMerger.notifyListenerHullsAreInvalid(listener, hullOneList, hullTwoList);
            return null;
        }
        if (!hullTwoListIsValid) {
            ConcaveHullMerger.notifyListenerHullsAreInvalid(listener, hullTwoList);
            return hullOneList;
        }
        if (!hullOneListIsValid) {
            ConcaveHullMerger.notifyListenerHullsAreInvalid(listener, hullOneList);
            return hullTwoList;
        }
        BoundingBox2D hullOneBoundingBox = ConcaveHullMerger.createBoundingBox(hullOneList = ConcaveHullMerger.preprocessHullTwoToMoveDuplicatesOrOnEdges(hullTwoList = ConcaveHullMerger.preprocessHullTwoToMoveDuplicatesOrOnEdges(hullOneList, hullTwoList), hullOneList));
        if (!hullOneBoundingBox.intersectsExclusive((BoundingBox2DReadOnly)(hullTwoBoundingBox = ConcaveHullMerger.createBoundingBox(hullTwoList)))) {
            return new ArrayList<Point2D>();
        }
        BoundingBox2D unionOfOriginalBoundingBoxes = BoundingBox2D.union((BoundingBox2DReadOnly)hullOneBoundingBox, (BoundingBox2DReadOnly)hullTwoBoundingBox);
        if (listener != null) {
            listener.preprocessedHull(hullOneList, hullTwoList);
        }
        List<Point2D> workingHull = hullOneList;
        List<Point2D> restingHull = hullTwoList;
        double minX = Double.POSITIVE_INFINITY;
        Point2D startingVertex = null;
        int workingHullIndex = -1;
        for (i = 0; i < hullOneList.size(); ++i) {
            vertex = hullOneList.get(i);
            if (!(vertex.getX() < minX)) continue;
            minX = vertex.getX();
            startingVertex = vertex;
            workingHullIndex = i;
        }
        for (i = 0; i < hullTwoList.size(); ++i) {
            vertex = hullTwoList.get(i);
            if (!(vertex.getX() < minX)) continue;
            minX = vertex.getX();
            startingVertex = vertex;
            workingHullIndex = i;
            workingHull = hullTwoList;
            restingHull = hullOneList;
        }
        if (listener != null) {
            listener.foundStartingVertexAndWorkingHull(startingVertex, workingHull, workingHull == hullOneList);
        }
        boolean foundAnIntersection = false;
        ArrayList<Point2D> mergedVertices = new ArrayList<Point2D>();
        Point2D workingVertex = startingVertex;
        int nextIndex = (workingHullIndex + 1) % workingHull.size();
        int edgeStartIndexToSkip = -1;
        int count = 0;
        int veerticesInMergedHull = 0;
        boolean exitedWithoutALoop = false;
        int totalNumberOfVertices = hullOneList.size() + hullTwoList.size();
        while (count <= totalNumberOfVertices && veerticesInMergedHull < 4 * totalNumberOfVertices) {
            Pair<Integer, Point2D> intersection;
            mergedVertices.add(workingVertex);
            ++veerticesInMergedHull;
            Point2D nextVertex = workingHull.get(nextIndex);
            LineSegment2D workingEdge = new LineSegment2D((Point2DReadOnly)workingVertex, (Point2DReadOnly)nextVertex);
            if (listener != null) {
                listener.consideringWorkingEdge(workingEdge, workingHull == hullOneList);
            }
            if ((intersection = ConcaveHullMerger.findClosestIntersection(workingEdge, restingHull, edgeStartIndexToSkip)) == null) {
                workingVertex = nextVertex;
                if (workingVertex == startingVertex) {
                    exitedWithoutALoop = true;
                    break;
                }
                ++count;
                nextIndex = (nextIndex + 1) % workingHull.size();
                edgeStartIndexToSkip = -1;
                continue;
            }
            foundAnIntersection = true;
            Point2D intersectionPoint = (Point2D)intersection.getRight();
            if (listener != null) {
                listener.foundIntersectionPoint(intersectionPoint, workingHull == hullOneList);
            }
            if ((edgeStartIndexToSkip = nextIndex - 1) < 0) {
                edgeStartIndexToSkip = workingHull.size() - 1;
            }
            List<Point2D> temp = workingHull;
            workingHull = restingHull;
            restingHull = temp;
            nextIndex = (Integer)intersection.getLeft();
            workingVertex = intersectionPoint;
        }
        if (!exitedWithoutALoop) {
            LogTools.error((String)"mergedVertices.size() > hullOne.length + hullTwo.length. Something got looped!");
            if (listener != null) {
                listener.hullGotLooped(originalHullOne, originalHullTwo, mergedVertices);
            }
        }
        if (ConcaveHullMerger.boundingBoxShrunk(unionOfOriginalBoundingBoxes, finalBoundingBox = ConcaveHullMerger.createBoundingBox(mergedVertices))) {
            return new ArrayList<Point2D>();
        }
        if (!foundAnIntersection && unionOfOriginalBoundingBoxes.equals((BoundingBox2DReadOnly)finalBoundingBox) && !ConcaveHullMerger.isPointInsideConcaveHull(hullTwoList.get(0), hullOneList) && !ConcaveHullMerger.isPointInsideConcaveHull(hullOneList.get(0), hullTwoList)) {
            return new ArrayList<Point2D>();
        }
        return mergedVertices;
    }

    private static void notifyListenerHullsAreInvalid(ConcaveHullMergerListener listener, List<Point2D> hullList) {
        if (listener != null) {
            listener.hullIsInvalid(hullList);
        }
    }

    private static void notifyListenerHullsAreInvalid(ConcaveHullMergerListener listener, List<Point2D> hullListA, List<Point2D> hullListB) {
        if (listener != null) {
            listener.hullsAreInvalid(hullListA, hullListB);
        }
    }

    public static boolean isConcaveHullSelfIntersecting(List<Point2D> concaveHull) {
        if (concaveHull == null) {
            return false;
        }
        if (concaveHull.size() < 4) {
            return false;
        }
        block0: for (int i = 0; i < concaveHull.size(); ++i) {
            Point2D currentVertex = concaveHull.get(i);
            Point2D nextVertex = concaveHull.get(ConcaveHullMerger.nextIndex(i, concaveHull));
            LineSegment2D edge = new LineSegment2D((Point2DReadOnly)currentVertex, (Point2DReadOnly)nextVertex);
            int j = ConcaveHullMerger.nextIndex(ConcaveHullMerger.nextIndex(i, concaveHull), concaveHull);
            while (true) {
                Point2D firstVertexToCheck = concaveHull.get(j);
                Point2D secondVertexToCheck = concaveHull.get(ConcaveHullMerger.nextIndex(j, concaveHull));
                if (secondVertexToCheck == currentVertex) continue block0;
                LineSegment2D edgeToCheck = new LineSegment2D((Point2DReadOnly)firstVertexToCheck, (Point2DReadOnly)secondVertexToCheck);
                boolean edgesIntersect = edge.intersectionWith((LineSegment2DReadOnly)edgeToCheck, null);
                if (edgesIntersect) {
                    return true;
                }
                j = ConcaveHullMerger.nextIndex(j, concaveHull);
            }
        }
        return false;
    }

    public static List<Point2D> preprocessHullByRemovingPoints(List<Point2D> hull) {
        if (hull == null || hull.size() < 3) {
            return hull;
        }
        int incomingHullSize = hull.size();
        hull = ConcaveHullMerger.preprocessToRemovePointsThatAreTooCloseTogether(hull);
        if ((hull = ConcaveHullMerger.preprocessToRemoveSliversWithSmallAngles(hull)).size() < incomingHullSize) {
            return ConcaveHullMerger.preprocessHullByRemovingPoints(hull);
        }
        hull = ConcaveHullMerger.preprocessToRemoveColinearPoints(hull);
        return hull;
    }

    private static List<Point2D> preprocessToRemovePointsThatAreTooCloseTogether(List<Point2D> hull) {
        if (hull == null || hull.size() < 3) {
            return null;
        }
        ArrayList<Point2D> processedHull = new ArrayList<Point2D>();
        processedHull.add(hull.get(0));
        Point2D previousVertexAdded = hull.get(0);
        for (int i = 1; i < hull.size(); ++i) {
            Point2D vertex = hull.get(i);
            if (!(previousVertexAdded.distanceSquared((Point2DReadOnly)vertex) >= 2.5E-5)) continue;
            if (i == hull.size() - 1) {
                if (!(hull.get(0).distanceSquared((Point2DReadOnly)vertex) >= 2.5E-5)) continue;
                processedHull.add(vertex);
                previousVertexAdded = vertex;
                continue;
            }
            processedHull.add(vertex);
            previousVertexAdded = vertex;
        }
        return processedHull;
    }

    private static List<Point2D> preprocessToRemoveSliversWithSmallAngles(List<Point2D> hull) {
        if (hull == null || hull.size() < 3) {
            return null;
        }
        ArrayList<Point2D> processedHull = new ArrayList<Point2D>();
        for (int i = 0; i < hull.size(); ++i) {
            Point2D vertex = hull.get(i);
            Point2D previousVertex = hull.get(ConcaveHullMerger.previousIndex(i, hull));
            Point2D nextVertex = hull.get(ConcaveHullMerger.nextIndex(i, hull));
            Vector2D v1 = new Vector2D();
            v1.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)vertex);
            Vector2D v2 = new Vector2D();
            v2.sub((Tuple2DReadOnly)previousVertex, (Tuple2DReadOnly)vertex);
            double dotProductBetweenUnitVectors = v1.dot((Vector2DReadOnly)v2) / (v1.length() * v2.length());
            if (dotProductBetweenUnitVectors > maximumDotProductBetweenSkinnyEdges || nextVertex.distanceSquared((Point2DReadOnly)previousVertex) < 2.5E-5) continue;
            processedHull.add(vertex);
        }
        return processedHull;
    }

    private static List<Point2D> preprocessToRemoveColinearPoints(List<Point2D> hull) {
        if (hull == null || hull.size() < 3) {
            return null;
        }
        ArrayList<Point2D> processedHull = new ArrayList<Point2D>();
        for (int i = 0; i < hull.size(); ++i) {
            Point2D vertex = hull.get(i);
            Point2D previousVertex = hull.get(ConcaveHullMerger.previousIndex(i, hull));
            Point2D nextVertex = hull.get(ConcaveHullMerger.nextIndex(i, hull));
            Vector2D v1 = new Vector2D();
            v1.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)vertex);
            Vector2D v2 = new Vector2D();
            v2.sub((Tuple2DReadOnly)previousVertex, (Tuple2DReadOnly)vertex);
            double dotProductBetweenUnitVectors = v1.dot((Vector2DReadOnly)v2) / (v1.length() * v2.length());
            if (dotProductBetweenUnitVectors < -maximumDotProductBetweenSkinnyEdges) continue;
            processedHull.add(vertex);
        }
        return processedHull;
    }

    private static int nextIndex(int index, List<Point2D> hull) {
        return (index + 1) % hull.size();
    }

    private static int previousIndex(int index, List<Point2D> hull) {
        return (index - 1 + hull.size()) % hull.size();
    }

    private static boolean boundingBoxShrunk(BoundingBox2D unionOfOriginalBoundingBoxes, BoundingBox2D finalBoundingBox) {
        if (unionOfOriginalBoundingBoxes.getMinX() < finalBoundingBox.getMinX()) {
            return true;
        }
        if (unionOfOriginalBoundingBoxes.getMinY() < finalBoundingBox.getMinY()) {
            return true;
        }
        if (unionOfOriginalBoundingBoxes.getMaxX() > finalBoundingBox.getMaxX()) {
            return true;
        }
        return unionOfOriginalBoundingBoxes.getMaxY() > finalBoundingBox.getMaxY();
    }

    private static BoundingBox2D createBoundingBox(Point2D[] pointList) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Point2D point : pointList) {
            minX = Math.min(minX, point.getX());
            minY = Math.min(minY, point.getY());
            maxX = Math.max(maxX, point.getX());
            maxY = Math.max(maxY, point.getY());
        }
        return new BoundingBox2D(minX, minY, maxX, maxY);
    }

    private static BoundingBox2D createBoundingBox(Iterable<Point2D> pointList) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Point2D point : pointList) {
            minX = Math.min(minX, point.getX());
            minY = Math.min(minY, point.getY());
            maxX = Math.max(maxX, point.getX());
            maxY = Math.max(maxY, point.getY());
        }
        return new BoundingBox2D(minX, minY, maxX, maxY);
    }

    private static List<Point2D> preprocessHullTwoToMoveDuplicatesOrOnEdges(List<Point2D> hullOne, List<Point2D> hullTwo) {
        ArrayList<Point2D> newHull = new ArrayList<Point2D>();
        for (int i = 0; i < hullTwo.size(); ++i) {
            newHull.add(ConcaveHullMerger.preprocessHullPoint(hullOne, hullTwo.get(i)));
        }
        return newHull;
    }

    private static Point2D preprocessHullPoint(List<Point2D> hullOne, Point2D hullPoint) {
        Point2D nextVertex;
        Point2D startVertex;
        int i;
        for (i = 0; i < hullOne.size(); ++i) {
            startVertex = hullOne.get(i);
            nextVertex = hullOne.get(ConcaveHullMerger.nextIndex(i, hullOne));
            Point2D previousVertex = hullOne.get(ConcaveHullMerger.previousIndex(i, hullOne));
            if (!(hullPoint.distanceSquared((Point2DReadOnly)startVertex) < 4.0E-6)) continue;
            Vector2D toPrevious = new Vector2D((Tuple2DReadOnly)previousVertex);
            toPrevious.sub((Tuple2DReadOnly)startVertex);
            toPrevious.normalize();
            toPrevious.set(-toPrevious.getY(), toPrevious.getX());
            toPrevious.scale(0.0025);
            Vector2D toNext = new Vector2D((Tuple2DReadOnly)nextVertex);
            toNext.sub((Tuple2DReadOnly)startVertex);
            toNext.normalize();
            toNext.set(toNext.getY(), -toNext.getX());
            toNext.scale(0.0025);
            Vector2D adjustment = new Vector2D((Tuple2DReadOnly)toPrevious);
            adjustment.add((Tuple2DReadOnly)toNext);
            Point2D adjustedPoint = new Point2D((Tuple2DReadOnly)hullPoint);
            adjustedPoint.add((Tuple2DReadOnly)adjustment);
            return adjustedPoint;
        }
        for (i = 0; i < hullOne.size(); ++i) {
            startVertex = hullOne.get(i);
            LineSegment2D edge = new LineSegment2D((Point2DReadOnly)startVertex, (Point2DReadOnly)(nextVertex = hullOne.get(ConcaveHullMerger.nextIndex(i, hullOne))));
            if (!(edge.distanceSquared((Point2DReadOnly)hullPoint) < 4.0E-6)) continue;
            Vector2D adjustment = new Vector2D((Tuple2DReadOnly)nextVertex);
            adjustment.sub((Tuple2DReadOnly)startVertex);
            adjustment.normalize();
            adjustment.set(adjustment.getY(), -adjustment.getX());
            adjustment.scale(0.0025);
            Point2D adjustedPoint = new Point2D((Tuple2DReadOnly)hullPoint);
            adjustedPoint.add((Tuple2DReadOnly)adjustment);
            return adjustedPoint;
        }
        return new Point2D((Tuple2DReadOnly)hullPoint);
    }

    public static void printHull(String name, List<Point2D> hullPoints) {
        System.out.print("double[][]" + name + " = new double[][]{");
        for (int i = 0; i < hullPoints.size(); ++i) {
            Point2D point = hullPoints.get(i);
            System.out.print("{" + point.getX() + ", " + point.getY() + "}");
            if (i == hullPoints.size() - 1) {
                System.out.println();
                continue;
            }
            System.out.println(",");
        }
        System.out.println("};");
    }

    public static Pair<Integer, Point2D> findClosestIntersection(LineSegment2D edge, List<Point2D> concaveHull, int edgeStartIndexToSkip) {
        int previousIndex = concaveHull.size() - 1;
        int nextIndex = 0;
        int bestIndex = -1;
        Point2DBasics bestIntersection = null;
        double bestDistanceSquared = Double.POSITIVE_INFINITY;
        while (nextIndex < concaveHull.size()) {
            double distanceSquared;
            Point2D nextVertex;
            Point2D previousVertex;
            LineSegment2D hullEdge;
            Point2DBasics intersection;
            if (previousIndex != edgeStartIndexToSkip && (intersection = edge.intersectionWith((LineSegment2DReadOnly)(hullEdge = new LineSegment2D((Point2DReadOnly)(previousVertex = concaveHull.get(previousIndex)), (Point2DReadOnly)(nextVertex = concaveHull.get(nextIndex)))))) != null && (distanceSquared = edge.getFirstEndpoint().distanceSquared((Point2DReadOnly)intersection)) < bestDistanceSquared) {
                bestDistanceSquared = distanceSquared;
                bestIntersection = intersection;
                bestIndex = nextIndex;
            }
            previousIndex = nextIndex++;
        }
        if (bestIntersection == null) {
            return null;
        }
        return new ImmutablePair((Object)bestIndex, (Object)new Point2D(bestIntersection));
    }

    private static boolean isPointInsideConcaveHull(Point2D pointToCheck, List<Point2D> concaveHull) {
        int previousIndex = concaveHull.size() - 1;
        int nextIndex = 0;
        Vector2D rayDirectionOne = new Vector2D(1.01, 0.02);
        Vector2D rayDirectionTwo = new Vector2D(-1.05, 2.09);
        Vector2D rayDirectionThree = new Vector2D(-1.07, -1.03);
        int crossingCountOne = ConcaveHullMerger.countNumberOfCrossings(pointToCheck, concaveHull, previousIndex, nextIndex, rayDirectionOne);
        int crossingCountTwo = ConcaveHullMerger.countNumberOfCrossings(pointToCheck, concaveHull, previousIndex, nextIndex, rayDirectionTwo);
        int crossingCountThree = ConcaveHullMerger.countNumberOfCrossings(pointToCheck, concaveHull, previousIndex, nextIndex, rayDirectionThree);
        boolean isOddNumberOne = ConcaveHullMerger.isOddNumber(crossingCountOne);
        boolean isOddNumberTwo = ConcaveHullMerger.isOddNumber(crossingCountTwo);
        boolean isOddNumberThree = ConcaveHullMerger.isOddNumber(crossingCountThree);
        return ConcaveHullMerger.voteOnBooleans(isOddNumberOne, isOddNumberTwo, isOddNumberThree);
    }

    private static boolean voteOnBooleans(boolean ... votes) {
        int numberFor = 0;
        int numberAgainst = 0;
        for (boolean vote : votes) {
            if (vote) {
                ++numberFor;
                continue;
            }
            ++numberAgainst;
        }
        return numberFor > numberAgainst;
    }

    private static int countNumberOfCrossings(Point2D pointToCheck, List<Point2D> concaveHull, int previousIndex, int nextIndex, Vector2D rayDirection) {
        int crossingCount = 0;
        while (nextIndex < concaveHull.size()) {
            Point2D nextVertex;
            Point2D previousVertex = concaveHull.get(previousIndex);
            boolean rayIntersects = EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)pointToCheck, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)previousVertex, (Point2DReadOnly)(nextVertex = concaveHull.get(nextIndex)));
            if (rayIntersects) {
                ++crossingCount;
            }
            previousIndex = nextIndex++;
        }
        return crossingCount;
    }

    private static boolean isOddNumber(int number) {
        return number % 2 != 0;
    }
}

