/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMBasics;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMFrame;
import us.ihmc.robotEnvironmentAwareness.slam.SurfaceElementICPSLAMParameters;
import us.ihmc.robotEnvironmentAwareness.slam.tools.SLAMTools;
import us.ihmc.robotics.optimization.LevenbergMarquardtParameterOptimizer;
import us.ihmc.robotics.optimization.OutputCalculator;

public class SurfaceElementICPSLAM
extends SLAMBasics {
    public static final boolean DEBUG = false;
    private final AtomicReference<SurfaceElementICPSLAMParameters> parameters = new AtomicReference<SurfaceElementICPSLAMParameters>(new SurfaceElementICPSLAMParameters());

    public SurfaceElementICPSLAM(double octreeResolution) {
        this(octreeResolution, (RigidBodyTransformReadOnly)new RigidBodyTransform());
    }

    public SurfaceElementICPSLAM(double octreeResolution, RigidBodyTransformReadOnly transformFromLocalFrameToSensor) {
        super(octreeResolution, transformFromLocalFrameToSensor);
    }

    public void updateParameters(SurfaceElementICPSLAMParameters parameters) {
        this.parameters.set(parameters);
    }

    @Override
    public RigidBodyTransformReadOnly computeFrameCorrectionTransformer(final SLAMFrame frame) {
        final SurfaceElementICPSLAMParameters surfaceElementICPSLAMParameters = this.parameters.get();
        final Function transformConverter = LevenbergMarquardtParameterOptimizer.createSpatialInputFunction((boolean)surfaceElementICPSLAMParameters.getIncludePitchAndRoll());
        double surfaceElementResolution = surfaceElementICPSLAMParameters.getSurfaceElementResolution();
        double windowMargin = surfaceElementICPSLAMParameters.getWindowMargin();
        int minimumNumberOfHits = surfaceElementICPSLAMParameters.getMinimumNumberOfHit();
        int maxNumberOfSurfels = surfaceElementICPSLAMParameters.getMaxNumberOfSurfaceElements();
        frame.registerSurfaceElements(this.getMapOcTree(), windowMargin, surfaceElementResolution, minimumNumberOfHits, surfaceElementICPSLAMParameters.getComputeSurfaceNormalsInFrame(), maxNumberOfSurfels);
        int numberOfSurfel = frame.getNumberOfSurfaceElements();
        this.correctedCorrespondingPointLocation = new Point3D[numberOfSurfel];
        OutputCalculator outputCalculator = new OutputCalculator(){
            private List<Point3DReadOnly> surfaceElementPoints = new ArrayList<Point3DReadOnly>();

            public void setIndicesToCompute(TIntArrayList indicesToCompute) {
                this.surfaceElementPoints.clear();
                for (int i = 0; i < indicesToCompute.size(); ++i) {
                    this.surfaceElementPoints.add(frame.getSurfaceElementsInLocalFrame().get(indicesToCompute.get(i)).getPoint());
                }
            }

            public void resetIndicesToCompute() {
                Stream planeStream = frame.getSurfaceElementsInLocalFrame().stream();
                this.surfaceElementPoints = planeStream.map(Plane3DReadOnly::getPoint).collect(Collectors.toList());
            }

            public DMatrixRMaj apply(DMatrixRMaj inputParameter) {
                RigidBodyTransformReadOnly driftCorrectionTransform = (RigidBodyTransformReadOnly)transformConverter.apply(inputParameter);
                RigidBodyTransform correctedLocalPoseInWorld = new RigidBodyTransform(frame.getUncorrectedLocalPoseInWorld());
                correctedLocalPoseInWorld.multiply(driftCorrectionTransform);
                int size = this.surfaceElementPoints.size();
                SurfaceElementICPSLAM.this.correctedCorrespondingPointLocation = new Point3D[size];
                DMatrixRMaj errorSpace = new DMatrixRMaj(size, 1);
                Stream surfelPointStream = this.surfaceElementPoints.stream();
                List surfelPointsInWorld = surfelPointStream.map(arg_0 -> 1.lambda$apply$0((RigidBodyTransformBasics)correctedLocalPoseInWorld, arg_0)).collect(Collectors.toList());
                for (int i = 0; i < size; ++i) {
                    Point3D correctedSurfelInWorld = (Point3D)surfelPointsInWorld.get(i);
                    SurfaceElementICPSLAM.this.correctedCorrespondingPointLocation[i] = correctedSurfelInWorld;
                    double distance = this.computeClosestDistance((Point3DReadOnly)correctedSurfelInWorld);
                    errorSpace.set(i, distance);
                }
                return errorSpace;
            }

            private double computeClosestDistance(Point3DReadOnly surfelLocation) {
                return SLAMTools.computeBoundedPerpendicularDistancePointToNormalOctree(SurfaceElementICPSLAM.this.mapOcTree, surfelLocation, SurfaceElementICPSLAM.this.mapOcTree.getResolution() * surfaceElementICPSLAMParameters.getBoundRatio());
            }

            private static /* synthetic */ Point3D lambda$apply$0(RigidBodyTransformBasics correctedLocalPoseInWorld, Point3DReadOnly point) {
                Point3D correctedSurfelInWorld = new Point3D();
                correctedLocalPoseInWorld.transform(point, (Point3DBasics)correctedSurfelInWorld);
                return correctedSurfelInWorld;
            }
        };
        int problemSize = surfaceElementICPSLAMParameters.getIncludePitchAndRoll() ? 6 : 4;
        LevenbergMarquardtParameterOptimizer optimizer = new LevenbergMarquardtParameterOptimizer(transformConverter, outputCalculator, problemSize, numberOfSurfel);
        if (frame.getPreviousFrame() != null && surfaceElementICPSLAMParameters.getWarmStartDriftTransform()) {
            Function inverseTransformConverter = LevenbergMarquardtParameterOptimizer.createInverseSpatialInputFunction((boolean)surfaceElementICPSLAMParameters.getIncludePitchAndRoll());
            optimizer.setInitialOptimalGuess((DMatrixRMaj)inverseTransformConverter.apply(frame.getPreviousFrame().getDriftCompensationTransform()));
        }
        DMatrixRMaj perturbationVector = new DMatrixRMaj(problemSize, 1);
        double translationPerturbation = this.mapOcTree.getResolution() * surfaceElementICPSLAMParameters.getTranslationPerturbation();
        perturbationVector.set(0, translationPerturbation);
        perturbationVector.set(1, translationPerturbation);
        perturbationVector.set(2, translationPerturbation);
        perturbationVector.set(3, surfaceElementICPSLAMParameters.getRotationPerturbation());
        if (surfaceElementICPSLAMParameters.getIncludePitchAndRoll()) {
            perturbationVector.set(4, surfaceElementICPSLAMParameters.getRotationPerturbation());
            perturbationVector.set(5, surfaceElementICPSLAMParameters.getRotationPerturbation());
        }
        optimizer.setPerturbationVector(perturbationVector);
        boolean initialCondition = optimizer.initialize();
        if (!initialCondition) {
            // empty if block
        }
        optimizer.setCorrespondenceThreshold(surfaceElementICPSLAMParameters.getMinimumCorrespondingDistance());
        optimizer.setMaximumNumberOfCorrespondences(surfaceElementICPSLAMParameters.getMaxNumberOfCorrespondences());
        double initialQuality = optimizer.getQuality();
        this.driftCorrectionResult.setInitialDistance(initialQuality);
        if (surfaceElementICPSLAMParameters.isEnableInitialQualityFilter() && initialQuality > surfaceElementICPSLAMParameters.getInitialQualityThreshold()) {
            LogTools.warn((String)("initial quality is very bad ! " + initialQuality));
            return null;
        }
        double qualitySteadyThreshold = surfaceElementICPSLAMParameters.getQualityConvergenceThreshold();
        double translationalSteadyThreshold = surfaceElementICPSLAMParameters.getTranslationalEffortConvergenceThreshold();
        double rotationalSteadyThreshold = surfaceElementICPSLAMParameters.getRotationalEffortConvergenceThreshold();
        SteadyDetector qualitySteady = new SteadyDetector(initialQuality, qualitySteadyThreshold);
        SteadyDetector translationalSteady = new SteadyDetector(0.0, translationalSteadyThreshold);
        RotationalEffortSteadyDetector rotationalSteady = new RotationalEffortSteadyDetector(rotationalSteadyThreshold);
        int numberOfSteadyIterations = 0;
        int steadyIterationsThreshold = surfaceElementICPSLAMParameters.getSteadyStateDetectorIterationThreshold();
        RotationMatrix rotationalEffort = new RotationMatrix();
        RigidBodyTransform driftCompensationTransform = new RigidBodyTransform();
        int iterations = -1;
        for (int i = 0; i < surfaceElementICPSLAMParameters.getMaxOptimizationIterations(); ++i) {
            optimizer.iterate();
            optimizer.convertInputToTransform(optimizer.getOptimalParameter(), driftCompensationTransform);
            double quality = optimizer.getQuality();
            double translationalEffort = driftCompensationTransform.getTranslation().lengthSquared();
            rotationalEffort.set((RotationMatrixReadOnly)driftCompensationTransform.getRotation());
            numberOfSteadyIterations = qualitySteady.isSteady(quality) && translationalSteady.isSteady(translationalEffort) && rotationalSteady.isSteady(rotationalEffort) ? ++numberOfSteadyIterations : 0;
            if (numberOfSteadyIterations < steadyIterationsThreshold) continue;
            iterations = i;
            break;
        }
        optimizer.convertInputToTransform(optimizer.getOptimalParameter(), driftCompensationTransform);
        this.driftCorrectionResult.setFinalDistance(optimizer.getQuality());
        this.driftCorrectionResult.setNumberOfSurfels(numberOfSurfel);
        this.driftCorrectionResult.setDriftCorrectionTransformer((RigidBodyTransformReadOnly)driftCompensationTransform);
        this.driftCorrectionResult.setIcpIterations(iterations);
        this.driftCorrectionResult.setNumberOfCorrespondances(optimizer.getNumberOfCorrespondingPoints());
        if (iterations < 0) {
            this.driftCorrectionResult.setSuccess(false);
        } else {
            this.driftCorrectionResult.setSuccess(true);
        }
        return driftCompensationTransform;
    }

    private class RotationalEffortSteadyDetector {
        private final RotationMatrix previous = new RotationMatrix();
        private final double threshold;

        RotationalEffortSteadyDetector(double threshold) {
            this.threshold = threshold;
        }

        boolean isSteady(RotationMatrix current) {
            boolean isSteady = this.distance(this.previous, current) < this.threshold;
            this.previous.set(current);
            return isSteady;
        }

        double distance(RotationMatrix value, RotationMatrix other) {
            return new Quaternion((Orientation3DReadOnly)value).distance((QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)other));
        }
    }

    private class SteadyDetector {
        private double previous;
        private final double threshold;

        SteadyDetector(double current, double threshold) {
            this.previous = current;
            this.threshold = threshold;
        }

        boolean isSteady(double current) {
            boolean isSteady = this.distance(this.previous, current) < this.threshold;
            this.previous = current;
            return isSteady;
        }

        double distance(double value, double other) {
            return Math.abs(value - other);
        }
    }
}

