/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.Scanner;
import us.ihmc.jOctoMap.tools.ScannerTools;

public class PolygonizerParameters {
    private double concaveHullThreshold;
    private int minNumberOfNodes;
    private double shallowAngleThreshold;
    private double peakAngleThreshold;
    private double lengthThreshold;
    private double depthThreshold;
    private boolean cutNarrowPassage;

    public PolygonizerParameters() {
        this.setDefaultParameters();
    }

    public PolygonizerParameters(PolygonizerParameters other) {
        this.set(other);
    }

    public void setDefaultParameters() {
        this.concaveHullThreshold = 0.15;
        this.minNumberOfNodes = 10;
        this.shallowAngleThreshold = Math.toRadians(1.0);
        this.peakAngleThreshold = Math.toRadians(170.0);
        this.lengthThreshold = 0.05;
        this.depthThreshold = 0.1;
        this.cutNarrowPassage = true;
    }

    public void set(PolygonizerParameters other) {
        this.concaveHullThreshold = other.concaveHullThreshold;
        this.minNumberOfNodes = other.minNumberOfNodes;
        this.shallowAngleThreshold = other.shallowAngleThreshold;
        this.peakAngleThreshold = other.peakAngleThreshold;
        this.lengthThreshold = other.lengthThreshold;
        this.depthThreshold = other.depthThreshold;
        this.cutNarrowPassage = other.cutNarrowPassage;
    }

    public void setConcaveHullThreshold(double concaveHullThreshold) {
        this.concaveHullThreshold = concaveHullThreshold;
    }

    public void setMinNumberOfNodes(int minNumberOfNodes) {
        this.minNumberOfNodes = minNumberOfNodes;
    }

    public void setShallowAngleThreshold(double shallowAngleThreshold) {
        this.shallowAngleThreshold = shallowAngleThreshold;
    }

    public void setPeakAngleThreshold(double peakAngleThreshold) {
        this.peakAngleThreshold = peakAngleThreshold;
    }

    public void setLengthThreshold(double lengthThreshold) {
        this.lengthThreshold = lengthThreshold;
    }

    public void setDepthThreshold(double depthThreshold) {
        this.depthThreshold = depthThreshold;
    }

    public void setCutNarrowPassage(boolean cutNarrowPassage) {
        this.cutNarrowPassage = cutNarrowPassage;
    }

    public double getConcaveHullThreshold() {
        return this.concaveHullThreshold;
    }

    public int getMinNumberOfNodes() {
        return this.minNumberOfNodes;
    }

    public double getShallowAngleThreshold() {
        return this.shallowAngleThreshold;
    }

    public double getPeakAngleThreshold() {
        return this.peakAngleThreshold;
    }

    public double getLengthThreshold() {
        return this.lengthThreshold;
    }

    public double getDepthThreshold() {
        return this.depthThreshold;
    }

    public boolean getCutNarrowPassage() {
        return this.cutNarrowPassage;
    }

    public String toString() {
        return "concaveHullThreshold: " + this.concaveHullThreshold + ", minNumberOfNodes: " + this.minNumberOfNodes + ", shallowAngleThreshold: " + this.shallowAngleThreshold + ", peakAngleThreshold: " + this.peakAngleThreshold + ", lengthThreshold: " + this.lengthThreshold + ", depthThreshold: " + this.depthThreshold + ", cutNarrowPassage: " + this.cutNarrowPassage;
    }

    public void setFromString(String parametersAsString) {
        parametersAsString = parametersAsString.replace(",", "");
        Scanner scanner = new Scanner(parametersAsString);
        this.setConcaveHullThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)this.getConcaveHullThreshold()));
        this.setMinNumberOfNodes(ScannerTools.readNextInt((Scanner)scanner, (int)this.getMinNumberOfNodes()));
        this.setShallowAngleThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)this.getShallowAngleThreshold()));
        this.setPeakAngleThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)this.getPeakAngleThreshold()));
        this.setLengthThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)this.getLengthThreshold()));
        this.setDepthThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)this.getDepthThreshold()));
        this.setCutNarrowPassage(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)this.getCutNarrowPassage()));
        scanner.close();
    }

    public static PolygonizerParameters parse(String parametersAsString) {
        PolygonizerParameters parameters = new PolygonizerParameters();
        parameters.setFromString(parametersAsString);
        return parameters;
    }
}

