/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.jOctoMap.boundingBox.OcTreeBoundingBoxInterface;
import us.ihmc.jOctoMap.iterators.OcTreeIterable;
import us.ihmc.jOctoMap.iterators.OcTreeIteratorFactory;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.jOctoMap.node.baseImplementation.AbstractOcTreeNode;
import us.ihmc.jOctoMap.rules.interfaces.IteratorSelectionRule;
import us.ihmc.jOctoMap.tools.OcTreeNearestNeighborTools;
import us.ihmc.robotEnvironmentAwareness.exception.PlanarRegionSegmentationException;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationNodeData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerTools;
import us.ihmc.robotEnvironmentAwareness.planarRegion.SurfaceNormalFilterParameters;

public class PlanarRegionSegmentationCalculator {
    private final Random random = new Random(234324L);
    private final Set<NormalOcTreeNode> allRegionNodes = new HashSet<NormalOcTreeNode>();
    private List<PlanarRegionSegmentationNodeData> regionsNodeData = new ArrayList<PlanarRegionSegmentationNodeData>();
    private final List<NormalOcTreeNode> nodesWithoutRegion = new ArrayList<NormalOcTreeNode>();
    private PlanarRegionSegmentationParameters parameters;
    private SurfaceNormalFilterParameters surfaceNormalFilterParameters;
    private OcTreeBoundingBoxInterface boundingBox;
    private Vector3D estimatedSensorPosition = new Vector3D();

    public void compute(NormalOcTreeNode root) {
        this.allRegionNodes.clear();
        this.regionsNodeData.parallelStream().forEach(region -> PlanarRegionSegmentationCalculator.removeBadNodesFromRegion(this.boundingBox, this.parameters, region));
        this.regionsNodeData = this.regionsNodeData.parallelStream().filter(region -> !region.isEmpty()).collect(Collectors.toList());
        this.regionsNodeData.forEach(region -> region.nodeStream().forEach(this.allRegionNodes::add));
        this.regionsNodeData.forEach(region -> this.growPlanarRegion(root, (PlanarRegionSegmentationNodeData)region, this.boundingBox, this.parameters));
        this.regionsNodeData = this.regionsNodeData.stream().filter(region -> region.getNumberOfNodes() > this.parameters.getMinRegionSize()).collect(Collectors.toList());
        HashSet nodeSet = new HashSet();
        nodeSet.clear();
        new OcTreeIterable((AbstractOcTreeNode)root, this.leafInBoundingBoxWithNormalSetRule(this.boundingBox)).forEach(nodeSet::add);
        nodeSet.removeAll(this.allRegionNodes);
        this.nodesWithoutRegion.clear();
        this.nodesWithoutRegion.addAll(nodeSet);
        this.regionsNodeData.addAll(this.searchNewPlanarRegions(root, this.boundingBox, this.parameters, this.random));
        this.regionsNodeData.parallelStream().forEach(PlanarRegionSegmentationNodeData::recomputeNormalAndOrigin);
        this.regionsNodeData.parallelStream().forEach(PlanarRegionSegmentationCalculator::flipNormalOfOutliers);
        this.regionsNodeData = this.regionsNodeData.parallelStream().filter(region -> !this.isRegionSparse((PlanarRegionSegmentationNodeData)region)).collect(Collectors.toList());
        this.regionsNodeData = PlanarRegionSegmentationCalculator.mergePlanarRegionsIfPossible(root, this.regionsNodeData, this.parameters);
    }

    public boolean isRegionSparse(PlanarRegionSegmentationNodeData region) {
        Vector3D standardDeviationPrincipalValues = region.getStandardDeviationPrincipalValues();
        if (standardDeviationPrincipalValues.getZ() > this.parameters.getMaxStandardDeviation()) {
            return true;
        }
        double density = (double)region.getNumberOfNodes() / PolygonizerTools.computeEllipsoidVolume((Vector3DReadOnly)standardDeviationPrincipalValues);
        return density < this.parameters.getMinVolumicDensity();
    }

    public void removeDeadNodes() {
        this.regionsNodeData.stream().forEach(region -> PlanarRegionSegmentationCalculator.removeDeadNodesFromRegion(region));
    }

    public List<PlanarRegionSegmentationNodeData> getSegmentationNodeData() {
        return this.regionsNodeData;
    }

    public List<PlanarRegionSegmentationRawData> getSegmentationRawData() {
        return this.regionsNodeData.stream().map(PlanarRegionSegmentationRawData::new).collect(Collectors.toList());
    }

    public void clear() {
        this.regionsNodeData.clear();
    }

    private IteratorSelectionRule<NormalOcTreeNode> leafInBoundingBoxWithNormalSetRule(OcTreeBoundingBoxInterface boundingBox) {
        IteratorSelectionRule isNormalSetRule = (node, maxDepth) -> node.isNormalSet();
        return OcTreeIteratorFactory.multipleRule((IteratorSelectionRule[])new IteratorSelectionRule[]{OcTreeIteratorFactory.leavesInsideBoundingBoxOnly((OcTreeBoundingBoxInterface)boundingBox), isNormalSetRule});
    }

    public static void flipNormalOfOutliers(PlanarRegionSegmentationNodeData region) {
        int numberOfNormalsNotFlipped;
        Vector3D regionNormal = region.getNormal();
        int numberOfNormalsFlipped = (int)region.nodeParallelStream().filter(node -> PlanarRegionSegmentationCalculator.isNodeNormalFlipped(node, regionNormal)).count();
        if (numberOfNormalsFlipped > (numberOfNormalsNotFlipped = region.getNumberOfNodes() - numberOfNormalsFlipped)) {
            regionNormal.negate();
        }
        region.nodeParallelStream().filter(node -> PlanarRegionSegmentationCalculator.isNodeNormalFlipped(node, regionNormal)).forEach(NormalOcTreeNode::negateNormal);
    }

    private static boolean isNodeNormalFlipped(NormalOcTreeNode node, Vector3D referenceNormal) {
        return node.getNormalX() * referenceNormal.getX() + node.getNormalY() * referenceNormal.getY() + node.getNormalZ() * referenceNormal.getZ() < 0.0;
    }

    public static List<PlanarRegionSegmentationNodeData> mergePlanarRegionsIfPossible(NormalOcTreeNode root, List<PlanarRegionSegmentationNodeData> inputRegions, PlanarRegionSegmentationParameters parameters) {
        ArrayList<PlanarRegionSegmentationNodeData> mergedRegions = new ArrayList<PlanarRegionSegmentationNodeData>();
        while (!inputRegions.isEmpty()) {
            PlanarRegionSegmentationNodeData candidateForMergeOtherRegions = inputRegions.get(0);
            Map<Boolean, List<PlanarRegionSegmentationNodeData>> mergeableAndNonMergeableGroups = inputRegions.subList(1, inputRegions.size()).parallelStream().collect(Collectors.groupingBy(other -> PlanarRegionSegmentationCalculator.areRegionsMergeable(root, candidateForMergeOtherRegions, other, parameters)));
            mergeableAndNonMergeableGroups.getOrDefault(true, Collections.emptyList()).forEach(candidateForMergeOtherRegions::addNodesFromOtherRegion);
            inputRegions = mergeableAndNonMergeableGroups.getOrDefault(false, Collections.emptyList());
            mergedRegions.add(candidateForMergeOtherRegions);
        }
        return mergedRegions;
    }

    public static boolean areRegionsMergeable(NormalOcTreeNode root, PlanarRegionSegmentationNodeData currentRegion, PlanarRegionSegmentationNodeData potentialRegionToMerge, PlanarRegionSegmentationParameters parameters) {
        PlanarRegionSegmentationNodeData otherRegion;
        PlanarRegionSegmentationNodeData regionToNavigate;
        if (currentRegion == potentialRegionToMerge) {
            throw new PlanarRegionSegmentationException("Problem Houston.");
        }
        double maxDistanceFromPlane = parameters.getMaxDistanceFromPlane();
        if (currentRegion.absoluteOrthogonalDistance((Point3DReadOnly)potentialRegionToMerge.getOrigin()) > maxDistanceFromPlane) {
            return false;
        }
        double dotThreshold = Math.cos(parameters.getMaxAngleFromPlane());
        if (currentRegion.absoluteDot(potentialRegionToMerge) < dotThreshold) {
            return false;
        }
        double searchRadius = parameters.getSearchRadius();
        double searchRadiusSquared = searchRadius * searchRadius;
        if (currentRegion.distanceSquaredFromOtherRegionBoundingBox(potentialRegionToMerge) > searchRadiusSquared) {
            return false;
        }
        if (potentialRegionToMerge.getNumberOfNodes() < currentRegion.getNumberOfNodes()) {
            regionToNavigate = potentialRegionToMerge;
            otherRegion = currentRegion;
        } else {
            regionToNavigate = currentRegion;
            otherRegion = potentialRegionToMerge;
        }
        return regionToNavigate.nodeStream().filter(node -> otherRegion.distanceFromBoundingBox((NormalOcTreeNode)node) < searchRadiusSquared).anyMatch(node -> PlanarRegionSegmentationCalculator.isNodeInOtherRegionNeighborhood(root, node, otherRegion, searchRadius));
    }

    public static boolean isNodeInOtherRegionNeighborhood(NormalOcTreeNode root, NormalOcTreeNode nodeFromOneRegion, final PlanarRegionSegmentationNodeData otherRegion, double searchRadius) {
        final MutableBoolean foundNeighborFromOtherRegion = new MutableBoolean(false);
        OcTreeNearestNeighborTools.NeighborActionRule<NormalOcTreeNode> actionRule = new OcTreeNearestNeighborTools.NeighborActionRule<NormalOcTreeNode>(){

            public void doActionOnNeighbor(NormalOcTreeNode node) {
                if (otherRegion.contains(node)) {
                    foundNeighborFromOtherRegion.setTrue();
                }
            }

            public boolean earlyAbort() {
                return foundNeighborFromOtherRegion.booleanValue();
            }
        };
        OcTreeNearestNeighborTools.findRadiusNeighbors((AbstractOcTreeNode)root, (AbstractOcTreeNode)nodeFromOneRegion, (double)searchRadius, (OcTreeNearestNeighborTools.NeighborActionRule)actionRule);
        return foundNeighborFromOtherRegion.booleanValue();
    }

    public List<PlanarRegionSegmentationNodeData> searchNewPlanarRegions(NormalOcTreeNode root, OcTreeBoundingBoxInterface boundingBox, PlanarRegionSegmentationParameters parameters, Random random) {
        ArrayList<PlanarRegionSegmentationNodeData> newRegions = new ArrayList<PlanarRegionSegmentationNodeData>();
        float minNormalQuality = (float)parameters.getMinNormalQuality();
        for (NormalOcTreeNode node : this.nodesWithoutRegion) {
            if (node.getNormalAverageDeviation() > minNormalQuality) continue;
            int regionId = -1;
            while (regionId == -1) {
                regionId = random.nextInt(Integer.MAX_VALUE);
            }
            PlanarRegionSegmentationNodeData region = this.createNewOcTreeNodePlanarRegion(root, node, regionId, boundingBox, parameters);
            if (region.getNumberOfNodes() <= parameters.getMinRegionSize()) continue;
            newRegions.add(region);
        }
        return newRegions;
    }

    public PlanarRegionSegmentationNodeData createNewOcTreeNodePlanarRegion(NormalOcTreeNode root, NormalOcTreeNode seedNode, int regionId, OcTreeBoundingBoxInterface boundingBox, PlanarRegionSegmentationParameters parameters) {
        PlanarRegionSegmentationNodeData newRegion = new PlanarRegionSegmentationNodeData(regionId);
        newRegion.addNode(seedNode);
        this.growPlanarRegion(root, newRegion, boundingBox, parameters);
        return newRegion;
    }

    public void growPlanarRegion(NormalOcTreeNode root, PlanarRegionSegmentationNodeData ocTreeNodePlanarRegion, OcTreeBoundingBoxInterface boundingBox, PlanarRegionSegmentationParameters parameters) {
        double searchRadius = parameters.getSearchRadius();
        HashSet newSetToExplore = new HashSet();
        OcTreeNearestNeighborTools.NeighborActionRule extendSearchRule = neighborNode -> this.recordCandidatesForRegion((NormalOcTreeNode)neighborNode, ocTreeNodePlanarRegion, newSetToExplore, boundingBox, parameters);
        if (this.surfaceNormalFilterParameters.isUseSurfaceNormalFilter() && !this.estimatedSensorPosition.containsNaN()) {
            double surfaceNormalLowerBound = this.surfaceNormalFilterParameters.getSurfaceNormalLowerBound();
            double surfaceNormalUpperBound = this.surfaceNormalFilterParameters.getSurfaceNormalUpperBound();
            double lowerBound = Math.cos(surfaceNormalLowerBound) * Math.signum(surfaceNormalLowerBound);
            double upperBound = Math.cos(surfaceNormalUpperBound) * Math.signum(surfaceNormalUpperBound);
            ocTreeNodePlanarRegion.nodeStream().filter(node -> PlanarRegionSegmentationCalculator.isNodeInBoundingBox(node, boundingBox) && PlanarRegionSegmentationCalculator.isNodeSurfaceNormalInBoundary(node, this.estimatedSensorPosition, lowerBound, upperBound)).forEach(regionNode -> OcTreeNearestNeighborTools.findRadiusNeighbors((AbstractOcTreeNode)root, (AbstractOcTreeNode)regionNode, (double)searchRadius, (OcTreeNearestNeighborTools.NeighborActionRule)extendSearchRule));
        } else {
            ocTreeNodePlanarRegion.nodeStream().filter(node -> PlanarRegionSegmentationCalculator.isNodeInBoundingBox(node, boundingBox)).forEach(regionNode -> OcTreeNearestNeighborTools.findRadiusNeighbors((AbstractOcTreeNode)root, (AbstractOcTreeNode)regionNode, (double)searchRadius, (OcTreeNearestNeighborTools.NeighborActionRule)extendSearchRule));
        }
        ArrayDeque nodesToExplore = new ArrayDeque(newSetToExplore);
        while (!nodesToExplore.isEmpty()) {
            NormalOcTreeNode currentNode = (NormalOcTreeNode)nodesToExplore.poll();
            if (!ocTreeNodePlanarRegion.addNode(currentNode)) continue;
            this.allRegionNodes.add(currentNode);
            newSetToExplore.clear();
            OcTreeNearestNeighborTools.findRadiusNeighbors((AbstractOcTreeNode)root, (AbstractOcTreeNode)currentNode, (double)searchRadius, (OcTreeNearestNeighborTools.NeighborActionRule)extendSearchRule);
            nodesToExplore.addAll(newSetToExplore);
        }
    }

    public void recordCandidatesForRegion(NormalOcTreeNode neighborNode, PlanarRegionSegmentationNodeData region, Set<NormalOcTreeNode> newSetToExplore, OcTreeBoundingBoxInterface boundingBox, PlanarRegionSegmentationParameters parameters) {
        if (this.allRegionNodes.contains(neighborNode)) {
            return;
        }
        if (!PlanarRegionSegmentationCalculator.isNodeInBoundingBox(neighborNode, boundingBox)) {
            return;
        }
        if (!PlanarRegionSegmentationCalculator.isNodePartOfRegion(neighborNode, region, parameters.getMaxDistanceFromPlane(), Math.cos(parameters.getMaxAngleFromPlane()))) {
            return;
        }
        if (!neighborNode.isNormalSet() || !neighborNode.isHitLocationSet()) {
            return;
        }
        newSetToExplore.add(neighborNode);
    }

    private static void removeBadNodesFromRegion(OcTreeBoundingBoxInterface boundingBox, PlanarRegionSegmentationParameters parameters, PlanarRegionSegmentationNodeData region) {
        List<NormalOcTreeNode> nodesToRemove = region.nodeStream().collect(Collectors.groupingBy(node -> PlanarRegionSegmentationCalculator.isBadNode(node, region, boundingBox, parameters))).getOrDefault(true, Collections.emptyList());
        region.removeNodesAndUpdate(nodesToRemove);
    }

    private static void removeDeadNodesFromRegion(PlanarRegionSegmentationNodeData region) {
        List<NormalOcTreeNode> nodesToRemove = region.nodeStream().collect(Collectors.groupingBy(node -> PlanarRegionSegmentationCalculator.isNodeDead(node))).getOrDefault(true, Collections.emptyList());
        region.removeNodesAndUpdate(nodesToRemove);
    }

    private static boolean isNodeInBoundingBox(NormalOcTreeNode node, OcTreeBoundingBoxInterface boundingBox) {
        return boundingBox == null || boundingBox.isInBoundingBox(node.getX(), node.getY(), node.getZ());
    }

    private static boolean isBadNode(NormalOcTreeNode node, PlanarRegionSegmentationNodeData region, OcTreeBoundingBoxInterface boundingBox, PlanarRegionSegmentationParameters parameters) {
        if (PlanarRegionSegmentationCalculator.isNodeDead(node)) {
            return true;
        }
        double maxDistanceFromPlane = parameters.getMaxDistanceFromPlane();
        double dotThreshold = Math.cos(parameters.getMaxAngleFromPlane());
        return PlanarRegionSegmentationCalculator.isNodeInBoundingBox(node, boundingBox) && !PlanarRegionSegmentationCalculator.isNodePartOfRegion(node, region, maxDistanceFromPlane, dotThreshold);
    }

    private static boolean isNodeDead(NormalOcTreeNode node) {
        return !node.isNormalSet();
    }

    public static boolean isNodePartOfRegion(NormalOcTreeNode node, PlanarRegionSegmentationNodeData region, double maxDistanceFromPlane, double dotThreshold) {
        double absoluteOrthogonalDistance = region.absoluteOrthogonalDistance(node);
        if (absoluteOrthogonalDistance > maxDistanceFromPlane) {
            return false;
        }
        double absoluteDot = region.absoluteDotWithNodeNormal(node);
        return absoluteDot > dotThreshold;
    }

    private static boolean isNodeSurfaceNormalInBoundary(NormalOcTreeNode node, Vector3D cameraPosition, double lowerBound, double upperBound) {
        Vector3D cameraToNode = new Vector3D(node.getHitLocationX(), node.getHitLocationY(), node.getHitLocationZ());
        cameraToNode.add(-cameraPosition.getX(), -cameraPosition.getY(), -cameraPosition.getZ());
        Vector3D surfaceNormal = node.getNormalCopy();
        cameraToNode.normalize();
        double dotValue = cameraToNode.dot((Vector3DReadOnly)surfaceNormal);
        boolean isVisible = lowerBound > dotValue || dotValue > upperBound;
        return isVisible;
    }

    public void setParameters(PlanarRegionSegmentationParameters parameters) {
        this.parameters = parameters;
    }

    public void setSurfaceNormalFilterParameters(SurfaceNormalFilterParameters parameters) {
        this.surfaceNormalFilterParameters = parameters;
    }

    public void setBoundingBox(OcTreeBoundingBoxInterface boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void setSensorPosition(Tuple3DReadOnly estimatedPosition) {
        if (estimatedPosition == null) {
            this.estimatedSensorPosition.setToNaN();
        } else {
            this.estimatedSensorPosition.set(estimatedPosition);
        }
    }
}

