/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullDecomposition;
import us.ihmc.robotEnvironmentAwareness.geometry.REAGeometryTools;
import us.ihmc.robotEnvironmentAwareness.planarRegion.CustomRegionMergeParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;
import us.ihmc.robotics.geometry.PlanarRegion;

public class CustomPlanarRegionHandler {
    public static void performConvexDecompositionIfNeeded(PlanarRegion customRegion) {
        if (customRegion.getNumberOfConvexPolygons() > 0) {
            return;
        }
        if (customRegion.getConcaveHull().isEmpty()) {
            throw new IllegalArgumentException("Invalid planar region: missing the concave hull information.");
        }
        ArrayList<ConvexPolygon2D> decomposedPolygons = new ArrayList<ConvexPolygon2D>();
        double depthThreshold = 0.01;
        ConcaveHullDecomposition.recursiveApproximateDecomposition(customRegion.getConcaveHull(), depthThreshold, decomposedPolygons);
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        customRegion.getTransformToWorld(transformToWorld);
        customRegion.set(transformToWorld, decomposedPolygons);
    }

    public static List<PlanarRegion> mergeCustomRegionsToEstimatedRegions(Collection<PlanarRegion> customRegions, List<PlanarRegionSegmentationRawData> estimatedRegions, CustomRegionMergeParameters parameters) {
        boolean atLeastOneRegionWasMerged = true;
        List<Object> previousUnmergedRegions = new ArrayList<PlanarRegion>(customRegions);
        List<Object> currentUnmergedRegions = Collections.emptyList();
        while (atLeastOneRegionWasMerged) {
            currentUnmergedRegions = previousUnmergedRegions.stream().filter(customRegion -> CustomPlanarRegionHandler.mergeCustomRegionToEstimatedRegions(customRegion, estimatedRegions, parameters) == null).collect(Collectors.toList());
            atLeastOneRegionWasMerged = currentUnmergedRegions.size() < previousUnmergedRegions.size();
            previousUnmergedRegions = currentUnmergedRegions;
        }
        return currentUnmergedRegions;
    }

    public static List<PlanarRegionSegmentationRawData> mergeCustomRegionToEstimatedRegions(PlanarRegion customRegion, List<PlanarRegionSegmentationRawData> estimatedRegions, CustomRegionMergeParameters parameters) {
        ArrayList<PlanarRegionSegmentationRawData> modifiedEstimatedRegions = new ArrayList<PlanarRegionSegmentationRawData>();
        for (PlanarRegionSegmentationRawData estimatedRegion : estimatedRegions) {
            if (!CustomPlanarRegionHandler.isCustomRegionMergeableToEstimatedRegion(customRegion, estimatedRegion, parameters)) continue;
            RigidBodyTransform transformToWorld = new RigidBodyTransform();
            customRegion.getTransformToWorld(transformToWorld);
            List vertices = customRegion.getConcaveHull().stream().map(Point3D::new).peek(arg_0 -> ((RigidBodyTransform)transformToWorld).transform(arg_0)).collect(Collectors.toList());
            Point3D previousVertex = (Point3D)vertices.get(vertices.size() - 1);
            for (Point3D vertex : vertices) {
                estimatedRegion.addIntersection((LineSegment3DReadOnly)new LineSegment3D((Point3DReadOnly)previousVertex, (Point3DReadOnly)vertex));
                previousVertex = vertex;
            }
            modifiedEstimatedRegions.add(estimatedRegion);
        }
        return modifiedEstimatedRegions.isEmpty() ? null : modifiedEstimatedRegions;
    }

    private static boolean isCustomRegionMergeableToEstimatedRegion(PlanarRegion customRegion, PlanarRegionSegmentationRawData estimatedRegion, CustomRegionMergeParameters parameters) {
        double maxDistanceFromPlane = parameters.getMaxDistanceFromPlane();
        double distanceFromPlane = EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)customRegion.getPlane().getPoint(), (Point3DReadOnly)estimatedRegion.getOrigin(), (Vector3DReadOnly)estimatedRegion.getNormal());
        if (distanceFromPlane > maxDistanceFromPlane) {
            return false;
        }
        double dotThreshold = Math.cos(parameters.getMaxAngleFromPlane());
        double normalDotProduct = Math.abs(estimatedRegion.getNormal().dot((Vector3DReadOnly)customRegion.getNormal()));
        if (normalDotProduct < dotThreshold) {
            return false;
        }
        double searchRadius = parameters.getSearchRadius();
        double searchRadiusSquared = searchRadius * searchRadius;
        BoundingBox3D customRegionBBX = customRegion.getBoundingBox3dInWorld();
        double bbxDistance = REAGeometryTools.distanceSquaredBetweenTwoBoundingBox3Ds((Point3DReadOnly)estimatedRegion.getBoundingBoxInWorld().getMinPoint(), (Point3DReadOnly)estimatedRegion.getBoundingBoxInWorld().getMaxPoint(), (Point3DReadOnly)customRegionBBX.getMinPoint(), (Point3DReadOnly)customRegionBBX.getMaxPoint());
        if (bbxDistance > searchRadiusSquared) {
            return false;
        }
        return estimatedRegion.getPointCloudInWorld().parallelStream().map(Point3D::new).peek(arg_0 -> ((PlanarRegion)customRegion).transformFromWorldToLocal(arg_0)).map(Point2D::new).anyMatch(point -> customRegion.distanceToPoint((Point2DReadOnly)point) < searchRadius);
    }
}

