/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.perceptionSuite;

import controller_msgs.msg.dds.LidarScanMessage;
import controller_msgs.msg.dds.NormalEstimationParametersMessage;
import controller_msgs.msg.dds.OcTreeKeyListMessage;
import controller_msgs.msg.dds.PlanarRegionSegmentationParametersMessage;
import controller_msgs.msg.dds.PlanarRegionsListMessage;
import controller_msgs.msg.dds.PolygonizerParametersMessage;
import controller_msgs.msg.dds.REASensorDataFilterParametersMessage;
import controller_msgs.msg.dds.REAStateRequestMessage;
import controller_msgs.msg.dds.RequestPlanarRegionsListMessage;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.OcTreeMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAParametersMessageHelper;
import us.ihmc.robotEnvironmentAwareness.ros.REAModuleROS2Subscription;
import us.ihmc.robotEnvironmentAwareness.ros.REASourceType;
import us.ihmc.robotEnvironmentAwareness.updaters.REACurrentStateProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.RegionFeaturesProvider;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class LidarREANetworkProvider
implements REANetworkProvider {
    private final IHMCROS2Publisher<PlanarRegionsListMessage> planarRegionPublisher;
    private final IHMCROS2Publisher<PlanarRegionsListMessage> lidarRegionPublisher;
    private final IHMCROS2Publisher<OcTreeKeyListMessage> ocTreePublisher;
    private REACurrentStateProvider currentStateProvider = null;
    private final ROS2Node ros2Node;
    private final ROS2Topic<PlanarRegionsListMessage> outputTopic;
    private PlanarRegionsListMessage lastPlanarRegionsListMessage;

    public LidarREANetworkProvider(ROS2Topic outputTopic, ROS2Topic lidarOutputTopic) {
        this(ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module"), outputTopic, lidarOutputTopic);
    }

    public LidarREANetworkProvider(ROS2Node ros2Node, ROS2Topic outputTopic, ROS2Topic lidarOutputTopic) {
        this.ros2Node = ros2Node;
        this.outputTopic = outputTopic;
        this.planarRegionPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)outputTopic);
        this.lidarRegionPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)lidarOutputTopic);
        this.ocTreePublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, OcTreeKeyListMessage.class, (ROS2Topic)outputTopic);
    }

    @Override
    public void registerMessager(Messager messager) {
        this.currentStateProvider = new REACurrentStateProvider((ROS2NodeInterface)this.ros2Node, this.outputTopic, messager);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, NormalEstimationParametersMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic, s -> messager.submitMessage(REAModuleAPI.NormalEstimationParameters, (Object)REAParametersMessageHelper.convertFromMessage((NormalEstimationParametersMessage)s.takeNextData())));
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, PlanarRegionSegmentationParametersMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic, s -> messager.submitMessage(REAModuleAPI.PlanarRegionsSegmentationParameters, (Object)REAParametersMessageHelper.convertFromMessage((PlanarRegionSegmentationParametersMessage)s.takeNextData())));
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, PolygonizerParametersMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic, s -> messager.submitMessage(REAModuleAPI.PlanarRegionsPolygonizerParameters, (Object)REAParametersMessageHelper.convertFromMessage((PolygonizerParametersMessage)s.takeNextData())));
    }

    @Override
    public void update(RegionFeaturesProvider regionFeaturesProvider, boolean planarRegionsHaveBeenUpdated, NormalOcTree ocTree) {
        if (regionFeaturesProvider.getPlanarRegionsList() != null && !regionFeaturesProvider.getPlanarRegionsList().isEmpty()) {
            if (planarRegionsHaveBeenUpdated) {
                this.lastPlanarRegionsListMessage = PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)regionFeaturesProvider.getPlanarRegionsList());
            }
            this.planarRegionPublisher.publish((Object)this.lastPlanarRegionsListMessage);
            this.lidarRegionPublisher.publish((Object)this.lastPlanarRegionsListMessage);
        }
        if (ocTree != null && ocTree.getRoot() != null) {
            OcTreeKeyListMessage ocTreeMessage = OcTreeMessageConverter.createOcTreeDataMessage(ocTree);
            this.ocTreePublisher.publish((Object)ocTreeMessage);
        }
    }

    @Override
    public void publishCurrentState() {
        if (this.currentStateProvider != null) {
            this.currentStateProvider.publishCurrentState();
        }
    }

    @Override
    public void registerLidarScanHandler(NewMessageListener<LidarScanMessage> lidarScanHandler) {
        ROS2Tools.createCallbackSubscription((ROS2NodeInterface)this.ros2Node, LidarScanMessage.class, (String)REASourceType.LIDAR_SCAN.getTopicName(), lidarScanHandler);
    }

    @Override
    public void registerLidarScanHandler(Messager messager, NewMessageListener<LidarScanMessage> lidarScanHandler) {
        new REAModuleROS2Subscription<LidarScanMessage>((ROS2NodeInterface)this.ros2Node, messager, REASourceType.LIDAR_SCAN, LidarScanMessage.class, lidarScanHandler);
    }

    @Override
    public void registerCustomRegionsHandler(NewMessageListener<PlanarRegionsListMessage> customRegionsHandler) {
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.subscriberCustomRegionsTopicName, customRegionsHandler);
    }

    @Override
    public void registerPlanarRegionsListRequestHandler(NewMessageListener<RequestPlanarRegionsListMessage> requestHandler) {
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, RequestPlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic, requestHandler);
    }

    @Override
    public void registerREAStateRequestHandler(NewMessageListener<REAStateRequestMessage> requestHandler) {
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, REAStateRequestMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic, requestHandler);
    }

    @Override
    public void registerREASensorDataFilterParametersHandler(NewMessageListener<REASensorDataFilterParametersMessage> parametersHandler) {
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, REASensorDataFilterParametersMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic, parametersHandler);
    }

    @Override
    public void stop() {
        this.ros2Node.destroy();
    }
}

