/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import com.vividsolutions.jts.triangulate.ConstraintEnforcementException;
import com.vividsolutions.jts.triangulate.quadedge.LocateFailureException;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeTriangle;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import us.ihmc.commons.lists.ListWrappingIndexTools;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHull;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullCollection;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullFactoryParameters;
import us.ihmc.robotEnvironmentAwareness.geometry.JTSTools;

public abstract class SimpleConcaveHullFactory {
    private static final boolean VERBOSE = false;
    private static final boolean REPORT_TIME = false;

    public static ConcaveHullCollection createConcaveHullCollection(List<? extends Point2DReadOnly> pointCloud2d, ConcaveHullFactoryParameters parameters) {
        return SimpleConcaveHullFactory.createConcaveHullCollection(pointCloud2d, Collections.emptyList(), parameters);
    }

    public static ConcaveHullCollection createConcaveHullCollection(List<? extends Point2DReadOnly> pointCloud2d, List<? extends LineSegment2DReadOnly> lineConstraints, ConcaveHullFactoryParameters parameters) {
        if (pointCloud2d.size() <= 3) {
            return new ConcaveHullCollection(pointCloud2d);
        }
        ConcaveHullFactoryResult concaveHull = SimpleConcaveHullFactory.createConcaveHull(pointCloud2d, lineConstraints, parameters);
        if (concaveHull == null) {
            return new ConcaveHullCollection();
        }
        return concaveHull.getConcaveHullCollection();
    }

    public static ConcaveHullFactoryResult createConcaveHull(List<? extends Point2DReadOnly> pointCloud2d, ConcaveHullFactoryParameters parameters) {
        return SimpleConcaveHullFactory.createConcaveHull(pointCloud2d, Collections.emptyList(), parameters);
    }

    public static ConcaveHullFactoryResult createConcaveHull(List<? extends Point2DReadOnly> pointCloud2d, List<? extends LineSegment2DReadOnly> lineConstraints, ConcaveHullFactoryParameters parameters) {
        if (pointCloud2d.size() <= 3) {
            return null;
        }
        double triangulationTolerance = parameters.getTriangulationTolerance();
        MultiPoint sites = SimpleConcaveHullFactory.filterAndCreateMultiPoint(pointCloud2d, lineConstraints, triangulationTolerance);
        MultiLineString constraintSegments = JTSTools.createMultiLineString(lineConstraints);
        ConcaveHullFactoryResult result = new ConcaveHullFactoryResult();
        ConcaveHullVariables initialVariables = null;
        initialVariables = SimpleConcaveHullFactory.initializeTriangulation(sites, constraintSegments, triangulationTolerance, result);
        if (initialVariables == null) {
            return null;
        }
        List<ConcaveHullVariables> variablesList = SimpleConcaveHullFactory.computeConcaveHullBorderEdges(parameters, initialVariables);
        result.intermediateVariables.addAll(variablesList);
        for (ConcaveHullVariables variables : result.intermediateVariables) {
            ConcaveHull concaveHull = SimpleConcaveHullFactory.computeConcaveHull(variables.getOrderedBorderEdges());
            if (concaveHull == null) continue;
            concaveHull.ensureClockwiseOrdering();
            result.concaveHullCollection.add(concaveHull);
        }
        return result;
    }

    public static MultiPoint filterAndCreateMultiPoint(List<? extends Point2DReadOnly> pointCloud2d, List<? extends LineSegment2DReadOnly> lineConstraints, double tolerance) {
        ArrayList<Point2DReadOnly> filteredPointCloud2d = new ArrayList<Point2DReadOnly>();
        for (Point2DReadOnly point2DReadOnly : pointCloud2d) {
            if (SimpleConcaveHullFactory.isTooCloseToConstraintSegments(point2DReadOnly, lineConstraints, tolerance)) continue;
            filteredPointCloud2d.add(point2DReadOnly);
        }
        return JTSTools.point2DsToMultiPoint(filteredPointCloud2d);
    }

    public static boolean isTooCloseToConstraintSegments(Point2DReadOnly point, List<? extends LineSegment2DReadOnly> lineConstraints, double tolerance) {
        try {
            for (LineSegment2DReadOnly lineSegment2DReadOnly : lineConstraints) {
                if (!(lineSegment2DReadOnly.distance(point) < tolerance)) continue;
                return true;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static ConcaveHull computeConcaveHull(List<QuadEdge> orderedBorderEdges) {
        List orderedConcaveHullVertices = orderedBorderEdges.stream().map(QuadEdge::orig).map(vertex -> new Point2D(vertex.getX(), vertex.getY())).collect(Collectors.toList());
        return new ConcaveHull(orderedConcaveHullVertices);
    }

    private static ConcaveHullVariables initializeTriangulation(MultiPoint sites, MultiLineString constraintSegments, double delaunayTriangulationTolerance, ConcaveHullFactoryResult concaveHullFactoryResult) {
        QuadEdgeSubdivision subdivision;
        Object stopWatch = null;
        ConformingDelaunayTriangulationBuilder conformingDelaunayTriangulationBuilder = new ConformingDelaunayTriangulationBuilder();
        conformingDelaunayTriangulationBuilder.setTolerance(delaunayTriangulationTolerance);
        conformingDelaunayTriangulationBuilder.setSites((Geometry)sites);
        try {
            if (constraintSegments != null) {
                conformingDelaunayTriangulationBuilder.setConstraints((Geometry)constraintSegments);
            }
            subdivision = conformingDelaunayTriangulationBuilder.getSubdivision();
        }
        catch (ConstraintEnforcementException | LocateFailureException e) {
            LogTools.warn((String)"Delaunay triangulation failed, removing line segment constraints.");
            conformingDelaunayTriangulationBuilder.setConstraints(null);
            subdivision = conformingDelaunayTriangulationBuilder.getSubdivision();
        }
        List allTriangles = concaveHullFactoryResult.allTriangles;
        allTriangles.addAll(QuadEdgeTriangle.createOn((QuadEdgeSubdivision)subdivision));
        if (allTriangles.isEmpty()) {
            return null;
        }
        return SimpleConcaveHullFactory.computeIntermediateVariables(allTriangles, constraintSegments);
    }

    public static ConcaveHullVariables computeIntermediateVariables(List<QuadEdgeTriangle> delaunayTriangles, MultiLineString constraintSegments) {
        int edgeIndex;
        ConcaveHullVariables variables = new ConcaveHullVariables();
        Set borderVertices = variables.borderVertices;
        Set borderTriangles = variables.borderTriangles;
        Set borderEdges = variables.borderEdges;
        PriorityQueue sortedByLengthQueue = variables.sortedByLengthQueue;
        Set constraintEdges = variables.constraintEdges;
        QuadEdge firstBorderEdge = null;
        for (QuadEdgeTriangle triangle : delaunayTriangles) {
            if (!triangle.isBorder()) continue;
            borderTriangles.add(triangle);
            for (edgeIndex = 0; edgeIndex < 3; ++edgeIndex) {
                if (!triangle.isBorder(edgeIndex)) continue;
                QuadEdge borderEdge = triangle.getEdge(edgeIndex);
                if (firstBorderEdge == null) {
                    firstBorderEdge = borderEdge.getPrimary();
                }
                borderEdges.add(borderEdge);
                borderVertices.add(borderEdge.orig());
                borderVertices.add(borderEdge.dest());
                sortedByLengthQueue.add(new ImmutablePair((Object)borderEdge, (Object)triangle));
            }
        }
        if (constraintSegments != null) {
            for (QuadEdgeTriangle triangle : delaunayTriangles) {
                for (edgeIndex = 0; edgeIndex < 3; ++edgeIndex) {
                    QuadEdge edge = triangle.getEdge(edgeIndex);
                    if (!SimpleConcaveHullFactory.isEdgeCollinearWithALineSemgentOfMultiLineString(edge, constraintSegments)) continue;
                    constraintEdges.add(edge.getPrimary());
                }
            }
        }
        List orderedBorderEdges = variables.orderedBorderEdges;
        orderedBorderEdges.add(firstBorderEdge);
        Vertex startVertex = firstBorderEdge.orig();
        Vertex currentDestVertex = firstBorderEdge.dest();
        QuadEdge previousEdge = firstBorderEdge;
        while (true) {
            QuadEdge currentEdge = null;
            for (QuadEdge currentIncidentEdge = previousEdge.dNext(); currentIncidentEdge != previousEdge; currentIncidentEdge = currentIncidentEdge.dNext()) {
                if (!SimpleConcaveHullFactory.isBorderEdge(currentIncidentEdge, borderEdges)) continue;
                currentEdge = currentIncidentEdge.sym();
                break;
            }
            if (currentDestVertex.equals(startVertex)) break;
            orderedBorderEdges.add(currentEdge);
            previousEdge = currentEdge;
            currentDestVertex = currentEdge.dest();
        }
        SimpleConcaveHullFactory.checkOrderedBorderEdgeListValid(orderedBorderEdges);
        if (orderedBorderEdges.size() < borderEdges.size()) {
            return null;
        }
        return variables;
    }

    private static boolean isEdgeCollinearWithALineSemgentOfMultiLineString(QuadEdge query, MultiLineString multiLineString) {
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            LineString lineString = (LineString)multiLineString.getGeometryN(i);
            if (!SimpleConcaveHullFactory.isEdgeCollinearWithALineSemgentOfLineString(query, lineString)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEdgeCollinearWithALineSemgentOfLineString(QuadEdge query, LineString lineString) {
        int finalIndex = lineString.isClosed() ? lineString.getNumPoints() : lineString.getNumPoints() - 1;
        for (int i = 0; i < finalIndex; ++i) {
            Coordinate lineSegmentEnd;
            Coordinate lineSegmentStart = lineString.getCoordinateN(i);
            if (!SimpleConcaveHullFactory.isEdgeCollinearWithLineSegment(query, lineSegmentStart, lineSegmentEnd = lineString.getCoordinateN((i + 1) % lineString.getNumPoints()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isEdgeCollinearWithLineSegment(QuadEdge query, Coordinate lineSegmentStart, Coordinate lineSegmentEnd) {
        Point2D firstPointOnLine1 = SimpleConcaveHullFactory.toPoint2d(query.orig());
        Point2D secondPointOnLine1 = SimpleConcaveHullFactory.toPoint2d(query.dest());
        Point2D firstPointOnLine2 = SimpleConcaveHullFactory.toPoint2d(lineSegmentStart);
        Point2D secondPointOnLine2 = SimpleConcaveHullFactory.toPoint2d(lineSegmentEnd);
        double angleEpsilon = 1.0E-6;
        double distanceEpsilon = 1.0E-12;
        return EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEpsilon);
    }

    private static Point2D toPoint2d(Vertex vertex) {
        return new Point2D(vertex.getX(), vertex.getY());
    }

    private static Point2D toPoint2d(Coordinate coordinate) {
        return new Point2D(coordinate.x, coordinate.y);
    }

    private static List<ConcaveHullVariables> computeConcaveHullBorderEdges(ConcaveHullFactoryParameters parameters, ConcaveHullVariables variables) {
        return SimpleConcaveHullFactory.computeConcaveHullBorderEdgesIterative(parameters, variables, new MutableInt(0));
    }

    public static Case determineCase(Pair<QuadEdge, QuadEdgeTriangle> candidatePair, ConcaveHullFactoryParameters parameters, ConcaveHullVariables variables) {
        QuadEdgeComparator quadEdgeComparator = variables.quadEdgeComparator;
        Set borderVertices = variables.borderVertices;
        Set borderEdges = variables.borderEdges;
        Set borderTriangles = variables.borderTriangles;
        Set constraintEdges = variables.constraintEdges;
        QuadEdge candidateEdge = (QuadEdge)candidatePair.getLeft();
        QuadEdgeTriangle candidateTriangle = (QuadEdgeTriangle)candidatePair.getRight();
        double edgeLength = quadEdgeComparator.getEdgeLength(candidateEdge);
        boolean isEdgeTooLong = edgeLength >= parameters.getEdgeLengthThreshold();
        int numberOfBorderVertices = SimpleConcaveHullFactory.numberOfBorderVertices(candidateTriangle, borderVertices);
        int numberOfBorderEdges = SimpleConcaveHullFactory.numberOfBorderEdges(candidateTriangle, borderEdges);
        for (QuadEdge edge2 : candidateTriangle.getEdges()) {
            if (!SimpleConcaveHullFactory.isConstraintEdge(edge2, constraintEdges) || !SimpleConcaveHullFactory.isBorderEdge(edge2, borderEdges)) continue;
            return Case.KEEP_TRIANGLE;
        }
        boolean forceRemovalToRevealConstraint = false;
        for (QuadEdge edge3 : candidateTriangle.getEdges()) {
            if (!SimpleConcaveHullFactory.isConstraintEdge(edge3, constraintEdges)) continue;
            forceRemovalToRevealConstraint = true;
        }
        if (numberOfBorderVertices == 2) {
            if (numberOfBorderEdges != 1) {
                throw new RuntimeException("Triangle should have one border edge, but has: " + numberOfBorderEdges);
            }
            return isEdgeTooLong || forceRemovalToRevealConstraint ? Case.ONE_BORDER_EDGE_TWO_BORDER_VERTICES : Case.KEEP_TRIANGLE;
        }
        if (numberOfBorderEdges == 2) {
            if (numberOfBorderVertices != 3) {
                throw new RuntimeException("Triangle should have three border vertices, but has: " + numberOfBorderVertices);
            }
            if (parameters.doRemoveAllTrianglesWithTwoBorderEdges() || isEdgeTooLong) {
                QuadEdge uniqueNonBorderEdge = Arrays.stream(candidateTriangle.getEdges()).filter(edge -> !SimpleConcaveHullFactory.isBorderEdge(edge, borderEdges)).findFirst().get();
                int vertexIndexOppositeToCandidateEdge = SimpleConcaveHullFactory.indexOfVertexOppositeToEdge(candidateTriangle.getEdgeIndex(uniqueNonBorderEdge));
                List adjacentTrianglesToVertex = candidateTriangle.getTrianglesAdjacentToVertex(vertexIndexOppositeToCandidateEdge);
                boolean isIntersectionTriangle = adjacentTrianglesToVertex.stream().filter(borderTriangles::contains).filter(triangle -> triangle != candidateTriangle).findAny().isPresent();
                if (isIntersectionTriangle) {
                    return parameters.isSplittingConcaveHullAllowed() ? Case.INTERSECTION_TRIANGLE : Case.KEEP_TRIANGLE;
                }
                return Case.TWO_BORDER_EDGES_THREE_BORDER_VERTICES;
            }
            return Case.KEEP_TRIANGLE;
        }
        if (!parameters.isSplittingConcaveHullAllowed()) {
            return Case.KEEP_TRIANGLE;
        }
        if (numberOfBorderEdges == 1) {
            return Case.ONE_BORDER_EDGES_THREE_BORDER_VERTICES;
        }
        return Case.THREE_BORDER_EDGES_THREE_BORDER_VERTICES;
    }

    private static List<ConcaveHullVariables> computeConcaveHullBorderEdgesIterative(ConcaveHullFactoryParameters parameters, List<ConcaveHullVariables> variables, MutableInt currentIteration) {
        ArrayList<ConcaveHullVariables> result = new ArrayList<ConcaveHullVariables>();
        for (ConcaveHullVariables hullVariables : variables) {
            currentIteration.increment();
            result.addAll(SimpleConcaveHullFactory.computeConcaveHullBorderEdgesIterative(parameters, hullVariables, currentIteration));
        }
        return result;
    }

    private static List<ConcaveHullVariables> computeConcaveHullBorderEdgesIterative(ConcaveHullFactoryParameters parameters, ConcaveHullVariables variables, MutableInt currentIteration) {
        Case currentCase;
        if (variables == null) {
            return Collections.emptyList();
        }
        block8: while (true) {
            if (currentIteration.intValue() >= parameters.getMaxNumberOfIterations()) {
                return Collections.singletonList(variables);
            }
            PriorityQueue sortedByLengthQueue = variables.sortedByLengthQueue;
            ArrayList<Pair> backup = new ArrayList<Pair>();
            currentCase = Case.KEEP_TRIANGLE;
            Pair candidateEntry = null;
            while (!sortedByLengthQueue.isEmpty() && (currentCase = SimpleConcaveHullFactory.determineCase((Pair<QuadEdge, QuadEdgeTriangle>)(candidateEntry = (Pair)sortedByLengthQueue.poll()), parameters, variables)) == Case.KEEP_TRIANGLE) {
                backup.add(candidateEntry);
            }
            sortedByLengthQueue.addAll(backup);
            backup.clear();
            switch (currentCase) {
                case ONE_BORDER_EDGE_TWO_BORDER_VERTICES: {
                    SimpleConcaveHullFactory.removeTriangleWithOneBorderEdge(variables, (Pair<QuadEdge, QuadEdgeTriangle>)candidateEntry);
                    currentIteration.increment();
                    continue block8;
                }
                case TWO_BORDER_EDGES_THREE_BORDER_VERTICES: {
                    SimpleConcaveHullFactory.removeTriangleWithTwoBorderEdges(variables, (Pair<QuadEdge, QuadEdgeTriangle>)candidateEntry);
                    currentIteration.increment();
                    continue block8;
                }
                case ONE_BORDER_EDGES_THREE_BORDER_VERTICES: {
                    List<ConcaveHullVariables> subVariablesList = SimpleConcaveHullFactory.removeTriangleAndDivideHull(variables, (Pair<QuadEdge, QuadEdgeTriangle>)candidateEntry);
                    return SimpleConcaveHullFactory.computeConcaveHullBorderEdgesIterative(parameters, subVariablesList, currentIteration);
                }
                case INTERSECTION_TRIANGLE: {
                    List<ConcaveHullVariables> subVariablesList = SimpleConcaveHullFactory.divideHullAtIntersectionTriangle(variables, (Pair<QuadEdge, QuadEdgeTriangle>)candidateEntry);
                    return SimpleConcaveHullFactory.computeConcaveHullBorderEdgesIterative(parameters, subVariablesList, currentIteration);
                }
                case THREE_BORDER_EDGES_THREE_BORDER_VERTICES: {
                    return Collections.emptyList();
                }
                case KEEP_TRIANGLE: {
                    return Collections.singletonList(variables);
                }
            }
            break;
        }
        throw new RuntimeException("Unknown case: " + (Object)((Object)currentCase));
    }

    private static void removeTriangleWithOneBorderEdge(ConcaveHullVariables variables, Pair<QuadEdge, QuadEdgeTriangle> entryToRemove) {
        QuadEdgeTriangle borderTriangleToRemove = (QuadEdgeTriangle)entryToRemove.getRight();
        QuadEdge edgeToRemove = (QuadEdge)entryToRemove.getLeft();
        int indexOfTriangleEdgeToRemove = borderTriangleToRemove.getEdgeIndex(edgeToRemove);
        int indexAfterRemovedEdge = QuadEdgeTriangle.nextIndex((int)indexOfTriangleEdgeToRemove);
        int indexBeforeRemovedEdge = QuadEdgeTriangle.nextIndex((int)indexAfterRemovedEdge);
        Set borderTriangles = variables.borderTriangles;
        Set borderEdges = variables.borderEdges;
        Set borderVertices = variables.borderVertices;
        PriorityQueue sortedByLengthMap = variables.sortedByLengthQueue;
        borderTriangles.remove(borderTriangleToRemove);
        borderEdges.remove(edgeToRemove);
        borderEdges.remove(edgeToRemove.sym());
        QuadEdge newBorderEdgeAfterRemovedEdge = borderTriangleToRemove.getEdge(indexAfterRemovedEdge).sym();
        QuadEdgeTriangle newBorderTriangleAfterRemovedTriangle = (QuadEdgeTriangle)newBorderEdgeAfterRemovedEdge.getData();
        QuadEdge newBorderEdgeBeforeRemovedEdge = borderTriangleToRemove.getEdge(indexBeforeRemovedEdge).sym();
        QuadEdgeTriangle newBorderTriangleBeforeRemovedTriangle = (QuadEdgeTriangle)newBorderEdgeBeforeRemovedEdge.getData();
        borderTriangles.add(newBorderTriangleAfterRemovedTriangle);
        borderEdges.add(newBorderEdgeAfterRemovedEdge);
        sortedByLengthMap.add(new ImmutablePair((Object)newBorderEdgeAfterRemovedEdge, (Object)newBorderTriangleAfterRemovedTriangle));
        borderTriangles.add(newBorderTriangleBeforeRemovedTriangle);
        borderEdges.add(newBorderEdgeBeforeRemovedEdge);
        sortedByLengthMap.add(new ImmutablePair((Object)newBorderEdgeBeforeRemovedEdge, (Object)newBorderTriangleBeforeRemovedTriangle));
        borderVertices.add(borderTriangleToRemove.getVertex(indexBeforeRemovedEdge));
        List orderedBorderEdges = variables.orderedBorderEdges;
        SimpleConcaveHullFactory.replaceOneEdgeWithTwoInOrderedList(orderedBorderEdges, edgeToRemove, newBorderEdgeBeforeRemovedEdge, newBorderEdgeAfterRemovedEdge);
    }

    private static void removeTriangleWithTwoBorderEdges(ConcaveHullVariables variables, Pair<QuadEdge, QuadEdgeTriangle> entryToRemove) {
        QuadEdgeTriangle borderTriangleToRemove = (QuadEdgeTriangle)entryToRemove.getRight();
        Set borderTriangles = variables.borderTriangles;
        Set borderEdges = variables.borderEdges;
        Set borderVertices = variables.borderVertices;
        PriorityQueue sortedByLengthMap = variables.sortedByLengthQueue;
        int newBorderEdgeIndex = -1;
        QuadEdge newBorderEdge = null;
        borderTriangles.remove(borderTriangleToRemove);
        for (int i = 0; i < 3; ++i) {
            QuadEdge edge = borderTriangleToRemove.getEdge(i);
            if (!SimpleConcaveHullFactory.isBorderEdge(edge, borderEdges)) {
                newBorderEdgeIndex = i;
                newBorderEdge = edge.sym();
                continue;
            }
            borderEdges.remove(edge);
            borderEdges.remove(edge.sym());
            sortedByLengthMap.remove(new ImmutablePair((Object)edge, (Object)borderTriangleToRemove));
        }
        borderVertices.remove(borderTriangleToRemove.getVertex(SimpleConcaveHullFactory.indexOfVertexOppositeToEdge(newBorderEdgeIndex)));
        QuadEdgeTriangle newBorderTriangle = (QuadEdgeTriangle)newBorderEdge.getData();
        borderTriangles.add(newBorderTriangle);
        borderEdges.add(newBorderEdge);
        sortedByLengthMap.add(new ImmutablePair((Object)newBorderEdge, (Object)newBorderTriangle));
        List orderedBorderEdges = variables.orderedBorderEdges;
        SimpleConcaveHullFactory.replaceTwoEdgesWithOneInOrderedList(orderedBorderEdges, borderTriangleToRemove.getEdge((newBorderEdgeIndex + 2) % 3), borderTriangleToRemove.getEdge((newBorderEdgeIndex + 1) % 3), newBorderEdge);
    }

    private static List<ConcaveHullVariables> removeTriangleAndDivideHull(ConcaveHullVariables variables, Pair<QuadEdge, QuadEdgeTriangle> entryToRemove) {
        QuadEdge edgeToRemove = (QuadEdge)entryToRemove.getLeft();
        QuadEdgeTriangle triangleToRemove = (QuadEdgeTriangle)entryToRemove.getRight();
        Vertex intersectionVertex = triangleToRemove.getVertex(SimpleConcaveHullFactory.indexOfVertexOppositeToEdge(triangleToRemove.getEdgeIndex(edgeToRemove)));
        SimpleConcaveHullFactory.removeTriangleWithOneBorderEdge(variables, entryToRemove);
        return SimpleConcaveHullFactory.divideHullAtIntersectionVertex(variables, intersectionVertex);
    }

    private static List<ConcaveHullVariables> divideHullAtIntersectionTriangle(ConcaveHullVariables variables, Pair<QuadEdge, QuadEdgeTriangle> entryWithIntersectionTriangle) {
        Set borderEdges = variables.borderEdges;
        QuadEdgeTriangle intersectionTriangle = (QuadEdgeTriangle)entryWithIntersectionTriangle.getRight();
        QuadEdge uniqueNonBorderEdge = Arrays.stream(intersectionTriangle.getEdges()).filter(edge -> !SimpleConcaveHullFactory.isBorderEdge(edge, borderEdges)).findAny().get();
        Vertex intersectionVertex = intersectionTriangle.getVertex(SimpleConcaveHullFactory.indexOfVertexOppositeToEdge(intersectionTriangle.getEdgeIndex(uniqueNonBorderEdge)));
        return SimpleConcaveHullFactory.divideHullAtIntersectionVertex(variables, intersectionVertex);
    }

    private static List<ConcaveHullVariables> divideHullAtIntersectionVertex(ConcaveHullVariables variables, Vertex intersectionVertex) {
        List orderedBorderEdges = variables.orderedBorderEdges;
        PriorityQueue sortedByLengthQueue = variables.sortedByLengthQueue;
        ArrayList<ConcaveHullVariables> dividedHullVariables = new ArrayList<ConcaveHullVariables>();
        int startIndex = IntStream.range(0, orderedBorderEdges.size()).filter(i -> ((QuadEdge)orderedBorderEdges.get(i)).orig() == intersectionVertex).findAny().getAsInt();
        int previousEndIndex = ListWrappingIndexTools.previous((int)startIndex, (List)orderedBorderEdges);
        do {
            int subHullStartIndex = ListWrappingIndexTools.next((int)previousEndIndex, (List)orderedBorderEdges);
            int subHullEndIndex = ListWrappingIndexTools.next((int)subHullStartIndex, (List)orderedBorderEdges);
            int count = 0;
            while (!SimpleConcaveHullFactory.doesVertexBelongToQuadEdge(intersectionVertex, (QuadEdge)orderedBorderEdges.get(subHullEndIndex))) {
                subHullEndIndex = ListWrappingIndexTools.next((int)subHullEndIndex, (List)orderedBorderEdges);
                if (count++ < orderedBorderEdges.size()) continue;
                throw new RuntimeException("Wrapped around the hull without finding the subHullEndIndex");
            }
            previousEndIndex = subHullEndIndex;
            if (ListWrappingIndexTools.subLengthInclusive((int)subHullStartIndex, (int)subHullEndIndex, (List)orderedBorderEdges) <= 3) continue;
            ConcaveHullVariables subHullVariables = new ConcaveHullVariables();
            List subOrderedBorderEdges = subHullVariables.orderedBorderEdges;
            Set subBorderEdges = subHullVariables.borderEdges;
            Set subBorderTriangles = subHullVariables.borderTriangles;
            Set subBorderVertices = subHullVariables.borderVertices;
            PriorityQueue subSortedByLengthQueue = subHullVariables.sortedByLengthQueue;
            Set subConstraintEdges = subHullVariables.constraintEdges;
            subOrderedBorderEdges.addAll(ListWrappingIndexTools.subListInclusive((int)subHullStartIndex, (int)subHullEndIndex, (List)orderedBorderEdges));
            SimpleConcaveHullFactory.checkOrderedBorderEdgeListValid(subOrderedBorderEdges);
            subBorderEdges.addAll(subOrderedBorderEdges);
            subBorderEdges.forEach(borderEdge -> subBorderVertices.add(borderEdge.orig()));
            sortedByLengthQueue.stream().filter(pair -> SimpleConcaveHullFactory.isBorderEdge((QuadEdge)pair.getLeft(), subBorderEdges)).forEach(subSortedByLengthQueue::add);
            subSortedByLengthQueue.forEach(pair -> subBorderTriangles.add(pair.getRight()));
            subConstraintEdges.addAll(variables.constraintEdges);
            dividedHullVariables.add(subHullVariables);
        } while (ListWrappingIndexTools.next((int)previousEndIndex, (List)orderedBorderEdges) != startIndex);
        return dividedHullVariables;
    }

    private static void replaceOneEdgeWithTwoInOrderedList(List<QuadEdge> orderedBorderEdges, QuadEdge edgeToReplace, QuadEdge newEdge1, QuadEdge newEdge2) {
        QuadEdge secondEdge;
        QuadEdge firstEdge;
        int indexOfEdgeToReplace = orderedBorderEdges.indexOf(edgeToReplace);
        if (indexOfEdgeToReplace == -1) {
            edgeToReplace = edgeToReplace.sym();
            indexOfEdgeToReplace = orderedBorderEdges.indexOf(edgeToReplace);
        }
        if (indexOfEdgeToReplace == -1) {
            throw new RuntimeException("Did not find edge to remove in the ordered border edge list.");
        }
        Vertex previousVertex = edgeToReplace.orig();
        Vertex nextVertex = edgeToReplace.dest();
        if (SimpleConcaveHullFactory.doesVertexBelongToQuadEdge(previousVertex, newEdge1)) {
            firstEdge = newEdge1.orig() == previousVertex ? newEdge1 : newEdge1.sym();
            QuadEdge quadEdge = secondEdge = newEdge2.dest() == nextVertex ? newEdge2 : newEdge2.sym();
            if (!SimpleConcaveHullFactory.doesVertexBelongToQuadEdge(nextVertex, newEdge2)) {
                throw new RuntimeException("newEdge2 is not connected to nextVertex.");
            }
        } else if (SimpleConcaveHullFactory.doesVertexBelongToQuadEdge(previousVertex, newEdge2)) {
            firstEdge = newEdge2.orig() == previousVertex ? newEdge2 : newEdge2.sym();
            QuadEdge quadEdge = secondEdge = newEdge1.dest() == nextVertex ? newEdge1 : newEdge1.sym();
            if (!SimpleConcaveHullFactory.doesVertexBelongToQuadEdge(nextVertex, newEdge1)) {
                throw new RuntimeException("newEdge1 is not connected to nextVertex.");
            }
        } else {
            throw new RuntimeException("newEdge1 is not connected to either previousVertex or nextVertex.");
        }
        orderedBorderEdges.set(indexOfEdgeToReplace, firstEdge);
        orderedBorderEdges.add(indexOfEdgeToReplace + 1, secondEdge);
        SimpleConcaveHullFactory.checkOrderedBorderEdgeListValid(orderedBorderEdges);
    }

    private static void replaceTwoEdgesWithOneInOrderedList(List<QuadEdge> orderedBorderEdges, QuadEdge edgeToReplace1, QuadEdge edgeToReplace2, QuadEdge newEdge) {
        QuadEdge edgeToInsert;
        Vertex nextVertex;
        Vertex previousVertex;
        int firstEdgeIndex = orderedBorderEdges.indexOf(edgeToReplace1);
        if (firstEdgeIndex == -1) {
            edgeToReplace1 = edgeToReplace1.sym();
            firstEdgeIndex = orderedBorderEdges.indexOf(edgeToReplace1);
        }
        if (firstEdgeIndex == -1) {
            throw new RuntimeException("Did not find the first edge to remove in the ordered border edge list.");
        }
        int secondEdgeIndex = orderedBorderEdges.indexOf(edgeToReplace2);
        if (secondEdgeIndex == -1) {
            edgeToReplace2 = edgeToReplace2.sym();
            secondEdgeIndex = orderedBorderEdges.indexOf(edgeToReplace2);
        }
        if (secondEdgeIndex == -1) {
            throw new RuntimeException("Did not find the second edge to remove in the ordered border edge list.");
        }
        if (ListWrappingIndexTools.minDistanceExclusive((int)firstEdgeIndex, (int)secondEdgeIndex, orderedBorderEdges) != 0) {
            throw new RuntimeException("The two edges are not connected");
        }
        if (ListWrappingIndexTools.previous((int)secondEdgeIndex, orderedBorderEdges) == firstEdgeIndex) {
            previousVertex = edgeToReplace1.orig();
            nextVertex = edgeToReplace2.dest();
        } else {
            previousVertex = edgeToReplace2.orig();
            nextVertex = edgeToReplace1.dest();
        }
        QuadEdge quadEdge = edgeToInsert = newEdge.orig() == previousVertex ? newEdge : newEdge.sym();
        if (edgeToInsert.orig() != previousVertex || edgeToInsert.dest() != nextVertex) {
            throw new RuntimeException("The new edge to insert is not properly connected to the list.");
        }
        orderedBorderEdges.set(firstEdgeIndex, edgeToInsert);
        orderedBorderEdges.remove(secondEdgeIndex);
        SimpleConcaveHullFactory.checkOrderedBorderEdgeListValid(orderedBorderEdges);
    }

    private static boolean doesVertexBelongToQuadEdge(Vertex vertex, QuadEdge edge) {
        return edge.orig() == vertex || edge.dest() == vertex;
    }

    private static void checkOrderedBorderEdgeListValid(List<QuadEdge> orderedBorderEdges) {
        for (int edgeIndex = 0; edgeIndex < orderedBorderEdges.size(); ++edgeIndex) {
            Vertex nextOrig;
            Vertex currentDest = orderedBorderEdges.get(edgeIndex).dest();
            if (currentDest == (nextOrig = ((QuadEdge)ListWrappingIndexTools.getNext((int)edgeIndex, orderedBorderEdges)).orig())) continue;
            throw new RuntimeException("Ordered border edge list is corrupted.");
        }
    }

    private static int numberOfBorderEdges(QuadEdgeTriangle triangle, Set<QuadEdge> borderEdges) {
        int numberOfBorderEdges = 0;
        for (int edgeIndex = 0; edgeIndex < 3; ++edgeIndex) {
            QuadEdge edge = triangle.getEdge(edgeIndex);
            if (!SimpleConcaveHullFactory.isBorderEdge(edge, borderEdges)) continue;
            ++numberOfBorderEdges;
        }
        return numberOfBorderEdges;
    }

    private static int numberOfBorderVertices(QuadEdgeTriangle triangle, Set<Vertex> borderVertices) {
        int numberOfBorderVertices = 0;
        for (int vertexIndex = 0; vertexIndex < 3; ++vertexIndex) {
            Vertex vertex = triangle.getVertex(vertexIndex);
            if (!borderVertices.contains(vertex)) continue;
            ++numberOfBorderVertices;
        }
        return numberOfBorderVertices;
    }

    private static boolean isBorderEdge(QuadEdge edge, Set<QuadEdge> borderEdges) {
        return borderEdges.contains(edge) || borderEdges.contains(edge.sym());
    }

    private static boolean isConstraintEdge(QuadEdge edge, Set<QuadEdge> constraintEdges) {
        return constraintEdges.contains(edge) || constraintEdges.contains(edge.sym());
    }

    private static int indexOfVertexOppositeToEdge(int edgeIndex) {
        if (edgeIndex < 0 || edgeIndex > 2) {
            throw new RuntimeException("Bad edge index: " + edgeIndex);
        }
        return QuadEdgeTriangle.nextIndex((int)QuadEdgeTriangle.nextIndex((int)edgeIndex));
    }

    public static class ConcaveHullVariables {
        private final Set<Vertex> borderVertices = new HashSet<Vertex>();
        private final Set<QuadEdge> borderEdges = new HashSet<QuadEdge>();
        private final List<QuadEdge> orderedBorderEdges = new ArrayList<QuadEdge>();
        private final Set<QuadEdgeTriangle> borderTriangles = new HashSet<QuadEdgeTriangle>();
        private final QuadEdgeComparator quadEdgeComparator = new QuadEdgeComparator();
        private final PriorityQueue<Pair<QuadEdge, QuadEdgeTriangle>> sortedByLengthQueue = new PriorityQueue<Pair<QuadEdge, QuadEdgeTriangle>>(this.quadEdgeComparator);
        private final Set<QuadEdge> constraintEdges = new HashSet<QuadEdge>();

        public Set<Vertex> getBorderVertices() {
            return this.borderVertices;
        }

        public Set<QuadEdge> getBorderEdges() {
            return this.borderEdges;
        }

        public List<QuadEdge> getOrderedBorderEdges() {
            return this.orderedBorderEdges;
        }

        public Set<QuadEdgeTriangle> getBorderTriangles() {
            return this.borderTriangles;
        }

        public PriorityQueue<Pair<QuadEdge, QuadEdgeTriangle>> getSortedByLengthQueue() {
            return this.sortedByLengthQueue;
        }

        public Set<QuadEdge> getConstraintEdges() {
            return this.constraintEdges;
        }
    }

    public static class ConcaveHullFactoryResult {
        private final ConcaveHullCollection concaveHullCollection = new ConcaveHullCollection();
        private final List<QuadEdgeTriangle> allTriangles = new ArrayList<QuadEdgeTriangle>();
        private final List<ConcaveHullVariables> intermediateVariables = new ArrayList<ConcaveHullVariables>();

        public ConcaveHullCollection getConcaveHullCollection() {
            return this.concaveHullCollection;
        }

        public List<QuadEdgeTriangle> getAllTriangles() {
            return this.allTriangles;
        }

        public List<ConcaveHullVariables> getIntermediateVariables() {
            return this.intermediateVariables;
        }
    }

    private static class QuadEdgeComparator
    implements Comparator<Pair<QuadEdge, QuadEdgeTriangle>> {
        private final Map<QuadEdge, Double> map = new HashMap<QuadEdge, Double>();

        private QuadEdgeComparator() {
        }

        @Override
        public int compare(Pair<QuadEdge, QuadEdgeTriangle> pair1, Pair<QuadEdge, QuadEdgeTriangle> pair2) {
            double length2;
            double length1 = this.getEdgeLength((QuadEdge)pair1.getKey());
            if (length1 < (length2 = this.getEdgeLength((QuadEdge)pair2.getKey()))) {
                return 1;
            }
            if (length1 == length2) {
                return 0;
            }
            return -1;
        }

        private double getEdgeLength(QuadEdge edge) {
            Double length = this.map.get(edge);
            if (length == null) {
                length = edge.getLength();
                this.map.put(edge, length);
                this.map.put(edge.sym(), length);
            }
            return length;
        }
    }

    private static enum Case {
        KEEP_TRIANGLE,
        ONE_BORDER_EDGE_TWO_BORDER_VERTICES,
        TWO_BORDER_EDGES_THREE_BORDER_VERTICES,
        ONE_BORDER_EDGES_THREE_BORDER_VERTICES,
        THREE_BORDER_EDGES_THREE_BORDER_VERTICES,
        INTERSECTION_TRIANGLE;

    }
}

