/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import javafx.util.Pair;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.lists.SupplierBuilder;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class IntersectionPlaneBoxCalculator {
    private static final double EPSILON = 0.001;
    private final Point3D[] boxVertices = new Point3D[8];
    private final List<Pair<Point3D, Point3D>> boxEdges = new ArrayList<Pair<Point3D, Point3D>>();
    private final Vector3D boxSize = new Vector3D();
    private final Point3D boxCenter = new Point3D();
    private final Point3D pointOnPlane = new Point3D();
    private final Vector3D planeNormal = new Vector3D();
    private final Vector3D edgeVector = new Vector3D();
    private final Vector3D fromPlaneCenterToEdgeStart = new Vector3D();
    private final RecyclingArrayList<Point3D> unorderedIntersections = new RecyclingArrayList(0, SupplierBuilder.createFromEmptyConstructor(Point3D.class));
    private final Point3D intersection = new Point3D();
    private final TDoubleArrayList orderedAngles = new TDoubleArrayList();
    private final Vector3D v0 = new Vector3D();
    private final Vector3D vi = new Vector3D();
    private final Vector3D vCross = new Vector3D();
    private final Point3D average = new Point3D();

    public IntersectionPlaneBoxCalculator() {
        this.boxVertices[0] = new Point3D(0.5, 0.5, -0.5);
        this.boxVertices[1] = new Point3D(0.5, -0.5, -0.5);
        this.boxVertices[2] = new Point3D(-0.5, -0.5, -0.5);
        this.boxVertices[3] = new Point3D(-0.5, 0.5, -0.5);
        this.boxVertices[4] = new Point3D(0.5, 0.5, 0.5);
        this.boxVertices[5] = new Point3D(0.5, -0.5, 0.5);
        this.boxVertices[6] = new Point3D(-0.5, -0.5, 0.5);
        this.boxVertices[7] = new Point3D(-0.5, 0.5, 0.5);
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[0], (Object)this.boxVertices[1]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[1], (Object)this.boxVertices[2]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[2], (Object)this.boxVertices[3]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[3], (Object)this.boxVertices[0]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[4], (Object)this.boxVertices[5]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[5], (Object)this.boxVertices[6]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[6], (Object)this.boxVertices[7]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[7], (Object)this.boxVertices[4]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[0], (Object)this.boxVertices[4]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[1], (Object)this.boxVertices[5]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[2], (Object)this.boxVertices[6]));
        this.boxEdges.add((Pair<Point3D, Point3D>)new Pair((Object)this.boxVertices[3], (Object)this.boxVertices[7]));
    }

    public void setCube(double size, Point3D center) {
        this.setBox(size, size, size, center);
    }

    public void setCube(double size, double centerX, double centerY, double centerZ) {
        this.setBox(size, size, size, centerX, centerY, centerZ);
    }

    public void setBox(double lx, double ly, double lz, Point3D center) {
        this.setBox(lx, ly, lz, center.getX(), center.getY(), center.getZ());
    }

    public void setBox(double lx, double ly, double lz, double centerX, double centerY, double centerZ) {
        this.boxSize.set(lx, ly, lz);
        this.boxCenter.set(centerX, centerY, centerZ);
    }

    public void setPlane(Point3D pointOnPlane, Vector3D planeNormal) {
        this.pointOnPlane.set(pointOnPlane);
        this.planeNormal.set(planeNormal);
    }

    public List<Point3D> computeIntersections() {
        RecyclingArrayList intersections = new RecyclingArrayList(Point3D.class);
        this.computeIntersections((RecyclingArrayList<Point3D>)intersections);
        return intersections;
    }

    public void computeIntersections(RecyclingArrayList<Point3D> intersectionsToPack) {
        this.unorderedIntersections.clear();
        for (int i = 0; i < 12; ++i) {
            double scaleFactor;
            Point3D edgeStart = (Point3D)this.boxEdges.get(i).getKey();
            Point3D edgeEnd = (Point3D)this.boxEdges.get(i).getValue();
            this.edgeVector.sub((Tuple3DReadOnly)edgeEnd, (Tuple3DReadOnly)edgeStart);
            this.fromPlaneCenterToEdgeStart.sub((Tuple3DReadOnly)this.pointOnPlane, (Tuple3DReadOnly)this.boxCenter);
            this.fromPlaneCenterToEdgeStart.setX(this.fromPlaneCenterToEdgeStart.getX() / this.boxSize.getX());
            this.fromPlaneCenterToEdgeStart.setY(this.fromPlaneCenterToEdgeStart.getY() / this.boxSize.getY());
            this.fromPlaneCenterToEdgeStart.setZ(this.fromPlaneCenterToEdgeStart.getZ() / this.boxSize.getZ());
            this.fromPlaneCenterToEdgeStart.sub((Tuple3DReadOnly)edgeStart);
            double dotNormalEdge = this.planeNormal.dot((Vector3DReadOnly)this.edgeVector);
            if (Math.abs(dotNormalEdge) < 1.0E-5 || (scaleFactor = this.planeNormal.dot((Vector3DReadOnly)this.fromPlaneCenterToEdgeStart) / dotNormalEdge) < 0.0 || scaleFactor > 1.0) continue;
            this.intersection.scaleAdd(scaleFactor, (Tuple3DReadOnly)this.edgeVector, (Tuple3DReadOnly)edgeStart);
            this.intersection.setX(this.intersection.getX() * this.boxSize.getX());
            this.intersection.setY(this.intersection.getY() * this.boxSize.getY());
            this.intersection.setZ(this.intersection.getZ() * this.boxSize.getZ());
            this.intersection.add((Tuple3DReadOnly)this.boxCenter);
            if (!this.listContains((List<Point3D>)this.unorderedIntersections, this.intersection)) {
                ((Point3D)this.unorderedIntersections.add()).set(this.intersection);
            }
            if (this.unorderedIntersections.size() == 6) break;
        }
        this.reorderIntersections((List<Point3D>)this.unorderedIntersections, intersectionsToPack);
    }

    private void reorderIntersections(List<Point3D> unorderedIntersections, RecyclingArrayList<Point3D> intersectionsToPack) {
        int i;
        intersectionsToPack.clear();
        if (unorderedIntersections.isEmpty()) {
            return;
        }
        this.orderedAngles.reset();
        ((Point3D)intersectionsToPack.add()).set(unorderedIntersections.get(0));
        this.orderedAngles.add(0.0);
        this.average.set(0.0, 0.0, 0.0);
        for (i = 0; i < unorderedIntersections.size(); ++i) {
            this.average.add((Tuple3DReadOnly)unorderedIntersections.get(i));
        }
        this.average.scale(1.0 / (double)unorderedIntersections.size());
        this.v0.sub((Tuple3DReadOnly)unorderedIntersections.get(0), (Tuple3DReadOnly)this.average);
        this.v0.normalize();
        for (i = 1; i < unorderedIntersections.size(); ++i) {
            this.vi.sub((Tuple3DReadOnly)unorderedIntersections.get(i), (Tuple3DReadOnly)this.average);
            this.vi.normalize();
            double angle = this.v0.dot((Vector3DReadOnly)this.vi);
            this.vCross.cross((Tuple3DReadOnly)this.v0, (Tuple3DReadOnly)this.vi);
            if (this.vCross.dot((Vector3DReadOnly)this.planeNormal) < 0.0) {
                angle = -2.0 - angle;
            }
            angle -= 1.0;
            int index = IntersectionPlaneBoxCalculator.angleBinarySearch(this.orderedAngles, angle *= -1.0);
            if (index < 0) {
                index = -index - 1;
            }
            ((Point3D)intersectionsToPack.insertAtIndex(index)).set(unorderedIntersections.get(i));
            this.orderedAngles.insert(index, angle);
        }
    }

    private static int angleBinarySearch(TDoubleArrayList l, double key) {
        int low = 0;
        int high = l.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            double midVal = l.get(mid);
            int cmp = IntersectionPlaneBoxCalculator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int compare(double angle1, double angle2) {
        if (angle1 == angle2) {
            return 0;
        }
        if (angle1 < angle2) {
            return -1;
        }
        return 1;
    }

    private boolean listContains(List<Point3D> listOfPoints, Point3D pointToCheck) {
        for (int i = 0; i < listOfPoints.size(); ++i) {
            if (!this.epsilonEquals(listOfPoints.get(i), pointToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean epsilonEquals(Point3D point1, Point3D point2) {
        double diff = point1.getX() - point2.getX();
        if (Double.isNaN(diff)) {
            return false;
        }
        double d = diff < 0.0 ? -diff : diff;
        if (d > 0.001 * this.boxSize.getX()) {
            return false;
        }
        diff = point1.getY() - point2.getY();
        if (Double.isNaN(diff)) {
            return false;
        }
        double d2 = diff < 0.0 ? -diff : diff;
        if (d2 > 0.001 * this.boxSize.getY()) {
            return false;
        }
        diff = point1.getZ() - point2.getZ();
        if (Double.isNaN(diff)) {
            return false;
        }
        double d3 = diff < 0.0 ? -diff : diff;
        return !(d3 > 0.001 * this.boxSize.getZ());
    }
}

