/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import us.ihmc.commons.lists.ListWrappingIndexTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullPocket;

public class ConcaveHullTools {
    public static boolean isVertexPreventingKink(int vertexIndex, List<? extends Point2DReadOnly> concaveHullVertices) {
        int vertexPreviousIndex = ListWrappingIndexTools.previous((int)vertexIndex, concaveHullVertices);
        int vertexNextIndex = ListWrappingIndexTools.next((int)(vertexIndex %= concaveHullVertices.size()), concaveHullVertices);
        Point2DReadOnly a = concaveHullVertices.get(vertexPreviousIndex);
        Point2DReadOnly b = concaveHullVertices.get(vertexIndex);
        Point2DReadOnly c = concaveHullVertices.get(vertexNextIndex);
        int currentIndex = ListWrappingIndexTools.next((int)vertexNextIndex, concaveHullVertices);
        while (currentIndex != vertexPreviousIndex) {
            if (EuclidGeometryTools.triangleArea((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c) > 1.0E-12 && EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)concaveHullVertices.get(currentIndex), (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c)) {
                return true;
            }
            currentIndex = ListWrappingIndexTools.next((int)currentIndex, concaveHullVertices);
        }
        return false;
    }

    public static boolean isClockwiseOrdered(List<? extends Point2DReadOnly> concaveHullVertices) {
        double sumOfAngles = 0.0;
        Vector2D previousEdge = new Vector2D();
        Vector2D nextEdge = new Vector2D();
        for (int vertexIndex = 0; vertexIndex < concaveHullVertices.size(); ++vertexIndex) {
            int previousVertexIndex = ListWrappingIndexTools.previous((int)vertexIndex, concaveHullVertices);
            int nextVertexIndex = ListWrappingIndexTools.next((int)vertexIndex, concaveHullVertices);
            Point2DReadOnly previousVertex = concaveHullVertices.get(previousVertexIndex);
            Point2DReadOnly vertex = concaveHullVertices.get(vertexIndex);
            Point2DReadOnly nextVertex = concaveHullVertices.get(nextVertexIndex);
            previousEdge.sub((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)previousVertex);
            nextEdge.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)vertex);
            sumOfAngles += previousEdge.angle((Vector2DReadOnly)nextEdge);
        }
        return sumOfAngles <= 0.0;
    }

    public static void ensureClockwiseOrdering(List<? extends Point2DReadOnly> concaveHullVertices) {
        if (!ConcaveHullTools.isClockwiseOrdered(concaveHullVertices)) {
            Collections.reverse(concaveHullVertices);
        }
    }

    public static void ensureCounterClockwiseOrdering(List<? extends Point2DReadOnly> concaveHullVertices) {
        if (ConcaveHullTools.isClockwiseOrdered(concaveHullVertices)) {
            Collections.reverse(concaveHullVertices);
        }
    }

    public static double computePerimeter(List<? extends Point2DReadOnly> concaveHullVertices) {
        double perimeter = 0.0;
        for (int i = 0; i < concaveHullVertices.size(); ++i) {
            Point2DReadOnly vertex = concaveHullVertices.get(i);
            Point2DReadOnly nextVertex = concaveHullVertices.get(ListWrappingIndexTools.next((int)i, concaveHullVertices));
            perimeter += vertex.distance(nextVertex);
        }
        return perimeter;
    }

    public static int removeSuccessiveDuplicateVertices(List<? extends Point2DReadOnly> concaveHullVertices) {
        int numberOfVerticesRemoved = 0;
        int index = 0;
        while (index < concaveHullVertices.size()) {
            int nextIndex = ListWrappingIndexTools.next((int)index, concaveHullVertices);
            if (concaveHullVertices.get(index).equals((Tuple2DReadOnly)concaveHullVertices.get(nextIndex))) {
                concaveHullVertices.remove(nextIndex);
                ++numberOfVerticesRemoved;
                continue;
            }
            ++index;
        }
        return numberOfVerticesRemoved;
    }

    public static boolean computeConcaveHullPocket(int concaveVertexIndex, ConcaveHullPocket pocketToPack, List<? extends Point2DReadOnly> concaveHullVertices) {
        pocketToPack.clear();
        boolean success = ConcaveHullTools.findBridgeVertices(concaveVertexIndex, pocketToPack, concaveHullVertices);
        if (!success) {
            pocketToPack.clear();
            return false;
        }
        success = ConcaveHullTools.findDeepestVertexInPocket(pocketToPack, concaveHullVertices);
        if (!success) {
            pocketToPack.clear();
            return false;
        }
        return true;
    }

    public static Set<ConcaveHullPocket> findConcaveHullPockets(List<? extends Point2DReadOnly> concaveHullVertices, double depthThreshold) {
        ConcaveHullPocket newPocket;
        HashSet<ConcaveHullPocket> pockets = new HashSet<ConcaveHullPocket>();
        int startIndex = 0;
        while (startIndex < concaveHullVertices.size() && (newPocket = ConcaveHullTools.findFirstConcaveHullPocket(concaveHullVertices, startIndex)) != null && (!(newPocket.getMaxDepth() >= depthThreshold) || pockets.add(newPocket))) {
            startIndex = newPocket.getEndBridgeIndex() + 1;
        }
        return pockets;
    }

    public static ConcaveHullPocket findFirstConcaveHullPocket(List<? extends Point2DReadOnly> concaveHullVertices) {
        return ConcaveHullTools.findFirstConcaveHullPocket(concaveHullVertices, 0);
    }

    public static ConcaveHullPocket findFirstConcaveHullPocket(List<? extends Point2DReadOnly> concaveHullVertices, int startIndex) {
        if (startIndex < 0 || startIndex >= concaveHullVertices.size()) {
            throw new IndexOutOfBoundsException("Expected startIndex in [0, " + concaveHullVertices.size() + "[, received: " + startIndex);
        }
        ConcaveHullPocket pocket = null;
        for (int i = startIndex; i < concaveHullVertices.size() && pocket == null; ++i) {
            pocket = ConcaveHullTools.computeConcaveHullPocket(i, concaveHullVertices);
        }
        return pocket;
    }

    public static ConcaveHullPocket computeConcaveHullPocket(int concaveVertexIndex, List<? extends Point2DReadOnly> concaveHullVertices) {
        ConcaveHullPocket pocketToReturn = new ConcaveHullPocket();
        boolean success = ConcaveHullTools.findBridgeVertices(concaveVertexIndex, pocketToReturn, concaveHullVertices);
        if (!success) {
            return null;
        }
        success = ConcaveHullTools.findDeepestVertexInPocket(pocketToReturn, concaveHullVertices);
        if (!success) {
            return null;
        }
        return pocketToReturn;
    }

    public static boolean findBridgeVertices(int concaveVertexIndex, ConcaveHullPocket pocketToPack, List<? extends Point2DReadOnly> concaveHullVertices) {
        Point2DReadOnly secondBridgeVertex;
        Point2DReadOnly concaveVertex = concaveHullVertices.get(concaveVertexIndex %= concaveHullVertices.size());
        int firstBridgeIndex = ListWrappingIndexTools.previous((int)concaveVertexIndex, concaveHullVertices);
        int secondBridgeIndex = ListWrappingIndexTools.next((int)concaveVertexIndex, concaveHullVertices);
        Point2DReadOnly firstBridgeVertex = concaveHullVertices.get(firstBridgeIndex);
        if (EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)concaveVertex, (Point2DReadOnly)firstBridgeVertex, (Point2DReadOnly)(secondBridgeVertex = concaveHullVertices.get(secondBridgeIndex)))) {
            return false;
        }
        int startIndexCandidate = firstBridgeIndex;
        int endIndexCandidate = secondBridgeIndex;
        while ((startIndexCandidate = ListWrappingIndexTools.previous((int)startIndexCandidate, concaveHullVertices)) != endIndexCandidate && startIndexCandidate != (endIndexCandidate = ListWrappingIndexTools.next((int)endIndexCandidate, concaveHullVertices))) {
            int i;
            boolean isBridgeCoveringPocket;
            Point2DReadOnly startCandidate = concaveHullVertices.get(startIndexCandidate);
            Point2DReadOnly endCandidate = concaveHullVertices.get(endIndexCandidate);
            if (EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)startCandidate, (Point2DReadOnly)firstBridgeVertex, (Point2DReadOnly)secondBridgeVertex)) {
                isBridgeCoveringPocket = true;
                i = ListWrappingIndexTools.next((int)startIndexCandidate, concaveHullVertices);
                while (i != secondBridgeIndex && isBridgeCoveringPocket) {
                    isBridgeCoveringPocket = !EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)concaveHullVertices.get(i), (Point2DReadOnly)startCandidate, (Point2DReadOnly)secondBridgeVertex);
                    i = ListWrappingIndexTools.next((int)i, concaveHullVertices);
                }
                if (!isBridgeCoveringPocket) continue;
                firstBridgeIndex = startIndexCandidate;
                firstBridgeVertex = startCandidate;
                endIndexCandidate = secondBridgeIndex;
                continue;
            }
            if (!EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)endCandidate, (Point2DReadOnly)firstBridgeVertex, (Point2DReadOnly)secondBridgeVertex)) continue;
            isBridgeCoveringPocket = true;
            i = ListWrappingIndexTools.next((int)firstBridgeIndex, concaveHullVertices);
            while (i != endIndexCandidate && isBridgeCoveringPocket) {
                isBridgeCoveringPocket = !EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)concaveHullVertices.get(i), (Point2DReadOnly)firstBridgeVertex, (Point2DReadOnly)endCandidate);
                i = ListWrappingIndexTools.next((int)i, concaveHullVertices);
            }
            if (!isBridgeCoveringPocket) continue;
            secondBridgeIndex = endIndexCandidate;
            secondBridgeVertex = endCandidate;
            startIndexCandidate = firstBridgeIndex;
        }
        pocketToPack.setBridgeIndices(firstBridgeIndex, secondBridgeIndex);
        pocketToPack.setBridgeVertices(firstBridgeVertex, secondBridgeVertex);
        return true;
    }

    public static boolean findDeepestVertexInPocket(ConcaveHullPocket pocketToModify, List<? extends Point2DReadOnly> concaveHullVertices) {
        pocketToModify.clearDepthParameters();
        int startBridgeIndex = pocketToModify.getStartBridgeIndex();
        int endBridgeIndex = pocketToModify.getEndBridgeIndex();
        Point2DReadOnly startBridgeVertex = concaveHullVertices.get(startBridgeIndex);
        Point2DReadOnly endBridgeVertex = concaveHullVertices.get(endBridgeIndex);
        int index = ListWrappingIndexTools.next((int)startBridgeIndex, concaveHullVertices);
        while (index != endBridgeIndex) {
            Point2DReadOnly vertex = concaveHullVertices.get(index);
            double depth = EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)vertex, (Point2DReadOnly)startBridgeVertex, (Point2DReadOnly)endBridgeVertex);
            if (depth > pocketToModify.getMaxDepth()) {
                pocketToModify.setDeepestVertexIndex(index);
                pocketToModify.setDeepestVertex(vertex);
                pocketToModify.setMaxDepth(depth);
            }
            index = ListWrappingIndexTools.next((int)index, concaveHullVertices);
        }
        return pocketToModify.getDeepestVertexIndex() >= 0;
    }

    public static ConcaveHullPocket findFirstConcaveHullPocketInefficient(List<? extends Point2DReadOnly> concaveHullVertices) {
        ConvexPolygon2D convexHull = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(concaveHullVertices));
        int convexStartIndex = 0;
        int concaveStartIndex = -1;
        for (int i = 0; i < convexHull.getNumberOfVertices(); ++i) {
            Point2DReadOnly currentConvexVertex = convexHull.getVertex(i);
            for (int j = 0; j < concaveHullVertices.size(); ++j) {
                Point2DReadOnly currentConcaveVertex = concaveHullVertices.get(j);
                if (!currentConcaveVertex.epsilonEquals((Tuple2DReadOnly)currentConvexVertex, 1.0E-7)) continue;
                concaveStartIndex = j;
                break;
            }
            if (convexStartIndex != -1) break;
        }
        if (convexStartIndex == -1 || concaveStartIndex == -1) {
            return null;
        }
        int startBridgeConcaveIndex = -1;
        int startBridgeConvexIndex = -1;
        for (int indexOffset = 1; indexOffset < concaveHullVertices.size(); ++indexOffset) {
            Point2DReadOnly currentConcaveVertex;
            int currentConvexIndex = (convexStartIndex + indexOffset) % convexHull.getNumberOfVertices();
            int currentConcaveIndex = (concaveStartIndex + indexOffset) % concaveHullVertices.size();
            Point2DReadOnly currentConvexVertex = convexHull.getVertex(currentConvexIndex);
            if (currentConvexVertex.epsilonEquals((Tuple2DReadOnly)(currentConcaveVertex = concaveHullVertices.get(currentConcaveIndex)), 1.0E-7)) continue;
            startBridgeConvexIndex = currentConvexIndex - 1;
            if (startBridgeConvexIndex == -1) {
                startBridgeConvexIndex = convexHull.getNumberOfVertices() - 1;
            }
            if ((startBridgeConcaveIndex = currentConcaveIndex - 1) != -1) break;
            startBridgeConcaveIndex = concaveHullVertices.size() - 1;
            break;
        }
        if (startBridgeConvexIndex == -1 || startBridgeConcaveIndex == -1) {
            return null;
        }
        int endBridgeConcaveIndex = -1;
        Point2DReadOnly firstBridgeVertex = convexHull.getVertex(startBridgeConvexIndex);
        Point2DReadOnly secondBridgeVertex = convexHull.getNextVertex(startBridgeConvexIndex);
        LineSegment2D bridgeSegment = new LineSegment2D(firstBridgeVertex, secondBridgeVertex);
        int currentConcaveIndex = (startBridgeConcaveIndex + 1) % concaveHullVertices.size();
        Point2DReadOnly currentConcaveVertex = concaveHullVertices.get(currentConcaveIndex);
        int deepestPocketVertexIndex = -1;
        double pocketMaxDepth = 0.0;
        while (!secondBridgeVertex.epsilonEquals((Tuple2DReadOnly)currentConcaveVertex, 1.0E-7)) {
            double currentDepth = bridgeSegment.distance(currentConcaveVertex);
            if (currentDepth > pocketMaxDepth) {
                deepestPocketVertexIndex = currentConcaveIndex;
                pocketMaxDepth = currentDepth;
            }
            currentConcaveIndex = (currentConcaveIndex + 1) % concaveHullVertices.size();
            currentConcaveVertex = concaveHullVertices.get(currentConcaveIndex);
        }
        endBridgeConcaveIndex = currentConcaveIndex;
        ConcaveHullPocket pocket = new ConcaveHullPocket();
        pocket.setBridgeIndices(startBridgeConcaveIndex, endBridgeConcaveIndex);
        pocket.setBridgeVertices(firstBridgeVertex, secondBridgeVertex);
        pocket.setMaxDepth(pocketMaxDepth);
        pocket.setDeepestVertex(concaveHullVertices.get(deepestPocketVertexIndex));
        pocket.setDeepestVertexIndex(deepestPocketVertexIndex);
        return pocket;
    }

    public static boolean isConvexAtVertex(int vertexIndex, List<? extends Point2DReadOnly> concaveHullVertices) {
        Point2DReadOnly nextVertex;
        Point2DReadOnly previousVertex;
        Point2DReadOnly vertex = concaveHullVertices.get(vertexIndex);
        return !EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)vertex, (Point2DReadOnly)(previousVertex = concaveHullVertices.get(ListWrappingIndexTools.previous((int)vertexIndex, concaveHullVertices))), (Point2DReadOnly)(nextVertex = concaveHullVertices.get(ListWrappingIndexTools.next((int)vertexIndex, concaveHullVertices))));
    }

    public static boolean isAlmostConvexAtVertex(int vertexIndex, double angleTolerance, List<? extends Point2DReadOnly> concaveHullVertices) {
        Point2DReadOnly vertex = concaveHullVertices.get(vertexIndex);
        Point2DReadOnly previousVertex = (Point2DReadOnly)ListWrappingIndexTools.getPrevious((int)vertexIndex, concaveHullVertices);
        Point2DReadOnly nextVertex = (Point2DReadOnly)ListWrappingIndexTools.getNext((int)vertexIndex, concaveHullVertices);
        return ConcaveHullTools.getAngleABC(nextVertex, previousVertex, vertex) > -angleTolerance;
    }

    public static double getAngleABC(Point2DReadOnly nextVertex, Point2DReadOnly previousVertex, Point2DReadOnly vertex) {
        double bax = previousVertex.getX() - nextVertex.getX();
        double bay = previousVertex.getY() - nextVertex.getY();
        double bcx = previousVertex.getX() - vertex.getX();
        double bcy = previousVertex.getY() - vertex.getY();
        return EuclidGeometryTools.angleFromFirstToSecondVector2D((double)bax, (double)bay, (double)bcx, (double)bcy);
    }

    public static double getAngleFromPreviousEdgeToNextEdge(int vertexIndex, List<? extends Point2DReadOnly> concaveHullVertices) {
        Point2DReadOnly vertex = concaveHullVertices.get(vertexIndex);
        Point2DReadOnly previousVertex = (Point2DReadOnly)ListWrappingIndexTools.getPrevious((int)vertexIndex, concaveHullVertices);
        Point2DReadOnly nextVertex = (Point2DReadOnly)ListWrappingIndexTools.getNext((int)vertexIndex, concaveHullVertices);
        double previousEdgeX = vertex.getX() - previousVertex.getX();
        double previousEdgeY = vertex.getY() - previousVertex.getY();
        double nextEdgeX = nextVertex.getX() - vertex.getX();
        double nextEdgeY = nextVertex.getY() - vertex.getY();
        return EuclidGeometryTools.angleFromFirstToSecondVector2D((double)previousEdgeX, (double)previousEdgeY, (double)nextEdgeX, (double)nextEdgeY);
    }

    public static boolean isHullConvex(List<? extends Point2DReadOnly> concaveHullVertices) {
        if (concaveHullVertices.size() <= 3) {
            return true;
        }
        for (int i = 0; i < concaveHullVertices.size(); ++i) {
            if (ConcaveHullTools.isConvexAtVertex(i, concaveHullVertices)) continue;
            return false;
        }
        return true;
    }

    public static int findInnerClosestEdgeToVertex(int vertexIndex, int deadIndexRegion, List<? extends Point2DReadOnly> concaveHullVertices, Point2DBasics closestPointToPack) {
        int startSearchIndex = ListWrappingIndexTools.next((int)vertexIndex, concaveHullVertices);
        int endSearchIndex = ListWrappingIndexTools.previous((int)vertexIndex, concaveHullVertices);
        return ConcaveHullTools.findInnerClosestEdgeToVertex(vertexIndex, startSearchIndex, endSearchIndex, concaveHullVertices, closestPointToPack);
    }

    public static int findInnerClosestEdgeToVertex(int vertexIndex, int startSearchIndex, int endSearchIndex, List<? extends Point2DReadOnly> concaveHullVertices, Point2DBasics closestPointToPack) {
        int closestEdgeFirstIndex = -1;
        double distanceSquaredToClosestEdge = Double.POSITIVE_INFINITY;
        Point2DReadOnly vertex = concaveHullVertices.get(vertexIndex %= concaveHullVertices.size());
        LineSegment2D edge = new LineSegment2D();
        Point2D candidateClosestPoint = new Point2D();
        int candidateIndex = startSearchIndex;
        while (candidateIndex != endSearchIndex) {
            Point2DReadOnly edgeFirstVertex = concaveHullVertices.get(candidateIndex);
            Point2DReadOnly edgeSecondVertex = (Point2DReadOnly)ListWrappingIndexTools.getNext((int)candidateIndex, concaveHullVertices);
            edge.set(edgeFirstVertex, edgeSecondVertex);
            edge.orthogonalProjection(vertex, (Point2DBasics)candidateClosestPoint);
            double distanceSquared = candidateClosestPoint.distanceSquared(vertex);
            if (distanceSquared < distanceSquaredToClosestEdge) {
                boolean isLineInsidePolygon = true;
                int startCheckIndex = ListWrappingIndexTools.next((int)startSearchIndex, concaveHullVertices);
                int endCheckIndex = ListWrappingIndexTools.next((int)candidateIndex, concaveHullVertices);
                int index = startCheckIndex;
                while (index != endCheckIndex && isLineInsidePolygon) {
                    isLineInsidePolygon = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)concaveHullVertices.get(index), (Point2DReadOnly)vertex, (Point2DReadOnly)candidateClosestPoint);
                    index = ListWrappingIndexTools.next((int)index, concaveHullVertices);
                }
                if (isLineInsidePolygon) {
                    distanceSquaredToClosestEdge = distanceSquared;
                    closestEdgeFirstIndex = candidateIndex;
                    closestPointToPack.set((Tuple2DReadOnly)candidateClosestPoint);
                }
            }
            candidateIndex = ListWrappingIndexTools.next((int)candidateIndex, concaveHullVertices);
        }
        return closestEdgeFirstIndex;
    }

    public static int findClosestIntersectionWithRay(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, int startSearchIndex, int endSearchIndex, List<? extends Point2DReadOnly> concaveHullVertices, Point2DBasics intersectionToPack) {
        double minDistanceSquared = Double.POSITIVE_INFINITY;
        int closestEdgeFirstVertexIndex = -1;
        intersectionToPack.set(Double.NaN, Double.NaN);
        Vector2D rayOriginToCandidate = new Vector2D();
        Line2D rayLine = new Line2D(rayOrigin, rayDirection);
        LineSegment2D edge = new LineSegment2D();
        int currentIndex = startSearchIndex;
        while (currentIndex != endSearchIndex) {
            int nextIndex = ListWrappingIndexTools.next((int)currentIndex, concaveHullVertices);
            Point2DReadOnly current = concaveHullVertices.get(currentIndex);
            Point2DReadOnly next = concaveHullVertices.get(nextIndex);
            edge.set(current, next);
            Point2DBasics intersection = edge.intersectionWith((Line2DReadOnly)rayLine);
            if (intersection != null) {
                double distanceSquared;
                rayOriginToCandidate.sub((Tuple2DReadOnly)intersection, (Tuple2DReadOnly)rayOrigin);
                if (!(rayOriginToCandidate.dot(rayDirection) < 0.0) && (distanceSquared = intersection.distanceSquared(rayOrigin)) < minDistanceSquared) {
                    minDistanceSquared = distanceSquared;
                    intersectionToPack.set((Tuple2DReadOnly)intersection);
                    closestEdgeFirstVertexIndex = currentIndex;
                }
            }
            currentIndex = ListWrappingIndexTools.next((int)currentIndex, concaveHullVertices);
        }
        return closestEdgeFirstVertexIndex;
    }

    public static String vertexListToString(List<? extends Point2DReadOnly> vertexList) {
        String ret = "";
        for (int i = 0; i < vertexList.size(); ++i) {
            Point2DReadOnly vertex = vertexList.get(i);
            ret = ret + vertex.getX() + ", " + vertex.getY();
            if (i >= vertexList.size() - 1) continue;
            ret = ret + "\n";
        }
        return ret;
    }

    public static void exportVertexListToFile(List<? extends Point2DReadOnly> vertexList, String fileName) {
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(ConcaveHullTools.vertexListToString(vertexList));
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

