/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.ListWrappingIndexTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHull;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullCollection;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullPocket;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullTools;
import us.ihmc.robotics.EuclidCoreMissingTools;

public class ConcaveHullPruningFilteringTools {
    public static int filterOutPeaksAndShallowAngles(double shallowAngleThreshold, double peakAngleThreshold, ConcaveHullCollection concaveHullCollectionToFilter) {
        int totalNumberOfVerticesRemoved = 0;
        int vertexRemoved = 0;
        do {
            vertexRemoved = 0;
            for (ConcaveHull concaveHullToFilter : concaveHullCollectionToFilter) {
                vertexRemoved += ConcaveHullPruningFilteringTools.filterOutPeaksAndShallowAngles(shallowAngleThreshold, peakAngleThreshold, concaveHullToFilter.getConcaveHullVertices());
            }
            totalNumberOfVerticesRemoved += vertexRemoved;
        } while (vertexRemoved != 0);
        return totalNumberOfVerticesRemoved;
    }

    public static int filterOutPeaksAndShallowAngles(double shallowAngleThreshold, double peakAngleThreshold, ConcaveHull concaveHullToFilter) {
        return ConcaveHullPruningFilteringTools.filterOutPeaksAndShallowAngles(shallowAngleThreshold, peakAngleThreshold, concaveHullToFilter.getConcaveHullVertices());
    }

    public static int filterOutPeaksAndShallowAngles(double shallowAngleThreshold, double peakAngleThreshold, List<Point2D> concaveHullVerticesToFilter) {
        int numberOfVerticesRemoved = 0;
        shallowAngleThreshold = -Math.abs(shallowAngleThreshold);
        peakAngleThreshold = -Math.abs(peakAngleThreshold);
        int currentIndex = 0;
        while (currentIndex < concaveHullVerticesToFilter.size()) {
            boolean isAngleWithinThresholds;
            if (!ConcaveHullTools.isConvexAtVertex(currentIndex, concaveHullVerticesToFilter)) {
                ++currentIndex;
                continue;
            }
            double angle = ConcaveHullTools.getAngleFromPreviousEdgeToNextEdge(currentIndex, concaveHullVerticesToFilter);
            boolean bl = isAngleWithinThresholds = angle < peakAngleThreshold || angle > shallowAngleThreshold;
            if (isAngleWithinThresholds && !ConcaveHullTools.isVertexPreventingKink(currentIndex, concaveHullVerticesToFilter)) {
                concaveHullVerticesToFilter.remove(currentIndex);
                ++numberOfVerticesRemoved;
                continue;
            }
            ++currentIndex;
        }
        return numberOfVerticesRemoved;
    }

    public static int filterOutShallowVertices(double percentageThreshold, List<Point2D> concaveHullVerticesToFilter) {
        int numberOfVerticesRemoved = 0;
        Point2D a = concaveHullVerticesToFilter.get(0);
        Point2D b = concaveHullVerticesToFilter.get(1);
        Point2D c = concaveHullVerticesToFilter.get(2);
        int currentIndex = 0;
        while (currentIndex < concaveHullVerticesToFilter.size()) {
            boolean isConvex = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)b, (Point2DReadOnly)a, (Point2DReadOnly)c);
            int nextIndex = ListWrappingIndexTools.next((int)currentIndex, concaveHullVerticesToFilter);
            if (isConvex && a.distance((Point2DReadOnly)c) / (a.distance((Point2DReadOnly)b) + b.distance((Point2DReadOnly)c)) > percentageThreshold && !ConcaveHullTools.isVertexPreventingKink(nextIndex, concaveHullVerticesToFilter)) {
                concaveHullVerticesToFilter.remove(nextIndex);
                b = c;
                ++numberOfVerticesRemoved;
            } else {
                a = b;
                b = c;
                ++currentIndex;
            }
            c = (Point2D)ListWrappingIndexTools.getNext((int)nextIndex, concaveHullVerticesToFilter);
        }
        return numberOfVerticesRemoved;
    }

    public static int filterOutGroupsOfShallowVertices(double percentageThreshold, List<Point2D> concaveHullVerticesToFilter) {
        int numberOfVerticesRemoved = 0;
        double perimeter = 0.0;
        double cuttingDistance = 0.0;
        double ratio = 0.0;
        int startCutIndex = 0;
        while (startCutIndex < concaveHullVerticesToFilter.size()) {
            int firstRemovableVertexIndex;
            Point2D firstVertex = concaveHullVerticesToFilter.get(startCutIndex);
            int intermediateIndex = ListWrappingIndexTools.next((int)startCutIndex, concaveHullVerticesToFilter);
            Point2D intermediateVertex = concaveHullVerticesToFilter.get(intermediateIndex);
            int lastVertexIndex = ListWrappingIndexTools.next((int)intermediateIndex, concaveHullVerticesToFilter);
            Point2D lastVertex = concaveHullVerticesToFilter.get(lastVertexIndex);
            perimeter = firstVertex.distance((Point2DReadOnly)intermediateVertex);
            perimeter += intermediateVertex.distance((Point2DReadOnly)lastVertex);
            cuttingDistance = firstVertex.distance((Point2DReadOnly)lastVertex);
            ratio = cuttingDistance / perimeter;
            if (ratio < percentageThreshold) {
                ++startCutIndex;
                continue;
            }
            int endCutIndex = lastVertexIndex;
            while (ratio > percentageThreshold) {
                intermediateVertex = lastVertex;
                endCutIndex = lastVertexIndex;
                lastVertexIndex = ListWrappingIndexTools.next((int)lastVertexIndex, concaveHullVerticesToFilter);
                lastVertex = concaveHullVerticesToFilter.get(lastVertexIndex);
                cuttingDistance = firstVertex.distance((Point2DReadOnly)lastVertex);
                ratio = cuttingDistance / (perimeter += intermediateVertex.distance((Point2DReadOnly)lastVertex));
            }
            int checkIndex = firstRemovableVertexIndex = ListWrappingIndexTools.next((int)startCutIndex, concaveHullVerticesToFilter);
            while (checkIndex != endCutIndex) {
                Point2D vertexToCheck = concaveHullVerticesToFilter.get(checkIndex);
                if (!EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)vertexToCheck, (Point2DReadOnly)firstVertex, (Point2DReadOnly)lastVertex)) {
                    endCutIndex = checkIndex;
                    if (endCutIndex == startCutIndex) break;
                    checkIndex = startCutIndex;
                    continue;
                }
                checkIndex = ListWrappingIndexTools.next((int)checkIndex, concaveHullVerticesToFilter);
            }
            if (endCutIndex == startCutIndex) {
                ++startCutIndex;
                continue;
            }
            numberOfVerticesRemoved += ListWrappingIndexTools.removeAllExclusive((int)startCutIndex, (int)endCutIndex, concaveHullVerticesToFilter);
        }
        return numberOfVerticesRemoved;
    }

    public static int filterOutSmallTriangles(double areaThreshold, List<Point2D> concaveHullVerticesToFilter) {
        int numberOfVerticesRemoved = 0;
        Point2D a = concaveHullVerticesToFilter.get(0);
        Point2D b = concaveHullVerticesToFilter.get(1);
        Point2D c = concaveHullVerticesToFilter.get(2);
        int currentIndex = 0;
        while (currentIndex < concaveHullVerticesToFilter.size()) {
            boolean isConvex = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)b, (Point2DReadOnly)a, (Point2DReadOnly)c);
            int nextIndex = ListWrappingIndexTools.next((int)currentIndex, concaveHullVerticesToFilter);
            if (isConvex && EuclidGeometryTools.triangleArea((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c) < areaThreshold && !ConcaveHullTools.isVertexPreventingKink(nextIndex, concaveHullVerticesToFilter)) {
                concaveHullVerticesToFilter.remove(nextIndex);
                b = c;
                ++numberOfVerticesRemoved;
            } else {
                a = b;
                b = c;
                ++currentIndex;
            }
            c = concaveHullVerticesToFilter.get(ListWrappingIndexTools.next((int)nextIndex, concaveHullVerticesToFilter));
        }
        return numberOfVerticesRemoved;
    }

    public static int flattenShallowPockets(double depthThreshold, List<Point2D> concaveHullVerticesToFilter) {
        int numberOfVerticesRemoved = 0;
        ConcaveHullPocket pocket = new ConcaveHullPocket();
        Vector2D shift = new Vector2D();
        for (int currentIndex = 0; currentIndex < concaveHullVerticesToFilter.size(); ++currentIndex) {
            double maxDepth;
            boolean success;
            if (ConcaveHullTools.isConvexAtVertex(currentIndex, concaveHullVerticesToFilter) || !(success = ConcaveHullTools.computeConcaveHullPocket(currentIndex, pocket, concaveHullVerticesToFilter)) || (maxDepth = pocket.getMaxDepth()) > depthThreshold) continue;
            Point2D startBridgeVertex = new Point2D((Tuple2DReadOnly)pocket.getStartBridgeVertex());
            Point2D endBridgeVertex = new Point2D((Tuple2DReadOnly)pocket.getEndBridgeVertex());
            shift.sub((Tuple2DReadOnly)endBridgeVertex, (Tuple2DReadOnly)startBridgeVertex);
            shift.normalize();
            shift.set(shift.getY(), -shift.getX());
            shift.scale(maxDepth);
            startBridgeVertex.add((Tuple2DReadOnly)shift);
            endBridgeVertex.add((Tuple2DReadOnly)shift);
            int startBridgeVertexIndex = pocket.getStartBridgeIndex();
            int endBridgeVertexIndex = pocket.getEndBridgeIndex();
            numberOfVerticesRemoved += ListWrappingIndexTools.removeAllExclusive((int)startBridgeVertexIndex, (int)endBridgeVertexIndex, concaveHullVerticesToFilter);
        }
        return numberOfVerticesRemoved;
    }

    public static int filterOutShortEdges(double lengthThreshold, ConcaveHullCollection concaveHullCollectionToFilter) {
        int numberOfRemovedVertices = 0;
        for (ConcaveHull concaveHullToFilter : concaveHullCollectionToFilter) {
            numberOfRemovedVertices += ConcaveHullPruningFilteringTools.filterOutShortEdges(lengthThreshold, concaveHullToFilter.getConcaveHullVertices());
        }
        return numberOfRemovedVertices;
    }

    public static int filterOutShortEdges(double lengthThreshold, ConcaveHull concaveHullToFilter) {
        return ConcaveHullPruningFilteringTools.filterOutShortEdges(lengthThreshold, concaveHullToFilter.getConcaveHullVertices());
    }

    public static int filterOutShortEdges(double lengthThreshold, List<Point2D> concaveHullVerticesToFilter) {
        int numberOfVerticesRemoved = 0;
        double lengthThresholdSquared = lengthThreshold * lengthThreshold;
        Vector2D edgeVector = new Vector2D();
        Vector2D previousEdgeVector = new Vector2D();
        Vector2D nextEdgeVector = new Vector2D();
        int beforeEdgeVertexIndex = 0;
        while (beforeEdgeVertexIndex < concaveHullVerticesToFilter.size()) {
            Point2D secondEdgeVertex;
            int firstEdgeVertexIndex = ListWrappingIndexTools.next((int)beforeEdgeVertexIndex, concaveHullVerticesToFilter);
            int secondEdgeVertexIndex = ListWrappingIndexTools.next((int)firstEdgeVertexIndex, concaveHullVerticesToFilter);
            int afterEdgeVertexIndex = ListWrappingIndexTools.next((int)secondEdgeVertexIndex, concaveHullVerticesToFilter);
            Point2D firstEdgeVertex = concaveHullVerticesToFilter.get(firstEdgeVertexIndex);
            double edgeLengthSquared = firstEdgeVertex.distanceSquared((Point2DReadOnly)(secondEdgeVertex = concaveHullVerticesToFilter.get(secondEdgeVertexIndex)));
            if (edgeLengthSquared > lengthThresholdSquared) {
                ++beforeEdgeVertexIndex;
                continue;
            }
            Point2D beforeEdgeVertex = concaveHullVerticesToFilter.get(beforeEdgeVertexIndex);
            Point2D afterEdgeVertex = concaveHullVerticesToFilter.get(afterEdgeVertexIndex);
            boolean isFirstEdgeVertexConvex = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)firstEdgeVertex, (Point2DReadOnly)beforeEdgeVertex, (Point2DReadOnly)secondEdgeVertex);
            boolean isSecondEdgeVertexConvex = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)secondEdgeVertex, (Point2DReadOnly)firstEdgeVertex, (Point2DReadOnly)afterEdgeVertex);
            if (!isFirstEdgeVertexConvex && !isSecondEdgeVertexConvex) {
                ++beforeEdgeVertexIndex;
                continue;
            }
            if (isFirstEdgeVertexConvex != isSecondEdgeVertexConvex) {
                if (isFirstEdgeVertexConvex) {
                    if (ConcaveHullTools.isVertexPreventingKink(firstEdgeVertexIndex, concaveHullVerticesToFilter)) {
                        ++beforeEdgeVertexIndex;
                        continue;
                    }
                    concaveHullVerticesToFilter.remove(firstEdgeVertexIndex);
                    ++numberOfVerticesRemoved;
                    continue;
                }
                if (ConcaveHullTools.isVertexPreventingKink(secondEdgeVertexIndex, concaveHullVerticesToFilter)) {
                    ++beforeEdgeVertexIndex;
                    continue;
                }
                concaveHullVerticesToFilter.remove(secondEdgeVertexIndex);
                ++numberOfVerticesRemoved;
                continue;
            }
            edgeVector.sub((Tuple2DReadOnly)secondEdgeVertex, (Tuple2DReadOnly)firstEdgeVertex);
            edgeVector.normalize();
            previousEdgeVector.sub((Tuple2DReadOnly)firstEdgeVertex, (Tuple2DReadOnly)beforeEdgeVertex);
            previousEdgeVector.normalize();
            nextEdgeVector.sub((Tuple2DReadOnly)afterEdgeVertex, (Tuple2DReadOnly)secondEdgeVertex);
            nextEdgeVector.normalize();
            double edgeDotNextEdge = edgeVector.dot((Vector2DReadOnly)nextEdgeVector);
            double previousEdgeDotEdge = previousEdgeVector.dot((Vector2DReadOnly)edgeVector);
            if (previousEdgeDotEdge > edgeDotNextEdge) {
                if (!ConcaveHullTools.isVertexPreventingKink(firstEdgeVertexIndex, concaveHullVerticesToFilter)) {
                    concaveHullVerticesToFilter.remove(firstEdgeVertexIndex);
                    ++numberOfVerticesRemoved;
                    continue;
                }
                if (!ConcaveHullTools.isVertexPreventingKink(secondEdgeVertexIndex, concaveHullVerticesToFilter)) {
                    concaveHullVerticesToFilter.remove(secondEdgeVertexIndex);
                    ++numberOfVerticesRemoved;
                    continue;
                }
                ++beforeEdgeVertexIndex;
                continue;
            }
            if (!ConcaveHullTools.isVertexPreventingKink(secondEdgeVertexIndex, concaveHullVerticesToFilter)) {
                concaveHullVerticesToFilter.remove(secondEdgeVertexIndex);
                ++numberOfVerticesRemoved;
                continue;
            }
            if (!ConcaveHullTools.isVertexPreventingKink(firstEdgeVertexIndex, concaveHullVerticesToFilter)) {
                concaveHullVerticesToFilter.remove(firstEdgeVertexIndex);
                ++numberOfVerticesRemoved;
                continue;
            }
            ++beforeEdgeVertexIndex;
        }
        return numberOfVerticesRemoved;
    }

    public static int filterByRay(double threshold, List<Point2D> concaveHullVerticesToFilter) {
        int numberOfVerticesRemoved = 0;
        Vector2D rayDirection = new Vector2D();
        Point2D intersection = new Point2D();
        double thresholdSquared = threshold * threshold;
        for (int currentIndex = 0; currentIndex < concaveHullVerticesToFilter.size(); ++currentIndex) {
            int secondSubLength;
            Point2D rayOrigin = concaveHullVerticesToFilter.get(currentIndex);
            rayDirection.sub((Tuple2DReadOnly)ListWrappingIndexTools.getNext((int)currentIndex, concaveHullVerticesToFilter), (Tuple2DReadOnly)ListWrappingIndexTools.getPrevious((int)currentIndex, concaveHullVerticesToFilter));
            rayDirection.set(rayDirection.getY(), -rayDirection.getX());
            int startSearchIndex = ListWrappingIndexTools.next((int)currentIndex, concaveHullVerticesToFilter);
            int endSearchIndex = ListWrappingIndexTools.previous((int)currentIndex, concaveHullVerticesToFilter);
            int edgeFirstVertexIndex = ConcaveHullTools.findClosestIntersectionWithRay((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, startSearchIndex, endSearchIndex, concaveHullVerticesToFilter, (Point2DBasics)intersection);
            if (!(rayOrigin.distanceSquared((Point2DReadOnly)intersection) < thresholdSquared)) continue;
            int edgeSecondVertexIndex = ListWrappingIndexTools.next((int)edgeFirstVertexIndex, concaveHullVerticesToFilter);
            int firstSubLength = ListWrappingIndexTools.subLengthInclusive((int)currentIndex, (int)edgeFirstVertexIndex, concaveHullVerticesToFilter);
            if (firstSubLength < (secondSubLength = ListWrappingIndexTools.subLengthInclusive((int)edgeSecondVertexIndex, (int)currentIndex, concaveHullVerticesToFilter))) {
                concaveHullVerticesToFilter.get(edgeFirstVertexIndex).set(intersection);
                numberOfVerticesRemoved += ListWrappingIndexTools.removeAllExclusive((int)currentIndex, (int)edgeFirstVertexIndex, concaveHullVerticesToFilter);
                continue;
            }
            concaveHullVerticesToFilter.get(edgeSecondVertexIndex).set(intersection);
            numberOfVerticesRemoved += ListWrappingIndexTools.removeAllExclusive((int)edgeSecondVertexIndex, (int)currentIndex, concaveHullVerticesToFilter);
        }
        return numberOfVerticesRemoved;
    }

    public static ConcaveHullCollection concaveHullNarrowPassageCutter(double alphaRadius, ConcaveHullCollection concaveHullCollectionToFilter) {
        ConcaveHullCollection filteredConcaveHullCollection = new ConcaveHullCollection();
        for (ConcaveHull concaveHull : concaveHullCollectionToFilter) {
            filteredConcaveHullCollection.addAll(ConcaveHullPruningFilteringTools.concaveHullNarrowPassageCutter(alphaRadius, concaveHull));
        }
        return filteredConcaveHullCollection;
    }

    public static ConcaveHullCollection concaveHullNarrowPassageCutter(double alphaRadius, ConcaveHull concaveHullToFilter) {
        double area;
        if (concaveHullToFilter.getNumberOfVertices() <= 2) {
            return null;
        }
        double perimeter = concaveHullToFilter.computePerimeter();
        if (0.5 * perimeter <= 2.0 * alphaRadius) {
            return null;
        }
        if (concaveHullToFilter.getNumberOfVertices() == 3) {
            for (int vertexIndex = 0; vertexIndex < 3; ++vertexIndex) {
                Point2D nextVertex;
                Point2D vertex = concaveHullToFilter.getConcaveHullVertices().get(vertexIndex);
                if (!(vertex.distanceSquared((Point2DReadOnly)(nextVertex = (Point2D)ListWrappingIndexTools.getNext((int)vertexIndex, concaveHullToFilter.getConcaveHullVertices()))) <= MathTools.square((double)(2.0 * alphaRadius)))) continue;
                return null;
            }
        }
        if (concaveHullToFilter.getNumberOfVertices() <= 6 && (area = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(concaveHullToFilter.getConcaveHullVertices())).getArea()) <= Math.PI * MathTools.square((double)alphaRadius)) {
            return null;
        }
        int numberOfVertices = concaveHullToFilter.getNumberOfVertices();
        int iEdgeStartA = 0;
        int iEdgeEndA = 1;
        while (iEdgeStartA < numberOfVertices - 1) {
            if (!ConcaveHullTools.isConvexAtVertex(iEdgeStartA, concaveHullToFilter.getConcaveHullVertices())) {
                Point2D edgeStartA = concaveHullToFilter.getVertex(iEdgeStartA);
                Point2D edgeEndA = concaveHullToFilter.getVertex(iEdgeEndA);
                int iEdgeStartB = iEdgeEndA;
                int iEdgeEndB = iEdgeStartB + 1;
                while (iEdgeStartB < numberOfVertices) {
                    if (!ConcaveHullTools.isConvexAtVertex(iEdgeStartB, concaveHullToFilter.getConcaveHullVertices())) {
                        double distance;
                        Point2D edgeStartB = concaveHullToFilter.getVertex(iEdgeStartB);
                        Point2D edgeEndB = concaveHullToFilter.getVertex(iEdgeEndB %= numberOfVertices);
                        if (!(ConcaveHullPruningFilteringTools.perimeterDistanceBetweenVertices(iEdgeEndA, iEdgeStartB, concaveHullToFilter) <= 2.0 * alphaRadius || ConcaveHullPruningFilteringTools.perimeterDistanceBetweenVertices(iEdgeEndB, iEdgeStartA, concaveHullToFilter) <= 2.0 * alphaRadius || (distance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)edgeStartA, (Point2DReadOnly)edgeEndA, (Point2DReadOnly)edgeStartB, (Point2DReadOnly)edgeEndB)) > 2.0 * alphaRadius)) {
                            Point2D closestPointOnEdgeA = new Point2D();
                            Point2D closestPointOnEdgeB = new Point2D();
                            EuclidCoreMissingTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)edgeStartA, (Point2DReadOnly)edgeEndA, (Point2DReadOnly)edgeStartB, (Point2DReadOnly)edgeEndB, (Point2DBasics)closestPointOnEdgeA, (Point2DBasics)closestPointOnEdgeB);
                            List<Point2D> concaveHullVertices = concaveHullToFilter.getConcaveHullVertices();
                            ConcaveHull subConcaveHullA = new ConcaveHull(ListWrappingIndexTools.subListInclusive((int)iEdgeEndA, (int)iEdgeStartB, concaveHullVertices));
                            ConcaveHull subConcaveHullB = new ConcaveHull(ListWrappingIndexTools.subListInclusive((int)iEdgeEndB, (int)iEdgeStartA, concaveHullVertices));
                            if (EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)closestPointOnEdgeA, (Point2DReadOnly)edgeStartA, (Point2DReadOnly)edgeEndA) < 0.5) {
                                subConcaveHullA.getConcaveHullVertices().add(0, edgeStartA);
                            } else {
                                subConcaveHullB.addVertex(edgeEndA);
                            }
                            if (EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)closestPointOnEdgeB, (Point2DReadOnly)edgeStartB, (Point2DReadOnly)edgeEndB) < 0.5) {
                                subConcaveHullB.getConcaveHullVertices().add(0, edgeStartB);
                            } else {
                                subConcaveHullA.addVertex(edgeEndB);
                            }
                            if (subConcaveHullA.getNumberOfVertices() == 2) {
                                return new ConcaveHullCollection(subConcaveHullB);
                            }
                            if (subConcaveHullB.getNumberOfVertices() == 2) {
                                return new ConcaveHullCollection(subConcaveHullA);
                            }
                            ConcaveHullCollection output = new ConcaveHullCollection();
                            output.addAll(ConcaveHullPruningFilteringTools.concaveHullNarrowPassageCutter(alphaRadius, subConcaveHullA));
                            output.addAll(ConcaveHullPruningFilteringTools.concaveHullNarrowPassageCutter(alphaRadius, subConcaveHullB));
                            return output;
                        }
                    }
                    ++iEdgeStartB;
                    ++iEdgeEndB;
                }
            }
            ++iEdgeStartA;
            ++iEdgeEndA;
        }
        return new ConcaveHullCollection(concaveHullToFilter);
    }

    private static double perimeterDistanceBetweenVertices(int firstVertexIndex, int secondVertexIndex, ConcaveHull concaveHull) {
        List pathToWalk = ListWrappingIndexTools.subListInclusive((int)firstVertexIndex, (int)secondVertexIndex, concaveHull.getConcaveHullVertices());
        double perimeterDistance = 0.0;
        for (int vertexIndex = 0; vertexIndex < pathToWalk.size() - 1; ++vertexIndex) {
            perimeterDistance += ((Point2D)pathToWalk.get(vertexIndex)).distance((Point2DReadOnly)pathToWalk.get(vertexIndex + 1));
        }
        return perimeterDistance;
    }
}

