/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import java.util.Scanner;
import us.ihmc.jOctoMap.tools.ScannerTools;

public class ConcaveHullFactoryParameters {
    private double edgeLengthThreshold;
    private boolean removeAllTrianglesWithTwoBorderEdges;
    private boolean allowSplittingConcaveHull;
    private int maxNumberOfIterations;
    private double triangulationTolerance;

    public ConcaveHullFactoryParameters() {
        this.setDefaultParameters();
    }

    public ConcaveHullFactoryParameters(ConcaveHullFactoryParameters other) {
        this.set(other);
    }

    public void set(ConcaveHullFactoryParameters other) {
        this.edgeLengthThreshold = other.edgeLengthThreshold;
        this.removeAllTrianglesWithTwoBorderEdges = other.removeAllTrianglesWithTwoBorderEdges;
        this.allowSplittingConcaveHull = other.allowSplittingConcaveHull;
        this.maxNumberOfIterations = other.maxNumberOfIterations;
        this.triangulationTolerance = other.triangulationTolerance;
    }

    public void setDefaultParameters() {
        this.edgeLengthThreshold = 0.1;
        this.removeAllTrianglesWithTwoBorderEdges = true;
        this.allowSplittingConcaveHull = true;
        this.maxNumberOfIterations = 5000;
        this.triangulationTolerance = 0.0;
    }

    public double getEdgeLengthThreshold() {
        return this.edgeLengthThreshold;
    }

    public boolean doRemoveAllTrianglesWithTwoBorderEdges() {
        return this.removeAllTrianglesWithTwoBorderEdges;
    }

    public boolean isSplittingConcaveHullAllowed() {
        return this.allowSplittingConcaveHull;
    }

    public int getMaxNumberOfIterations() {
        return this.maxNumberOfIterations;
    }

    public double getTriangulationTolerance() {
        return this.triangulationTolerance;
    }

    public void setEdgeLengthThreshold(double edgeLengthThreshold) {
        this.edgeLengthThreshold = edgeLengthThreshold;
    }

    public void setRemoveAllTrianglesWithTwoBorderEdges(boolean removeAllTrianglesWithTwoBorderEdges) {
        this.removeAllTrianglesWithTwoBorderEdges = removeAllTrianglesWithTwoBorderEdges;
    }

    public void setAllowSplittingConcaveHull(boolean allowSplittingConcaveHull) {
        this.allowSplittingConcaveHull = allowSplittingConcaveHull;
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }

    public void setTriangulationTolerance(double triangulationTolerance) {
        this.triangulationTolerance = triangulationTolerance;
    }

    public String toString() {
        return "edge length threshold: " + this.edgeLengthThreshold + ", remove any triangle with two borderedges: " + this.removeAllTrianglesWithTwoBorderEdges + ", allow splitting concave hull: " + this.allowSplittingConcaveHull + ", maximum number of iterations: " + this.maxNumberOfIterations + ", triangulation tolerance: " + this.triangulationTolerance;
    }

    public void setFromString(String parametersAsString) {
        parametersAsString = parametersAsString.replace(",", "");
        Scanner scanner = new Scanner(parametersAsString);
        this.setEdgeLengthThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)this.getEdgeLengthThreshold()));
        this.setRemoveAllTrianglesWithTwoBorderEdges(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)this.doRemoveAllTrianglesWithTwoBorderEdges()));
        this.setAllowSplittingConcaveHull(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)this.isSplittingConcaveHullAllowed()));
        this.setMaxNumberOfIterations(ScannerTools.readNextInt((Scanner)scanner, (int)this.getMaxNumberOfIterations()));
        this.setTriangulationTolerance(ScannerTools.readNextDouble((Scanner)scanner, (double)this.getTriangulationTolerance()));
        scanner.close();
    }

    public static ConcaveHullFactoryParameters parse(String parametersAsString) {
        ConcaveHullFactoryParameters parameters = new ConcaveHullFactoryParameters();
        parameters.setFromString(parametersAsString);
        return parameters;
    }
}

