/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullCutPoint;
import us.ihmc.robotics.referenceFrames.Pose2dReferenceFrame;
import us.ihmc.tools.lists.CircularArrayList;

public class ConcaveHullCutModel {
    private CircularArrayList<ConcaveHullCutPoint> points = new CircularArrayList();
    private final CircularArrayList<ConcaveHullCutPoint> intersectionsFromLeftToRight;
    private final LinkedHashMap<Integer, ConcaveHullCutPoint> nextVertexToIntersectionMap;

    public ConcaveHullCutModel(List<Point2D> concaveHullVertices, Line2DReadOnly cuttingLine, Vector2DReadOnly upDirection, Map<Integer, Point2D> intersections) {
        int n;
        Pose2dReferenceFrame cuttingLineFrame = new Pose2dReferenceFrame("cuttingLineFrame", ReferenceFrame.getWorldFrame());
        double angle = EuclidGeometryTools.angleFromFirstToSecondVector2D((double)0.0, (double)1.0, (double)upDirection.getX(), (double)upDirection.getY());
        cuttingLineFrame.setPoseAndUpdate(cuttingLine.getPoint(), angle);
        this.intersectionsFromLeftToRight = new CircularArrayList();
        for (Map.Entry<Integer, Point2D> entry : intersections.entrySet()) {
            FramePoint2D frameIntersection = new FramePoint2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)entry.getValue());
            frameIntersection.changeFrame((ReferenceFrame)cuttingLineFrame);
            this.intersectionsFromLeftToRight.add((Object)new ConcaveHullCutPoint(frameIntersection, entry.getKey()));
        }
        this.intersectionsFromLeftToRight.sort(Comparator.comparingDouble(ConcaveHullCutPoint::getX));
        for (ConcaveHullCutPoint concaveHullCutPoint : this.intersectionsFromLeftToRight) {
            concaveHullCutPoint.getAsFramePoint().changeFrame(ReferenceFrame.getWorldFrame());
        }
        this.nextVertexToIntersectionMap = new LinkedHashMap();
        for (ConcaveHullCutPoint concaveHullCutPoint : this.intersectionsFromLeftToRight) {
            this.nextVertexToIntersectionMap.put(concaveHullCutPoint.getNextVertex(), concaveHullCutPoint);
        }
        int hullIndex = 0;
        while (this.points.size() < concaveHullVertices.size() + this.nextVertexToIntersectionMap.size()) {
            this.points.add((Object)new ConcaveHullCutPoint((Tuple2DReadOnly)concaveHullVertices.get(hullIndex)));
            if (!this.nextVertexToIntersectionMap.containsKey(hullIndex = EuclidGeometryPolygonTools.next((int)hullIndex, (int)concaveHullVertices.size()))) continue;
            this.points.add((Object)this.nextVertexToIntersectionMap.get(hullIndex));
        }
        boolean bl = false;
        for (int i = 0; i < this.points.size(); ++i) {
            if (!((ConcaveHullCutPoint)this.points.get(i)).isIntersection() || !((ConcaveHullCutPoint)this.points.get(i)).getAsFramePoint().equals((FrameTuple2DReadOnly)((ConcaveHullCutPoint)this.intersectionsFromLeftToRight.get(0)).getAsFramePoint())) continue;
            n = i;
        }
        this.points.reindexTo(n);
    }

    public int indexOfIntersectionToLeft(int indexKnownToBeAnIntersection) {
        int i;
        int leftToRightIndex = -1;
        for (i = 0; i < this.points.size(); ++i) {
            if (i != indexKnownToBeAnIntersection) continue;
            int intersectionIndex = this.intersectionsFromLeftToRight.indexOf(this.points.get(i));
            leftToRightIndex = this.intersectionsFromLeftToRight.getPreviousIndex(intersectionIndex);
            break;
        }
        for (i = 0; i < this.points.size(); ++i) {
            if (!((ConcaveHullCutPoint)this.points.get(i)).equals(this.intersectionsFromLeftToRight.get(leftToRightIndex))) continue;
            return i;
        }
        throw new RuntimeException("Shouldn't get here");
    }

    public boolean allIntersectionsVisited() {
        for (ConcaveHullCutPoint point : this.intersectionsFromLeftToRight) {
            if (point.getVisited()) continue;
            return false;
        }
        return true;
    }

    public int indexOfFirstUnvisitedIntersection() {
        int i;
        int leftToRightIndex = -1;
        for (i = 0; i < this.intersectionsFromLeftToRight.size(); ++i) {
            ConcaveHullCutPoint concaveHullCutPoint = (ConcaveHullCutPoint)this.intersectionsFromLeftToRight.get(i);
            if (concaveHullCutPoint.getVisited()) continue;
            leftToRightIndex = i;
            break;
        }
        for (i = 0; i < this.points.size(); ++i) {
            if (!((ConcaveHullCutPoint)this.points.get(i)).equals(this.intersectionsFromLeftToRight.get(leftToRightIndex))) continue;
            return i;
        }
        throw new RuntimeException("Somehow the unvisited vertex didn't equal any in the combined list. Bug!");
    }

    public CircularArrayList<ConcaveHullCutPoint> getPoints() {
        return this.points;
    }

    public CircularArrayList<ConcaveHullCutPoint> getIntersectionsFromLeftToRight() {
        return this.intersectionsFromLeftToRight;
    }

    public LinkedHashMap<Integer, ConcaveHullCutPoint> getNextVertexToIntersectionMap() {
        return this.nextVertexToIntersectionMap;
    }
}

