/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullPocket;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullTools;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerTools;

public class ConcaveHull
implements Iterable<Point2D> {
    private final List<Point2D> hullVertices;

    public ConcaveHull() {
        this.hullVertices = new ArrayList<Point2D>();
    }

    public ConcaveHull(List<? extends Point2DReadOnly> hullVertices) {
        this.hullVertices = hullVertices.stream().map(Point2D::new).collect(Collectors.toList());
    }

    public ConcaveHull(ConcaveHull other) {
        this.hullVertices = new ArrayList<Point2D>();
        for (Point2D hullVertex : other.hullVertices) {
            this.hullVertices.add(new Point2D((Tuple2DReadOnly)hullVertex));
        }
    }

    public boolean isEmpty() {
        return this.hullVertices.isEmpty();
    }

    public void ensureCounterClockwiseOrdering() {
        ConcaveHullTools.ensureCounterClockwiseOrdering(this.hullVertices);
    }

    public void ensureClockwiseOrdering() {
        ConcaveHullTools.ensureClockwiseOrdering(this.hullVertices);
    }

    public void removeSuccessiveDuplicateVertices() {
        ConcaveHullTools.removeSuccessiveDuplicateVertices(this.hullVertices);
    }

    public boolean isVertexPreventingKink(int vertexIndex) {
        return ConcaveHullTools.isVertexPreventingKink(vertexIndex, this.hullVertices);
    }

    public double computePerimeter() {
        return ConcaveHullTools.computePerimeter(this.hullVertices);
    }

    public boolean computeConcaveHullPocket(int concaveVertexIndex, ConcaveHullPocket pocketToPack) {
        return ConcaveHullTools.computeConcaveHullPocket(concaveVertexIndex, pocketToPack, this.hullVertices);
    }

    public ConcaveHullPocket computeConcaveHullPocket(int concaveVertexIndex) {
        return ConcaveHullTools.computeConcaveHullPocket(concaveVertexIndex, this.hullVertices);
    }

    public Set<ConcaveHullPocket> findConcaveHullPockets(double depthThreshold) {
        return ConcaveHullTools.findConcaveHullPockets(this.hullVertices, depthThreshold);
    }

    public ConcaveHullPocket findFirstConcaveHullPocket() {
        return this.findFirstConcaveHullPocket(0);
    }

    public ConcaveHullPocket findFirstConcaveHullPocket(int startIndex) {
        return ConcaveHullTools.findFirstConcaveHullPocket(this.hullVertices, startIndex);
    }

    public boolean isConvexAtVertex(int vertexIndex) {
        return ConcaveHullTools.isConvexAtVertex(vertexIndex, this.hullVertices);
    }

    public boolean isAlmostConvexAtVertex(int vertexIndex, double angleTolerance) {
        return ConcaveHullTools.isAlmostConvexAtVertex(vertexIndex, angleTolerance, this.hullVertices);
    }

    public double getAngleFromPreviousEdgeToNextEdge(int vertexIndex) {
        return ConcaveHullTools.getAngleFromPreviousEdgeToNextEdge(vertexIndex, this.hullVertices);
    }

    public boolean isHullConvex() {
        return ConcaveHullTools.isHullConvex(this.hullVertices);
    }

    public int getNumberOfVertices() {
        return this.hullVertices.size();
    }

    public List<Point2D> getConcaveHullVertices() {
        return this.hullVertices;
    }

    public void addVertex(double x, double y) {
        this.hullVertices.add(new Point2D(x, y));
    }

    public void addVertex(Point2D vertex) {
        this.hullVertices.add(vertex);
    }

    public Point2D getVertex(int vertexIndex) {
        return this.hullVertices.get(vertexIndex);
    }

    public List<Point3D> toVerticesInWorld(Point3DReadOnly hullOrigin, Orientation3DReadOnly hullOrientation) {
        return PolygonizerTools.toPointsInWorld(this.hullVertices, hullOrigin, hullOrientation);
    }

    public List<Point3D> toVerticesInWorld(Point3DReadOnly hullOrigin, Vector3DReadOnly hullNormal) {
        return PolygonizerTools.toPointsInWorld(this.hullVertices, hullOrigin, hullNormal);
    }

    public List<Point3D> toVerticesInWorld(RigidBodyTransform transformToWorld) {
        List<Point3D> vertices3d = this.toVertices3d(0.0);
        vertices3d.forEach(vertex -> transformToWorld.transform((Point3DBasics)vertex));
        return vertices3d;
    }

    public List<Point3D> toVertices3d(double zOffset) {
        return this.stream().map(vertex -> new Point3D(vertex.getX(), vertex.getY(), zOffset)).collect(Collectors.toList());
    }

    public boolean epsilonEquals(ConcaveHull other, double epsilon) {
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int vertexIndex = 0; vertexIndex <= this.getNumberOfVertices(); ++vertexIndex) {
            if (this.hullVertices.get(vertexIndex).epsilonEquals(other.hullVertices.get(vertexIndex), epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean geometricallyEquals(ConcaveHull other, double epsilon) {
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        if (this.getNumberOfVertices() == 0) {
            return true;
        }
        int alignmentOffset = 0;
        boolean failed = true;
        block0: while (failed && alignmentOffset < this.getNumberOfVertices()) {
            failed = false;
            for (int i = 0; i < this.getNumberOfVertices(); ++i) {
                int compareIndex = (i + alignmentOffset) % this.getNumberOfVertices();
                boolean epsilonEquals = this.hullVertices.get(i).epsilonEquals(other.hullVertices.get(compareIndex), epsilon);
                if (epsilonEquals) continue;
                failed = true;
                ++alignmentOffset;
                continue block0;
            }
        }
        return !failed;
    }

    public Stream<Point2D> stream() {
        return this.hullVertices.stream();
    }

    @Override
    public Iterator<Point2D> iterator() {
        return this.hullVertices.iterator();
    }

    public int hashCode() {
        int hashCode = 1;
        for (Point2D vertex : this) {
            hashCode = 31 * hashCode + (vertex == null ? 0 : vertex.hashCode());
        }
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof ConcaveHull) {
            return this.equals((ConcaveHull)object);
        }
        return false;
    }

    public boolean equals(ConcaveHull other) {
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int vertexIndex = 0; vertexIndex < this.getNumberOfVertices(); ++vertexIndex) {
            if (this.hullVertices.get(vertexIndex).equals((Tuple2DReadOnly)other.hullVertices.get(vertexIndex))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Size: " + this.getNumberOfVertices() + "\n" + ConcaveHullTools.vertexListToString(this.hullVertices);
    }
}

