/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.objectDetection;

import controller_msgs.msg.dds.DoorParameterPacket;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import sensor_msgs.msg.dds.RegionOfInterest;
import us.ihmc.commons.Conversions;
import us.ihmc.javaFXToolkit.messager.SharedMemoryJavaFXMessager;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.fusion.objectDetection.AbstractObjectParameterCalculator;
import us.ihmc.robotEnvironmentAwareness.fusion.objectDetection.DoorParameterCalculator;
import us.ihmc.robotEnvironmentAwareness.fusion.objectDetection.ObjectDetectionSocketHelper;
import us.ihmc.robotEnvironmentAwareness.fusion.objectDetection.ObjectType;
import us.ihmc.robotEnvironmentAwareness.fusion.tools.ImageVisualizationHelper;
import us.ihmc.ros2.ROS2Node;

public class FusionSensorObjectDetectionManager {
    private final SharedMemoryJavaFXMessager messager;
    private static final int socketPort = 65535;
    private static final long milliSecondsForOneTick = 10L;
    private static final double maximumTimeToWaitResult = 20.0;
    private Socket objectDetectionSocket;
    private boolean imageRequested;
    private final List<ObjectType> selectedObjectTypes = new ArrayList<ObjectType>();
    private final Map<ObjectType, RegionOfInterest> objectTypeToROIMap = new HashMap<ObjectType, RegionOfInterest>();
    private final AbstractObjectParameterCalculator<DoorParameterPacket> doorParameterCalculator;
    private final AtomicReference<StereoVisionPointCloudMessage> latestStereoVisionPointCloudMessage = new AtomicReference<Object>(null);
    private final AtomicReference<BufferedImage> leatestBufferedImage = new AtomicReference();

    public FusionSensorObjectDetectionManager(ROS2Node ros2Node, SharedMemoryJavaFXMessager messager) {
        this.messager = messager;
        this.doorParameterCalculator = new DoorParameterCalculator(ros2Node, DoorParameterPacket.class);
        TimerTask socketTimerTask = new TimerTask(){
            private double waitingTime = 0.0;

            @Override
            public void run() {
                if (!FusionSensorObjectDetectionManager.this.imageRequested) {
                    return;
                }
                this.waitingTime += 0.01;
                if (this.waitingTime > 20.0) {
                    this.done();
                    LogTools.info((String)"# detecting time out!");
                }
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(FusionSensorObjectDetectionManager.this.objectDetectionSocket.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    if (!bufferedReader.ready()) {
                        return;
                    }
                    int[] roiData = ObjectDetectionSocketHelper.convertStringToIntArray(bufferedReader.readLine());
                    FusionSensorObjectDetectionManager.this.objectTypeToROIMap.clear();
                    for (int i = 0; i < roiData.length; i += 5) {
                        if (roiData[i] == -1) {
                            return;
                        }
                        ObjectType detectedObjectType = ObjectType.values()[roiData[i]];
                        int xmin = roiData[i + 1];
                        int xmax = roiData[i + 2];
                        int ymin = roiData[i + 3];
                        int ymax = roiData[i + 4];
                        RegionOfInterest roi = new RegionOfInterest();
                        roi.setXOffset((long)xmin);
                        roi.setYOffset((long)ymin);
                        roi.setHeight((long)(ymax - ymin));
                        roi.setWidth((long)(xmax - xmin));
                        FusionSensorObjectDetectionManager.this.objectTypeToROIMap.put(detectedObjectType, roi);
                    }
                    LogTools.info((String)("# detecting time tooks " + this.waitingTime + " seconds."));
                    this.done();
                    FusionSensorObjectDetectionManager.this.publishResults();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            private void done() {
                this.waitingTime = 0.0;
                FusionSensorObjectDetectionManager.this.imageRequested = false;
            }
        };
        Timer socketTimer = new Timer();
        socketTimer.schedule(socketTimerTask, 0L, 10L);
    }

    public void updateLatestStereoVisionPointCloudMessage(StereoVisionPointCloudMessage message) {
        this.latestStereoVisionPointCloudMessage.set(message);
    }

    public void connectExternalModule(String moduleAddress) {
        LogTools.info((String)("server address to connect is " + moduleAddress));
        try {
            this.objectDetectionSocket = new Socket(moduleAddress, 65535);
        }
        catch (ConnectException | UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestObjectDetection(BufferedImage image, List<ObjectType> selectedTypes) {
        this.leatestBufferedImage.set(image);
        byte[] imgBytes = ObjectDetectionSocketHelper.convertImgToBytes(image);
        byte[] imgDimBytes = ObjectDetectionSocketHelper.convertImgDimToBytes(imgBytes.length, image.getWidth(), image.getHeight());
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(this.objectDetectionSocket.getOutputStream());
            dataOutputStream.write(imgDimBytes);
            dataOutputStream.write(imgBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.selectedObjectTypes.clear();
        this.selectedObjectTypes.addAll(selectedTypes);
        this.imageRequested = true;
    }

    public void close() throws Exception {
        if (this.objectDetectionSocket != null && !this.objectDetectionSocket.isClosed()) {
            this.objectDetectionSocket.close();
        }
    }

    private void publishResults() {
        BufferedImage image = this.leatestBufferedImage.get();
        for (ObjectType objectType : this.selectedObjectTypes) {
            RegionOfInterest detectedObjectROI = this.objectTypeToROIMap.get((Object)objectType);
            if (detectedObjectROI == null) continue;
            ImageVisualizationHelper.drawROIOnImage(image, detectedObjectROI, objectType.getROIColor(), objectType.toString());
            switch (objectType) {
                case Cup: {
                    break;
                }
                case Door: {
                    this.calculateAndPublishDoorParameter(detectedObjectROI, this.objectTypeToROIMap.get((Object)ObjectType.DoorHandle));
                    break;
                }
                case DoorHandle: {
                    break;
                }
                case Human: {
                    break;
                }
            }
        }
        this.messager.submitMessage(LidarImageFusionAPI.ImageResultState, (Object)image);
    }

    private void calculateAndPublishDoorParameter(RegionOfInterest doorROI, RegionOfInterest handleROI) {
        long startTime = System.nanoTime();
        this.doorParameterCalculator.initialize();
        this.doorParameterCalculator.trimPointCloudInROI(this.latestStereoVisionPointCloudMessage.get(), doorROI);
        this.doorParameterCalculator.calculate(handleROI);
        this.doorParameterCalculator.publish();
        long computingTime = System.nanoTime() - startTime;
        LogTools.info((String)("Door computing time is " + Conversions.nanosecondsToSeconds((long)computingTime)));
    }
}

