/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.data;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.javaFXToolkit.messager.SharedMemoryJavaFXMessager;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.fusion.data.LidarImageFusionData;
import us.ihmc.robotEnvironmentAwareness.fusion.data.StereoREAPlanarRegionSegmentationCalculator;
import us.ihmc.robotEnvironmentAwareness.fusion.parameters.PlanarRegionPropagationParameters;
import us.ihmc.robotEnvironmentAwareness.fusion.parameters.SegmentationRawDataFilteringParameters;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullFactoryParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.CustomPlanarRegionHandler;
import us.ihmc.robotEnvironmentAwareness.planarRegion.CustomRegionMergeParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.IntersectionEstimationParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionIntersectionCalculator;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionPolygonizer;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationNodeData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerParameters;
import us.ihmc.robotEnvironmentAwareness.updaters.RegionFeaturesProvider;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class StereoREAPlanarRegionFeatureUpdater
implements RegionFeaturesProvider {
    private final StereoREAPlanarRegionSegmentationCalculator planarRegionSegmentationCalculator = new StereoREAPlanarRegionSegmentationCalculator();
    private PlanarRegionsList planarRegionsList = null;
    private final TIntObjectHashMap<PlanarRegion> customPlanarRegions = new TIntObjectHashMap();
    private final AtomicReference<Boolean> enableCustomRegions;
    private final AtomicReference<Boolean> clearCustomRegions;
    private final AtomicReference<CustomRegionMergeParameters> customRegionMergingParameters;
    private final AtomicReference<SegmentationRawDataFilteringParameters> segmentationRawDataFilteringParameters;
    private final AtomicReference<PlanarRegionPropagationParameters> planarRegionPropagationParameters;
    private final AtomicReference<ConcaveHullFactoryParameters> concaveHullFactoryParameters;
    private final AtomicReference<PolygonizerParameters> polygonizerParameters;
    private final AtomicReference<IntersectionEstimationParameters> intersectionEstimationParameters;
    private List<LineSegment3D> planarRegionsIntersections = null;

    public StereoREAPlanarRegionFeatureUpdater(Messager reaMessager, SharedMemoryJavaFXMessager messager) {
        this.enableCustomRegions = reaMessager.createInput(REAModuleAPI.CustomRegionsMergingEnable, (Object)true);
        this.clearCustomRegions = reaMessager.createInput(REAModuleAPI.CustomRegionsClear, (Object)false);
        this.concaveHullFactoryParameters = reaMessager.createInput(REAModuleAPI.PlanarRegionsConcaveHullParameters, (Object)new ConcaveHullFactoryParameters());
        this.polygonizerParameters = reaMessager.createInput(REAModuleAPI.PlanarRegionsPolygonizerParameters, (Object)new PolygonizerParameters());
        this.intersectionEstimationParameters = reaMessager.createInput(REAModuleAPI.PlanarRegionsIntersectionParameters, (Object)new IntersectionEstimationParameters());
        this.segmentationRawDataFilteringParameters = messager.createInput(LidarImageFusionAPI.SegmentationRawDataFilteringParameters, (Object)new SegmentationRawDataFilteringParameters());
        this.planarRegionPropagationParameters = messager.createInput(LidarImageFusionAPI.PlanarRegionPropagationParameters, (Object)new PlanarRegionPropagationParameters());
        this.customRegionMergingParameters = reaMessager.createInput(REAModuleAPI.CustomRegionsMergingParameters, (Object)new CustomRegionMergeParameters());
    }

    public void updateLatestLidarImageFusionData(LidarImageFusionData lidarImageFusionData) {
        this.planarRegionSegmentationCalculator.updateFusionData(lidarImageFusionData, this.segmentationRawDataFilteringParameters.get(), this.planarRegionPropagationParameters.get());
        this.planarRegionSegmentationCalculator.initialize();
    }

    public void clear() {
        this.planarRegionsList = null;
    }

    public boolean update() {
        boolean calculationIsDone = this.planarRegionSegmentationCalculator.calculate();
        if (calculationIsDone) {
            List<PlanarRegionSegmentationRawData> rawData = this.planarRegionSegmentationCalculator.getSegmentationRawData();
            this.updateIntersections(rawData);
            this.mergeCustomPlanarRegions(rawData);
            this.updatePolygons(rawData);
            return true;
        }
        return false;
    }

    private void mergeCustomPlanarRegions(List<PlanarRegionSegmentationRawData> rawData) {
        List<Object> unmergedCustomPlanarRegions = Collections.emptyList();
        if (this.clearCustomRegions.getAndSet(false).booleanValue()) {
            this.customPlanarRegions.clear();
            unmergedCustomPlanarRegions = Collections.emptyList();
        } else {
            unmergedCustomPlanarRegions = this.enableCustomRegions.get() != false ? CustomPlanarRegionHandler.mergeCustomRegionsToEstimatedRegions(this.customPlanarRegions.valueCollection(), rawData, this.customRegionMergingParameters.get()) : Collections.emptyList();
        }
        if (this.planarRegionsList != null) {
            unmergedCustomPlanarRegions.forEach(arg_0 -> ((PlanarRegionsList)this.planarRegionsList).addPlanarRegion(arg_0));
        }
    }

    private void updatePolygons(List<PlanarRegionSegmentationRawData> rawData) {
        ConcaveHullFactoryParameters concaveHullFactoryParameters = this.concaveHullFactoryParameters.get();
        PolygonizerParameters polygonizerParameters = this.polygonizerParameters.get();
        this.planarRegionsList = PlanarRegionPolygonizer.createPlanarRegionsList(rawData, concaveHullFactoryParameters, polygonizerParameters);
    }

    private void updateIntersections(List<PlanarRegionSegmentationRawData> rawData) {
        this.planarRegionsIntersections = PlanarRegionIntersectionCalculator.computeIntersections(rawData, this.intersectionEstimationParameters.get());
    }

    public void registerCustomPlanarRegion(PlanarRegion planarRegion) {
        if (planarRegion.getRegionId() == -1) {
            return;
        }
        if (planarRegion.isEmpty()) {
            this.customPlanarRegions.remove(planarRegion.getRegionId());
        } else {
            CustomPlanarRegionHandler.performConvexDecompositionIfNeeded(planarRegion);
            this.customPlanarRegions.put(planarRegion.getRegionId(), (Object)planarRegion);
        }
    }

    @Override
    public List<PlanarRegionSegmentationNodeData> getSegmentationNodeData() {
        return null;
    }

    @Override
    public PlanarRegionsList getPlanarRegionsList() {
        return this.planarRegionsList;
    }

    @Override
    public int getNumberOfPlaneIntersections() {
        return this.planarRegionsIntersections == null ? 0 : this.planarRegionsIntersections.size();
    }

    @Override
    public LineSegment3D getIntersection(int index) {
        return this.planarRegionsIntersections.get(index);
    }
}

