/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.data;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.fusion.data.SegmentationRawData;
import us.ihmc.robotics.linearAlgebra.PrincipalComponentAnalysis3D;

public class SegmentationNodeData {
    private static final boolean USE_PCA_TO_UPDATE = true;
    private int id = -1;
    private final TIntArrayList labels = new TIntArrayList();
    private final List<Point3D> labelCenters = new ArrayList<Point3D>();
    private final List<Vector3D> labelNormals = new ArrayList<Vector3D>();
    private final Vector3D normal = new Vector3D();
    private final Point3D center = new Point3D();
    private double weight = 0.0;
    private final List<Point3D> pointsInSegment = new ArrayList<Point3D>();
    private final PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();

    public SegmentationNodeData(SegmentationRawData seedImageSegment) {
        this.id = seedImageSegment.getId();
        this.labels.add(seedImageSegment.getImageSegmentLabel());
        this.labelCenters.add(seedImageSegment.getCenter());
        this.labelNormals.add(seedImageSegment.getNormal());
        this.normal.set(seedImageSegment.getNormal());
        this.center.set(seedImageSegment.getCenter());
        this.pointsInSegment.addAll(seedImageSegment.getPoints());
    }

    public void merge(SegmentationRawData fusionDataSegment) {
        this.labels.add(fusionDataSegment.getImageSegmentLabel());
        this.labelCenters.add(fusionDataSegment.getCenter());
        this.labelNormals.add(fusionDataSegment.getNormal());
        this.pointsInSegment.addAll(fusionDataSegment.getPoints());
        fusionDataSegment.getPoints().stream().forEach(point -> this.pca.addPoint(point.getX(), point.getY(), point.getZ()));
        this.pca.compute();
        this.pca.getMean(this.center);
        this.pca.getThirdVector(this.normal);
        if (this.normal.getZ() < 0.0) {
            this.normal.negate();
        }
    }

    public void extend(SegmentationRawData fusionDataSegment, double threshold, boolean updateNodeData, double extendingThreshold) {
        block0: for (Point3D point2 : fusionDataSegment.getPoints()) {
            double distance = SegmentationNodeData.distancePlaneToPoint(this.normal, this.center, point2);
            if (!(distance < threshold)) continue;
            for (Point3D pointInSegment : this.pointsInSegment) {
                if (!(pointInSegment.distance((Point3DReadOnly)point2) < extendingThreshold)) continue;
                this.pointsInSegment.add(point2);
                continue block0;
            }
        }
        if (updateNodeData) {
            PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
            pca.clear();
            this.pointsInSegment.stream().forEach(point -> pca.addPoint(point.getX(), point.getY(), point.getZ()));
            pca.compute();
            pca.getMean(this.center);
            pca.getThirdVector(this.normal);
            if (this.normal.getZ() < 0.0) {
                this.normal.negate();
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public TIntArrayList getLabels() {
        return this.labels;
    }

    public Vector3D getNormal() {
        return this.normal;
    }

    public Point3D getCenter() {
        return this.center;
    }

    public List<Point3D> getPointsInSegment() {
        return this.pointsInSegment;
    }

    public boolean isCoplanar(SegmentationRawData fusionDataSegment, double threshold, boolean isBigSegment) {
        Point3D nodeDataCenter = new Point3D((Tuple3DReadOnly)this.center);
        Vector3D nodeDataNormal = new Vector3D((Tuple3DReadOnly)this.normal);
        if (isBigSegment) {
            double min = Double.POSITIVE_INFINITY;
            double cur = 0.0;
            int closestLabel = -1;
            for (int i = 0; i < this.labelCenters.size(); ++i) {
                Point3D labelCenter = this.labelCenters.get(i);
                cur = labelCenter.distance((Point3DReadOnly)fusionDataSegment.getCenter());
                if (!(cur < min)) continue;
                min = cur;
                closestLabel = i;
            }
            nodeDataCenter.set(this.labelCenters.get(closestLabel));
            nodeDataNormal.set(this.labelNormals.get(closestLabel));
        }
        double distanceFromSegment = SegmentationNodeData.distancePlaneToPoint(fusionDataSegment.getNormal(), fusionDataSegment.getCenter(), nodeDataCenter);
        double distanceToSegment = SegmentationNodeData.distancePlaneToPoint(nodeDataNormal, nodeDataCenter, fusionDataSegment.getCenter());
        return Math.abs(distanceFromSegment) < threshold && Math.abs(distanceToSegment) < threshold;
    }

    public boolean isParallel(SegmentationRawData fusionDataSegment, double threshold) {
        return Math.abs(fusionDataSegment.getNormal().dot((Vector3DReadOnly)this.normal)) > threshold;
    }

    public static double distancePlaneToPoint(Vector3D normalVector, Point3D center, Point3D point) {
        Vector3D centerVector = new Vector3D((Tuple3DReadOnly)center);
        double constantD = -normalVector.dot((Vector3DReadOnly)centerVector);
        if (normalVector.lengthSquared() == 0.0) {
            System.out.println("normalVector.lengthSquared() == 0");
        }
        Vector3D pointVector = new Vector3D((Tuple3DReadOnly)point);
        return Math.abs(normalVector.dot((Vector3DReadOnly)pointVector) + constantD) / Math.sqrt(normalVector.lengthSquared());
    }
}

