/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.data;

import boofcv.struct.calib.CameraPinholeBrown;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.StereoPointCloudCompression;
import us.ihmc.robotEnvironmentAwareness.fusion.MultisenseInformation;
import us.ihmc.robotEnvironmentAwareness.fusion.data.LidarImageFusionData;
import us.ihmc.robotEnvironmentAwareness.fusion.parameters.ImageSegmentationParameters;
import us.ihmc.robotEnvironmentAwareness.fusion.parameters.SegmentationRawDataFilteringParameters;
import us.ihmc.robotEnvironmentAwareness.fusion.tools.LidarImageFusionDataFactory;

public class LidarImageFusionDataBuffer {
    private final LidarImageFusionDataFactory lidarImageFusionDataFactory = new LidarImageFusionDataFactory();
    private final AtomicReference<StereoVisionPointCloudMessage> latestStereoVisionPointCloudMessage = new AtomicReference<Object>(null);
    private final AtomicReference<BufferedImage> latestBufferedImage = new AtomicReference<Object>(null);
    private final AtomicReference<Point3D> latestCameraPosition;
    private final AtomicReference<Quaternion> latestCameraOrientation;
    private final AtomicReference<CameraPinholeBrown> latestCameraIntrinsicParameters;
    private final AtomicReference<Integer> bufferSize;
    private final AtomicReference<SegmentationRawDataFilteringParameters> latestSegmentationRawDataFilteringParameters;
    private final AtomicReference<ImageSegmentationParameters> latestImageSegmentationParaeters;
    private final AtomicReference<LidarImageFusionData> newBuffer = new AtomicReference<Object>(null);

    public LidarImageFusionDataBuffer(Messager messager, CameraPinholeBrown intrinsic) {
        this.bufferSize = messager.createInput(LidarImageFusionAPI.StereoBufferSize, (Object)50000);
        this.latestImageSegmentationParaeters = messager.createInput(LidarImageFusionAPI.ImageSegmentationParameters, (Object)new ImageSegmentationParameters());
        this.latestSegmentationRawDataFilteringParameters = messager.createInput(LidarImageFusionAPI.SegmentationRawDataFilteringParameters, (Object)new SegmentationRawDataFilteringParameters());
        this.latestCameraPosition = messager.createInput(LidarImageFusionAPI.CameraPositionState, (Object)new Point3D());
        this.latestCameraOrientation = messager.createInput(LidarImageFusionAPI.CameraOrientationState, (Object)new Quaternion());
        this.latestCameraIntrinsicParameters = messager.createInput(LidarImageFusionAPI.CameraIntrinsicParametersState, (Object)MultisenseInformation.CART.getIntrinsicParameters());
    }

    public LidarImageFusionData pollNewBuffer() {
        return this.newBuffer.getAndSet(null);
    }

    public void updateNewBuffer() {
        int numberOfPoints;
        StereoVisionPointCloudMessage pointCloudMessage = this.latestStereoVisionPointCloudMessage.get();
        Point3D[] pointCloudBuffer = StereoPointCloudCompression.decompressPointCloudToArray(pointCloudMessage);
        int[] colorBuffer = StereoPointCloudCompression.decompressColorsToIntArray(pointCloudMessage);
        Random random = new Random();
        for (numberOfPoints = pointCloudBuffer.length; numberOfPoints > this.bufferSize.get(); --numberOfPoints) {
            int indexToRemove = random.nextInt(numberOfPoints);
            int lastIndex = numberOfPoints - 1;
            pointCloudBuffer[indexToRemove] = pointCloudBuffer[lastIndex];
            colorBuffer[indexToRemove] = colorBuffer[lastIndex];
        }
        Point3D[] pointCloud = new Point3D[numberOfPoints];
        int[] colors = new int[numberOfPoints];
        for (int i = 0; i < numberOfPoints; ++i) {
            pointCloud[i] = pointCloudBuffer[i];
            colors[i] = colorBuffer[i];
        }
        this.lidarImageFusionDataFactory.setIntrinsicParameters(this.latestCameraIntrinsicParameters.get());
        this.lidarImageFusionDataFactory.setImageSegmentationParameters(this.latestImageSegmentationParaeters.get());
        this.lidarImageFusionDataFactory.setSegmentationRawDataFilteringParameters(this.latestSegmentationRawDataFilteringParameters.get());
        this.lidarImageFusionDataFactory.setCameraPose(this.latestCameraPosition.get(), this.latestCameraOrientation.get());
        LidarImageFusionData data = this.lidarImageFusionDataFactory.createLidarImageFusionData(pointCloud, colors, this.latestBufferedImage.get());
        this.newBuffer.set(data);
    }

    public void updateLatestStereoVisionPointCloudMessage(StereoVisionPointCloudMessage message) {
        this.latestStereoVisionPointCloudMessage.set(message);
    }

    public void updateLatestBufferedImage(BufferedImage bufferedImage) {
        this.latestBufferedImage.set(bufferedImage);
    }
}

