/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion;

import java.io.File;
import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.messager.SharedMemoryJavaFXMessager;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.robotEnvironmentAwareness.communication.KryoMessager;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.fusion.FusionSensorImageViewer;
import us.ihmc.robotEnvironmentAwareness.fusion.FusionSensorMeshViewer;
import us.ihmc.robotEnvironmentAwareness.fusion.controller.ImageProcessingAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.fusion.controller.ObjectDetectionAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.fusion.controller.StereoREAAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.DataImporterAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.PointCloudAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionDataExporter;
import us.ihmc.ros2.ROS2Node;

public class LidarImageFusionProcessorUI {
    private final SharedMemoryJavaFXMessager messager;
    private final BorderPane mainPane;
    private final Stage primaryStage;
    private final FusionSensorMeshViewer meshViewer;
    private final FusionSensorImageViewer imageViewer;
    public static final int imageStreamingImageFixedWidth = 512;
    private static final String UI_CONFIGURATION_FILE_NAME = "./Configurations/defaultREAUIConfiguration.txt";
    @FXML
    private PointCloudAnchorPaneController pointCloudAnchorPaneController;
    @FXML
    private ImageProcessingAnchorPaneController imageProcessingAnchorPaneController;
    @FXML
    private ObjectDetectionAnchorPaneController objectDetectionAnchorPaneController;
    @FXML
    private StereoREAAnchorPaneController stereoREAAnchorPaneController;
    @FXML
    private DataImporterAnchorPaneController dataImporterAnchorPaneController;

    private LidarImageFusionProcessorUI(ROS2Node ros2Node, SharedMemoryJavaFXMessager messager, REAUIMessager reaMessager, Stage primaryStage) throws Exception {
        this.messager = messager;
        this.primaryStage = primaryStage;
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        this.mainPane = (BorderPane)loader.load();
        this.initializeControllers(reaMessager, primaryStage);
        View3DFactory view3dFactory = View3DFactory.createSubscene();
        view3dFactory.addCameraController(true);
        view3dFactory.addWorldCoordinateSystem(0.05);
        VBox imageViewPane = new VBox();
        this.mainPane.setRight((Node)imageViewPane);
        this.mainPane.setCenter((Node)view3dFactory.getSubSceneWrappedInsidePane());
        this.meshViewer = new FusionSensorMeshViewer(ros2Node, messager, reaMessager);
        this.imageViewer = new FusionSensorImageViewer(messager, (Pane)imageViewPane);
        view3dFactory.addNodeToView(this.meshViewer.getRoot());
        primaryStage.setTitle(this.getClass().getSimpleName());
        primaryStage.setMaximized(true);
        Scene mainScene = new Scene((Parent)this.mainPane, 600.0, 400.0);
        primaryStage.setScene(mainScene);
        primaryStage.setOnCloseRequest(event -> this.stop());
    }

    public static LidarImageFusionProcessorUI creatIntraprocessUI(ROS2Node ros2Node, SharedMemoryJavaFXMessager messager, Stage primaryStage) throws Exception {
        KryoMessager moduleMessager = KryoMessager.createIntraprocess(REAModuleAPI.API, NetworkPorts.REA_MODULE_UI_PORT, REACommunicationProperties.getPrivateNetClassList());
        REAUIMessager reaMessager = new REAUIMessager(moduleMessager);
        reaMessager.startMessager();
        new PlanarRegionDataExporter(reaMessager);
        return new LidarImageFusionProcessorUI(ros2Node, messager, reaMessager, primaryStage);
    }

    public void show() {
        this.primaryStage.show();
        this.imageViewer.start();
    }

    public void stop() {
        try {
            this.messager.closeMessager();
            this.meshViewer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeControllers(REAUIMessager reaMessager, Stage primaryStage) {
        File configurationFile = new File(UI_CONFIGURATION_FILE_NAME);
        try {
            configurationFile.getParentFile().mkdirs();
            configurationFile.createNewFile();
        }
        catch (IOException e) {
            System.out.println(configurationFile.getAbsolutePath());
            e.printStackTrace();
        }
        this.pointCloudAnchorPaneController.setConfigurationFile(configurationFile);
        this.pointCloudAnchorPaneController.attachREAMessager(reaMessager);
        this.pointCloudAnchorPaneController.bindControls();
        this.imageProcessingAnchorPaneController.initialize((JavaFXMessager)this.messager);
        this.objectDetectionAnchorPaneController.initialize(this.messager);
        this.stereoREAAnchorPaneController.initialize((JavaFXMessager)this.messager);
        this.dataImporterAnchorPaneController.initialize(reaMessager, this.messager, (Window)primaryStage);
    }
}

