/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.communication.packets;

import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Quaternion32;

public class BoxMessage
extends Packet<BoxMessage> {
    public boolean isEmpty;
    public Vector3D32 size;
    public Point3D32 center;
    public Quaternion32 orientation;

    public static BoxMessage emptyBox() {
        BoxMessage empty = new BoxMessage();
        empty.isEmpty = true;
        empty.size = null;
        empty.center = null;
        empty.orientation = null;
        return empty;
    }

    public void set(BoxMessage other) {
        this.setPacketInformation(other);
        this.isEmpty = other.isEmpty;
        this.size = new Vector3D32((Tuple3DReadOnly)other.size);
        this.center = new Point3D32((Tuple3DReadOnly)this.center);
        this.orientation = new Quaternion32((Orientation3DReadOnly)other.orientation);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setSize(Vector3D size) {
        this.isEmpty = false;
        this.size = new Vector3D32((Tuple3DReadOnly)size);
    }

    public void setSize(Vector3D32 size) {
        this.isEmpty = false;
        this.size = size;
    }

    public void setCenter(Point3D center) {
        this.isEmpty = false;
        this.center = new Point3D32((Tuple3DReadOnly)center);
    }

    public void setCenter(Point3D32 center) {
        this.isEmpty = false;
        this.center = center;
    }

    public void setOrientation(Quaternion orientation) {
        this.isEmpty = false;
        this.orientation = new Quaternion32((Orientation3DReadOnly)orientation);
    }

    public void setOrientation(Quaternion32 orientation) {
        this.isEmpty = false;
        this.orientation = orientation;
    }

    public Vector3D32 getSize() {
        return this.size;
    }

    public Point3D32 getCenter() {
        return this.center;
    }

    public Quaternion32 getOrientation() {
        return this.orientation;
    }

    public boolean epsilonEquals(BoxMessage other, double epsilon) {
        if (!this.size.epsilonEquals(other.size, (double)((float)epsilon))) {
            return false;
        }
        if (!this.center.epsilonEquals(other.center, (double)((float)epsilon))) {
            return false;
        }
        return this.orientation.epsilonEquals(other.orientation, (double)((float)epsilon));
    }
}

