/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.communication.converters;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import gnu.trove.list.array.TByteArrayList;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.IntConsumer;
import net.jpountz.lz4.LZ4Exception;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.jOctoMap.key.OcTreeKey;
import us.ihmc.jOctoMap.key.OcTreeKeyReadOnly;
import us.ihmc.jOctoMap.tools.OcTreeKeyConversionTools;
import us.ihmc.jOctoMap.tools.OcTreeKeyTools;
import us.ihmc.robotEnvironmentAwareness.communication.converters.ScanPointFilter;
import us.ihmc.tools.compression.LZ4CompressionImplementation;

public class StereoPointCloudCompression {
    private static final int OCTREE_DEPTH = 16;
    private static final double OCTREE_RESOLUTION_TO_SIZE_RATIO = Math.pow(2.0, 16.0) - 1.0;
    private static final ThreadLocal<LZ4CompressionImplementation> compressorThreadLocal = ThreadLocal.withInitial(LZ4CompressionImplementation::new);

    public static StereoVisionPointCloudMessage compressPointCloud(long timestamp, Point3DReadOnly[] pointCloud, int[] colors, int numberOfPoints, double minimumResolution, ScanPointFilter filter) {
        int i;
        int compressedColorSize;
        int compressedPointCloudSize;
        BoundingBox3D boundingBox = new BoundingBox3D();
        boundingBox.setToNaN();
        if (filter != null) {
            int filteredIndex = 0;
            Point3D[] filteredPointCloud = new Point3D[numberOfPoints];
            int[] filteredColors = new int[numberOfPoints];
            for (int i2 = 0; i2 < numberOfPoints; ++i2) {
                Point3DReadOnly scanPoint = pointCloud[i2];
                int color = colors[i2];
                if (!filter.test(i2, scanPoint)) continue;
                filteredPointCloud[filteredIndex] = scanPoint;
                filteredColors[filteredIndex] = color;
                boundingBox.updateToIncludePoint(scanPoint);
                ++filteredIndex;
            }
            numberOfPoints = filteredIndex;
            pointCloud = filteredPointCloud;
            colors = filteredColors;
        } else {
            for (Point3DReadOnly scanPoint : pointCloud) {
                boundingBox.updateToIncludePoint(scanPoint);
            }
        }
        double sizeX = boundingBox.getMaxX() - boundingBox.getMinX();
        double sizeY = boundingBox.getMaxY() - boundingBox.getMinY();
        double sizeZ = boundingBox.getMaxZ() - boundingBox.getMinZ();
        double centerX = 0.5 * (boundingBox.getMaxX() + boundingBox.getMinX());
        double centerY = 0.5 * (boundingBox.getMaxY() + boundingBox.getMinY());
        double centerZ = 0.5 * (boundingBox.getMaxZ() + boundingBox.getMinZ());
        double octreeSize = EuclidCoreTools.max((double)sizeX, (double)sizeY, (double)sizeZ);
        double octreeResolution = Math.max(minimumResolution, octreeSize / OCTREE_RESOLUTION_TO_SIZE_RATIO);
        int octreeIndex = 0;
        OcTreeKey[] octreeKeys = new OcTreeKey[numberOfPoints];
        int[] octreeColors = new int[numberOfPoints];
        CompressionOctreeNode rootNode = new CompressionOctreeNode(0);
        for (int i3 = 0; i3 < numberOfPoints; ++i3) {
            double z;
            double y;
            Point3DReadOnly scanPoint = pointCloud[i3];
            int color = colors[i3];
            double x = scanPoint.getX() - centerX;
            OcTreeKey key = OcTreeKeyConversionTools.coordinateToKey((double)x, (double)(y = scanPoint.getY() - centerY), (double)(z = scanPoint.getZ() - centerZ), (double)octreeResolution, (int)16);
            if (!rootNode.insertNode((OcTreeKeyReadOnly)key, 16)) continue;
            octreeKeys[octreeIndex] = key;
            octreeColors[octreeIndex] = color;
            ++octreeIndex;
        }
        numberOfPoints = octreeIndex;
        int pointCloudByteBufferSize = numberOfPoints * 3 * 4;
        int colorByteBufferSize = numberOfPoints * 4;
        ByteBuffer rawPointCloudByteBuffer = ByteBuffer.allocate(pointCloudByteBufferSize);
        ByteBuffer rawColorByteBuffer = ByteBuffer.allocate(colorByteBufferSize);
        IntBuffer rawPointCloudIntBuffer = rawPointCloudByteBuffer.asIntBuffer();
        IntBuffer rawColorIntBuffer = rawColorByteBuffer.asIntBuffer();
        for (int i4 = 0; i4 < numberOfPoints; ++i4) {
            OcTreeKey key = octreeKeys[i4];
            int color = octreeColors[i4];
            rawPointCloudIntBuffer.put(3 * i4, key.getKey(0));
            rawPointCloudIntBuffer.put(3 * i4 + 1, key.getKey(1));
            rawPointCloudIntBuffer.put(3 * i4 + 2, key.getKey(2));
            rawColorIntBuffer.put(i4, color);
        }
        ByteBuffer compressedPointCloudByteBuffer = ByteBuffer.allocate(pointCloudByteBufferSize);
        ByteBuffer compressedColorByteBuffer = ByteBuffer.allocate(colorByteBufferSize);
        LZ4CompressionImplementation compressor = compressorThreadLocal.get();
        try {
            compressedPointCloudSize = compressor.compress(rawPointCloudByteBuffer, compressedPointCloudByteBuffer);
        }
        catch (LZ4Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            compressedColorSize = compressor.compress(rawColorByteBuffer, compressedColorByteBuffer);
        }
        catch (LZ4Exception e) {
            e.printStackTrace();
            return null;
        }
        StereoVisionPointCloudMessage message = new StereoVisionPointCloudMessage();
        message.setTimestamp(timestamp);
        message.setSensorPoseConfidence(1.0);
        boundingBox.getCenterPoint((Point3DBasics)message.getPointCloudCenter());
        message.setResolution(octreeResolution);
        compressedPointCloudByteBuffer.flip();
        for (i = 0; i < compressedPointCloudSize; ++i) {
            message.getPointCloud().add(compressedPointCloudByteBuffer.get());
        }
        compressedColorByteBuffer.flip();
        for (i = 0; i < compressedColorSize; ++i) {
            message.getColors().add(compressedColorByteBuffer.get());
        }
        message.setNumberOfPoints(numberOfPoints);
        return message;
    }

    public static Point3D32[] decompressPointCloudToArray32(StereoVisionPointCloudMessage message) {
        return StereoPointCloudCompression.decompressPointCloudToArray32((TByteArrayList)message.getPointCloud(), message.getPointCloudCenter(), message.getResolution(), message.getNumberOfPoints());
    }

    public static Point3D32[] decompressPointCloudToArray32(TByteArrayList compressedPointCloud, Point3D center, double resolution, int numberOfPoints) {
        final Point3D32[] pointCloud = new Point3D32[numberOfPoints];
        StereoPointCloudCompression.decompressPointCloud(compressedPointCloud, center, resolution, numberOfPoints, new PointCoordinateConsumer(){
            int index = 0;

            @Override
            public void accept(double x, double y, double z) {
                pointCloud[this.index] = new Point3D32((float)x, (float)y, (float)z);
                ++this.index;
            }
        });
        return pointCloud;
    }

    public static Point3D[] decompressPointCloudToArray(StereoVisionPointCloudMessage message) {
        return StereoPointCloudCompression.decompressPointCloudToArray((TByteArrayList)message.getPointCloud(), message.getPointCloudCenter(), message.getResolution(), message.getNumberOfPoints());
    }

    public static Point3D[] decompressPointCloudToArray(TByteArrayList compressedPointCloud, Point3D center, double resolution, int numberOfPoints) {
        final Point3D[] pointCloud = new Point3D[numberOfPoints];
        StereoPointCloudCompression.decompressPointCloud(compressedPointCloud, center, resolution, numberOfPoints, new PointCoordinateConsumer(){
            int index = 0;

            @Override
            public void accept(double x, double y, double z) {
                pointCloud[this.index] = new Point3D((double)((float)x), (double)((float)y), (double)((float)z));
                ++this.index;
            }
        });
        return pointCloud;
    }

    public static void decompressPointCloud(StereoVisionPointCloudMessage message, PointCoordinateConsumer pointCoordinateConsumer) {
        StereoPointCloudCompression.decompressPointCloud((TByteArrayList)message.getPointCloud(), message.getPointCloudCenter(), message.getResolution(), message.getNumberOfPoints(), pointCoordinateConsumer);
    }

    public static void decompressPointCloud(TByteArrayList compressedPointCloud, Point3D center, double resolution, int numberOfPoints, PointCoordinateConsumer pointCoordinateConsumer) {
        ByteBuffer compressedPointCloudByteBuffer = ByteBuffer.wrap(compressedPointCloud.toArray());
        ByteBuffer decompressedPointCloudByteBuffer = ByteBuffer.allocate(numberOfPoints * 3 * 4);
        compressorThreadLocal.get().decompress(compressedPointCloudByteBuffer, decompressedPointCloudByteBuffer, numberOfPoints * 3 * 4);
        decompressedPointCloudByteBuffer.flip();
        IntBuffer pointCloudIntBuffer = decompressedPointCloudByteBuffer.asIntBuffer();
        for (int i = 0; i < numberOfPoints; ++i) {
            double x = OcTreeKeyConversionTools.keyToCoordinate((int)pointCloudIntBuffer.get(), (double)resolution, (int)16);
            double y = OcTreeKeyConversionTools.keyToCoordinate((int)pointCloudIntBuffer.get(), (double)resolution, (int)16);
            double z = OcTreeKeyConversionTools.keyToCoordinate((int)pointCloudIntBuffer.get(), (double)resolution, (int)16);
            pointCoordinateConsumer.accept(x + center.getX(), y + center.getY(), z + center.getZ());
        }
    }

    public static Color[] decompressColorsToAWTColorArray(StereoVisionPointCloudMessage message) {
        return StereoPointCloudCompression.decompressColorsToAWTColorArray((TByteArrayList)message.getColors(), message.getNumberOfPoints());
    }

    public static Color[] decompressColorsToAWTColorArray(TByteArrayList compressedColors, int numberOfPoints) {
        final Color[] colors = new Color[numberOfPoints];
        StereoPointCloudCompression.decompressColors(compressedColors, numberOfPoints, new IntConsumer(){
            int index = 0;

            @Override
            public void accept(int value) {
                colors[this.index] = new Color(value);
                ++this.index;
            }
        });
        return colors;
    }

    public static int[] decompressColorsToIntArray(StereoVisionPointCloudMessage message) {
        return StereoPointCloudCompression.decompressColorsToIntArray((TByteArrayList)message.getColors(), message.getNumberOfPoints());
    }

    public static int[] decompressColorsToIntArray(TByteArrayList compressedColors, int numberOfPoints) {
        final int[] colors = new int[numberOfPoints];
        StereoPointCloudCompression.decompressColors(compressedColors, numberOfPoints, new IntConsumer(){
            int index = 0;

            @Override
            public void accept(int value) {
                colors[this.index] = value;
                ++this.index;
            }
        });
        return colors;
    }

    public static void decompressColors(StereoVisionPointCloudMessage message, IntConsumer colorConsumer) {
        StereoPointCloudCompression.decompressColors((TByteArrayList)message.getColors(), message.getNumberOfPoints(), colorConsumer);
    }

    public static void decompressColors(TByteArrayList compressedColors, int numberOfPoints, IntConsumer colorConsumer) {
        ByteBuffer compressedColorByteBuffer = ByteBuffer.wrap(compressedColors.toArray());
        ByteBuffer decompressedColorByteBuffer = ByteBuffer.allocate(numberOfPoints * 4);
        compressorThreadLocal.get().decompress(compressedColorByteBuffer, decompressedColorByteBuffer, numberOfPoints * 4);
        decompressedColorByteBuffer.flip();
        IntBuffer colorIntBuffer = decompressedColorByteBuffer.asIntBuffer();
        for (int i = 0; i < numberOfPoints; ++i) {
            colorConsumer.accept(colorIntBuffer.get());
        }
    }

    private static class CompressionOctreeNode {
        private final int depth;
        private CompressionOctreeNode[] children;

        public CompressionOctreeNode(int depth) {
            this.depth = depth;
        }

        public boolean insertNode(OcTreeKeyReadOnly key, int treeDepth) {
            boolean childCreated;
            int childIndex = OcTreeKeyTools.computeChildIndex((OcTreeKeyReadOnly)key, (int)this.depth, (int)treeDepth);
            CompressionOctreeNode child = this.getChild(childIndex);
            boolean bl = childCreated = child == null;
            if (childCreated) {
                child = this.createChild(childIndex);
            }
            if (this.depth == treeDepth - 2) {
                return childCreated;
            }
            return child.insertNode(key, treeDepth);
        }

        public CompressionOctreeNode getChild(int childIndex) {
            if (this.children == null) {
                return null;
            }
            return this.children[childIndex];
        }

        public CompressionOctreeNode createChild(int childIndex) {
            CompressionOctreeNode newChild;
            if (this.children == null) {
                this.children = new CompressionOctreeNode[8];
            }
            this.children[childIndex] = newChild = new CompressionOctreeNode(this.depth + 1);
            return newChild;
        }
    }

    public static interface PointCoordinateConsumer {
        public void accept(double var1, double var3, double var5);
    }
}

