/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.communication.converters;

import controller_msgs.msg.dds.LidarScanMessage;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.buffer.ChannelBuffer;
import sensor_msgs.PointCloud2;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.LidarPointCloudCompression;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.subscriber.RosPointCloudSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class PointCloud2ToLidarScanMessageConverter {
    private static final String POINT_CLOUD_2_TOPIC_NAME = "/camera/depth/color/points";
    private static final double SENSOR_POSE_X = 0.0;
    private static final double SENSOR_POSE_Y = 0.0;
    private static final double SENSOR_POSE_Z = 1.0;
    private static final double SENSOR_POSE_YAW = 0.0;
    private static final double SENSOR_POSE_PITCH = 0.0;
    private static final double SENSOR_POSE_ROLL = -2.35;
    private final AtomicReference<PointCloud2> pointCloud2Message = new AtomicReference();
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicBoolean firstMessage = new AtomicBoolean(true);

    public PointCloud2ToLidarScanMessageConverter(String topicName, double poseX, double poseY, double poseZ, double poseYaw, double posePitch, double poseRoll) throws URISyntaxException {
        URI rosMasterURI = new URI("http://localhost:11311");
        RosMainNode rosMainNode = new RosMainNode(rosMasterURI, this.getClass().getSimpleName());
        Pose3D sensorPose = new Pose3D(poseX, poseY, poseZ, poseYaw, posePitch, poseRoll);
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)this.getClass().getSimpleName());
        IHMCROS2Publisher lidarScanMessagePublisher = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, LidarScanMessage.class, (String)"/ihmc/lidar_scan");
        RosPointCloudSubscriber pointCloudSubscriber = new RosPointCloudSubscriber(){

            public void onNewMessage(PointCloud2 pointCloud) {
                PointCloud2ToLidarScanMessageConverter.this.pointCloud2Message.set(pointCloud);
            }
        };
        LidarScanMessage lidarScanMessage = new LidarScanMessage();
        lidarScanMessage.getLidarPosition().set(sensorPose.getPosition());
        lidarScanMessage.getLidarOrientation().set(sensorPose.getOrientation());
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().set(poseX, poseY, poseZ);
        transform.getRotation().setYawPitchRoll(poseYaw, posePitch, poseRoll);
        new Thread(() -> {
            while (true) {
                PointCloud2 pointCloud;
                if ((pointCloud = (PointCloud2)this.pointCloud2Message.getAndSet(null)) != null) {
                    if (this.firstMessage.getAndSet(false)) {
                        LogTools.info((String)"Receiving point cloud message...");
                    }
                    ByteOrder byteOrder = pointCloud.getIsBigendian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                    long pointStep = pointCloud.getPointStep();
                    int width = pointCloud.getWidth();
                    int height = pointCloud.getHeight();
                    int numberOfPoints = width * height;
                    float[] points = new float[3 * numberOfPoints];
                    byte[] bytes = new byte[4];
                    for (int i = 0; i < numberOfPoints; ++i) {
                        int startIndex = (int)pointStep * i;
                        PointCloud2ToLidarScanMessageConverter.packBytes(bytes, startIndex + 0, pointCloud.getData());
                        float x = ByteBuffer.wrap(bytes).order(byteOrder).getFloat();
                        PointCloud2ToLidarScanMessageConverter.packBytes(bytes, startIndex + 4, pointCloud.getData());
                        float y = ByteBuffer.wrap(bytes).order(byteOrder).getFloat();
                        PointCloud2ToLidarScanMessageConverter.packBytes(bytes, startIndex + 8, pointCloud.getData());
                        float z = ByteBuffer.wrap(bytes).order(byteOrder).getFloat();
                        Pose3D dataPoint = new Pose3D((double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                        dataPoint.applyTransform((Transform)transform);
                        points[3 * i + 0] = (float)dataPoint.getX();
                        points[3 * i + 1] = (float)dataPoint.getY();
                        points[3 * i + 2] = (float)dataPoint.getZ();
                    }
                    lidarScanMessage.setSequenceId((long)this.counter.getAndIncrement());
                    lidarScanMessage.getScan().clear();
                    LidarPointCloudCompression.compressPointCloud((int)numberOfPoints, (LidarScanMessage)lidarScanMessage, (index, element) -> points[3 * index + element]);
                    lidarScanMessagePublisher.publish((Object)lidarScanMessage);
                }
                ThreadTools.sleep((long)20L);
            }
        }).start();
        rosMainNode.attachSubscriber(topicName, (RosTopicSubscriberInterface)pointCloudSubscriber);
        rosMainNode.execute();
        pointCloudSubscriber.wailTillRegistered();
    }

    private static void packBytes(byte[] bytes, int startIndex, ChannelBuffer data) {
        for (int i = 0; i < 4; ++i) {
            bytes[i] = data.getByte(startIndex + i);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 7) {
                System.out.println("Using the default parameters");
                new PointCloud2ToLidarScanMessageConverter(POINT_CLOUD_2_TOPIC_NAME, 0.0, 0.0, 1.0, 0.0, 0.0, -2.35);
            } else {
                System.out.println("Loading parameters from program arguments");
                String topicName = args[0];
                double poseX = Double.parseDouble(args[1]);
                double poseY = Double.parseDouble(args[2]);
                double poseZ = Double.parseDouble(args[3]);
                double poseYaw = Double.parseDouble(args[4]);
                double posePitch = Double.parseDouble(args[5]);
                double poseRoll = Double.parseDouble(args[6]);
                new PointCloud2ToLidarScanMessageConverter(topicName, poseX, poseY, poseZ, poseYaw, posePitch, poseRoll);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

