/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.javaFXToolkit.messager.SharedMemoryJavaFXMessager;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.LiveMapModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.LiveMapUI;
import us.ihmc.robotEnvironmentAwareness.updaters.LiveMapModule;
import us.ihmc.ros2.ROS2Node;

public class LiveMapStandaloneLauncher
extends Application {
    private static final String MODULE_CONFIGURATION_FILE_NAME = "./Configurations/defaultLiveMapModuleConfiguration.txt";
    private Messager messager;
    private LiveMapUI ui;
    private LiveMapModule module;
    private ROS2Node ros2Node;
    private final boolean launchUI;
    private final DomainFactory.PubSubImplementation pubSubImplementation;

    public LiveMapStandaloneLauncher() {
        this(true, DomainFactory.PubSubImplementation.FAST_RTPS);
    }

    public LiveMapStandaloneLauncher(boolean launchUIs, DomainFactory.PubSubImplementation pubSubImplementation) {
        this.launchUI = launchUIs;
        this.pubSubImplementation = pubSubImplementation;
    }

    public void start(Stage primaryStage) throws Exception {
        this.messager = new SharedMemoryJavaFXMessager(LiveMapModuleAPI.API);
        this.messager.startMessager();
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)this.pubSubImplementation, (String)"REA_module");
        this.ui = this.launchUI ? LiveMapUI.createIntraprocessUI(this.messager, primaryStage) : null;
        this.module = LiveMapModule.createIntraprocess(this.ros2Node, this.messager, "atlas");
        if (this.launchUI) {
            this.ui.show();
        }
        this.module.start();
    }

    public void stop() throws Exception {
        if (this.ui != null) {
            this.ui.stop();
        }
        this.module.stop();
        this.ros2Node.destroy();
        this.messager.closeMessager();
        Platform.exit();
    }

    public static void main(String[] args) {
        LiveMapStandaloneLauncher.launch((String[])args);
    }
}

