/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrix;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.JointStateType;

public class MultiBodySystemTools {
    public static SpatialInertia computeSubtreeInertia(JointReadOnly joint) {
        return MultiBodySystemTools.computeSubtreeInertia(joint.getSuccessor());
    }

    public static double computeSubTreeMass(RigidBodyReadOnly rootBody) {
        SpatialInertiaReadOnly inertia = rootBody.getInertia();
        double ret = inertia == null ? 0.0 : inertia.getMass();
        for (int i = 0; i < rootBody.getChildrenJoints().size(); ++i) {
            ret += MultiBodySystemTools.computeSubTreeMass(rootBody.getChildrenJoints().get(i).getSuccessor());
        }
        return ret;
    }

    public static SpatialInertia computeSubtreeInertia(RigidBodyReadOnly rootBody) {
        MovingReferenceFrame bodyFixedFrame = rootBody.getBodyFixedFrame();
        SpatialInertia subtreeInertia = new SpatialInertia(bodyFixedFrame, bodyFixedFrame);
        SpatialInertia bodyInertia = new SpatialInertia();
        for (RigidBodyReadOnly rigidBodyReadOnly : rootBody.subtreeList()) {
            bodyInertia.setIncludingFrame(rigidBodyReadOnly.getInertia());
            bodyInertia.changeFrame(bodyFixedFrame);
            subtreeInertia.add(bodyInertia);
        }
        return subtreeInertia;
    }

    public static RigidBodyReadOnly getRootBody(RigidBodyReadOnly body) {
        RigidBodyReadOnly root = body;
        while (root.getParentJoint() != null) {
            root = root.getParentJoint().getPredecessor();
        }
        return root;
    }

    public static RigidBodyBasics getRootBody(RigidBodyBasics body) {
        RigidBodyBasics root = body;
        while (root.getParentJoint() != null) {
            root = root.getParentJoint().getPredecessor();
        }
        return root;
    }

    public static OneDoFJointBasics[] createOneDoFJointPath(RigidBodyBasics start, RigidBodyBasics end) {
        return (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])MultiBodySystemTools.createJointPath(start, end), OneDoFJointBasics.class);
    }

    public static JointBasics[] createJointPath(RigidBodyBasics start, RigidBodyBasics end) {
        ArrayList<JointBasics> jointPath = new ArrayList<JointBasics>();
        MultiBodySystemTools.collectJointPath(start, end, jointPath);
        return jointPath.toArray(new JointBasics[jointPath.size()]);
    }

    public static JointReadOnly[] createJointPath(RigidBodyReadOnly start, RigidBodyReadOnly end) {
        ArrayList<JointReadOnly> jointPath = new ArrayList<JointReadOnly>();
        MultiBodySystemTools.collectJointPath(start, end, jointPath);
        return jointPath.toArray(new JointReadOnly[jointPath.size()]);
    }

    public static RigidBodyReadOnly collectJointPath(RigidBodyReadOnly start, RigidBodyReadOnly end, List<JointReadOnly> jointPathToPack) {
        jointPathToPack.clear();
        RigidBodyReadOnly ancestor = MultiBodySystemTools.computeNearestCommonAncestor(start, end);
        RigidBodyReadOnly currentBody = start;
        while (currentBody != ancestor) {
            JointReadOnly parentJoint = currentBody.getParentJoint();
            jointPathToPack.add(parentJoint);
            currentBody = parentJoint.getPredecessor();
        }
        int distance = jointPathToPack.size();
        currentBody = end;
        while (currentBody != ancestor) {
            currentBody = currentBody.getParentJoint().getPredecessor();
            ++distance;
        }
        while (jointPathToPack.size() < distance) {
            jointPathToPack.add(null);
        }
        currentBody = end;
        int i = distance - 1;
        while (currentBody != ancestor) {
            JointReadOnly parentJoint = currentBody.getParentJoint();
            jointPathToPack.set(i, parentJoint);
            currentBody = parentJoint.getPredecessor();
            --i;
        }
        return ancestor;
    }

    public static RigidBodyBasics collectJointPath(RigidBodyBasics start, RigidBodyBasics end, List<JointBasics> jointPathToPack) {
        jointPathToPack.clear();
        RigidBodyBasics ancestor = MultiBodySystemTools.computeNearestCommonAncestor(start, end);
        RigidBodyBasics currentBody = start;
        while (currentBody != ancestor) {
            JointBasics parentJoint = currentBody.getParentJoint();
            jointPathToPack.add(parentJoint);
            currentBody = parentJoint.getPredecessor();
        }
        int distance = jointPathToPack.size();
        currentBody = end;
        while (currentBody != ancestor) {
            currentBody = currentBody.getParentJoint().getPredecessor();
            ++distance;
        }
        while (jointPathToPack.size() < distance) {
            jointPathToPack.add(null);
        }
        currentBody = end;
        int i = distance - 1;
        while (currentBody != ancestor) {
            JointBasics parentJoint = currentBody.getParentJoint();
            jointPathToPack.set(i, parentJoint);
            currentBody = parentJoint.getPredecessor();
            --i;
        }
        return ancestor;
    }

    public static RigidBodyReadOnly collectRigidBodyPath(RigidBodyReadOnly start, RigidBodyReadOnly end, List<RigidBodyReadOnly> rigidBodyPathToPack) {
        rigidBodyPathToPack.clear();
        if (start == end) {
            rigidBodyPathToPack.add(end);
            return end;
        }
        RigidBodyReadOnly ancestor = MultiBodySystemTools.computeNearestCommonAncestor(start, end);
        RigidBodyReadOnly currentBody = start;
        if (start == ancestor) {
            rigidBodyPathToPack.add(start);
        }
        while (currentBody != ancestor) {
            rigidBodyPathToPack.add(currentBody);
            currentBody = currentBody.getParentJoint().getPredecessor();
        }
        int distance = rigidBodyPathToPack.size();
        currentBody = end;
        while (currentBody != ancestor) {
            currentBody = currentBody.getParentJoint().getPredecessor();
            ++distance;
        }
        while (rigidBodyPathToPack.size() < distance) {
            rigidBodyPathToPack.add(null);
        }
        currentBody = end;
        if (end == ancestor) {
            rigidBodyPathToPack.add(end);
        }
        int i = distance - 1;
        while (currentBody != ancestor) {
            rigidBodyPathToPack.set(i, currentBody);
            currentBody = currentBody.getParentJoint().getPredecessor();
            --i;
        }
        return ancestor;
    }

    public static RigidBodyBasics collectRigidBodyPath(RigidBodyBasics start, RigidBodyBasics end, List<RigidBodyBasics> rigidBodyPathToPack) {
        rigidBodyPathToPack.clear();
        if (start == end) {
            rigidBodyPathToPack.add(end);
            return end;
        }
        RigidBodyBasics ancestor = MultiBodySystemTools.computeNearestCommonAncestor(start, end);
        RigidBodyBasics currentBody = start;
        if (start == ancestor) {
            rigidBodyPathToPack.add(start);
        }
        while (currentBody != ancestor) {
            rigidBodyPathToPack.add(currentBody);
            currentBody = currentBody.getParentJoint().getPredecessor();
        }
        int distance = rigidBodyPathToPack.size();
        currentBody = end;
        while (currentBody != ancestor) {
            currentBody = currentBody.getParentJoint().getPredecessor();
            ++distance;
        }
        while (rigidBodyPathToPack.size() < distance) {
            rigidBodyPathToPack.add(null);
        }
        currentBody = end;
        if (end == ancestor) {
            rigidBodyPathToPack.add(end);
        }
        int i = distance - 1;
        while (currentBody != ancestor) {
            rigidBodyPathToPack.set(i, currentBody);
            currentBody = currentBody.getParentJoint().getPredecessor();
            --i;
        }
        return ancestor;
    }

    public static boolean isAncestor(RigidBodyReadOnly candidateDescendant, RigidBodyReadOnly ancestor) {
        RigidBodyReadOnly currentBody = candidateDescendant;
        while (!currentBody.isRootBody()) {
            if (currentBody == ancestor) {
                return true;
            }
            currentBody = currentBody.getParentJoint().getPredecessor();
        }
        return currentBody == ancestor;
    }

    public static int computeDistanceToRoot(RigidBodyReadOnly rigidBody) {
        int distance = 0;
        RigidBodyReadOnly currentBody = rigidBody;
        while (!currentBody.isRootBody()) {
            ++distance;
            currentBody = currentBody.getParentJoint().getPredecessor();
        }
        return distance;
    }

    public static int computeDistanceToAncestor(RigidBodyReadOnly descendant, RigidBodyReadOnly ancestor) {
        int distance = 0;
        RigidBodyReadOnly currentBody = descendant;
        while (!currentBody.isRootBody() && currentBody != ancestor) {
            ++distance;
            currentBody = currentBody.getParentJoint().getPredecessor();
        }
        if (currentBody != ancestor) {
            distance = -1;
        }
        return distance;
    }

    public static int computeDistance(RigidBodyReadOnly firstBody, RigidBodyReadOnly secondBody) {
        RigidBodyReadOnly ancestor = MultiBodySystemTools.computeNearestCommonAncestor(firstBody, secondBody);
        return MultiBodySystemTools.computeDistanceToAncestor(firstBody, ancestor) + MultiBodySystemTools.computeDistanceToAncestor(secondBody, ancestor);
    }

    public static int computeDegreesOfFreedom(RigidBodyReadOnly firstBody, RigidBodyReadOnly secondBody) {
        JointReadOnly parentJoint;
        int nDoFs = 0;
        RigidBodyReadOnly ancestor = MultiBodySystemTools.computeNearestCommonAncestor(firstBody, secondBody);
        RigidBodyReadOnly currentBody = firstBody;
        while (currentBody != ancestor) {
            parentJoint = currentBody.getParentJoint();
            nDoFs += parentJoint.getDegreesOfFreedom();
            currentBody = parentJoint.getPredecessor();
        }
        currentBody = secondBody;
        while (currentBody != ancestor) {
            parentJoint = currentBody.getParentJoint();
            nDoFs += parentJoint.getDegreesOfFreedom();
            currentBody = parentJoint.getPredecessor();
        }
        return nDoFs;
    }

    public static int computeDegreesOfFreedom(List<? extends JointReadOnly> joints) {
        int numberOfDegreesOfFreedom = 0;
        for (int i = 0; i < joints.size(); ++i) {
            numberOfDegreesOfFreedom += joints.get(i).getDegreesOfFreedom();
        }
        return numberOfDegreesOfFreedom;
    }

    public static int computeDegreesOfFreedom(JointReadOnly[] joints) {
        int numberOfDegreesOfFreedom = 0;
        for (int i = 0; i < joints.length; ++i) {
            numberOfDegreesOfFreedom += joints[i].getDegreesOfFreedom();
        }
        return numberOfDegreesOfFreedom;
    }

    public static RigidBodyBasics computeNearestCommonAncestor(RigidBodyBasics firstBody, RigidBodyBasics secondBody) {
        return (RigidBodyBasics)MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)secondBody);
    }

    public static RigidBodyReadOnly computeNearestCommonAncestor(RigidBodyReadOnly firstBody, RigidBodyReadOnly secondBody) {
        int distanceToRoot;
        if (firstBody == secondBody) {
            return firstBody;
        }
        RigidBodyReadOnly firstAncestor = firstBody;
        int firstDistanceToRoot = MultiBodySystemTools.computeDistanceToRoot(firstBody);
        RigidBodyReadOnly secondAncestor = secondBody;
        int secondDistanceToRoot = MultiBodySystemTools.computeDistanceToRoot(secondBody);
        if (firstDistanceToRoot > secondDistanceToRoot) {
            for (distanceToRoot = firstDistanceToRoot; distanceToRoot > secondDistanceToRoot; --distanceToRoot) {
                firstAncestor = firstAncestor.getParentJoint().getPredecessor();
            }
        } else if (secondDistanceToRoot > firstDistanceToRoot) {
            for (distanceToRoot = secondDistanceToRoot; distanceToRoot > firstDistanceToRoot; --distanceToRoot) {
                secondAncestor = secondAncestor.getParentJoint().getPredecessor();
            }
        } else {
            distanceToRoot = firstDistanceToRoot;
        }
        if (firstAncestor == secondAncestor) {
            return firstAncestor;
        }
        while (distanceToRoot > 0) {
            if ((firstAncestor = firstAncestor.getParentJoint().getPredecessor()) == (secondAncestor = secondAncestor.getParentJoint().getPredecessor())) {
                return firstAncestor;
            }
            --distanceToRoot;
        }
        throw new IllegalArgumentException("The two rigid-bodies are not part of the same multi-body system: first root: " + firstAncestor.getName() + ", second root: " + secondAncestor.getName());
    }

    public static RigidBodyReadOnly[] collectSuccessors(JointReadOnly ... joints) {
        return (RigidBodyReadOnly[])Stream.of(joints).map(JointReadOnly::getSuccessor).toArray(RigidBodyReadOnly[]::new);
    }

    public static RigidBodyBasics[] collectSuccessors(JointBasics ... joints) {
        return (RigidBodyBasics[])Stream.of(joints).map(JointBasics::getSuccessor).toArray(RigidBodyBasics[]::new);
    }

    public static RigidBodyReadOnly[] collectSubtreeSuccessors(JointReadOnly ... joints) {
        return (RigidBodyReadOnly[])Stream.of(joints).map(JointReadOnly::getSuccessor).flatMap(RigidBodyReadOnly::subtreeStream).distinct().toArray(RigidBodyReadOnly[]::new);
    }

    public static RigidBodyBasics[] collectSubtreeSuccessors(JointBasics ... joints) {
        return (RigidBodyBasics[])Stream.of(joints).map(JointBasics::getSuccessor).flatMap(RigidBodyBasics::subtreeStream).distinct().toArray(RigidBodyBasics[]::new);
    }

    public static JointReadOnly[] collectSupportJoints(RigidBodyReadOnly rigidBody) {
        return MultiBodySystemTools.createJointPath(MultiBodySystemTools.getRootBody(rigidBody), rigidBody);
    }

    public static JointBasics[] collectSupportJoints(RigidBodyBasics rigidBody) {
        return MultiBodySystemTools.createJointPath(MultiBodySystemTools.getRootBody(rigidBody), rigidBody);
    }

    public static JointReadOnly[] collectSupportJoints(RigidBodyReadOnly ... rigidBodies) {
        return (JointReadOnly[])Stream.of(rigidBodies).map(MultiBodySystemTools::collectSupportJoints).flatMap(Stream::of).distinct().toArray(JointReadOnly[]::new);
    }

    public static JointBasics[] collectSupportJoints(RigidBodyBasics ... rigidBodies) {
        return (JointBasics[])Stream.of(rigidBodies).map(MultiBodySystemTools::collectSupportJoints).flatMap(Stream::of).distinct().toArray(JointBasics[]::new);
    }

    public static JointReadOnly[] collectSubtreeJoints(RigidBodyReadOnly ... rootBodies) {
        return (JointReadOnly[])Stream.of(rootBodies).flatMap(SubtreeStreams::fromChildren).distinct().toArray(JointReadOnly[]::new);
    }

    public static JointBasics[] collectSubtreeJoints(RigidBodyBasics ... rootBodies) {
        return (JointBasics[])Stream.of(rootBodies).flatMap(SubtreeStreams::fromChildren).distinct().toArray(JointBasics[]::new);
    }

    public static JointReadOnly[] collectSubtreeJoints(List<? extends RigidBodyReadOnly> rootBodies) {
        return (JointReadOnly[])rootBodies.stream().flatMap(SubtreeStreams::fromChildren).distinct().toArray(JointReadOnly[]::new);
    }

    public static JointReadOnly[] collectSupportAndSubtreeJoints(RigidBodyReadOnly rigidBody) {
        List<JointReadOnly> supportAndSubtreeJoints = SubtreeStreams.fromChildren(rigidBody).collect(Collectors.toList());
        supportAndSubtreeJoints.addAll(Arrays.asList(MultiBodySystemTools.collectSupportJoints(rigidBody)));
        return supportAndSubtreeJoints.toArray(new JointReadOnly[supportAndSubtreeJoints.size()]);
    }

    public static JointBasics[] collectSupportAndSubtreeJoints(RigidBodyBasics rigidBody) {
        ArrayList supportAndSubtreeJoints = new ArrayList();
        Stream.of(MultiBodySystemTools.collectSupportJoints(rigidBody)).forEach(supportAndSubtreeJoints::add);
        rigidBody.childrenSubtreeIterable().forEach(supportAndSubtreeJoints::add);
        return supportAndSubtreeJoints.toArray(new JointBasics[supportAndSubtreeJoints.size()]);
    }

    public static JointReadOnly[] collectSupportAndSubtreeJoints(RigidBodyReadOnly ... rigidBodies) {
        return (JointReadOnly[])Stream.of(rigidBodies).map(MultiBodySystemTools::collectSupportAndSubtreeJoints).flatMap(Stream::of).distinct().toArray(JointReadOnly[]::new);
    }

    public static JointBasics[] collectSupportAndSubtreeJoints(RigidBodyBasics ... rigidBodies) {
        return (JointBasics[])Stream.of(rigidBodies).map(MultiBodySystemTools::collectSupportAndSubtreeJoints).flatMap(Stream::of).distinct().toArray(JointBasics[]::new);
    }

    public static RigidBodyBasics[] collectSubtreeEndEffectors(RigidBodyBasics rigidBody) {
        return (RigidBodyBasics[])rigidBody.subtreeStream().filter(body -> body.getChildrenJoints().isEmpty()).toArray(RigidBodyBasics[]::new);
    }

    public static RigidBodyReadOnly[] collectSubtreeEndEffectors(RigidBodyReadOnly rigidBody) {
        return (RigidBodyReadOnly[])rigidBody.subtreeStream().filter(body -> body.getChildrenJoints().isEmpty()).toArray(RigidBodyReadOnly[]::new);
    }

    public static <T extends JointReadOnly> List<T> filterJoints(List<? extends JointReadOnly> source, Class<T> clazz) {
        ArrayList filteredJoints = new ArrayList();
        MultiBodySystemTools.filterJoints(source, filteredJoints, clazz);
        return filteredJoints;
    }

    public static <T extends JointReadOnly> int filterJoints(List<? extends JointReadOnly> source, List<T> destination, Class<T> clazz) {
        int numberOfFilteredJoints = 0;
        for (int i = 0; i < source.size(); ++i) {
            JointReadOnly joint = source.get(i);
            if (!clazz.isAssignableFrom(joint.getClass())) continue;
            destination.add(joint);
            ++numberOfFilteredJoints;
        }
        return numberOfFilteredJoints;
    }

    public static <T extends JointReadOnly> T[] filterJoints(JointReadOnly[] source, Class<T> clazz) {
        JointReadOnly[] retArray = (JointReadOnly[])Array.newInstance(clazz, MultiBodySystemTools.computeNumberOfJointsOfType(clazz, source));
        MultiBodySystemTools.filterJoints((JointReadOnly[])source, (JointReadOnly[])retArray, clazz);
        return retArray;
    }

    public static <T extends JointReadOnly> int filterJoints(JointReadOnly[] source, T[] destination, Class<T> clazz) {
        int numberOfFilteredJoints = 0;
        for (int i = 0; i < source.length; ++i) {
            JointReadOnly joint = source[i];
            if (!clazz.isAssignableFrom(joint.getClass())) continue;
            destination[numberOfFilteredJoints++] = joint;
        }
        return numberOfFilteredJoints;
    }

    public static JointReadOnly findJoint(RigidBodyReadOnly start, String jointName) {
        return MultiBodySystemTools.findJoint(start, jointName, false);
    }

    public static JointReadOnly findJoint(RigidBodyReadOnly start, String jointName, boolean ignoreCase) {
        int i;
        List<? extends JointReadOnly> childrenJoints = start.getChildrenJoints();
        for (i = 0; i < childrenJoints.size(); ++i) {
            JointReadOnly childJoint = childrenJoints.get(i);
            if (!(ignoreCase ? childJoint.getName().equalsIgnoreCase(jointName) : childJoint.getName().equals(jointName))) continue;
            return childJoint;
        }
        for (i = 0; i < childrenJoints.size(); ++i) {
            JointReadOnly result = MultiBodySystemTools.findJoint(childrenJoints.get(i).getSuccessor(), jointName, ignoreCase);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static JointBasics findJoint(RigidBodyBasics start, String jointName) {
        return MultiBodySystemTools.findJoint(start, jointName, false);
    }

    public static JointBasics findJoint(RigidBodyBasics start, String jointName, boolean ignoreCase) {
        return (JointBasics)MultiBodySystemTools.findJoint((RigidBodyReadOnly)start, jointName, ignoreCase);
    }

    public static RigidBodyReadOnly findRigidBody(RigidBodyReadOnly start, String rigidBodyName) {
        return MultiBodySystemTools.findRigidBody(start, rigidBodyName, false);
    }

    public static RigidBodyReadOnly findRigidBody(RigidBodyReadOnly start, String rigidBodyName, boolean ignoreCase) {
        if (start == null) {
            return null;
        }
        if (ignoreCase ? start.getName().equalsIgnoreCase(rigidBodyName) : start.getName().equals(rigidBodyName)) {
            return start;
        }
        List<? extends JointReadOnly> childrenJoints = start.getChildrenJoints();
        for (int i = 0; i < childrenJoints.size(); ++i) {
            RigidBodyReadOnly result = MultiBodySystemTools.findRigidBody(childrenJoints.get(i).getSuccessor(), rigidBodyName, ignoreCase);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static RigidBodyBasics findRigidBody(RigidBodyBasics start, String rigidBodyName) {
        return MultiBodySystemTools.findRigidBody(start, rigidBodyName, false);
    }

    public static RigidBodyBasics findRigidBody(RigidBodyBasics start, String rigidBodyName, boolean ignoreCase) {
        return (RigidBodyBasics)MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)start, rigidBodyName, ignoreCase);
    }

    public static boolean areJointsInContinuousOrder(JointReadOnly[] joints) {
        for (int index = 0; index < joints.length - 1; ++index) {
            if (joints[index] == joints[index + 1].getPredecessor().getParentJoint()) continue;
            return false;
        }
        return true;
    }

    public static boolean areJointsInContinuousOrder(List<? extends JointReadOnly> joints) {
        for (int index = 0; index < joints.size() - 1; ++index) {
            if (joints.get(index) == joints.get(index + 1).getPredecessor().getParentJoint()) continue;
            return false;
        }
        return true;
    }

    public static boolean doesSubtreeContainLoopClosure(RigidBodyReadOnly start) {
        int i;
        for (i = 0; i < start.getChildrenJoints().size(); ++i) {
            if (!start.getChildrenJoints().get(i).isLoopClosure()) continue;
            return true;
        }
        for (i = 0; i < start.getChildrenJoints().size(); ++i) {
            if (!MultiBodySystemTools.doesSubtreeContainLoopClosure(start.getChildrenJoints().get(i).getSuccessor())) continue;
            return true;
        }
        return false;
    }

    public static <T extends JointReadOnly> int computeNumberOfJointsOfType(Class<T> clazz, JointReadOnly[] joints) {
        int number = 0;
        for (JointReadOnly joint : joints) {
            if (!clazz.isAssignableFrom(joint.getClass())) continue;
            ++number;
        }
        return number;
    }

    public static void copyJointsState(List<? extends JointReadOnly> source, List<? extends JointBasics> destination, JointStateType stateSelection) {
        if (source.size() != destination.size()) {
            throw new IllegalArgumentException("Inconsistent argument size: source = " + source.size() + ", destination = " + destination.size() + ".");
        }
        switch (stateSelection) {
            case CONFIGURATION: {
                MultiBodySystemTools.copyJointsConfiguration(source, destination);
                return;
            }
            case VELOCITY: {
                MultiBodySystemTools.copyJointsVelocity(source, destination);
                return;
            }
            case ACCELERATION: {
                MultiBodySystemTools.copyJointsAcceleration(source, destination);
                return;
            }
            case EFFORT: {
                MultiBodySystemTools.copyJointsTau(source, destination);
                return;
            }
        }
        throw new RuntimeException("Unexpected value for stateSelection: " + String.valueOf((Object)stateSelection));
    }

    private static void copyJointsConfiguration(List<? extends JointReadOnly> source, List<? extends JointBasics> destination) {
        for (int jointIndex = 0; jointIndex < source.size(); ++jointIndex) {
            JointReadOnly sourceJoint = source.get(jointIndex);
            JointBasics destinationJoint = destination.get(jointIndex);
            destinationJoint.setJointConfiguration(sourceJoint);
        }
    }

    private static void copyJointsVelocity(List<? extends JointReadOnly> source, List<? extends JointBasics> destination) {
        for (int jointIndex = 0; jointIndex < source.size(); ++jointIndex) {
            JointReadOnly sourceJoint = source.get(jointIndex);
            JointBasics destinationJoint = destination.get(jointIndex);
            destinationJoint.setJointTwist(sourceJoint);
        }
    }

    private static void copyJointsAcceleration(List<? extends JointReadOnly> source, List<? extends JointBasics> destination) {
        for (int jointIndex = 0; jointIndex < source.size(); ++jointIndex) {
            JointReadOnly sourceJoint = source.get(jointIndex);
            JointBasics destinationJoint = destination.get(jointIndex);
            destinationJoint.setJointAcceleration(sourceJoint);
        }
    }

    private static void copyJointsTau(List<? extends JointReadOnly> source, List<? extends JointBasics> destination) {
        for (int jointIndex = 0; jointIndex < source.size(); ++jointIndex) {
            JointReadOnly sourceJoint = source.get(jointIndex);
            JointBasics destinationJoint = destination.get(jointIndex);
            destinationJoint.setJointWrench(sourceJoint);
        }
    }

    public static int extractJointsState(List<? extends JointReadOnly> joints, JointStateType stateSelection, DMatrix matrixToPack) {
        switch (stateSelection) {
            case CONFIGURATION: {
                return MultiBodySystemTools.extractJointsConfiguration(joints, 0, matrixToPack);
            }
            case VELOCITY: {
                return MultiBodySystemTools.extractJointsVelocity(joints, 0, matrixToPack);
            }
            case ACCELERATION: {
                return MultiBodySystemTools.extractJointsAcceleration(joints, 0, matrixToPack);
            }
            case EFFORT: {
                return MultiBodySystemTools.extractJointsTau(joints, 0, matrixToPack);
            }
        }
        throw new RuntimeException("Unexpected value for stateSelection: " + String.valueOf((Object)stateSelection));
    }

    private static int extractJointsConfiguration(List<? extends JointReadOnly> joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            JointReadOnly joint = joints.get(jointIndex);
            startIndex = joint.getJointConfiguration(startIndex, matrixToPack);
        }
        return startIndex;
    }

    private static int extractJointsVelocity(List<? extends JointReadOnly> joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            JointReadOnly joint = joints.get(jointIndex);
            startIndex = joint.getJointVelocity(startIndex, matrixToPack);
        }
        return startIndex;
    }

    private static int extractJointsAcceleration(List<? extends JointReadOnly> joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            JointReadOnly joint = joints.get(jointIndex);
            startIndex = joint.getJointAcceleration(startIndex, matrixToPack);
        }
        return startIndex;
    }

    private static int extractJointsTau(List<? extends JointReadOnly> joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            JointReadOnly joint = joints.get(jointIndex);
            startIndex = joint.getJointTau(startIndex, matrixToPack);
        }
        return startIndex;
    }

    public static int extractJointsState(JointReadOnly[] joints, JointStateType stateSelection, DMatrix matrixToPack) {
        switch (stateSelection) {
            case CONFIGURATION: {
                return MultiBodySystemTools.extractJointsConfiguration(joints, 0, matrixToPack);
            }
            case VELOCITY: {
                return MultiBodySystemTools.extractJointsVelocity(joints, 0, matrixToPack);
            }
            case ACCELERATION: {
                return MultiBodySystemTools.extractJointsAcceleration(joints, 0, matrixToPack);
            }
            case EFFORT: {
                return MultiBodySystemTools.extractJointsTau(joints, 0, matrixToPack);
            }
        }
        throw new RuntimeException("Unexpected value for stateSelection: " + String.valueOf((Object)stateSelection));
    }

    private static int extractJointsConfiguration(JointReadOnly[] joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            JointReadOnly joint = joints[jointIndex];
            startIndex = joint.getJointConfiguration(startIndex, matrixToPack);
        }
        return startIndex;
    }

    private static int extractJointsVelocity(JointReadOnly[] joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            JointReadOnly joint = joints[jointIndex];
            startIndex = joint.getJointVelocity(startIndex, matrixToPack);
        }
        return startIndex;
    }

    private static int extractJointsAcceleration(JointReadOnly[] joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            JointReadOnly joint = joints[jointIndex];
            startIndex = joint.getJointAcceleration(startIndex, matrixToPack);
        }
        return startIndex;
    }

    private static int extractJointsTau(JointReadOnly[] joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            JointReadOnly joint = joints[jointIndex];
            startIndex = joint.getJointTau(startIndex, matrixToPack);
        }
        return startIndex;
    }

    public static int insertJointsState(List<? extends JointBasics> joints, JointStateType stateSelection, DMatrix matrix) {
        switch (stateSelection) {
            case CONFIGURATION: {
                return MultiBodySystemTools.insertJointsConfiguration(joints, 0, matrix);
            }
            case VELOCITY: {
                return MultiBodySystemTools.insertJointsVelocity(joints, 0, matrix);
            }
            case ACCELERATION: {
                return MultiBodySystemTools.insertJointsAcceleration(joints, 0, matrix);
            }
            case EFFORT: {
                return MultiBodySystemTools.insertJointsTau(joints, 0, matrix);
            }
        }
        throw new RuntimeException("Unexpected value for stateSelection: " + String.valueOf((Object)stateSelection));
    }

    private static int insertJointsConfiguration(List<? extends JointBasics> joints, int startIndex, DMatrix matrix) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            JointBasics joint = joints.get(jointIndex);
            startIndex = joint.setJointConfiguration(startIndex, matrix);
        }
        return startIndex;
    }

    private static int insertJointsVelocity(List<? extends JointBasics> joints, int startIndex, DMatrix matrix) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            JointBasics joint = joints.get(jointIndex);
            startIndex = joint.setJointVelocity(startIndex, matrix);
        }
        return startIndex;
    }

    private static int insertJointsAcceleration(List<? extends JointBasics> joints, int startIndex, DMatrix matrix) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            JointBasics joint = joints.get(jointIndex);
            startIndex = joint.setJointAcceleration(startIndex, matrix);
        }
        return startIndex;
    }

    private static int insertJointsTau(List<? extends JointBasics> joints, int startIndex, DMatrix matrix) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            JointBasics joint = joints.get(jointIndex);
            startIndex = joint.setJointTau(startIndex, matrix);
        }
        return startIndex;
    }

    public static int insertJointsState(JointBasics[] joints, JointStateType stateSelection, DMatrix matrix) {
        switch (stateSelection) {
            case CONFIGURATION: {
                return MultiBodySystemTools.insertJointsConfiguration(joints, 0, matrix);
            }
            case VELOCITY: {
                return MultiBodySystemTools.insertJointsVelocity(joints, 0, matrix);
            }
            case ACCELERATION: {
                return MultiBodySystemTools.insertJointsAcceleration(joints, 0, matrix);
            }
            case EFFORT: {
                return MultiBodySystemTools.insertJointsTau(joints, 0, matrix);
            }
        }
        throw new RuntimeException("Unexpected value for stateSelection: " + String.valueOf((Object)stateSelection));
    }

    private static int insertJointsConfiguration(JointBasics[] joints, int startIndex, DMatrix matrix) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            JointBasics joint = joints[jointIndex];
            startIndex = joint.setJointConfiguration(startIndex, matrix);
        }
        return startIndex;
    }

    private static int insertJointsVelocity(JointBasics[] joints, int startIndex, DMatrix matrix) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            JointBasics joint = joints[jointIndex];
            startIndex = joint.setJointVelocity(startIndex, matrix);
        }
        return startIndex;
    }

    private static int insertJointsAcceleration(JointBasics[] joints, int startIndex, DMatrix matrix) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            JointBasics joint = joints[jointIndex];
            startIndex = joint.setJointAcceleration(startIndex, matrix);
        }
        return startIndex;
    }

    private static int insertJointsTau(JointBasics[] joints, int startIndex, DMatrix matrix) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            JointBasics joint = joints[jointIndex];
            startIndex = joint.setJointTau(startIndex, matrix);
        }
        return startIndex;
    }

    public static List<JointReadOnly> sortLoopClosureInChildrenJoints(RigidBodyReadOnly rigidBody) {
        ArrayList<JointReadOnly> childrenJoints = new ArrayList<JointReadOnly>(rigidBody.getChildrenJoints());
        if (childrenJoints.size() > 1) {
            ArrayList<JointReadOnly> loopClosureAncestors = new ArrayList<JointReadOnly>();
            int i = 0;
            while (i < childrenJoints.size()) {
                if (MultiBodySystemTools.doesSubtreeContainLoopClosure(((JointReadOnly)childrenJoints.get(i)).getSuccessor())) {
                    loopClosureAncestors.add((JointReadOnly)childrenJoints.remove(i));
                    continue;
                }
                ++i;
            }
            childrenJoints.addAll(loopClosureAncestors);
        }
        return childrenJoints;
    }
}

