/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class MomentOfInertiaFactory {
    public static Matrix3D solidCylinder(double mass, double radius, double height, Vector3DReadOnly axisOfCylinder) {
        MomentOfInertiaFactory.checkMassAndDimensions(mass, radius, height);
        double IalongAxis = 0.5 * mass * radius * radius;
        double IcrossAxis = mass * (3.0 * radius * radius + height * height) / 12.0;
        AxisAngle axisAngle = EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)axisOfCylinder);
        Vector3D principalInertia = new Vector3D(IcrossAxis, IcrossAxis, IalongAxis);
        axisAngle.transform((Tuple3DBasics)principalInertia);
        Matrix3D momentOfInertia = new Matrix3D();
        momentOfInertia.setM00(Math.abs(principalInertia.getX()));
        momentOfInertia.setM11(Math.abs(principalInertia.getY()));
        momentOfInertia.setM22(Math.abs(principalInertia.getZ()));
        return momentOfInertia;
    }

    public static Matrix3D solidEllipsoid(double mass, Tuple3DReadOnly radii) {
        return MomentOfInertiaFactory.solidEllipsoid(mass, radii.getX(), radii.getY(), radii.getZ());
    }

    public static Matrix3D solidEllipsoid(double mass, double xRadius, double yRadius, double zRadius) {
        MomentOfInertiaFactory.checkMassAndDimensions(mass, xRadius, yRadius, zRadius);
        Matrix3D momentOfInertia = new Matrix3D();
        double scale = 0.2 * mass;
        momentOfInertia.setM00(scale * (yRadius * yRadius + zRadius * zRadius));
        momentOfInertia.setM11(scale * (zRadius * zRadius + xRadius * xRadius));
        momentOfInertia.setM22(scale * (xRadius * xRadius + yRadius * yRadius));
        return momentOfInertia;
    }

    public static Matrix3D solidSphere(double mass, double radius) {
        MomentOfInertiaFactory.checkMassAndDimensions(mass, radius);
        Matrix3D momentOfInertia = new Matrix3D();
        double inertia = 0.4 * mass * radius * radius;
        momentOfInertia.setM00(inertia);
        momentOfInertia.setM11(inertia);
        momentOfInertia.setM22(inertia);
        return momentOfInertia;
    }

    public static Matrix3D solidBox(double mass, Tuple3DReadOnly size) {
        return MomentOfInertiaFactory.solidBox(mass, size.getX(), size.getY(), size.getZ());
    }

    public static Matrix3D solidBox(double mass, double xSize, double ySize, double zSize) {
        MomentOfInertiaFactory.checkMassAndDimensions(mass, xSize, ySize, zSize);
        Matrix3D momentOfInertia = new Matrix3D();
        double scale = mass / 12.0;
        momentOfInertia.setM00(scale * (ySize * ySize + zSize * zSize));
        momentOfInertia.setM11(scale * (zSize * zSize + xSize * xSize));
        momentOfInertia.setM22(scale * (xSize * xSize + ySize * ySize));
        return momentOfInertia;
    }

    public static Matrix3D fromMassAndRadiiOfGyration(double mass, double radiusOfGyrationX, double radiusOfGyrationY, double radiusOfGyrationZ) {
        MomentOfInertiaFactory.checkMassAndDimensions(mass, radiusOfGyrationX, radiusOfGyrationY, radiusOfGyrationZ);
        Matrix3D momentOfInertia = new Matrix3D();
        momentOfInertia.setM00(mass * (radiusOfGyrationY * radiusOfGyrationY + radiusOfGyrationZ * radiusOfGyrationZ));
        momentOfInertia.setM11(mass * (radiusOfGyrationX * radiusOfGyrationX + radiusOfGyrationZ * radiusOfGyrationZ));
        momentOfInertia.setM22(mass * (radiusOfGyrationX * radiusOfGyrationX + radiusOfGyrationY * radiusOfGyrationY));
        return momentOfInertia;
    }

    private static void checkMassAndDimensions(double mass, double ... dimensions) {
        if (mass < 0.0) {
            throw new IllegalArgumentException("can not pass in negative mass values");
        }
        for (double dimension : dimensions) {
            if (!(dimension < 0.0)) continue;
            throw new IllegalArgumentException("can not pass in negative dimensions");
        }
    }
}

