/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem;

import java.util.List;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MecanoTools;

public class SphericalJoint
extends Joint
implements SphericalJointBasics {
    private final Quaternion jointOrientation = new Quaternion();
    private final FixedFrameVector3DBasics jointAngularVelocity = new FrameVector3D((ReferenceFrame)this.afterJointFrame);
    private final FixedFrameVector3DBasics jointAngularAcceleration = new FrameVector3D((ReferenceFrame)this.afterJointFrame);
    private final FixedFrameVector3DBasics jointTorque;
    private final TwistReadOnly jointTwist = MecanoFactories.newTwistReadOnly(this.afterJointFrame, this.beforeJointFrame, (FrameVector3DReadOnly)this.jointAngularVelocity, (FrameVector3DReadOnly)new FrameVector3D((ReferenceFrame)this.afterJointFrame));
    private final SpatialAccelerationReadOnly jointAcceleration = MecanoFactories.newSpatialAccelerationVectorReadOnly(this.afterJointFrame, this.beforeJointFrame, (FrameVector3DReadOnly)this.jointAngularAcceleration, (FrameVector3DReadOnly)new FrameVector3D((ReferenceFrame)this.afterJointFrame));
    private WrenchReadOnly successorWrench;
    private final List<TwistReadOnly> unitTwists = MecanoTools.computeSphericalJointMotionSubspace(this.beforeJointFrame, this.afterJointFrame);

    public SphericalJoint(String name, RigidBodyBasics predecessor, Tuple3DReadOnly jointOffset) {
        this(name, predecessor, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), jointOffset));
    }

    public SphericalJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        super(name, predecessor, transformToParent);
        this.jointTorque = new FrameVector3D((ReferenceFrame)this.afterJointFrame);
    }

    @Override
    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        MovingReferenceFrame successorFrame = successor.getBodyFixedFrame();
        this.successorWrench = MecanoFactories.newWrenchReadOnly(successorFrame, (FrameVector3DReadOnly)this.jointTorque, (FrameVector3DReadOnly)new FrameVector3D((ReferenceFrame)this.afterJointFrame));
    }

    @Override
    public QuaternionBasics getJointOrientation() {
        return this.jointOrientation;
    }

    @Override
    public FixedFrameVector3DBasics getJointAngularVelocity() {
        return this.jointAngularVelocity;
    }

    @Override
    public FixedFrameVector3DBasics getJointAngularAcceleration() {
        return this.jointAngularAcceleration;
    }

    @Override
    public FixedFrameVector3DBasics getJointTorque() {
        return this.jointTorque;
    }

    @Override
    public TwistReadOnly getJointTwist() {
        return this.jointTwist;
    }

    @Override
    public SpatialAccelerationReadOnly getJointAcceleration() {
        return this.jointAcceleration;
    }

    @Override
    public WrenchReadOnly getJointWrench() {
        return this.successorWrench;
    }

    @Override
    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    @Override
    public String toString() {
        return super.toString() + ", orientation: " + String.valueOf(this.jointOrientation) + ", velocity" + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this.jointAngularVelocity) + ", acceleration: " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this.jointAngularAcceleration) + ", torque: " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this.jointTorque);
    }
}

