/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.misc.UnrolledInverseFromMinor_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.ArticulatedBodyInertia;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class ForwardDynamicsCalculator {
    private final MultiBodySystemReadOnly input;
    private final ArticulatedBodyRecursionStep initialRecursionStep;
    private final Map<RigidBodyReadOnly, ArticulatedBodyRecursionStep> rigidBodyToRecursionStepMap = new LinkedHashMap<RigidBodyReadOnly, ArticulatedBodyRecursionStep>();
    private final ArticulatedBodyRecursionStep[] articulatedBodyRecursionSteps;
    private boolean isJointTauOutputDirty = true;
    private boolean isJointAccelerationOutputDirty = true;
    private final DMatrixRMaj jointTauOutput;
    private final DMatrixRMaj jointAccelerationOutput;
    private final RigidBodyAccelerationProvider accelerationProvider;
    private final RigidBodyAccelerationProvider zeroVelocityAccelerationProvider;
    private final int totalDoFs;
    private final SpatialForce jointForceFromChild = new SpatialForce();

    public ForwardDynamicsCalculator(RigidBodyReadOnly rootBody) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody));
    }

    public ForwardDynamicsCalculator(MultiBodySystemReadOnly input) {
        this(input, true);
    }

    public ForwardDynamicsCalculator(MultiBodySystemReadOnly input, boolean considerIgnoredSubtreesInertia) {
        this.input = input;
        RigidBodyReadOnly rootBody = input.getRootBody();
        this.initialRecursionStep = new ArticulatedBodyRecursionStep(rootBody, null, null);
        this.rigidBodyToRecursionStepMap.put(rootBody, this.initialRecursionStep);
        this.buildMultiBodyTree(this.initialRecursionStep, input.getJointsToIgnore());
        if (considerIgnoredSubtreesInertia) {
            this.initialRecursionStep.updateIgnoredSubtreeInertia();
        }
        this.articulatedBodyRecursionSteps = this.rigidBodyToRecursionStepMap.values().toArray(new ArticulatedBodyRecursionStep[this.rigidBodyToRecursionStepMap.size()]);
        this.totalDoFs = input.getNumberOfDoFs();
        this.jointTauOutput = new DMatrixRMaj(this.totalDoFs, 1);
        this.jointAccelerationOutput = new DMatrixRMaj(this.totalDoFs, 1);
        Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> accelerationFunction = body -> {
            ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(body);
            if (recursionStep == null) {
                return null;
            }
            recursionStep.rigidBodyAcceleration.changeFrame(body.getBodyFixedFrame());
            return recursionStep.rigidBodyAcceleration;
        };
        this.accelerationProvider = RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(accelerationFunction, input.getInertialFrame());
        Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> zeroVelocityAccelerationFunction = body -> {
            ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(body);
            if (recursionStep == null) {
                return null;
            }
            recursionStep.rigidBodyZeroVelocityAcceleration.changeFrame(body.getBodyFixedFrame());
            return recursionStep.rigidBodyZeroVelocityAcceleration;
        };
        this.zeroVelocityAccelerationProvider = RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(zeroVelocityAccelerationFunction, input.getInertialFrame(), false, true);
    }

    private void buildMultiBodyTree(ArticulatedBodyRecursionStep parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        List<JointReadOnly> childrenJoints = MultiBodySystemTools.sortLoopClosureInChildrenJoints(parent.rigidBody);
        for (JointReadOnly childJoint : childrenJoints) {
            if (jointsToIgnore.contains(childJoint)) continue;
            if (childJoint.isLoopClosure()) {
                System.out.println(this.getClass().getSimpleName() + ": This calculator does not support kinematic loops. Ignoring joint: " + childJoint.getName());
                continue;
            }
            RigidBodyReadOnly childBody = childJoint.getSuccessor();
            if (childBody == null) continue;
            int[] jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(childJoint);
            ArticulatedBodyRecursionStep child = new ArticulatedBodyRecursionStep(childBody, parent, jointIndices);
            this.rigidBodyToRecursionStepMap.put(childBody, child);
            this.buildMultiBodyTree(child, jointsToIgnore);
        }
    }

    public void setGravitationalAcceleration(FrameTuple3DReadOnly gravity) {
        gravity.checkReferenceFrameMatch(this.input.getInertialFrame());
        this.setGravitationalAcceleration((Tuple3DReadOnly)gravity);
    }

    @Deprecated
    public void setGravitionalAcceleration(FrameTuple3DReadOnly gravity) {
        this.setGravitationalAcceleration(gravity);
    }

    public void setGravitationalAcceleration(Tuple3DReadOnly gravity) {
        SpatialAcceleration rootAcceleration = this.initialRecursionStep.rigidBodyAcceleration;
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().setAndNegate(gravity);
    }

    @Deprecated
    public void setGravitionalAcceleration(Tuple3DReadOnly gravity) {
        this.setGravitationalAcceleration(gravity);
    }

    public void setGravitationalAcceleration(double gravity) {
        this.setGravitationalAcceleration(0.0, 0.0, gravity);
    }

    @Deprecated
    public void setGravitionalAcceleration(double gravity) {
        this.setGravitationalAcceleration(gravity);
    }

    public void setGravitationalAcceleration(double gravityX, double gravityY, double gravityZ) {
        SpatialAcceleration rootAcceleration = this.initialRecursionStep.rigidBodyAcceleration;
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().set(gravityX, gravityY, gravityZ);
        rootAcceleration.negate();
    }

    @Deprecated
    public void setGravitionalAcceleration(double gravityX, double gravityY, double gravityZ) {
        this.setGravitationalAcceleration(gravityX, gravityY, gravityZ);
    }

    public void setRootAcceleration(SpatialAccelerationReadOnly newRootAcceleration) {
        this.initialRecursionStep.rigidBodyAcceleration.set(newRootAcceleration);
    }

    public void setExternalWrenchesToZero() {
        for (ArticulatedBodyRecursionStep recursionStep : this.articulatedBodyRecursionSteps) {
            if (recursionStep.externalWrench == null) continue;
            recursionStep.externalWrench.setToZero();
        }
    }

    public FixedFrameWrenchBasics getExternalWrench(RigidBodyReadOnly rigidBody) {
        ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(rigidBody);
        return recursionStep == null ? null : recursionStep.externalWrench;
    }

    public void setExternalWrench(RigidBodyReadOnly rigidBody, WrenchReadOnly externalWrench) {
        this.rigidBodyToRecursionStepMap.get((Object)rigidBody).externalWrench.setMatchingFrame(externalWrench);
    }

    public void setJointSourceMode(JointReadOnly joint, JointSourceMode mode) {
        this.rigidBodyToRecursionStepMap.get((Object)joint.getSuccessor()).sourceMode = mode;
    }

    public void setJointSourceModes(Function<JointReadOnly, JointSourceMode> jointSourceModeFunction) {
        for (ArticulatedBodyRecursionStep recursionStep : this.articulatedBodyRecursionSteps) {
            JointSourceMode newMode;
            if (recursionStep.getJoint() == null || (newMode = jointSourceModeFunction.apply(recursionStep.getJoint())) == null) continue;
            recursionStep.sourceMode = newMode;
        }
    }

    public void resetJointSourceModes() {
        for (ArticulatedBodyRecursionStep recursionStep : this.articulatedBodyRecursionSteps) {
            recursionStep.sourceMode = JointSourceMode.EFFORT_SOURCE;
        }
    }

    public JointSourceMode getJointSourceMode(JointReadOnly joint) {
        return this.rigidBodyToRecursionStepMap.get((Object)joint.getSuccessor()).sourceMode;
    }

    public void compute() {
        this.compute(null);
    }

    public void compute(DMatrix jointTauInput) {
        this.compute(jointTauInput, null);
    }

    public void compute(DMatrix jointTauInput, DMatrix jointAccelerationInput) {
        this.checkAllJointMatrixSize(jointTauInput);
        this.checkAllJointMatrixSize(jointAccelerationInput);
        this.isJointTauOutputDirty = true;
        this.isJointAccelerationOutputDirty = true;
        boolean atLeastOneLockedJoint = this.initialRecursionStep.passOne();
        this.initialRecursionStep.passTwo(jointTauInput);
        this.initialRecursionStep.passThree(jointAccelerationInput);
        if (atLeastOneLockedJoint) {
            this.initialRecursionStep.passFour();
        }
    }

    private void checkAllJointMatrixSize(DMatrix matrix) {
        if (matrix == null) {
            return;
        }
        if (matrix.getNumRows() != this.totalDoFs || matrix.getNumCols() != 1) {
            throw new MatrixDimensionException(String.format("Incompatible matrix dimension, expected: [nRows: %d, nCols: %d], was: [nRows: %d, nCols: %d]", this.totalDoFs, 1, matrix.getNumRows(), matrix.getNumCols()));
        }
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public DMatrixRMaj getJointAccelerationMatrix() {
        if (this.isJointAccelerationOutputDirty) {
            for (ArticulatedBodyRecursionStep articulatedBodyRecursionStep : this.articulatedBodyRecursionSteps) {
                articulatedBodyRecursionStep.getAccelerationOutput((DMatrix)this.jointAccelerationOutput);
            }
            this.isJointAccelerationOutputDirty = false;
        }
        return this.jointAccelerationOutput;
    }

    public DMatrixRMaj getJointTauMatrix() {
        if (this.isJointTauOutputDirty) {
            for (ArticulatedBodyRecursionStep articulatedBodyRecursionStep : this.articulatedBodyRecursionSteps) {
                articulatedBodyRecursionStep.getTauOutput((DMatrix)this.jointTauOutput);
            }
            this.isJointTauOutputDirty = false;
        }
        return this.jointTauOutput;
    }

    public DMatrixRMaj getComputedJointAcceleration(JointReadOnly joint) {
        ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return null;
        }
        return recursionStep.qdd;
    }

    public DMatrixRMaj getJointTau(JointReadOnly joint) {
        ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return null;
        }
        return recursionStep.qdd;
    }

    public WrenchReadOnly getJointWrench(JointReadOnly joint) {
        ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return null;
        }
        return recursionStep.getJointWrench();
    }

    ArticulatedBodyRecursionStep getInitialRecursionStep() {
        return this.initialRecursionStep;
    }

    public void writeComputedJointAccelerations(JointBasics[] joints) {
        for (JointBasics joint : joints) {
            this.writeComputedJointAcceleration(joint);
        }
    }

    public void writeComputedJointAccelerations(List<? extends JointBasics> joints) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            this.writeComputedJointAcceleration(joints.get(jointIndex));
        }
    }

    public boolean writeComputedJointAcceleration(JointBasics joint) {
        ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return false;
        }
        joint.setJointAcceleration(0, (DMatrix)recursionStep.qdd);
        return true;
    }

    public RigidBodyAccelerationProvider getAccelerationProvider() {
        return this.accelerationProvider;
    }

    public RigidBodyAccelerationProvider getAccelerationProvider(boolean considerVelocities) {
        return considerVelocities ? this.accelerationProvider : this.zeroVelocityAccelerationProvider;
    }

    static void addEquals(DMatrixD1 a, SpatialVectorReadOnly b) {
        if (a.numCols != 1 || a.numRows != 6) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        a.plus(0, b.getAngularPartX());
        a.plus(1, b.getAngularPartY());
        a.plus(2, b.getAngularPartZ());
        a.plus(3, b.getLinearPartX());
        a.plus(4, b.getLinearPartY());
        a.plus(5, b.getLinearPartZ());
    }

    static void mult(ArticulatedBodyInertia a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numRows != 6) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        c.reshape(6, b.numCols);
        Matrix3D angularInertia = a.getAngularInertia();
        Matrix3D crossInertia = a.getCrossInertia();
        Matrix3D linearInertia = a.getLinearInertia();
        double a00 = angularInertia.getM00();
        double a01 = angularInertia.getM01();
        double a02 = angularInertia.getM02();
        double a10 = angularInertia.getM10();
        double a11 = angularInertia.getM11();
        double a12 = angularInertia.getM12();
        double a20 = angularInertia.getM20();
        double a21 = angularInertia.getM21();
        double a22 = angularInertia.getM22();
        double a03 = crossInertia.getM00();
        double a04 = crossInertia.getM01();
        double a05 = crossInertia.getM02();
        double a13 = crossInertia.getM10();
        double a14 = crossInertia.getM11();
        double a15 = crossInertia.getM12();
        double a23 = crossInertia.getM20();
        double a24 = crossInertia.getM21();
        double a25 = crossInertia.getM22();
        double a33 = linearInertia.getM00();
        double a34 = linearInertia.getM01();
        double a35 = linearInertia.getM02();
        double a43 = linearInertia.getM10();
        double a44 = linearInertia.getM11();
        double a45 = linearInertia.getM12();
        double a53 = linearInertia.getM20();
        double a54 = linearInertia.getM21();
        double a55 = linearInertia.getM22();
        for (int i = 0; i < b.getNumCols(); ++i) {
            double b0i = b.unsafe_get(0, i);
            double b1i = b.unsafe_get(1, i);
            double b2i = b.unsafe_get(2, i);
            double b3i = b.unsafe_get(3, i);
            double b4i = b.unsafe_get(4, i);
            double b5i = b.unsafe_get(5, i);
            c.unsafe_set(0, i, a00 * b0i + a01 * b1i + a02 * b2i + a03 * b3i + a04 * b4i + a05 * b5i);
            c.unsafe_set(1, i, a10 * b0i + a11 * b1i + a12 * b2i + a13 * b3i + a14 * b4i + a15 * b5i);
            c.unsafe_set(2, i, a20 * b0i + a21 * b1i + a22 * b2i + a23 * b3i + a24 * b4i + a25 * b5i);
            c.unsafe_set(3, i, a03 * b0i + a13 * b1i + a23 * b2i + a33 * b3i + a34 * b4i + a35 * b5i);
            c.unsafe_set(4, i, a04 * b0i + a14 * b1i + a24 * b2i + a43 * b3i + a44 * b4i + a45 * b5i);
            c.unsafe_set(5, i, a05 * b0i + a15 * b1i + a25 * b2i + a53 * b3i + a54 * b4i + a55 * b5i);
        }
    }

    static void multTransA(double alpha, DMatrix1Row a, SpatialVectorReadOnly b, DMatrix1Row c) {
        if (a.numRows != 6) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        c.reshape(a.numCols, 1);
        double b0 = b.getAngularPartX();
        double b1 = b.getAngularPartY();
        double b2 = b.getAngularPartZ();
        double b3 = b.getLinearPartX();
        double b4 = b.getLinearPartY();
        double b5 = b.getLinearPartZ();
        for (int aCol = 0; aCol < a.numCols; ++aCol) {
            double total = a.unsafe_get(0, aCol) * b0;
            total += a.unsafe_get(1, aCol) * b1;
            total += a.unsafe_get(2, aCol) * b2;
            total += a.unsafe_get(3, aCol) * b3;
            total += a.unsafe_get(4, aCol) * b4;
            c.set(aCol, 0, alpha * (total += a.unsafe_get(5, aCol) * b5));
        }
    }

    static void multAdd(ArticulatedBodyInertia a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numRows != 6) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (c.numRows != 6 || c.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'c' is not compatible");
        }
        Matrix3D angularInertia = a.getAngularInertia();
        Matrix3D crossInertia = a.getCrossInertia();
        Matrix3D linearInertia = a.getLinearInertia();
        double a00 = angularInertia.getM00();
        double a01 = angularInertia.getM01();
        double a02 = angularInertia.getM02();
        double a10 = angularInertia.getM10();
        double a11 = angularInertia.getM11();
        double a12 = angularInertia.getM12();
        double a20 = angularInertia.getM20();
        double a21 = angularInertia.getM21();
        double a22 = angularInertia.getM22();
        double a03 = crossInertia.getM00();
        double a04 = crossInertia.getM01();
        double a05 = crossInertia.getM02();
        double a13 = crossInertia.getM10();
        double a14 = crossInertia.getM11();
        double a15 = crossInertia.getM12();
        double a23 = crossInertia.getM20();
        double a24 = crossInertia.getM21();
        double a25 = crossInertia.getM22();
        double a33 = linearInertia.getM00();
        double a34 = linearInertia.getM01();
        double a35 = linearInertia.getM02();
        double a43 = linearInertia.getM10();
        double a44 = linearInertia.getM11();
        double a45 = linearInertia.getM12();
        double a53 = linearInertia.getM20();
        double a54 = linearInertia.getM21();
        double a55 = linearInertia.getM22();
        for (int i = 0; i < b.getNumCols(); ++i) {
            double b0i = b.unsafe_get(0, i);
            double b1i = b.unsafe_get(1, i);
            double b2i = b.unsafe_get(2, i);
            double b3i = b.unsafe_get(3, i);
            double b4i = b.unsafe_get(4, i);
            double b5i = b.unsafe_get(5, i);
            c.unsafe_set(0, i, c.unsafe_get(0, i) + a00 * b0i + a01 * b1i + a02 * b2i + a03 * b3i + a04 * b4i + a05 * b5i);
            c.unsafe_set(1, i, c.unsafe_get(1, i) + a10 * b0i + a11 * b1i + a12 * b2i + a13 * b3i + a14 * b4i + a15 * b5i);
            c.unsafe_set(2, i, c.unsafe_get(2, i) + a20 * b0i + a21 * b1i + a22 * b2i + a23 * b3i + a24 * b4i + a25 * b5i);
            c.unsafe_set(3, i, c.unsafe_get(3, i) + a03 * b0i + a13 * b1i + a23 * b2i + a33 * b3i + a34 * b4i + a35 * b5i);
            c.unsafe_set(4, i, c.unsafe_get(4, i) + a04 * b0i + a14 * b1i + a24 * b2i + a43 * b3i + a44 * b4i + a45 * b5i);
            c.unsafe_set(5, i, c.unsafe_get(5, i) + a05 * b0i + a15 * b1i + a25 * b2i + a53 * b3i + a54 * b4i + a55 * b5i);
        }
    }

    class ArticulatedBodyRecursionStep {
        final RigidBodyReadOnly rigidBody;
        private SpatialInertia bodyInertia;
        private SpatialInertia bodySubtreeInertia;
        final Wrench externalWrench;
        final SpatialAcceleration biasAcceleration;
        final Wrench biasWrench;
        final SpatialInertia spatialInertia;
        final ArticulatedBodyInertia articulatedInertia;
        final SpatialForce articulatedBiasWrench;
        final ArticulatedBodyInertia articulatedInertiaForParent;
        final SpatialForce articulatedBiasWrenchForParent;
        final SpatialAcceleration rigidBodyAcceleration = new SpatialAcceleration();
        final SpatialAcceleration rigidBodyZeroVelocityAcceleration = new SpatialAcceleration();
        final DMatrixRMaj S;
        final DMatrixRMaj U;
        final DMatrixRMaj D;
        final DMatrixRMaj Dinv;
        final DMatrixRMaj U_Dinv;
        final DMatrixRMaj U_Dinv_UT;
        final DMatrixRMaj tau;
        final DMatrixRMaj u;
        final DMatrixRMaj c;
        final DMatrixRMaj pa;
        final DMatrixRMaj a;
        final DMatrixRMaj qdd_intermediate;
        final DMatrixRMaj qdd;
        final ArticulatedBodyRecursionStep parent;
        final List<ArticulatedBodyRecursionStep> children = new ArrayList<ArticulatedBodyRecursionStep>();
        final LinearSolverDense<DMatrixRMaj> inverseSolver;
        final RigidBodyTransform transformToParentJointFrame;
        final int[] jointIndices;
        JointSourceMode sourceMode = JointSourceMode.EFFORT_SOURCE;
        private final Wrench jointWrench;
        private final DMatrixRMaj jointWrenchMatrix;
        private boolean isJointWrenchDirty = true;

        private ArticulatedBodyRecursionStep(RigidBodyReadOnly rigidBody, ArticulatedBodyRecursionStep parent, int[] jointIndices) {
            this.rigidBody = rigidBody;
            this.parent = parent;
            this.jointIndices = jointIndices;
            this.externalWrench = new Wrench((ReferenceFrame)this.getBodyFixedFrame(), this.getBodyFixedFrame());
            if (parent == null) {
                this.biasAcceleration = null;
                this.biasWrench = null;
                this.spatialInertia = null;
                this.articulatedInertia = null;
                this.articulatedBiasWrench = null;
                this.articulatedInertiaForParent = null;
                this.articulatedBiasWrenchForParent = null;
                this.rigidBodyAcceleration.setToZero(this.getBodyFixedFrame(), ForwardDynamicsCalculator.this.input.getInertialFrame(), this.getBodyFixedFrame());
                this.rigidBodyZeroVelocityAcceleration.setToZero(this.getBodyFixedFrame(), ForwardDynamicsCalculator.this.input.getInertialFrame(), this.getBodyFixedFrame());
                this.S = null;
                this.U = null;
                this.D = null;
                this.Dinv = null;
                this.U_Dinv = null;
                this.U_Dinv_UT = null;
                this.tau = null;
                this.u = null;
                this.c = null;
                this.pa = null;
                this.qdd = null;
                this.qdd_intermediate = null;
                this.a = null;
                this.inverseSolver = null;
                this.transformToParentJointFrame = null;
                this.jointWrench = null;
                this.jointWrenchMatrix = null;
            } else {
                parent.children.add(this);
                int nDoFs = this.getJoint().getDegreesOfFreedom();
                this.biasAcceleration = new SpatialAcceleration();
                this.biasWrench = new Wrench();
                this.spatialInertia = new SpatialInertia();
                this.articulatedInertia = new ArticulatedBodyInertia();
                this.articulatedBiasWrench = new SpatialForce();
                this.articulatedInertiaForParent = parent.isRoot() ? null : new ArticulatedBodyInertia();
                this.articulatedBiasWrenchForParent = parent.isRoot() ? null : new SpatialForce();
                this.S = new DMatrixRMaj(6, nDoFs);
                this.U = new DMatrixRMaj(6, nDoFs);
                this.D = new DMatrixRMaj(nDoFs, nDoFs);
                this.Dinv = new DMatrixRMaj(nDoFs, nDoFs);
                this.U_Dinv = new DMatrixRMaj(6, nDoFs);
                this.U_Dinv_UT = new DMatrixRMaj(6, 6);
                this.tau = new DMatrixRMaj(nDoFs, 1);
                this.u = new DMatrixRMaj(nDoFs, 1);
                this.c = new DMatrixRMaj(6, 1);
                this.pa = new DMatrixRMaj(6, 1);
                this.qdd = new DMatrixRMaj(nDoFs, 1);
                this.qdd_intermediate = new DMatrixRMaj(nDoFs, 1);
                this.a = new DMatrixRMaj(6, 1);
                this.inverseSolver = nDoFs == 6 ? LinearSolverFactory_DDRM.symmPosDef((int)6) : null;
                this.transformToParentJointFrame = new RigidBodyTransform();
                if (!this.getJoint().isMotionSubspaceVariable()) {
                    this.getJoint().getMotionSubspace((DMatrix1Row)this.S);
                }
                this.jointWrench = new Wrench();
                this.jointWrenchMatrix = new DMatrixRMaj(6, 1);
            }
        }

        private void updateIgnoredSubtreeInertia() {
            if (this.bodySubtreeInertia != null) {
                this.bodyInertia.setToZero();
                this.bodySubtreeInertia.setToZero();
            }
            if (!this.isRoot() && this.children.size() != this.rigidBody.getChildrenJoints().size()) {
                for (JointReadOnly jointReadOnly : this.rigidBody.getChildrenJoints()) {
                    if (!ForwardDynamicsCalculator.this.input.getJointsToIgnore().contains(jointReadOnly)) continue;
                    SpatialInertia subtreeInertia = MultiBodySystemTools.computeSubtreeInertia(jointReadOnly);
                    subtreeInertia.changeFrame(this.getBodyFixedFrame());
                    if (this.bodySubtreeInertia == null) {
                        this.bodyInertia = new SpatialInertia(this.getBodyFixedFrame(), this.getBodyFixedFrame());
                        this.bodySubtreeInertia = new SpatialInertia(this.getBodyFixedFrame(), this.getBodyFixedFrame());
                    }
                    this.bodySubtreeInertia.add(subtreeInertia);
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).updateIgnoredSubtreeInertia();
            }
        }

        public boolean passOne() {
            if (this.isRoot()) {
                this.rigidBodyZeroVelocityAcceleration.setIncludingFrame(this.rigidBodyAcceleration);
            } else {
                MovingReferenceFrame frameAfterJoint = this.getFrameAfterJoint();
                MovingReferenceFrame frameBeforeJoint = this.getJoint().getFrameBeforeJoint();
                if (this.parent.isRoot()) {
                    frameAfterJoint.getTransformToDesiredFrame(this.transformToParentJointFrame, this.parent.getBodyFixedFrame());
                } else {
                    frameAfterJoint.getTransformToDesiredFrame(this.transformToParentJointFrame, this.parent.getFrameAfterJoint());
                }
                if (this.bodyInertia != null) {
                    this.bodyInertia.setIncludingFrame(this.rigidBody.getInertia());
                    this.bodyInertia.add(this.bodySubtreeInertia);
                    this.bodyInertia.computeDynamicWrench(null, this.getBodyTwist(), this.biasWrench);
                } else {
                    this.rigidBody.getInertia().computeDynamicWrench(null, this.getBodyTwist(), this.biasWrench);
                }
                this.biasWrench.sub(this.externalWrench);
                this.biasWrench.changeFrame(frameAfterJoint);
                this.biasAcceleration.setToZero(frameAfterJoint, ForwardDynamicsCalculator.this.input.getInertialFrame(), frameBeforeJoint);
                this.biasAcceleration.changeFrame(frameAfterJoint, this.getJoint().getJointTwist(), frameAfterJoint.getTwistOfFrame());
                if (this.getJoint().isMotionSubspaceVariable()) {
                    this.biasAcceleration.add(this.getJoint().getJointBiasAcceleration());
                }
                this.biasAcceleration.get((DMatrix)this.c);
            }
            this.isJointWrenchDirty = true;
            boolean atLeastOneAccelSourceJoint = this.sourceMode == JointSourceMode.ACCELERATION_SOURCE;
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                atLeastOneAccelSourceJoint |= this.children.get(childIndex).passOne();
            }
            return atLeastOneAccelSourceJoint;
        }

        public void passTwo(DMatrix jointTauInput) {
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passTwo(jointTauInput);
            }
            if (this.isRoot()) {
                return;
            }
            MovingReferenceFrame frameAfterJoint = this.getFrameAfterJoint();
            if (this.bodyInertia != null) {
                this.spatialInertia.setIncludingFrame(this.bodyInertia);
            } else {
                this.spatialInertia.setIncludingFrame(this.rigidBody.getInertia());
            }
            this.spatialInertia.changeFrame(frameAfterJoint);
            this.articulatedInertia.setIncludingFrame(this.spatialInertia);
            this.articulatedBiasWrench.setIncludingFrame(this.biasWrench);
            this.articulatedBiasWrench.changeFrame(frameAfterJoint);
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                ArticulatedBodyRecursionStep child = this.children.get(childIndex);
                child.articulatedInertiaForParent.applyTransform(child.transformToParentJointFrame);
                child.articulatedBiasWrenchForParent.applyTransform((RigidBodyTransformReadOnly)child.transformToParentJointFrame);
                child.articulatedInertiaForParent.setReferenceFrame(frameAfterJoint);
                child.articulatedBiasWrenchForParent.setReferenceFrame(frameAfterJoint);
                this.articulatedInertia.add(child.articulatedInertiaForParent);
                this.articulatedBiasWrench.add(child.articulatedBiasWrenchForParent);
            }
            int nDoFs = this.getJoint().getDegreesOfFreedom();
            if (this.getJoint().isMotionSubspaceVariable()) {
                this.getJoint().getMotionSubspace((DMatrix1Row)this.S);
            }
            if (this.sourceMode == JointSourceMode.EFFORT_SOURCE) {
                ForwardDynamicsCalculator.mult(this.articulatedInertia, (DMatrix1Row)this.S, (DMatrix1Row)this.U);
                CommonOps_DDRM.multTransA((DMatrix1Row)this.S, (DMatrix1Row)this.U, (DMatrix1Row)this.D);
                if (nDoFs == 1) {
                    this.Dinv.set(0, 1.0 / this.D.get(0));
                } else if (nDoFs == 0) {
                    this.Dinv.reshape(0, 0);
                } else if (nDoFs <= 5) {
                    UnrolledInverseFromMinor_DDRM.inv((DMatrixRMaj)this.D, (DMatrixRMaj)this.Dinv);
                } else {
                    this.inverseSolver.setA((Matrix)this.D);
                    this.inverseSolver.invert((Matrix)this.Dinv);
                }
                if (jointTauInput != null) {
                    for (int dofIndex = 0; dofIndex < nDoFs; ++dofIndex) {
                        this.tau.set(dofIndex, 0, jointTauInput.get(this.jointIndices[dofIndex], 0));
                    }
                } else {
                    this.getJoint().getJointTau(0, (DMatrix)this.tau);
                }
                ForwardDynamicsCalculator.multTransA(-1.0, (DMatrix1Row)this.S, this.articulatedBiasWrench, (DMatrix1Row)this.u);
                CommonOps_DDRM.addEquals((DMatrixD1)this.u, (DMatrixD1)this.tau);
                if (!this.parent.isRoot()) {
                    CommonOps_DDRM.mult((DMatrix1Row)this.U, (DMatrix1Row)this.Dinv, (DMatrix1Row)this.U_Dinv);
                    CommonOps_DDRM.multTransB((DMatrix1Row)this.U_Dinv, (DMatrix1Row)this.U, (DMatrix1Row)this.U_Dinv_UT);
                    this.articulatedInertiaForParent.setIncludingFrame(this.articulatedInertia);
                    this.articulatedInertiaForParent.sub((DMatrix)this.U_Dinv_UT);
                    this.articulatedBiasWrench.get((DMatrix)this.pa);
                    ForwardDynamicsCalculator.multAdd(this.articulatedInertiaForParent, (DMatrix1Row)this.c, (DMatrix1Row)this.pa);
                    CommonOps_DDRM.multAdd((DMatrix1Row)this.U_Dinv, (DMatrix1Row)this.u, (DMatrix1Row)this.pa);
                    this.articulatedBiasWrenchForParent.setIncludingFrame(frameAfterJoint, (DMatrix)this.pa);
                }
            } else if (!this.parent.isRoot()) {
                this.articulatedInertiaForParent.setIncludingFrame(this.articulatedInertia);
                this.articulatedBiasWrench.get((DMatrix)this.pa);
                ForwardDynamicsCalculator.multAdd(this.articulatedInertiaForParent, (DMatrix1Row)this.c, (DMatrix1Row)this.pa);
                this.getJoint().getJointAcceleration().get((DMatrix)this.a);
                ForwardDynamicsCalculator.multAdd(this.articulatedInertiaForParent, (DMatrix1Row)this.a, (DMatrix1Row)this.pa);
                this.articulatedBiasWrenchForParent.setIncludingFrame(frameAfterJoint, (DMatrix)this.pa);
            }
        }

        public void passThree(DMatrix jointAccelerationInput) {
            if (!this.isRoot()) {
                this.rigidBodyZeroVelocityAcceleration.setIncludingFrame(this.parent.rigidBodyZeroVelocityAcceleration);
                this.rigidBodyZeroVelocityAcceleration.applyInverseTransform((RigidBodyTransformReadOnly)this.transformToParentJointFrame);
                this.rigidBodyZeroVelocityAcceleration.setBodyFrame(this.getBodyFixedFrame());
                this.rigidBodyZeroVelocityAcceleration.setBaseFrame(ForwardDynamicsCalculator.this.input.getInertialFrame());
                this.rigidBodyZeroVelocityAcceleration.setReferenceFrame(this.getFrameAfterJoint());
                this.rigidBodyAcceleration.setIncludingFrame(this.parent.rigidBodyAcceleration);
                this.rigidBodyAcceleration.applyInverseTransform((RigidBodyTransformReadOnly)this.transformToParentJointFrame);
                this.rigidBodyAcceleration.setReferenceFrame(this.getFrameAfterJoint());
                this.rigidBodyAcceleration.add(this.biasAcceleration);
                int nDoFs = this.getJoint().getDegreesOfFreedom();
                if (this.sourceMode == JointSourceMode.EFFORT_SOURCE) {
                    ForwardDynamicsCalculator.multTransA(-1.0, (DMatrix1Row)this.U, this.rigidBodyAcceleration, (DMatrix1Row)this.qdd_intermediate);
                    CommonOps_DDRM.addEquals((DMatrixD1)this.qdd_intermediate, (DMatrixD1)this.u);
                    CommonOps_DDRM.mult((DMatrix1Row)this.Dinv, (DMatrix1Row)this.qdd_intermediate, (DMatrix1Row)this.qdd);
                } else if (jointAccelerationInput != null) {
                    for (int dofIndex = 0; dofIndex < nDoFs; ++dofIndex) {
                        this.qdd.set(dofIndex, 0, jointAccelerationInput.get(this.jointIndices[dofIndex], 0));
                    }
                } else {
                    this.getJoint().getJointAcceleration(0, (DMatrix)this.qdd);
                }
                CommonOps_DDRM.mult((DMatrix1Row)this.S, (DMatrix1Row)this.qdd, (DMatrix1Row)this.a);
                this.rigidBodyZeroVelocityAcceleration.add((DMatrix)this.a);
                ForwardDynamicsCalculator.addEquals((DMatrixD1)this.a, this.rigidBodyAcceleration);
                this.rigidBodyAcceleration.setIncludingFrame(this.getBodyFixedFrame(), ForwardDynamicsCalculator.this.input.getInertialFrame(), this.getFrameAfterJoint(), (DMatrix)this.a);
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passThree(jointAccelerationInput);
            }
        }

        public void passFour() {
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passFour();
            }
            if (this.isRoot()) {
                return;
            }
            if (this.sourceMode == JointSourceMode.ACCELERATION_SOURCE) {
                this.getJointWrench().get((DMatrix)this.jointWrenchMatrix);
                CommonOps_DDRM.multTransA((DMatrix1Row)this.S, (DMatrix1Row)this.jointWrenchMatrix, (DMatrix1Row)this.tau);
            }
        }

        private WrenchReadOnly getJointWrench() {
            if (this.isJointWrenchDirty) {
                if (!this.isRoot()) {
                    SpatialInertiaReadOnly inertia;
                    MovingReferenceFrame frameAfterJoint = this.getFrameAfterJoint();
                    this.rigidBodyAcceleration.changeFrame(this.getBodyFixedFrame());
                    SpatialInertiaReadOnly spatialInertiaReadOnly = inertia = this.bodyInertia == null ? this.rigidBody.getInertia() : this.bodyInertia;
                    if (inertia.isCenterOfMassOffsetZero()) {
                        inertia.computeDynamicWrench(this.rigidBodyAcceleration, null, this.jointWrench);
                        this.jointWrench.changeFrame(frameAfterJoint);
                        this.jointWrench.add(this.biasWrench);
                    } else {
                        inertia.computeDynamicWrench(this.rigidBodyAcceleration, this.getBodyTwist(), this.jointWrench);
                        this.jointWrench.sub(this.externalWrench);
                        this.jointWrench.changeFrame(frameAfterJoint);
                    }
                    for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                        this.addJointWrenchFromChild(this.children.get(childIndex));
                    }
                }
                this.isJointWrenchDirty = false;
            }
            return this.jointWrench;
        }

        private void addJointWrenchFromChild(ArticulatedBodyRecursionStep child) {
            ForwardDynamicsCalculator.this.jointForceFromChild.setIncludingFrame(child.getJointWrench());
            ForwardDynamicsCalculator.this.jointForceFromChild.changeFrame(this.getFrameAfterJoint());
            this.jointWrench.add(ForwardDynamicsCalculator.this.jointForceFromChild);
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public MovingReferenceFrame getBodyFixedFrame() {
            return this.rigidBody.getBodyFixedFrame();
        }

        public MovingReferenceFrame getFrameAfterJoint() {
            return this.getJoint().getFrameAfterJoint();
        }

        public JointReadOnly getJoint() {
            return this.rigidBody.getParentJoint();
        }

        public TwistReadOnly getBodyTwist() {
            return this.getBodyFixedFrame().getTwistOfFrame();
        }

        public void getAccelerationOutput(DMatrix allJointAccelerationMatrix) {
            if (this.isRoot()) {
                return;
            }
            int nDoFs = this.getJoint().getDegreesOfFreedom();
            for (int dofIndex = 0; dofIndex < nDoFs; ++dofIndex) {
                allJointAccelerationMatrix.set(this.jointIndices[dofIndex], 0, this.qdd.get(dofIndex, 0));
            }
        }

        public void getTauOutput(DMatrix allJointTauMatrix) {
            if (this.isRoot()) {
                return;
            }
            int nDoFs = this.getJoint().getDegreesOfFreedom();
            for (int dofIndex = 0; dofIndex < nDoFs; ++dofIndex) {
                allJointTauMatrix.set(this.jointIndices[dofIndex], 0, this.tau.get(dofIndex, 0));
            }
        }

        public String toString() {
            return "RigidBody: " + String.valueOf(this.rigidBody) + ", parent: " + String.valueOf(this.parent.rigidBody) + ", children: " + String.valueOf(Arrays.asList(this.children.stream().map(c -> c.rigidBody).toArray()));
        }
    }

    public static enum JointSourceMode {
        EFFORT_SOURCE,
        ACCELERATION_SOURCE;

    }
}

