/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.FixedJoint;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.PlanarJoint;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteTwinsJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.SphericalJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FixedJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FixedJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PrismaticJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteTwinsJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteTwinsJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodySystemFactories {
    public static final JointBuilder DEFAULT_JOINT_BUILDER = new JointBuilder(){};
    public static final RigidBodyBuilder DEFAULT_RIGID_BODY_BUILDER = new RigidBodyBuilder(){};

    public static OneDoFJointBasics[] cloneOneDoFJointKinematicChain(RigidBodyBasics start, RigidBodyBasics end) {
        return (OneDoFJointBasics[])MultiBodySystemFactories.cloneKinematicChainAndFilter((JointReadOnly[])MultiBodySystemTools.createOneDoFJointPath(start, end), OneDoFJointBasics.class);
    }

    public static OneDoFJointBasics[] cloneOneDoFJointKinematicChain(OneDoFJointBasics[] originalJoints) {
        return (OneDoFJointBasics[])MultiBodySystemFactories.cloneKinematicChainAndFilter((JointReadOnly[])originalJoints, OneDoFJointBasics.class);
    }

    public static <T extends JointReadOnly> T[] cloneKinematicChainAndFilter(T[] originalJoints, Class<T> clazz) {
        return MultiBodySystemTools.filterJoints((JointReadOnly[])MultiBodySystemFactories.cloneKinematicChain(originalJoints), clazz);
    }

    public static <T extends JointReadOnly> T[] cloneKinematicChainAndFilter(T[] originalJoints, Class<T> clazz, String cloneSuffix) {
        return MultiBodySystemTools.filterJoints((JointReadOnly[])MultiBodySystemFactories.cloneKinematicChain(originalJoints, cloneSuffix), clazz);
    }

    public static JointBasics[] cloneKinematicChain(JointReadOnly[] originalJoints) {
        return MultiBodySystemFactories.cloneKinematicChain(originalJoints, "Copy");
    }

    public static JointBasics[] cloneKinematicChain(JointReadOnly[] originalJoints, String cloneSuffix) {
        return MultiBodySystemFactories.cloneKinematicChain(originalJoints, cloneSuffix, null);
    }

    public static JointBasics[] cloneKinematicChain(JointReadOnly[] originalJoints, String cloneSuffix, ReferenceFrame chainRootFrame) {
        return MultiBodySystemFactories.cloneKinematicChain(originalJoints, cloneSuffix, chainRootFrame, DEFAULT_RIGID_BODY_BUILDER, DEFAULT_JOINT_BUILDER);
    }

    public static JointBasics[] cloneKinematicChain(JointReadOnly[] originalJoints, String cloneSuffix, ReferenceFrame chainRootFrame, RigidBodyBuilder rigidBodyBuilder, JointBuilder jointBuilder) {
        if (!MultiBodySystemTools.areJointsInContinuousOrder(originalJoints)) {
            throw new IllegalArgumentException("The given joints do not represent a continuous kinematic chain or are out of order: " + Arrays.toString(originalJoints));
        }
        JointBasics[] cloneJoints = new JointBasics[originalJoints.length];
        HashMap<RigidBodyReadOnly, RigidBodyBasics> originalToCloneBodyMap = new HashMap<RigidBodyReadOnly, RigidBodyBasics>();
        RigidBodyReadOnly originalAncestor = originalJoints[0].getPredecessor();
        RigidBodyBasics cloneAncestor = originalAncestor.isRootBody() ? rigidBodyBuilder.cloneRigidBody(originalAncestor, chainRootFrame, cloneSuffix, null) : (chainRootFrame != null ? new RigidBody(originalAncestor.getName() + cloneSuffix, chainRootFrame) : new RigidBody(originalAncestor.getName() + cloneSuffix, originalAncestor.getParentJoint().getFrameAfterJoint()));
        originalToCloneBodyMap.put(originalAncestor, cloneAncestor);
        for (int jointIndex = 0; jointIndex < originalJoints.length; ++jointIndex) {
            JointReadOnly originalJoint = originalJoints[jointIndex];
            if (originalJoint.isLoopClosure()) {
                throw new UnsupportedOperationException("Cloning loop closure joints is not supported.");
            }
            RigidBodyReadOnly originalPredecessor = originalJoint.getPredecessor();
            RigidBodyBasics clonePredecessor = (RigidBodyBasics)originalToCloneBodyMap.get(originalPredecessor);
            JointBasics cloneJoint = jointBuilder.cloneJoint(originalJoint, cloneSuffix, clonePredecessor);
            RigidBodyReadOnly originalSuccessor = originalJoint.getSuccessor();
            RigidBodyBasics cloneSuccessor = rigidBodyBuilder.cloneRigidBody(originalSuccessor, null, cloneSuffix, cloneJoint);
            originalToCloneBodyMap.put(originalSuccessor, cloneSuccessor);
            cloneJoints[jointIndex] = cloneJoint;
        }
        return cloneJoints;
    }

    public static RigidBodyBasics cloneMultiBodySystem(RigidBodyReadOnly originalRootBody, ReferenceFrame cloneStationaryFrame, String cloneSuffix) {
        return MultiBodySystemFactories.cloneMultiBodySystem(originalRootBody, cloneStationaryFrame, cloneSuffix, null, null);
    }

    public static RigidBodyBasics cloneMultiBodySystem(RigidBodyReadOnly originalRootBody, ReferenceFrame cloneStationaryFrame, String cloneSuffix, RigidBodyBuilder rigidBodyBuilder, JointBuilder jointBuilder) {
        if (!originalRootBody.isRootBody()) {
            throw new IllegalArgumentException("The given rigid-body is not the root-body of its multi-body system: " + originalRootBody.getName());
        }
        if (rigidBodyBuilder == null) {
            rigidBodyBuilder = DEFAULT_RIGID_BODY_BUILDER;
        }
        RigidBodyBasics cloneSubtreeStartBody = rigidBodyBuilder.cloneRigidBody(originalRootBody, cloneStationaryFrame, cloneSuffix, null);
        MultiBodySystemFactories.cloneSubtree(originalRootBody, cloneSubtreeStartBody, cloneSuffix, rigidBodyBuilder, jointBuilder);
        return cloneSubtreeStartBody;
    }

    public static RigidBodyBasics cloneSubtree(RigidBodyReadOnly originalSubtreeStartBody, String cloneSuffix) {
        return MultiBodySystemFactories.cloneSubtree(originalSubtreeStartBody, cloneSuffix, null, null);
    }

    public static RigidBodyBasics cloneSubtree(RigidBodyReadOnly originalSubtreeStartBody, String cloneSuffix, RigidBodyBuilder rigidBodyBuilder, JointBuilder jointBuilder) {
        if (originalSubtreeStartBody.isRootBody()) {
            throw new IllegalArgumentException("originalSubtreeStartBody is a root body of its multi-body system, use MultiBodyFactories.cloneMultiBodySystem(...) instead");
        }
        if (rigidBodyBuilder == null) {
            rigidBodyBuilder = DEFAULT_RIGID_BODY_BUILDER;
        }
        RigidBodyBasics cloneSubtreeStartBody = rigidBodyBuilder.buildRoot(originalSubtreeStartBody.getName() + cloneSuffix, (RigidBodyTransformReadOnly)new RigidBodyTransform(), originalSubtreeStartBody.getParentJoint().getFrameAfterJoint());
        MultiBodySystemFactories.cloneSubtree(originalSubtreeStartBody, cloneSubtreeStartBody, cloneSuffix, rigidBodyBuilder, jointBuilder);
        return cloneSubtreeStartBody;
    }

    private static void cloneSubtree(RigidBodyReadOnly originalStart, RigidBodyBasics cloneStart, String cloneSuffix, RigidBodyBuilder rigidBodyBuilder, JointBuilder jointBuilder) {
        if (rigidBodyBuilder == null) {
            rigidBodyBuilder = DEFAULT_RIGID_BODY_BUILDER;
        }
        if (jointBuilder == null) {
            jointBuilder = DEFAULT_JOINT_BUILDER;
        }
        HashMap<RigidBodyReadOnly, RigidBodyBasics> originalToCloneBodyMap = new HashMap<RigidBodyReadOnly, RigidBodyBasics>();
        originalToCloneBodyMap.put(originalStart, cloneStart);
        ArrayList<JointBasics> loopClosureCloneJoints = new ArrayList<JointBasics>();
        ArrayList<JointReadOnly> loopClosureOriginalJoints = new ArrayList<JointReadOnly>();
        for (JointReadOnly jointReadOnly : originalStart.childrenSubtreeIterable()) {
            RigidBodyReadOnly originalPredecessor = jointReadOnly.getPredecessor();
            RigidBodyBasics clonePredecessor = (RigidBodyBasics)originalToCloneBodyMap.get(originalPredecessor);
            JointBasics cloneJoint = jointBuilder.cloneJoint(jointReadOnly, cloneSuffix, clonePredecessor);
            if (jointReadOnly.isLoopClosure()) {
                loopClosureCloneJoints.add(cloneJoint);
                loopClosureOriginalJoints.add(jointReadOnly);
                continue;
            }
            RigidBodyReadOnly originalSuccessor = jointReadOnly.getSuccessor();
            RigidBodyBasics cloneSuccessor = rigidBodyBuilder.cloneRigidBody(originalSuccessor, null, cloneSuffix, cloneJoint);
            originalToCloneBodyMap.put(originalSuccessor, cloneSuccessor);
        }
        for (int loopClosureIndex = 0; loopClosureIndex < loopClosureCloneJoints.size(); ++loopClosureIndex) {
            JointBasics jointBasics = (JointBasics)loopClosureCloneJoints.get(loopClosureIndex);
            JointReadOnly originalJoint = (JointReadOnly)loopClosureOriginalJoints.get(loopClosureIndex);
            RigidBodyBasics cloneSuccessor = (RigidBodyBasics)originalToCloneBodyMap.get(originalJoint.getSuccessor());
            RigidBodyTransform cloneTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)originalJoint.getLoopClosureFrame().getTransformToParent());
            cloneTransform.invert();
            jointBasics.setupLoopClosure(cloneSuccessor, (RigidBodyTransformReadOnly)cloneTransform);
        }
    }

    public static interface RigidBodyBuilder {
        default public RigidBodyBasics buildRoot(String bodyName, RigidBodyTransformReadOnly transformToParent, ReferenceFrame parentStationaryFrame) {
            return new RigidBody(bodyName, transformToParent, parentStationaryFrame);
        }

        default public RigidBodyBasics build(String bodyName, JointBasics parentJoint, Matrix3DReadOnly momentOfInertia, double mass, RigidBodyTransformReadOnly inertiaPose) {
            return new RigidBody(bodyName, parentJoint, momentOfInertia, mass, inertiaPose);
        }

        default public RigidBodyBasics cloneRigidBody(RigidBodyReadOnly original, ReferenceFrame cloneStationaryFrame, String cloneSuffix, JointBasics parentJointOfClone) {
            if (original.isRootBody() && parentJointOfClone != null) {
                throw new IllegalArgumentException("Inconsistent set of arguments. If the original body is the root body, the parent joint should be null.");
            }
            String nameOriginal = original.getName();
            if (parentJointOfClone == null) {
                MovingReferenceFrame originalBodyFixedFrame = original.getBodyFixedFrame();
                if (cloneStationaryFrame == null) {
                    cloneStationaryFrame = originalBodyFixedFrame;
                }
                return this.buildRoot(nameOriginal + cloneSuffix, (RigidBodyTransformReadOnly)originalBodyFixedFrame.getTransformToParent(), cloneStationaryFrame);
            }
            SpatialInertiaReadOnly originalInertia = original.getInertia();
            double mass = originalInertia.getMass();
            Matrix3DReadOnly momentOfInertia = originalInertia.getMomentOfInertia();
            RigidBodyTransform inertiaPose = new RigidBodyTransform((RigidBodyTransformReadOnly)original.getBodyFixedFrame().getTransformToParent());
            RigidBodyBasics clone = this.build(nameOriginal + cloneSuffix, parentJointOfClone, momentOfInertia, mass, (RigidBodyTransformReadOnly)inertiaPose);
            clone.getInertia().getCenterOfMassOffset().set((Tuple3DReadOnly)originalInertia.getCenterOfMassOffset());
            return clone;
        }
    }

    public static interface JointBuilder {
        default public JointBasics buildJoint(Class<? extends JointReadOnly> jointType, String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
            if (SixDoFJointReadOnly.class.isAssignableFrom(jointType)) {
                return this.buildSixDoFJoint(name, predecessor, transformToParent);
            }
            if (PlanarJointReadOnly.class.isAssignableFrom(jointType)) {
                return this.buildPlanarJoint(name, predecessor, transformToParent);
            }
            if (SphericalJointReadOnly.class.isAssignableFrom(jointType)) {
                return this.buildSphericalJoint(name, predecessor, transformToParent);
            }
            if (FixedJointReadOnly.class.isAssignableFrom(jointType)) {
                return this.buildFixedJoint(name, predecessor, transformToParent);
            }
            return null;
        }

        default public OneDoFJointBasics buildOneDoFJoint(Class<? extends OneDoFJointReadOnly> jointType, String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, Vector3DReadOnly jointAxis) {
            if (RevoluteJointBasics.class.isAssignableFrom(jointType)) {
                return this.buildRevoluteJoint(name, predecessor, transformToParent, jointAxis);
            }
            if (PrismaticJointBasics.class.isAssignableFrom(jointType)) {
                return this.buildPrismaticJoint(name, predecessor, transformToParent, jointAxis);
            }
            return null;
        }

        default public SixDoFJointBasics buildSixDoFJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
            return new SixDoFJoint(name, predecessor, transformToParent);
        }

        default public PlanarJointBasics buildPlanarJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
            return new PlanarJoint(name, predecessor, transformToParent);
        }

        default public SphericalJointBasics buildSphericalJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
            return new SphericalJoint(name, predecessor, transformToParent);
        }

        default public RevoluteJointBasics buildRevoluteJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, Vector3DReadOnly jointAxis) {
            return new RevoluteJoint(name, predecessor, transformToParent, jointAxis);
        }

        default public PrismaticJointBasics buildPrismaticJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, Vector3DReadOnly jointAxis) {
            return new PrismaticJoint(name, predecessor, transformToParent, jointAxis);
        }

        default public FixedJointBasics buildFixedJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
            return new FixedJoint(name, predecessor, transformToParent);
        }

        default public JointBasics cloneJoint(JointReadOnly original, String cloneSuffix, RigidBodyBasics clonePredecessor) {
            if (original instanceof OneDoFJointReadOnly) {
                return this.cloneOneDoFJoint((OneDoFJointReadOnly)original, cloneSuffix, clonePredecessor);
            }
            String jointNameOriginal = original.getName();
            RigidBodyTransform jointTransform = this.cloneJointTransformToParent(original);
            JointBasics clone = this.buildJoint(original.getClass(), jointNameOriginal + cloneSuffix, clonePredecessor, (RigidBodyTransformReadOnly)jointTransform);
            if (clone == null) {
                throw new UnsupportedOperationException("Unhandled joint type: " + original.getClass().getName());
            }
            return clone;
        }

        default public OneDoFJointBasics cloneOneDoFJoint(OneDoFJointReadOnly original, String cloneSuffix, RigidBodyBasics clonePredecessor) {
            OneDoFJointBasics clone = original instanceof CrossFourBarJointReadOnly ? this.cloneCrossFourBarJoint((CrossFourBarJointReadOnly)original, cloneSuffix, clonePredecessor) : (original instanceof RevoluteTwinsJointReadOnly ? this.cloneRevoluteTwinsJoint((RevoluteTwinsJointReadOnly)original, cloneSuffix, clonePredecessor) : this.buildOneDoFJoint(original.getClass(), original.getName() + cloneSuffix, clonePredecessor, (RigidBodyTransformReadOnly)this.cloneJointTransformToParent(original), (Vector3DReadOnly)original.getJointAxis()));
            if (clone == null) {
                throw new RuntimeException("Unhandled type of " + OneDoFJoint.class.getSimpleName() + ": " + original.getClass().getSimpleName());
            }
            clone.setJointLimits(original.getJointLimitLower(), original.getJointLimitUpper());
            clone.setVelocityLimits(original.getVelocityLimitLower(), original.getVelocityLimitUpper());
            clone.setEffortLimits(original.getEffortLimitLower(), original.getEffortLimitUpper());
            return clone;
        }

        default public CrossFourBarJointBasics cloneCrossFourBarJoint(CrossFourBarJointReadOnly original, String cloneSuffix, RigidBodyBasics clonePredecessor) {
            RevoluteJointReadOnly originalJointA = original.getJointA();
            RevoluteJointReadOnly originalJointB = original.getJointB();
            RevoluteJointReadOnly originalJointC = original.getJointC();
            RevoluteJointReadOnly originalJointD = original.getJointD();
            RigidBodyReadOnly originalBodyDA = originalJointA.getSuccessor();
            RigidBodyReadOnly originalBodyBC = originalJointB.getSuccessor();
            int loopClosureIndex = originalJointA.isLoopClosure() ? 0 : (originalJointB.isLoopClosure() ? 1 : (originalJointC.isLoopClosure() ? 2 : 3));
            return new CrossFourBarJoint(original.getName() + cloneSuffix, clonePredecessor, originalJointA.getName() + cloneSuffix, originalJointB.getName() + cloneSuffix, originalJointC.getName() + cloneSuffix, originalJointD.getName() + cloneSuffix, originalBodyDA.getName() + cloneSuffix, originalBodyBC.getName() + cloneSuffix, (RigidBodyTransformReadOnly)originalJointA.getFrameBeforeJoint().getTransformToParent(), (RigidBodyTransformReadOnly)originalJointB.getFrameBeforeJoint().getTransformToParent(), (RigidBodyTransformReadOnly)originalJointD.getFrameBeforeJoint().getTransformToParent(), (RigidBodyTransformReadOnly)originalJointC.getFrameBeforeJoint().getTransformToParent(), originalBodyDA.getInertia().getMomentOfInertia(), originalBodyBC.getInertia().getMomentOfInertia(), originalBodyDA.getInertia().getMass(), originalBodyBC.getInertia().getMass(), (RigidBodyTransformReadOnly)originalBodyDA.getBodyFixedFrame().getTransformToParent(), (RigidBodyTransformReadOnly)originalBodyBC.getBodyFixedFrame().getTransformToParent(), original.getActuatedJointIndex(), loopClosureIndex, (Vector3DReadOnly)original.getJointAxis());
        }

        default public RevoluteTwinsJointBasics cloneRevoluteTwinsJoint(RevoluteTwinsJointReadOnly original, String cloneSuffix, RigidBodyBasics clonePredecessor) {
            RevoluteJointReadOnly originalJointA = original.getJointA();
            RevoluteJointReadOnly originalJointB = original.getJointB();
            RigidBodyReadOnly originalBodyAB = originalJointA.getSuccessor();
            return new RevoluteTwinsJoint(original.getName() + cloneSuffix, clonePredecessor, originalJointA.getName() + cloneSuffix, originalJointB.getName() + cloneSuffix, originalBodyAB.getName() + cloneSuffix, (RigidBodyTransformReadOnly)originalJointA.getFrameBeforeJoint().getTransformToParent(), (RigidBodyTransformReadOnly)originalJointB.getFrameBeforeJoint().getTransformToParent(), originalBodyAB.getInertia().getMomentOfInertia(), originalBodyAB.getInertia().getMass(), (RigidBodyTransformReadOnly)originalBodyAB.getBodyFixedFrame().getTransformToParent(), original.getActuatedJointIndex(), original.getConstraintRatio(), original.getConstraintOffset(), (Vector3DReadOnly)original.getJointAxis());
        }

        default public RigidBodyTransform cloneJointTransformToParent(JointReadOnly original) {
            if (original.getFrameBeforeJoint() == original.getPredecessor().getBodyFixedFrame()) {
                return null;
            }
            return original.getFrameBeforeJoint().getTransformToParent();
        }
    }
}

