/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialMotionBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;

public interface SpatialMotionBasics
extends FixedFrameSpatialMotionBasics,
SpatialVectorBasics {
    public void setBodyFrame(ReferenceFrame var1);

    public void setBaseFrame(ReferenceFrame var1);

    default public void setToZero(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setToZero(expressedInFrame);
    }

    default public void setToNaN(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setToNaN(expressedInFrame);
    }

    default public void setIncludingFrame(ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart, Point3DReadOnly observerPosition) {
        this.setReferenceFrame(expressedInFrame);
        this.set(angularPart, linearPart, observerPosition);
    }

    default public void setIncludingFrame(FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart, FramePoint3DReadOnly observerPosition) {
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)observerPosition);
        this.setIncludingFrame(angularPart.getReferenceFrame(), (Vector3DReadOnly)angularPart, (Vector3DReadOnly)linearPart, (Point3DReadOnly)observerPosition);
    }

    default public void setIncludingFrame(SpatialMotionReadOnly other) {
        this.setIncludingFrame(other.getBodyFrame(), other.getBaseFrame(), other.getReferenceFrame(), (Vector3DReadOnly)other.getAngularPart(), (Vector3DReadOnly)other.getLinearPart());
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, SpatialVectorReadOnly spatialVector) {
        this.setIncludingFrame(bodyFrame, baseFrame, spatialVector.getReferenceFrame(), (Vector3DReadOnly)spatialVector.getAngularPart(), (Vector3DReadOnly)spatialVector.getLinearPart());
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
        this.setIncludingFrame(bodyFrame, baseFrame, angularPart.getReferenceFrame(), (Vector3DReadOnly)angularPart, (Vector3DReadOnly)linearPart);
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setIncludingFrame(expressedInFrame, angularPart, linearPart);
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, double[] array) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setIncludingFrame(expressedInFrame, array);
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, int startIndex, double[] array) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setIncludingFrame(expressedInFrame, startIndex, array);
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, float[] array) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setIncludingFrame(expressedInFrame, array);
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, int startIndex, float[] array) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setIncludingFrame(expressedInFrame, startIndex, array);
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, DMatrix matrix) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setIncludingFrame(expressedInFrame, matrix);
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, int startRow, DMatrix matrix) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setIncludingFrame(expressedInFrame, startRow, matrix);
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, int startRow, int column, DMatrix matrix) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setIncludingFrame(expressedInFrame, startRow, column, matrix);
    }

    default public void invert() {
        this.negate();
        ReferenceFrame oldBaseFrame = this.getBaseFrame();
        this.setBaseFrame(this.getBodyFrame());
        this.setBodyFrame(oldBaseFrame);
    }
}

