/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class RigidBodyTwistCalculator
implements RigidBodyTwistProvider {
    private final MultiBodySystemReadOnly input;
    private final RigidBodyTwistHolder root;
    private final Map<RigidBodyReadOnly, RigidBodyTwistHolder> rigidBodyTwistHolders = new HashMap<RigidBodyReadOnly, RigidBodyTwistHolder>();
    private JointVelocityAccessor jointVelocityAccessor;
    private RigidBodyTwistProvider provider;

    public RigidBodyTwistCalculator(MultiBodySystemReadOnly input) {
        this.input = input;
        this.root = new RigidBodyTwistHolder(null, input.getRootBody());
        this.rigidBodyTwistHolders.put(input.getRootBody(), this.root);
        this.buildTree(this.root, input.getJointsToIgnore());
        this.provider = RigidBodyTwistProvider.toRigidBodyTwistProvider(this::getTwistOfBody, this.getInertialFrame());
    }

    private void buildTree(RigidBodyTwistHolder parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        List<? extends JointReadOnly> childrenJoints = parent.body.getChildrenJoints();
        for (JointReadOnly jointReadOnly : childrenJoints) {
            RigidBodyReadOnly childBody;
            if (jointsToIgnore.contains(jointReadOnly) || (childBody = jointReadOnly.getSuccessor()) == null) continue;
            RigidBodyTwistHolder childHolder = new RigidBodyTwistHolder(parent, childBody);
            parent.children.add(childHolder);
            this.rigidBodyTwistHolders.put(childBody, childHolder);
            this.buildTree(childHolder, jointsToIgnore);
        }
    }

    public void reset() {
        this.root.reset();
    }

    public void useJointVelocityState() {
        this.setJointVelocityAccessor((joint, matrixToPack) -> joint.getJointVelocity(0, matrixToPack));
    }

    public void useAllJointVelocityMatrix(DMatrix jointVelocities) {
        this.setJointVelocityAccessor((joint, matrixToPack) -> {
            int[] jointDoFIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(joint);
            for (int i = 0; i < jointDoFIndices.length; ++i) {
                matrixToPack.set(i, 0, jointVelocities.get(jointDoFIndices[i], 0));
            }
        });
    }

    public void setJointVelocityAccessor(JointVelocityAccessor jointVelocityAccessor) {
        this.root.reset();
        this.jointVelocityAccessor = jointVelocityAccessor;
    }

    @Override
    public TwistReadOnly getTwistOfBody(RigidBodyReadOnly body) {
        RigidBodyTwistHolder holder = this.rigidBodyTwistHolders.get(body);
        if (holder == null) {
            return null;
        }
        return holder.getTwist();
    }

    @Override
    public TwistReadOnly getRelativeTwist(RigidBodyReadOnly base, RigidBodyReadOnly body) {
        return this.provider.getRelativeTwist(base, body);
    }

    @Override
    public FrameVector3DReadOnly getLinearVelocityOfBodyFixedPoint(RigidBodyReadOnly base, RigidBodyReadOnly body, FramePoint3DReadOnly bodyFixedPoint) {
        return this.provider.getLinearVelocityOfBodyFixedPoint(base, body, bodyFixedPoint);
    }

    @Override
    public ReferenceFrame getInertialFrame() {
        return this.input.getInertialFrame();
    }

    private class RigidBodyTwistHolder {
        private final RigidBodyReadOnly body;
        private final Twist twist = new Twist();
        private final RigidBodyTwistHolder parent;
        private final List<RigidBodyTwistHolder> children = new ArrayList<RigidBodyTwistHolder>();
        private boolean dirty = true;
        private final DMatrixRMaj jointTwistMatrix;
        private final DMatrixRMaj jointVelocityMatrix;
        private final DMatrixRMaj jointMotionSubspaceMatrix;

        public RigidBodyTwistHolder(RigidBodyTwistHolder parent, RigidBodyReadOnly body) {
            this.parent = parent;
            this.body = body;
            if (parent == null) {
                this.jointTwistMatrix = null;
                this.jointVelocityMatrix = null;
                this.jointMotionSubspaceMatrix = null;
                this.twist.setToZero(body.getBodyFixedFrame(), RigidBodyTwistCalculator.this.getInertialFrame(), body.getBodyFixedFrame());
            } else {
                this.jointTwistMatrix = new DMatrixRMaj(6, 1);
                int nDoFs = body.getParentJoint().getDegreesOfFreedom();
                this.jointVelocityMatrix = new DMatrixRMaj(nDoFs, 1);
                this.jointMotionSubspaceMatrix = new DMatrixRMaj(6, nDoFs);
            }
        }

        public void reset() {
            this.dirty = true;
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).reset();
            }
        }

        public TwistReadOnly getTwist() {
            if (RigidBodyTwistCalculator.this.jointVelocityAccessor == null) {
                throw new IllegalStateException("Joint velocity accessor has not been set.");
            }
            if (this.dirty) {
                if (this.parent == null) {
                    this.twist.setToZero(this.body.getBodyFixedFrame(), RigidBodyTwistCalculator.this.getInertialFrame(), this.body.getBodyFixedFrame());
                } else {
                    JointReadOnly joint = this.body.getParentJoint();
                    this.twist.setIncludingFrame(this.parent.getTwist());
                    this.twist.changeFrame(joint.getFrameAfterJoint());
                    RigidBodyTwistCalculator.this.jointVelocityAccessor.getJointVelocity(joint, (DMatrix)this.jointVelocityMatrix);
                    joint.getMotionSubspace((DMatrix1Row)this.jointMotionSubspaceMatrix);
                    CommonOps_DDRM.mult((DMatrix1Row)this.jointMotionSubspaceMatrix, (DMatrix1Row)this.jointVelocityMatrix, (DMatrix1Row)this.jointTwistMatrix);
                    this.twist.add((DMatrix)this.jointTwistMatrix);
                    this.twist.changeFrame(this.body.getBodyFixedFrame());
                    this.twist.setBodyFrame(this.body.getBodyFixedFrame());
                }
                this.dirty = false;
            }
            return this.twist;
        }
    }

    public static interface JointVelocityAccessor {
        public void getJointVelocity(JointReadOnly var1, DMatrix var2);
    }
}

