/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;

public interface JointMatrixIndexProvider {
    public List<? extends JointReadOnly> getIndexedJointsInOrder();

    public int[] getJointDoFIndices(JointReadOnly var1);

    public int[] getJointConfigurationIndices(JointReadOnly var1);

    public static JointMatrixIndexProvider toIndexProvider(JointReadOnly[] jointsToIndex) {
        return JointMatrixIndexProvider.toIndexProvider(Arrays.asList(jointsToIndex));
    }

    public static JointMatrixIndexProvider toIndexProvider(Collection<? extends JointReadOnly> jointsToIndex) {
        final ArrayList<? extends JointReadOnly> indexedJointsInOrder = new ArrayList<JointReadOnly>(jointsToIndex);
        final HashMap<JointReadOnly, int[]> jointToDoFIndexMap = new HashMap<JointReadOnly, int[]>();
        final HashMap<JointReadOnly, int[]> jointToConfigurationIndexMap = new HashMap<JointReadOnly, int[]>();
        int currentDoFIndex = 0;
        int currentConfigurationIndex = 0;
        for (JointReadOnly jointReadOnly : indexedJointsInOrder) {
            int[] dofIndices = new int[jointReadOnly.getDegreesOfFreedom()];
            for (int i = 0; i < jointReadOnly.getDegreesOfFreedom(); ++i) {
                dofIndices[i] = currentDoFIndex++;
            }
            jointToDoFIndexMap.put(jointReadOnly, dofIndices);
            int[] configurationIndices = new int[jointReadOnly.getConfigurationMatrixSize()];
            for (int i = 0; i < jointReadOnly.getConfigurationMatrixSize(); ++i) {
                configurationIndices[i] = currentConfigurationIndex++;
            }
            jointToConfigurationIndexMap.put(jointReadOnly, configurationIndices);
        }
        return new JointMatrixIndexProvider(){

            @Override
            public List<? extends JointReadOnly> getIndexedJointsInOrder() {
                return indexedJointsInOrder;
            }

            @Override
            public int[] getJointDoFIndices(JointReadOnly joint) {
                return (int[])jointToDoFIndexMap.get(joint);
            }

            @Override
            public int[] getJointConfigurationIndices(JointReadOnly joint) {
                return (int[])jointToConfigurationIndexMap.get(joint);
            }
        };
    }
}

