/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class FloatingBaseRigidBodyDynamicsCalculator {
    private static final int large = 1000;
    private static final double tolerance = 1.0E-4;
    private final LinearSolverDense<DMatrixRMaj> pseudoInverseSolver = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
    private final DMatrixRMaj matrixTranspose = new DMatrixRMaj(1000, 1000);
    private final DMatrixRMaj tempObjective = new DMatrixRMaj(1000, 1000);

    public void computeJointAccelerationGivenContactForcesForFloatingSubsystem(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseGravityAndCoriolisVector, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj jointAccelerationsToPack, DMatrixRMaj contactForces) {
        this.tempObjective.set((DMatrixD1)floatingBaseGravityAndCoriolisVector);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)floatingBaseContactForceJacobianMatrix, (DMatrix1Row)contactForces, (DMatrix1Row)this.tempObjective);
        this.pseudoInverseSolver.setA((Matrix)floatingBaseMassMatrix);
        this.pseudoInverseSolver.solve((Matrix)this.tempObjective, (Matrix)jointAccelerationsToPack);
        CommonOps_DDRM.changeSign((DMatrixD1)jointAccelerationsToPack);
    }

    public void computeContactForcesGivenJointAccelerationsForFloatingSubsystem(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseGravityAndCoriolisVector, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj jointAccelerations, DMatrixRMaj contactForcesToPack) {
        CommonOps_DDRM.transpose((DMatrixRMaj)floatingBaseContactForceJacobianMatrix, (DMatrixRMaj)this.matrixTranspose);
        this.tempObjective.set((DMatrixD1)floatingBaseGravityAndCoriolisVector);
        CommonOps_DDRM.multAdd((DMatrix1Row)floatingBaseMassMatrix, (DMatrix1Row)jointAccelerations, (DMatrix1Row)this.tempObjective);
        this.pseudoInverseSolver.setA((Matrix)this.matrixTranspose);
        this.pseudoInverseSolver.solve((Matrix)this.tempObjective, (Matrix)contactForcesToPack);
        CommonOps_DDRM.changeSign((DMatrixD1)contactForcesToPack);
    }

    public static void computeJointTorquesGivenContactForcesAndJointAccelerations(DMatrixRMaj bodyMassMatrix, DMatrixRMaj bodyGravityAndCoriolisVector, DMatrixRMaj bodyContactForceJacobianMatrix, DMatrixRMaj jointAccelerations, DMatrixRMaj contactForces, DMatrixRMaj jointTorquesToPack) {
        jointTorquesToPack.set((DMatrixD1)bodyGravityAndCoriolisVector);
        CommonOps_DDRM.multAdd((DMatrix1Row)bodyMassMatrix, (DMatrix1Row)jointAccelerations, (DMatrix1Row)jointTorquesToPack);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)bodyContactForceJacobianMatrix, (DMatrix1Row)contactForces, (DMatrix1Row)jointTorquesToPack);
    }

    public boolean areFloatingBaseRigidBodyDynamicsSatisfied(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseGravityAndCoriolisVector, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj bodyMassMatrix, DMatrixRMaj bodyGravityAndCoriolisVector, DMatrixRMaj bodyContactForceJacobianMatrix, DMatrixRMaj jointAccelerations, DMatrixRMaj jointTorques, DMatrixRMaj contactForces) {
        if (!this.areFloatingBaseDynamicsSatisfied(floatingBaseMassMatrix, floatingBaseGravityAndCoriolisVector, floatingBaseContactForceJacobianMatrix, jointAccelerations, contactForces)) {
            return false;
        }
        return this.areActuatedDynamicsSatisfied(bodyMassMatrix, bodyGravityAndCoriolisVector, bodyContactForceJacobianMatrix, jointAccelerations, jointTorques, contactForces);
    }

    public boolean areFloatingBaseDynamicsSatisfied(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseGravityAndCoriolisVector, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj jointAccelerations, DMatrixRMaj contactForces) {
        this.tempObjective.set((DMatrixD1)floatingBaseGravityAndCoriolisVector);
        CommonOps_DDRM.multAdd((DMatrix1Row)floatingBaseMassMatrix, (DMatrix1Row)jointAccelerations, (DMatrix1Row)this.tempObjective);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)floatingBaseContactForceJacobianMatrix, (DMatrix1Row)contactForces, (DMatrix1Row)this.tempObjective);
        return MatrixFeatures_DDRM.isZeros((DMatrixD1)this.tempObjective, (double)1.0E-4);
    }

    public boolean areActuatedDynamicsSatisfied(DMatrixRMaj bodyMassMatrix, DMatrixRMaj bodyGravityAndCoriolisVector, DMatrixRMaj bodyContactForceJacobianMatrix, DMatrixRMaj jointAccelerations, DMatrixRMaj jointTorques, DMatrixRMaj contactForces) {
        this.tempObjective.set((DMatrixD1)bodyGravityAndCoriolisVector);
        CommonOps_DDRM.multAdd((DMatrix1Row)bodyMassMatrix, (DMatrix1Row)jointAccelerations, (DMatrix1Row)this.tempObjective);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)bodyContactForceJacobianMatrix, (DMatrix1Row)contactForces, (DMatrix1Row)this.tempObjective);
        return MatrixFeatures_DDRM.isEquals((DMatrixD1)this.tempObjective, (DMatrixD1)jointTorques, (double)1.0E-4);
    }
}

