/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.LinkedHashMap;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.algorithms.interfaces.MassMatrixCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class DifferentialIDMassMatrixCalculator
implements MassMatrixCalculator {
    private final InverseDynamicsCalculator idCalculator;
    private final JointBasics[] jointsInOrder;
    private final DMatrixRMaj massMatrix;
    private final DMatrixRMaj storedJointDesiredAccelerations;
    private final DMatrixRMaj tmpDesiredJointAccelerationsMatrix;
    private final DMatrixRMaj tmpTauMatrix;
    private final LinkedHashMap<JointBasics, Wrench> storedJointWrenches = new LinkedHashMap();
    private final DMatrixRMaj storedJointVelocities;
    private final int totalNumberOfDoFs;

    public DifferentialIDMassMatrixCalculator(ReferenceFrame inertialFrame, RigidBodyBasics rootBody) {
        SpatialAccelerationReadOnly zeroRootAcceleration = MecanoFactories.newGravitationalSpatialAcceleration(rootBody, 0.0);
        this.idCalculator = new InverseDynamicsCalculator(rootBody);
        this.idCalculator.setConsiderCoriolisAndCentrifugalForces(false);
        this.idCalculator.setConsiderJointAccelerations(true);
        this.idCalculator.setRootAcceleration(zeroRootAcceleration);
        this.jointsInOrder = MultiBodySystemTools.collectSubtreeJoints(rootBody);
        this.totalNumberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom(this.jointsInOrder);
        this.massMatrix = new DMatrixRMaj(this.totalNumberOfDoFs, this.totalNumberOfDoFs);
        this.storedJointDesiredAccelerations = new DMatrixRMaj(this.totalNumberOfDoFs, 1);
        this.storedJointVelocities = new DMatrixRMaj(this.totalNumberOfDoFs, 1);
        this.tmpDesiredJointAccelerationsMatrix = new DMatrixRMaj(this.totalNumberOfDoFs, 1);
        this.tmpTauMatrix = new DMatrixRMaj(this.totalNumberOfDoFs, 1);
        for (JointBasics joint : this.jointsInOrder) {
            MovingReferenceFrame bodyFixedFrame = joint.getSuccessor().getBodyFixedFrame();
            Wrench jointWrench = new Wrench((ReferenceFrame)bodyFixedFrame, bodyFixedFrame);
            this.storedJointWrenches.put(joint, jointWrench);
        }
    }

    @Override
    public void compute() {
        this.storeJointState();
        this.setDesiredAccelerationsToZero();
        int column = 0;
        for (int i = 0; i < this.totalNumberOfDoFs; ++i) {
            this.tmpDesiredJointAccelerationsMatrix.set(i, 0, 1.0);
            MultiBodySystemTools.insertJointsState(this.jointsInOrder, JointStateType.ACCELERATION, (DMatrix)this.tmpDesiredJointAccelerationsMatrix);
            this.idCalculator.compute();
            this.tmpTauMatrix.set((DMatrixD1)this.idCalculator.getJointTauMatrix());
            CommonOps_DDRM.extract((DMatrix)this.tmpTauMatrix, (int)0, (int)this.totalNumberOfDoFs, (int)0, (int)1, (DMatrix)this.massMatrix, (int)0, (int)column);
            ++column;
            this.tmpDesiredJointAccelerationsMatrix.set(i, 0, 0.0);
        }
        this.restoreJointState();
    }

    private void setDesiredAccelerationsToZero() {
        for (JointBasics joint : this.jointsInOrder) {
            joint.setJointAccelerationToZero();
            joint.setJointVelocity(0, (DMatrix)new DMatrixRMaj(joint.getDegreesOfFreedom(), 1));
        }
    }

    private void storeJointState() {
        MultiBodySystemTools.extractJointsState(this.jointsInOrder, JointStateType.ACCELERATION, (DMatrix)this.storedJointDesiredAccelerations);
        MultiBodySystemTools.extractJointsState(this.jointsInOrder, JointStateType.VELOCITY, (DMatrix)this.storedJointVelocities);
        for (JointBasics joint : this.jointsInOrder) {
            DMatrixRMaj tauMatrix = new DMatrixRMaj(joint.getDegreesOfFreedom(), 1);
            joint.getJointTau(0, (DMatrix)tauMatrix);
            DMatrixRMaj spatialForce = new DMatrixRMaj(6, 1);
            DMatrixRMaj motionSubspace = new DMatrixRMaj(6, joint.getDegreesOfFreedom());
            joint.getMotionSubspace((DMatrix1Row)motionSubspace);
            CommonOps_DDRM.mult((DMatrix1Row)motionSubspace, (DMatrix1Row)tauMatrix, (DMatrix1Row)spatialForce);
            Wrench jointWrench = this.storedJointWrenches.get(joint);
            jointWrench.setIncludingFrame(joint.getFrameAfterJoint(), (DMatrix)spatialForce);
            jointWrench.changeFrame(joint.getFrameAfterJoint());
        }
    }

    private void restoreJointState() {
        MultiBodySystemTools.insertJointsState(this.jointsInOrder, JointStateType.ACCELERATION, (DMatrix)this.storedJointDesiredAccelerations);
        MultiBodySystemTools.insertJointsState(this.jointsInOrder, JointStateType.VELOCITY, (DMatrix)this.storedJointVelocities);
        for (JointBasics joint : this.jointsInOrder) {
            joint.setJointWrench(this.storedJointWrenches.get(joint));
        }
    }

    @Override
    public DMatrixRMaj getMassMatrix() {
        return this.massMatrix;
    }

    @Override
    public void getMassMatrix(DMatrixRMaj massMatrixToPack) {
        massMatrixToPack.set((DMatrixD1)this.massMatrix);
    }

    @Override
    public JointBasics[] getJointsInOrder() {
        return this.jointsInOrder;
    }
}

