/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class ArticulatedBodyInertiaAlorigthmTools {
    public static void translateAngularInertia(boolean negateTranslation, Tuple3DReadOnly translation, Matrix3DReadOnly linearInertia, Matrix3DReadOnly crossInertia, Matrix3DBasics angularInertiaToTranslate) {
        double z;
        double y;
        double x;
        if (negateTranslation) {
            x = -translation.getX();
            y = -translation.getY();
            z = -translation.getZ();
        } else {
            x = translation.getX();
            y = translation.getY();
            z = translation.getZ();
        }
        double xx = x * x;
        double yy = y * y;
        double zz = z * z;
        double xy = x * y;
        double xz = x * z;
        double yz = y * z;
        double mxx = linearInertia.getM00();
        double myy = linearInertia.getM11();
        double mzz = linearInertia.getM22();
        double mxy = linearInertia.getM01();
        double mxz = linearInertia.getM02();
        double myz = linearInertia.getM12();
        double ixx = angularInertiaToTranslate.getM00();
        double iyy = angularInertiaToTranslate.getM11();
        double izz = angularInertiaToTranslate.getM22();
        double ixy = angularInertiaToTranslate.getM01();
        double ixz = angularInertiaToTranslate.getM02();
        double iyz = angularInertiaToTranslate.getM12();
        double c00 = crossInertia.getM00();
        double c01 = crossInertia.getM01();
        double c02 = crossInertia.getM02();
        double c10 = crossInertia.getM10();
        double c11 = crossInertia.getM11();
        double c12 = crossInertia.getM12();
        double c20 = crossInertia.getM20();
        double c21 = crossInertia.getM21();
        double c22 = crossInertia.getM22();
        ixx += yy * mzz + zz * myy - 2.0 * yz * myz;
        iyy += xx * mzz + zz * mxx - 2.0 * xz * mxz;
        izz += xx * myy + yy * mxx - 2.0 * xy * mxy;
        ixy += -zz * mxy - xy * mzz + xz * myz + yz * mxz;
        ixz += -yy * mxz + xy * myz - xz * myy + yz * mxy;
        iyz += -xx * myz + xy * mxz + xz * mxy - yz * mxx;
        angularInertiaToTranslate.set(ixx += 2.0 * (y * c02 - z * c01), ixy += -x * c02 + y * c12 + z * (c00 - c11), ixz += x * c01 - y * (c00 - c22) - z * c21, ixy, iyy += 2.0 * (-x * c12 + z * c10), iyz += x * (c11 - c22) - y * c10 + z * c20, ixz, iyz, izz += 2.0 * (x * c21 - y * c20));
    }

    public static void translateCrossInertia(boolean negateTranslation, Tuple3DReadOnly translation, Matrix3DReadOnly linearInertia, Matrix3DBasics crossInertiaToTranslate) {
        double z;
        double y;
        double x;
        if (negateTranslation) {
            x = -translation.getX();
            y = -translation.getY();
            z = -translation.getZ();
        } else {
            x = translation.getX();
            y = translation.getY();
            z = translation.getZ();
        }
        double mxx = linearInertia.getM00();
        double myy = linearInertia.getM11();
        double mzz = linearInertia.getM22();
        double mxy = linearInertia.getM01();
        double mxz = linearInertia.getM02();
        double myz = linearInertia.getM12();
        double c00 = crossInertiaToTranslate.getM00();
        double c01 = crossInertiaToTranslate.getM01();
        double c02 = crossInertiaToTranslate.getM02();
        double c10 = crossInertiaToTranslate.getM10();
        double c11 = crossInertiaToTranslate.getM11();
        double c12 = crossInertiaToTranslate.getM12();
        double c20 = crossInertiaToTranslate.getM20();
        double c21 = crossInertiaToTranslate.getM21();
        double c22 = crossInertiaToTranslate.getM22();
        crossInertiaToTranslate.set(c00 += y * mxz - z * mxy, c01 += y * myz - z * myy, c02 += y * mzz - z * myz, c10 += -x * mxz + z * mxx, c11 += -x * myz + z * mxy, c12 += -x * mzz + z * mxz, c20 += x * mxy - y * mxx, c21 += x * myy - y * mxy, c22 += x * myz - y * mxz);
    }
}

