/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialForceBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;

public class SpatialForce
implements SpatialForceBasics,
Settable<SpatialForce> {
    private final SpatialVector spatialVector = new SpatialVector();
    private final Point3D pointOfApplication = new Point3D();
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public SpatialForce() {
    }

    public SpatialForce(ReferenceFrame expressedInFrame) {
        this.setToZero(expressedInFrame);
    }

    public SpatialForce(ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.setIncludingFrame(expressedInFrame, angularPart, linearPart);
    }

    public SpatialForce(ReferenceFrame expressedInFrame, DMatrix matrix) {
        this.setIncludingFrame(expressedInFrame, matrix);
    }

    public SpatialForce(ReferenceFrame expressedInFrame, double[] array) {
        this.setIncludingFrame(expressedInFrame, array);
    }

    public SpatialForce(SpatialForceReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(SpatialForce other) {
        SpatialForceBasics.super.set((SpatialVectorReadOnly)other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame expressedInFrame) {
        this.spatialVector.setReferenceFrame(expressedInFrame);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.spatialVector.getReferenceFrame();
    }

    @Override
    public FixedFrameVector3DBasics getAngularPart() {
        return this.spatialVector.getAngularPart();
    }

    @Override
    public FixedFrameVector3DBasics getLinearPart() {
        return this.spatialVector.getLinearPart();
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        if (this.getReferenceFrame() == desiredFrame) {
            return;
        }
        this.getReferenceFrame().getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((RigidBodyTransformReadOnly)this.transformToDesiredFrame);
        this.setReferenceFrame(desiredFrame);
    }

    @Override
    public void applyTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
        } else {
            this.pointOfApplication.setToZero();
            this.pointOfApplication.applyTransform(transform);
            this.spatialVector.applyTransform(transform);
            this.addCrossToAngularPart((Tuple3DReadOnly)this.pointOfApplication, (Tuple3DReadOnly)this.getLinearPart());
        }
    }

    @Override
    public void applyInverseTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyInverseTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
        } else {
            this.pointOfApplication.setToZero();
            this.pointOfApplication.applyInverseTransform(transform);
            this.spatialVector.applyInverseTransform(transform);
            this.addCrossToAngularPart((Tuple3DReadOnly)this.pointOfApplication, (Tuple3DReadOnly)this.getLinearPart());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SpatialForceReadOnly) {
            return SpatialForceBasics.super.equals((SpatialForceReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getSpatialForceVectorString(this);
    }
}

