/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem;

import java.util.Collections;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteTwinsJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteTwinsJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class RevoluteTwinsJoint
implements RevoluteTwinsJointBasics {
    private final String name;
    private final String nameId;
    private final RigidBodyBasics predecessor;
    private RigidBodyBasics successor;
    private final MovingReferenceFrame beforeJointFrame;
    private final MovingReferenceFrame afterJointFrame;
    private final RevoluteJointBasics jointA;
    private final RevoluteJointBasics jointB;
    private final RevoluteJointBasics actuatedJoint;
    private final RevoluteJointBasics constrainedJoint;
    private final TwistReadOnly jointTwist;
    private final Twist unitJointTwist = new Twist();
    private final Twist unitSuccessorTwist = new Twist();
    private final Twist unitPredecessorTwist = new Twist();
    private final List<TwistReadOnly> unitTwists;
    private final SpatialAccelerationReadOnly jointAcceleration;
    private final SpatialAcceleration jointBiasAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration successorBiasAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitJointAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitSuccessorAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitPredecessorAcceleration = new SpatialAcceleration();
    private final Wrench unitJointWrench = new Wrench();
    private WrenchReadOnly jointWrench;
    private final int actuatedJointIndex;
    private final DMatrixRMaj constraintJacobian;
    private final DMatrixRMaj constraintConvectiveTerm = new DMatrixRMaj(2, 1);
    private double constraintRatio;
    private double constraintOffset;
    private final Vector3D rotationVector = new Vector3D();
    private double jointLimitLower = Double.NEGATIVE_INFINITY;
    private double jointLimitUpper = Double.POSITIVE_INFINITY;
    private double velocityLimitLower = Double.NEGATIVE_INFINITY;
    private double velocityLimitUpper = Double.POSITIVE_INFINITY;
    private double effortLimitLower = Double.NEGATIVE_INFINITY;
    private double effortLimitUpper = Double.POSITIVE_INFINITY;
    private double jointInternalLimitUpper;
    private double jointInternalLimitLower;
    private double jointInternalVelocityLimitUpper;
    private double jointInternalVelocityLimitLower;
    private final Twist deltaTwist = new Twist();
    private final Twist bodyTwist = new Twist();

    public RevoluteTwinsJoint(String name, RigidBodyBasics predecessor, String jointNameA, String jointNameB, String bodyNameAB, RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToA, Matrix3DReadOnly bodyInertiaAB, double bodyMassAB, RigidBodyTransformReadOnly bodyInertiaPoseAB, int actuatedJointIndex, double constraintRatio, double constraintOffset, Vector3DReadOnly jointAxis) {
        this(name, predecessor, jointNameA, jointNameB, bodyNameAB, transformAToPredecessor, transformBToA, bodyInertiaAB, bodyMassAB, bodyInertiaPoseAB, MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER, actuatedJointIndex, constraintRatio, constraintOffset, jointAxis);
    }

    public RevoluteTwinsJoint(String name, RigidBodyBasics predecessor, String jointNameA, String jointNameB, String bodyNameAB, RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToA, Matrix3DReadOnly bodyInertiaAB, double bodyMassAB, RigidBodyTransformReadOnly bodyInertiaPoseAB, MultiBodySystemFactories.RigidBodyBuilder rigidBodyBuilder, int actuatedJointIndex, double constraintRatio, double constraintOffset, Vector3DReadOnly jointAxis) {
        if (actuatedJointIndex < 0 || actuatedJointIndex > 1) {
            throw new IllegalArgumentException("The actuated joint index has to be either 0 or 1, was: " + actuatedJointIndex);
        }
        this.actuatedJointIndex = actuatedJointIndex;
        JointReadOnly.checkJointNameSanity(name);
        jointNameA = CrossFourBarJoint.getInternalName(name, jointNameA, "A");
        jointNameB = CrossFourBarJoint.getInternalName(name, jointNameB, "B");
        bodyNameAB = CrossFourBarJoint.getInternalName(name, bodyNameAB, "AB");
        if (bodyInertiaAB == null) {
            bodyInertiaAB = new Matrix3D();
        }
        if (bodyInertiaPoseAB == null) {
            bodyInertiaPoseAB = new RigidBodyTransform();
        }
        MovingReferenceFrame parentFrame = predecessor.isRootBody() ? predecessor.getBodyFixedFrame() : predecessor.getParentJoint().getFrameAfterJoint();
        RigidBody base = new RigidBody(name + "InternalBase", parentFrame);
        this.jointA = new RevoluteJoint(jointNameA, (RigidBodyBasics)base, transformAToPredecessor, jointAxis);
        RigidBodyBasics bodyAB = rigidBodyBuilder.build(bodyNameAB, this.jointA, bodyInertiaAB, bodyMassAB, bodyInertiaPoseAB);
        this.jointB = new RevoluteJoint(jointNameB, bodyAB, transformBToA, jointAxis);
        this.actuatedJoint = actuatedJointIndex == 0 ? this.jointA : this.jointB;
        this.constrainedJoint = actuatedJointIndex == 0 ? this.jointB : this.jointA;
        this.name = name;
        this.predecessor = predecessor;
        predecessor.addChildJoint(this);
        this.nameId = JointReadOnly.computeNameId(this);
        this.beforeJointFrame = this.jointA.getFrameBeforeJoint();
        this.afterJointFrame = this.jointB.getFrameAfterJoint();
        this.unitTwists = Collections.singletonList(this.unitJointTwist);
        this.jointTwist = MecanoFactories.newTwistReadOnly(this::getQd, this.unitJointTwist);
        this.jointAcceleration = MecanoFactories.newSpatialAccelerationVectorReadOnly(this::getQdd, this.unitJointAcceleration, this.jointBiasAcceleration);
        this.constraintRatio = constraintRatio;
        this.constraintOffset = constraintOffset;
        this.constraintJacobian = new DMatrixRMaj(2, 1);
        this.constraintJacobian.set(actuatedJointIndex, 0, 1.0);
        this.constraintJacobian.set(1 - actuatedJointIndex, 0, constraintRatio);
        this.updateJointLimits();
        this.updateVelocityLimits();
    }

    public RevoluteTwinsJoint(String name, RevoluteJointBasics[] revoluteTwinsJoints, int actuatedJointIndex, double constraintRatio, double constraintOffset) {
        if (revoluteTwinsJoints.length != 2) {
            throw new IllegalArgumentException("There must be exactly two revolute joints, was: " + revoluteTwinsJoints.length);
        }
        if (actuatedJointIndex < 0 || actuatedJointIndex > 1) {
            throw new IllegalArgumentException("The actuated joint index has to be either 0 or 1, was: " + actuatedJointIndex);
        }
        if (MultiBodySystemTools.computeDistanceToRoot(revoluteTwinsJoints[0].getPredecessor()) < MultiBodySystemTools.computeDistanceToRoot(revoluteTwinsJoints[1].getPredecessor())) {
            this.actuatedJointIndex = actuatedJointIndex;
            this.jointA = revoluteTwinsJoints[0];
            this.jointB = revoluteTwinsJoints[1];
        } else {
            this.actuatedJointIndex = 1 - actuatedJointIndex;
            this.jointA = revoluteTwinsJoints[1];
            this.jointB = revoluteTwinsJoints[0];
        }
        this.actuatedJoint = actuatedJointIndex == 0 ? this.jointA : this.jointB;
        this.constrainedJoint = actuatedJointIndex == 0 ? this.jointB : this.jointA;
        FrameVector3D jointBAxis = new FrameVector3D((FrameTuple3DReadOnly)this.jointB.getJointAxis());
        jointBAxis.changeFrame(this.jointA.getJointAxis().getReferenceFrame());
        if (this.jointA.getJointAxis().dot((FrameTuple3DReadOnly)jointBAxis) < 0.9999999) {
            throw new IllegalArgumentException(String.format("The axes of the joint %s and %s are not parallel.", this.jointA.getName(), this.jointB.getName()));
        }
        this.name = name;
        this.predecessor = this.jointA.getPredecessor();
        this.predecessor.getChildrenJoints().remove(this.jointA);
        this.predecessor.addChildJoint(this);
        this.beforeJointFrame = this.jointA.getFrameBeforeJoint();
        this.afterJointFrame = this.jointB.getFrameAfterJoint();
        this.nameId = JointReadOnly.computeNameId(this);
        this.unitTwists = Collections.singletonList(this.unitJointTwist);
        this.jointTwist = MecanoFactories.newTwistReadOnly(this::getQd, this.unitJointTwist);
        this.jointAcceleration = MecanoFactories.newSpatialAccelerationVectorReadOnly(this::getQdd, this.unitJointAcceleration, this.jointBiasAcceleration);
        this.constraintRatio = constraintRatio;
        this.constraintOffset = constraintOffset;
        this.constraintJacobian = new DMatrixRMaj(2, 1);
        this.constraintJacobian.set(actuatedJointIndex, 0, 1.0);
        this.constraintJacobian.set(1 - actuatedJointIndex, 0, constraintRatio);
        this.updateJointLimits();
        this.updateVelocityLimits();
    }

    private void updateJointLimits() {
        this.jointInternalLimitLower = RevoluteTwinsJointReadOnly.computeJointLimitLower(this);
        this.jointInternalLimitUpper = RevoluteTwinsJointReadOnly.computeJointLimitUpper(this);
        if (this.jointInternalLimitLower > this.jointInternalLimitUpper) {
            throw new IllegalStateException("The joint limits are inconsistent: [" + this.jointInternalLimitLower + ", " + this.jointInternalLimitUpper + "]. This probably means that limits for the joints A and B are incompatible given the constraint ratio.");
        }
    }

    private void updateVelocityLimits() {
        this.jointInternalVelocityLimitLower = RevoluteTwinsJointReadOnly.computeVelocityLimitLower(this);
        this.jointInternalVelocityLimitUpper = RevoluteTwinsJointReadOnly.computeVelocityLimitUpper(this);
        if (this.jointInternalVelocityLimitLower > this.jointInternalVelocityLimitUpper) {
            throw new IllegalStateException("The velocity limits are inconsistent: [" + this.jointInternalVelocityLimitLower + ", " + this.jointInternalVelocityLimitUpper + "]. This probably means that limits for the joints A and B are incompatible given the constraint ratio.");
        }
    }

    @Override
    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        this.jointWrench = MecanoFactories.newWrenchReadOnly(this::getTau, this.unitJointWrench);
    }

    @Override
    public void updateFrame() {
        double q_actuated = this.actuatedJoint.getQ();
        double qDot_actuated = this.actuatedJoint.getQd();
        double qDDot_actuated = this.actuatedJoint.getQdd();
        double q_constrained = this.constraintRatio * q_actuated + this.constraintOffset;
        double qDot_constrained = this.constraintRatio * qDot_actuated;
        double qDDot_constrained = this.constraintRatio * qDDot_actuated;
        this.constrainedJoint.setQ(q_constrained);
        this.constrainedJoint.setQd(qDot_constrained);
        this.constrainedJoint.setQdd(qDDot_constrained);
        this.jointA.updateFrame();
        this.jointB.updateFrame();
        this.updateMotionSubspace();
    }

    @Override
    public void updateMotionSubspace() {
        RevoluteTwinsJoint.updateUnitJointTwist(this, this.unitJointTwist);
        this.unitJointAcceleration.setIncludingFrame(this.unitJointTwist);
        RevoluteTwinsJoint.updateBiasAcceleration(this, this.deltaTwist, this.bodyTwist, this.jointBiasAcceleration);
        if (this.getSuccessor() != null) {
            this.unitSuccessorTwist.setIncludingFrame(this.unitJointTwist);
            this.unitSuccessorTwist.setBaseFrame(this.predecessor.getBodyFixedFrame());
            this.unitSuccessorTwist.setBodyFrame(this.successor.getBodyFixedFrame());
            this.unitSuccessorTwist.changeFrame(this.successor.getBodyFixedFrame());
            this.unitPredecessorTwist.setIncludingFrame(this.unitSuccessorTwist);
            this.unitPredecessorTwist.invert();
            this.unitPredecessorTwist.changeFrame(this.predecessor.getBodyFixedFrame());
            this.unitSuccessorAcceleration.setIncludingFrame(this.unitSuccessorTwist);
            this.unitPredecessorAcceleration.setIncludingFrame(this.unitPredecessorTwist);
            this.successorBiasAcceleration.setIncludingFrame(this.jointBiasAcceleration);
            this.successorBiasAcceleration.setBaseFrame(this.getPredecessor().getBodyFixedFrame());
            this.successorBiasAcceleration.setBodyFrame(this.getSuccessor().getBodyFixedFrame());
            this.successorBiasAcceleration.changeFrame(this.getSuccessor().getBodyFixedFrame());
            this.unitJointWrench.setIncludingFrame(this.actuatedJoint.getUnitJointTwist());
            this.unitJointWrench.changeFrame(this.afterJointFrame);
            this.unitJointWrench.setBodyFrame(this.getSuccessor().getBodyFixedFrame());
        }
    }

    public static void updateUnitJointTwist(RevoluteTwinsJointReadOnly joint, TwistBasics unitJointTwistToPack) {
        RevoluteJointReadOnly jointA = joint.getJointA();
        TwistReadOnly unitTwistA = jointA.getUnitJointTwist();
        RevoluteJointReadOnly jointB = joint.getJointB();
        TwistReadOnly unitTwistB = jointB.getUnitJointTwist();
        double jA = joint.getConstraintJacobian().get(0, 0);
        double jB = joint.getConstraintJacobian().get(1, 0);
        unitJointTwistToPack.setIncludingFrame(unitTwistA);
        unitJointTwistToPack.scale(jA);
        unitJointTwistToPack.setBodyFrame(jointB.getFrameBeforeJoint());
        unitJointTwistToPack.changeFrame(jointB.getFrameAfterJoint());
        unitJointTwistToPack.getAngularPart().scaleAdd(jB, (FrameTuple3DReadOnly)unitTwistB.getAngularPart(), (FrameTuple3DReadOnly)unitJointTwistToPack.getAngularPart());
        unitJointTwistToPack.getLinearPart().scaleAdd(jB, (FrameTuple3DReadOnly)unitTwistB.getLinearPart(), (FrameTuple3DReadOnly)unitJointTwistToPack.getLinearPart());
        unitJointTwistToPack.scale(1.0 / (jA + jB));
        unitJointTwistToPack.setBodyFrame(joint.getFrameAfterJoint());
    }

    public static void updateBiasAcceleration(RevoluteTwinsJointReadOnly joint, TwistBasics deltaTwist, TwistBasics bodyTwist, SpatialAccelerationBasics jointBiasAcceleration) {
        RevoluteJointReadOnly jointA = joint.getJointA();
        RevoluteJointReadOnly jointB = joint.getJointB();
        jointB.getFrameAfterJoint().getTwistRelativeToOther(jointA.getFrameAfterJoint(), deltaTwist);
        jointB.getFrameBeforeJoint().getTwistRelativeToOther(jointA.getFrameBeforeJoint(), bodyTwist);
        deltaTwist.changeFrame(jointB.getFrameAfterJoint());
        bodyTwist.changeFrame(jointB.getFrameAfterJoint());
        jointBiasAcceleration.setToZero(jointB.getFrameBeforeJoint(), joint.getFrameBeforeJoint(), jointA.getFrameAfterJoint());
        jointBiasAcceleration.changeFrame(jointB.getFrameAfterJoint(), deltaTwist, bodyTwist);
        jointBiasAcceleration.setBodyFrame(joint.getFrameAfterJoint());
    }

    @Override
    public RevoluteJointBasics getActuatedJoint() {
        return this.actuatedJoint;
    }

    @Override
    public RevoluteJointBasics getConstrainedJoint() {
        return this.constrainedJoint;
    }

    @Override
    public RevoluteJointBasics getJointA() {
        return this.jointA;
    }

    @Override
    public RevoluteJointBasics getJointB() {
        return this.jointB;
    }

    @Override
    public int getActuatedJointIndex() {
        return this.actuatedJointIndex;
    }

    @Override
    public double getConstraintRatio() {
        return this.constraintRatio;
    }

    @Override
    public double getConstraintOffset() {
        return this.constraintOffset;
    }

    public DMatrixRMaj getConstraintJacobian() {
        return this.constraintJacobian;
    }

    public DMatrixRMaj getConstraintConvectiveTerm() {
        return this.constraintConvectiveTerm;
    }

    @Override
    public MovingReferenceFrame getFrameBeforeJoint() {
        return this.beforeJointFrame;
    }

    @Override
    public MovingReferenceFrame getFrameAfterJoint() {
        return this.afterJointFrame;
    }

    @Override
    public RigidBodyBasics getPredecessor() {
        return this.predecessor;
    }

    @Override
    public RigidBodyBasics getSuccessor() {
        return this.successor;
    }

    @Override
    public MovingReferenceFrame getLoopClosureFrame() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameId() {
        return this.nameId;
    }

    @Override
    public void setupLoopClosure(RigidBodyBasics successor, RigidBodyTransformReadOnly transformFromSuccessorParentJoint) {
        throw new UnsupportedOperationException("Loop closure using a four bar joint has not been implemented.");
    }

    @Override
    public double getTau() {
        this.constrainedJoint.setTau(0.0);
        return this.actuatedJoint.getTau() / (1.0 + this.constraintRatio);
    }

    @Override
    public TwistReadOnly getUnitJointTwist() {
        return this.unitJointTwist;
    }

    @Override
    public TwistReadOnly getUnitSuccessorTwist() {
        return this.unitSuccessorTwist;
    }

    @Override
    public TwistReadOnly getUnitPredecessorTwist() {
        return this.unitPredecessorTwist;
    }

    @Override
    public SpatialAccelerationReadOnly getUnitJointAcceleration() {
        return this.unitJointAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getUnitSuccessorAcceleration() {
        return this.unitSuccessorAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getUnitPredecessorAcceleration() {
        return this.unitPredecessorAcceleration;
    }

    @Override
    public void getJointConfiguration(RigidBodyTransform jointConfigurationToPack) {
        this.afterJointFrame.getTransformToDesiredFrame(jointConfigurationToPack, this.beforeJointFrame);
    }

    @Override
    public TwistReadOnly getJointTwist() {
        return this.jointTwist;
    }

    @Override
    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    @Override
    public SpatialAccelerationReadOnly getJointAcceleration() {
        return this.jointAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getJointBiasAcceleration() {
        return this.jointBiasAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getSuccessorBiasAcceleration() {
        return this.successorBiasAcceleration;
    }

    @Override
    public void getPredecessorAcceleration(SpatialAccelerationBasics accelerationToPack) {
        throw new UnsupportedOperationException("Implement me!");
    }

    @Override
    public SpatialAccelerationReadOnly getPredecessorBiasAcceleration() {
        throw new UnsupportedOperationException("Implement me!");
    }

    @Override
    public WrenchReadOnly getJointWrench() {
        return this.jointWrench;
    }

    @Override
    public void setConstraintRatio(double constraintRatio) {
        this.constraintRatio = constraintRatio;
    }

    @Override
    public void setConstraintOffset(double constraintOffset) {
        this.constraintOffset = constraintOffset;
    }

    @Override
    public void setJointOrientation(Orientation3DReadOnly jointOrientation) {
        jointOrientation.getRotationVector((Vector3DBasics)this.rotationVector);
        this.setQ(this.rotationVector.dot((Tuple3DReadOnly)this.getJointAxis()));
    }

    @Override
    public void setJointLimitLower(double jointLimitLower) {
        this.jointLimitLower = jointLimitLower;
    }

    @Override
    public void setJointLimitUpper(double jointLimitUpper) {
        this.jointLimitUpper = jointLimitUpper;
    }

    @Override
    public void setVelocityLimitLower(double velocityLimitLower) {
        this.velocityLimitLower = velocityLimitLower;
    }

    @Override
    public void setVelocityLimitUpper(double velocityLimitUpper) {
        this.velocityLimitUpper = velocityLimitUpper;
    }

    @Override
    public void setEffortLimitLower(double effortLimitLower) {
        this.effortLimitLower = effortLimitLower;
    }

    @Override
    public void setEffortLimitUpper(double effortLimitUpper) {
        this.effortLimitUpper = effortLimitUpper;
    }

    @Override
    public double getJointLimitLower() {
        this.updateJointLimits();
        return Math.max(this.jointLimitLower, this.jointInternalLimitLower);
    }

    @Override
    public double getJointLimitUpper() {
        this.updateJointLimits();
        return Math.min(this.jointLimitUpper, this.jointInternalLimitUpper);
    }

    @Override
    public double getVelocityLimitLower() {
        this.updateVelocityLimits();
        return Math.max(this.velocityLimitLower, this.jointInternalVelocityLimitLower);
    }

    @Override
    public double getVelocityLimitUpper() {
        this.updateVelocityLimits();
        return Math.min(this.velocityLimitUpper, this.jointInternalVelocityLimitUpper);
    }

    @Override
    public double getEffortLimitLower() {
        return Math.max(RevoluteTwinsJointBasics.super.getEffortLimitLower(), this.effortLimitLower);
    }

    @Override
    public double getEffortLimitUpper() {
        return Math.min(RevoluteTwinsJointBasics.super.getEffortLimitUpper(), this.effortLimitUpper);
    }

    public String toString() {
        String qAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQ());
        String qdAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQd());
        String qddAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQdd());
        String tauAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getTau());
        return this.getClass().getSimpleName() + " " + this.getName() + ", q: " + qAsString + ", qd: " + qdAsString + ", qdd: " + qddAsString + ", tau: " + tauAsString;
    }

    public int hashCode() {
        return this.nameId.hashCode();
    }

    public static RevoluteTwinsJoint cloneRevoluteTwinsJoint(RevoluteTwinsJointReadOnly original, ReferenceFrame stationaryFrame, String cloneSuffix) {
        RigidBodyReadOnly originalPredecessor = original.getPredecessor();
        RigidBody clonePredecessor = new RigidBody(originalPredecessor.getName() + cloneSuffix, stationaryFrame);
        return RevoluteTwinsJoint.cloneRevoluteTwinsJoint(original, clonePredecessor, cloneSuffix);
    }

    public static RevoluteTwinsJoint cloneRevoluteTwinsJoint(RevoluteTwinsJointReadOnly original, RigidBodyBasics clonePredecessor, String cloneSuffix) {
        return (RevoluteTwinsJoint)MultiBodySystemFactories.DEFAULT_JOINT_BUILDER.cloneRevoluteTwinsJoint(original, cloneSuffix, clonePredecessor);
    }
}

