/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem;

import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FixedJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MecanoTools;

public class FixedJoint
implements FixedJointBasics {
    protected final String name;
    private final String nameId;
    protected final RigidBodyBasics predecessor;
    protected RigidBodyBasics successor;
    protected final MovingReferenceFrame jointFrame;
    private final TwistReadOnly jointTwist;
    private final SpatialAccelerationReadOnly jointAcceleration;
    private WrenchReadOnly jointWrench;
    protected MovingReferenceFrame loopClosureFrame = null;

    public FixedJoint(String name, RigidBodyBasics predecessor) {
        this(name, predecessor, null);
    }

    public FixedJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        if (name.contains(":")) {
            throw new IllegalArgumentException("A joint name can not contain ':'. Tried to construct a jonit with name " + name + ".");
        }
        this.name = name;
        this.predecessor = predecessor;
        this.jointFrame = MecanoFactories.newJointFrame(this, transformToParent, this.getName() + "Frame");
        this.nameId = predecessor.isRootBody() ? name : predecessor.getParentJoint().getNameId() + ":" + name;
        predecessor.addChildJoint(this);
        this.jointTwist = new Twist((ReferenceFrame)this.jointFrame, (ReferenceFrame)this.jointFrame, this.jointFrame);
        this.jointAcceleration = new SpatialAcceleration((ReferenceFrame)this.jointFrame, (ReferenceFrame)this.jointFrame, this.jointFrame);
    }

    @Override
    public MovingReferenceFrame getFrameBeforeJoint() {
        return this.jointFrame;
    }

    @Override
    public MovingReferenceFrame getFrameAfterJoint() {
        return this.jointFrame;
    }

    @Override
    public RigidBodyBasics getPredecessor() {
        return this.predecessor;
    }

    @Override
    public RigidBodyBasics getSuccessor() {
        return this.successor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameId() {
        return this.nameId;
    }

    @Override
    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        MovingReferenceFrame successorFrame = successor.getBodyFixedFrame();
        this.jointWrench = new Wrench((ReferenceFrame)successorFrame, this.jointFrame);
    }

    @Override
    public void setupLoopClosure(RigidBodyBasics successor, RigidBodyTransformReadOnly transformFromSuccessorParentJoint) {
        RigidBodyTransform transformToSuccessorParentJoint = new RigidBodyTransform(transformFromSuccessorParentJoint);
        transformToSuccessorParentJoint.invert();
        this.loopClosureFrame = MovingReferenceFrame.constructFrameFixedInParent(MecanoTools.capitalize(this.getName()) + "LoopClosureFrame", this.getFrameAfterJoint(), (RigidBodyTransformReadOnly)transformToSuccessorParentJoint);
        this.setSuccessor(successor);
        successor.addParentLoopClosureJoint(this);
    }

    @Override
    public TwistReadOnly getJointTwist() {
        return this.jointTwist;
    }

    @Override
    public SpatialAccelerationReadOnly getJointAcceleration() {
        return this.jointAcceleration;
    }

    @Override
    public WrenchReadOnly getJointWrench() {
        return this.jointWrench;
    }

    @Override
    public List<TwistReadOnly> getUnitTwists() {
        return Collections.emptyList();
    }

    @Override
    public MovingReferenceFrame getLoopClosureFrame() {
        return this.loopClosureFrame;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getName();
    }

    public int hashCode() {
        return this.nameId.hashCode();
    }
}

