/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodyGravityGradientCalculator {
    private final MultiBodySystemReadOnly input;
    private final DMatrixRMaj tauMatrix;
    private final DMatrixRMaj tauGradientMatrix;
    private final AlgorithmStep initialStep;
    private final Map<RigidBodyReadOnly, AlgorithmStep> rigidBodyToAlgorithmStepMap = new LinkedHashMap<RigidBodyReadOnly, AlgorithmStep>();
    private final FrameVector3D gravitationalAcceleration = new FrameVector3D();
    private boolean dirtyFlag = true;
    private final SpatialForce childExternalSpatialForce = new SpatialForce();
    private final FramePoint3D childCoM = new FramePoint3D();

    public MultiBodyGravityGradientCalculator(RigidBodyReadOnly rootBody) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody));
    }

    public MultiBodyGravityGradientCalculator(MultiBodySystemReadOnly input) {
        this.input = input;
        this.tauGradientMatrix = new DMatrixRMaj(input.getNumberOfDoFs(), input.getNumberOfDoFs());
        this.tauMatrix = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
        this.initialStep = new AlgorithmStep(input.getRootBody(), null, null);
        this.rigidBodyToAlgorithmStepMap.put(input.getRootBody(), this.initialStep);
        this.buildMultiBodyTree(this.initialStep, input.getJointsToIgnore());
        this.initialStep.includeIgnoredSubtreeInertia();
        this.gravitationalAcceleration.setToZero(input.getInertialFrame());
    }

    private List<AlgorithmStep> buildMultiBodyTree(AlgorithmStep parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        ArrayList<AlgorithmStep> algorithmSteps = new ArrayList<AlgorithmStep>();
        algorithmSteps.add(parent);
        List<JointReadOnly> childrenJoints = MultiBodySystemTools.sortLoopClosureInChildrenJoints(parent.rigidBody);
        for (JointReadOnly childJoint : childrenJoints) {
            RigidBodyReadOnly childBody;
            if (jointsToIgnore.contains(childJoint) || childJoint.isLoopClosure() || (childBody = childJoint.getSuccessor()) == null || this.rigidBodyToAlgorithmStepMap.containsKey(childBody)) continue;
            int[] jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(childJoint);
            AlgorithmStep child = new AlgorithmStep(childBody, parent, jointIndices);
            this.rigidBodyToAlgorithmStepMap.put(childBody, child);
            algorithmSteps.addAll(this.buildMultiBodyTree(child, jointsToIgnore));
        }
        return algorithmSteps;
    }

    public void setGravitionalAcceleration(FrameTuple3DReadOnly gravity) {
        this.gravitationalAcceleration.set(gravity);
    }

    public void setGravitionalAcceleration(Tuple3DReadOnly gravity) {
        this.gravitationalAcceleration.setIncludingFrame(this.input.getInertialFrame(), gravity);
    }

    public void setGravitionalAcceleration(double gravity) {
        this.setGravitionalAcceleration(0.0, 0.0, gravity);
    }

    public void setGravitionalAcceleration(double gravityX, double gravityY, double gravityZ) {
        this.gravitationalAcceleration.setIncludingFrame(this.input.getInertialFrame(), gravityX, gravityY, gravityZ);
    }

    public void setExternalWrenchesToZero() {
        this.initialStep.setExternalWrenchToZeroRecursive();
    }

    public FixedFrameWrenchBasics getExternalWrench(RigidBodyReadOnly rigidBody) {
        return this.rigidBodyToAlgorithmStepMap.get((Object)rigidBody).externalWrench;
    }

    public void setExternalWrench(RigidBodyReadOnly rigidBody, WrenchReadOnly externalWrench) {
        this.getExternalWrench(rigidBody).setMatchingFrame(externalWrench);
    }

    public void reset() {
        this.dirtyFlag = true;
    }

    private void update() {
        if (!this.dirtyFlag) {
            return;
        }
        this.dirtyFlag = false;
        this.initialStep.passOne();
        this.initialStep.passTwo();
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public DMatrixRMaj getTauMatrix() {
        this.update();
        return this.tauMatrix;
    }

    public DMatrixRMaj getTauGradientMatrix() {
        this.update();
        return this.tauGradientMatrix;
    }

    private class AlgorithmStep {
        private final RigidBodyReadOnly rigidBody;
        private final SpatialInertia bodyInertia;
        private final int[] jointIndices;
        private final AlgorithmStep parent;
        private final List<AlgorithmStep> children = new ArrayList<AlgorithmStep>();
        private final FixedFrameWrenchBasics externalWrench;
        private boolean hasExternalWrench = false;
        private boolean hasSubTreeExternalWrench = false;
        private double subTreeMass;
        private final FramePoint3D subTreeCoM = new FramePoint3D();
        private final SpatialForce subTreeExternalSpatialForce = new SpatialForce();
        private final FrameVector3D gravityForceAtCoM = new FrameVector3D();
        private final Twist unitTwist_i = new Twist();
        private final SpatialVector descendantForce = new SpatialVector();
        private final FramePoint3D pointOfApplication = new FramePoint3D();

        public AlgorithmStep(RigidBodyReadOnly rigidBody, AlgorithmStep parent, int[] jointIndices) {
            this.rigidBody = rigidBody;
            this.parent = parent;
            this.jointIndices = jointIndices;
            if (this.isRoot()) {
                this.bodyInertia = null;
                this.externalWrench = null;
            } else {
                parent.children.add(this);
                this.bodyInertia = new SpatialInertia(rigidBody.getInertia());
                this.externalWrench = new Wrench((ReferenceFrame)this.getBodyFixedFrame(), this.getBodyFixedFrame());
            }
        }

        public void includeIgnoredSubtreeInertia() {
            if (!this.isRoot() && this.children.size() != this.rigidBody.getChildrenJoints().size()) {
                for (JointReadOnly jointReadOnly : this.rigidBody.getChildrenJoints()) {
                    if (!MultiBodyGravityGradientCalculator.this.input.getJointsToIgnore().contains(jointReadOnly)) continue;
                    SpatialInertia subtreeIneria = MultiBodySystemTools.computeSubtreeInertia(jointReadOnly);
                    subtreeIneria.changeFrame(this.rigidBody.getBodyFixedFrame());
                    this.bodyInertia.add(subtreeIneria);
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).includeIgnoredSubtreeInertia();
            }
        }

        public void setExternalWrenchToZeroRecursive() {
            if (!this.isRoot()) {
                this.externalWrench.setToZero();
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).setExternalWrenchToZeroRecursive();
            }
        }

        public void passOne() {
            int i;
            for (i = 0; i < this.children.size(); ++i) {
                this.children.get(i).passOne();
            }
            this.subTreeMass = this.bodyInertia == null ? 0.0 : this.bodyInertia.getMass();
            for (i = 0; i < this.children.size(); ++i) {
                this.subTreeMass += this.children.get((int)i).subTreeMass;
            }
            if (!this.isRoot()) {
                this.hasSubTreeExternalWrench = this.hasExternalWrench = this.externalWrench.getLinearPartX() != 0.0 || this.externalWrench.getLinearPartY() != 0.0 || this.externalWrench.getLinearPartZ() != 0.0 || this.externalWrench.getAngularPartX() != 0.0 || this.externalWrench.getAngularPartY() != 0.0 || this.externalWrench.getAngularPartZ() != 0.0;
                this.subTreeExternalSpatialForce.setIncludingFrame(this.externalWrench);
                this.subTreeExternalSpatialForce.changeFrame(this.getFrameAfterJoint());
                for (i = 0; i < this.children.size(); ++i) {
                    if (!this.children.get((int)i).hasSubTreeExternalWrench) continue;
                    MultiBodyGravityGradientCalculator.this.childExternalSpatialForce.setIncludingFrame(this.children.get((int)i).subTreeExternalSpatialForce);
                    MultiBodyGravityGradientCalculator.this.childExternalSpatialForce.changeFrame(this.getFrameAfterJoint());
                    this.subTreeExternalSpatialForce.add(MultiBodyGravityGradientCalculator.this.childExternalSpatialForce);
                    this.hasSubTreeExternalWrench = true;
                }
            }
            MovingReferenceFrame frameToUse = this.isRoot() ? this.getBodyFixedFrame() : this.getFrameAfterJoint();
            this.gravityForceAtCoM.setIncludingFrame((FrameTuple3DReadOnly)MultiBodyGravityGradientCalculator.this.gravitationalAcceleration);
            this.gravityForceAtCoM.scale(this.subTreeMass);
            this.gravityForceAtCoM.changeFrame((ReferenceFrame)frameToUse);
            if (this.bodyInertia == null) {
                this.subTreeCoM.setToZero((ReferenceFrame)this.getBodyFixedFrame());
            } else {
                this.subTreeCoM.setIncludingFrame((FrameTuple3DReadOnly)this.bodyInertia.getCenterOfMassOffset());
                this.subTreeCoM.changeFrame((ReferenceFrame)frameToUse);
                this.subTreeCoM.scale(this.bodyInertia.getMass());
            }
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                MultiBodyGravityGradientCalculator.this.childCoM.setIncludingFrame((FrameTuple3DReadOnly)this.children.get((int)i2).subTreeCoM);
                MultiBodyGravityGradientCalculator.this.childCoM.changeFrame((ReferenceFrame)frameToUse);
                this.subTreeCoM.scaleAdd(this.children.get((int)i2).subTreeMass, (FrameTuple3DReadOnly)MultiBodyGravityGradientCalculator.this.childCoM, (FrameTuple3DReadOnly)this.subTreeCoM);
            }
            this.subTreeCoM.scale(1.0 / this.subTreeMass);
        }

        public void passTwo() {
            int i;
            for (i = 0; i < this.children.size(); ++i) {
                this.children.get(i).passTwo();
            }
            if (this.isRoot()) {
                return;
            }
            for (i = 0; i < this.getNumberOfDoFs(); ++i) {
                int index_i = this.jointIndices[i];
                TwistReadOnly unitTwist_i = this.getUnitTwist(i);
                MultiBodyGravityGradientCalculator.this.tauMatrix.set(index_i, 0, this.computeTauElement(unitTwist_i));
                double gradient_ii = this.computeGravityGradientElement(unitTwist_i, unitTwist_i);
                MultiBodyGravityGradientCalculator.this.tauGradientMatrix.set(index_i, index_i, gradient_ii);
                for (int j = 0; j < i; ++j) {
                    int index_j = this.jointIndices[j];
                    TwistReadOnly unitTwist_j = this.getUnitTwist(j);
                    double n_gravity_ij = this.computeGravityGradientElement(unitTwist_i, unitTwist_j);
                    double n_gravity_ji = this.computeGravityGradientElement(unitTwist_j, unitTwist_i);
                    double n_extWrench_ij = this.computeSubTreeExtWrenchGradientElement(unitTwist_i, unitTwist_j, this);
                    MultiBodyGravityGradientCalculator.this.tauGradientMatrix.set(index_i, index_j, n_gravity_ij + n_extWrench_ij);
                    MultiBodyGravityGradientCalculator.this.tauGradientMatrix.set(index_j, index_i, n_gravity_ji - n_extWrench_ij);
                }
            }
            AlgorithmStep ancestor = this.parent;
            while (!ancestor.isRoot()) {
                for (int j = 0; j < this.getNumberOfDoFs(); ++j) {
                    int index_j = this.jointIndices[j];
                    TwistReadOnly unitTwist_j = this.getUnitTwist(j);
                    for (int i2 = 0; i2 < ancestor.getNumberOfDoFs(); ++i2) {
                        double gradient_ji;
                        int index_i = ancestor.jointIndices[i2];
                        this.unitTwist_i.setIncludingFrame(ancestor.getUnitTwist(i2));
                        this.unitTwist_i.changeFrame(this.getFrameAfterJoint());
                        double gradient_ij = gradient_ji = this.computeGravityGradientElement(unitTwist_j, this.unitTwist_i);
                        MultiBodyGravityGradientCalculator.this.tauGradientMatrix.set(index_i, index_j, gradient_ij);
                        MultiBodyGravityGradientCalculator.this.tauGradientMatrix.set(index_j, index_i, gradient_ji += this.computeSubTreeExtWrenchGradientElement(unitTwist_j, this.unitTwist_i, this));
                    }
                }
                ancestor = ancestor.parent;
            }
        }

        private double computeTauElement(TwistReadOnly unitTwist) {
            FrameVector3DReadOnly velocity = unitTwist.getLinearPart();
            FrameVector3DReadOnly omega = unitTwist.getAngularPart();
            double fx = -this.gravityForceAtCoM.getX();
            double fy = -this.gravityForceAtCoM.getY();
            double fz = -this.gravityForceAtCoM.getZ();
            double tx = this.subTreeCoM.getY() * fz - this.subTreeCoM.getZ() * fy - this.subTreeExternalSpatialForce.getAngularPartX();
            double ty = this.subTreeCoM.getZ() * fx - this.subTreeCoM.getX() * fz - this.subTreeExternalSpatialForce.getAngularPartY();
            double tz = this.subTreeCoM.getX() * fy - this.subTreeCoM.getY() * fx - this.subTreeExternalSpatialForce.getAngularPartZ();
            return TupleTools.dot((double)tx, (double)ty, (double)tz, (Tuple3DReadOnly)omega) + TupleTools.dot((double)(fx -= this.subTreeExternalSpatialForce.getLinearPartX()), (double)(fy -= this.subTreeExternalSpatialForce.getLinearPartY()), (double)(fz -= this.subTreeExternalSpatialForce.getLinearPartZ()), (Tuple3DReadOnly)velocity);
        }

        private double computeGravityGradientElement(TwistReadOnly unitTwist_i, TwistReadOnly unitTwist_j) {
            FrameVector3DReadOnly velocity_i = unitTwist_i.getLinearPart();
            FrameVector3DReadOnly omega_i = unitTwist_i.getAngularPart();
            FrameVector3DReadOnly omega_j = unitTwist_j.getAngularPart();
            double fx = -this.gravityForceAtCoM.getX();
            double fy = -this.gravityForceAtCoM.getY();
            double fz = -this.gravityForceAtCoM.getZ();
            double fxDot = fy * omega_j.getZ() - fz * omega_j.getY();
            double fyDot = fz * omega_j.getX() - fx * omega_j.getZ();
            double fzDot = fx * omega_j.getY() - fy * omega_j.getX();
            double txDot = this.subTreeCoM.getY() * fzDot - this.subTreeCoM.getZ() * fyDot;
            double tyDot = this.subTreeCoM.getZ() * fxDot - this.subTreeCoM.getX() * fzDot;
            double tzDot = this.subTreeCoM.getX() * fyDot - this.subTreeCoM.getY() * fxDot;
            return TupleTools.dot((double)txDot, (double)tyDot, (double)tzDot, (Tuple3DReadOnly)omega_i) + TupleTools.dot((double)fxDot, (double)fyDot, (double)fzDot, (Tuple3DReadOnly)velocity_i);
        }

        private double computeSubTreeExtWrenchGradientElement(TwistReadOnly unitTwist_i, TwistReadOnly unitTwist_j, AlgorithmStep start_k) {
            if (!start_k.hasSubTreeExternalWrench) {
                return 0.0;
            }
            double gradientElement = 0.0;
            if (start_k.hasExternalWrench) {
                gradientElement = this.computeSingleExtWrenchGradientElement(unitTwist_i, unitTwist_j, start_k);
            }
            for (int i = 0; i < start_k.children.size(); ++i) {
                AlgorithmStep child = start_k.children.get(i);
                gradientElement += this.computeSubTreeExtWrenchGradientElement(unitTwist_i, unitTwist_j, child);
            }
            return gradientElement;
        }

        private double computeSingleExtWrenchGradientElement(TwistReadOnly unitTwist_i, TwistReadOnly unitTwist_j, AlgorithmStep descendant_k) {
            this.descendantForce.setIncludingFrame(descendant_k.externalWrench);
            this.descendantForce.changeFrame(this.getFrameAfterJoint());
            this.pointOfApplication.setToZero((ReferenceFrame)descendant_k.getBodyFixedFrame());
            this.pointOfApplication.changeFrame((ReferenceFrame)this.getFrameAfterJoint());
            double fx = -this.descendantForce.getLinearPartX();
            double fy = -this.descendantForce.getLinearPartY();
            double fz = -this.descendantForce.getLinearPartZ();
            double tx = -this.descendantForce.getAngularPartX();
            double ty = -this.descendantForce.getAngularPartY();
            double tz = -this.descendantForce.getAngularPartZ();
            FrameVector3DReadOnly velocity_i = unitTwist_i.getLinearPart();
            FrameVector3DReadOnly velocity_j = unitTwist_j.getLinearPart();
            FrameVector3DReadOnly omega_i = unitTwist_i.getAngularPart();
            FrameVector3DReadOnly omega_j = unitTwist_j.getAngularPart();
            double dx = this.pointOfApplication.getX();
            double dy = this.pointOfApplication.getY();
            double dz = this.pointOfApplication.getZ();
            double fxDot_j = fy * omega_j.getZ() - fz * omega_j.getY();
            double fyDot_j = fz * omega_j.getX() - fx * omega_j.getZ();
            double fzDot_j = fx * omega_j.getY() - fy * omega_j.getX();
            double fxDot_i = fy * omega_i.getZ() - fz * omega_i.getY();
            double fyDot_i = fz * omega_i.getX() - fx * omega_i.getZ();
            double fzDot_i = fx * omega_i.getY() - fy * omega_i.getX();
            double txDot_j = dy * fzDot_j - dz * fyDot_j + ty * omega_j.getZ() - tz * omega_j.getY();
            double tyDot_j = dz * fxDot_j - dx * fzDot_j + tz * omega_j.getX() - tx * omega_j.getZ();
            double tzDot_j = dx * fyDot_j - dy * fxDot_j + tx * omega_j.getY() - ty * omega_j.getX();
            double txDot_i = dy * fzDot_i - dz * fyDot_i;
            double tyDot_i = dz * fxDot_i - dx * fzDot_i;
            double tzDot_i = dx * fyDot_i - dy * fxDot_i;
            double gradient_ijk = TupleTools.dot((double)txDot_j, (double)tyDot_j, (double)tzDot_j, (Tuple3DReadOnly)omega_i);
            gradient_ijk += TupleTools.dot((double)fxDot_j, (double)fyDot_j, (double)fzDot_j, (Tuple3DReadOnly)velocity_i);
            gradient_ijk -= TupleTools.dot((double)txDot_i, (double)tyDot_i, (double)tzDot_i, (Tuple3DReadOnly)omega_j);
            return gradient_ijk -= TupleTools.dot((double)fxDot_i, (double)fyDot_i, (double)fzDot_i, (Tuple3DReadOnly)velocity_j);
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public JointReadOnly getJoint() {
            return this.rigidBody.getParentJoint();
        }

        public int getNumberOfDoFs() {
            return this.getJoint().getDegreesOfFreedom();
        }

        public MovingReferenceFrame getFrameAfterJoint() {
            return this.getJoint().getFrameAfterJoint();
        }

        public TwistReadOnly getUnitTwist(int dofIndex) {
            return this.getJoint().getUnitTwists().get(dofIndex);
        }

        public MovingReferenceFrame getBodyFixedFrame() {
            return this.rigidBody.getBodyFixedFrame();
        }
    }
}

