/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class JointTorqueRegressorCalculator {
    private final MultiBodySystemReadOnly input;
    private final DMatrixRMaj jointTorqueRegressorMatrix;
    private final DMatrixRMaj parameterVector;
    private final InverseDynamicsCalculator inverseDynamicsCalculator;
    private final JointTorqueRegressorRecursionStep initialRecursionStep;
    private final JointTorqueRegressorRecursionStep[] jointTorqueRegressorRecursionSteps;
    private static final int PARAMETERS_PER_BODY = 10;

    public JointTorqueRegressorCalculator(RigidBodyBasics rootBody) {
        this(MultiBodySystemBasics.toMultiBodySystemBasics(rootBody));
    }

    public JointTorqueRegressorCalculator(MultiBodySystemBasics input) {
        this.input = input;
        this.inverseDynamicsCalculator = new InverseDynamicsCalculator(input);
        RigidBodyBasics rootBody = input.getRootBody();
        this.initialRecursionStep = new JointTorqueRegressorRecursionStep(rootBody, null, this.inverseDynamicsCalculator, null);
        this.jointTorqueRegressorRecursionSteps = this.buildMultiBodyTree(this.initialRecursionStep, input.getJointsToIgnore()).toArray(new JointTorqueRegressorRecursionStep[0]);
        int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom(input.getJointsToConsider());
        int nBodies = this.jointTorqueRegressorRecursionSteps.length;
        int nParams = 10 * nBodies;
        this.jointTorqueRegressorMatrix = new DMatrixRMaj(nDoFs, nParams);
        this.parameterVector = new DMatrixRMaj(nParams, 1);
        this.collectParameterVectorFromRecursionSteps();
    }

    private List<JointTorqueRegressorRecursionStep> buildMultiBodyTree(JointTorqueRegressorRecursionStep parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        ArrayList<JointTorqueRegressorRecursionStep> recursionSteps = new ArrayList<JointTorqueRegressorRecursionStep>();
        if (!parent.rigidBody.isRootBody()) {
            recursionSteps.add(parent);
        }
        List<JointReadOnly> childrenJoints = MultiBodySystemTools.sortLoopClosureInChildrenJoints(parent.rigidBody);
        for (JointReadOnly childJoint : childrenJoints) {
            if (jointsToIgnore.contains(childJoint)) continue;
            if (childJoint.isLoopClosure()) {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + ": This calculator does not support kinematic loops. Found loop closure at joint: " + childJoint.getName());
            }
            RigidBodyBasics childBody = (RigidBodyBasics)childJoint.getSuccessor();
            if (childBody == null) continue;
            int[] jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(childJoint);
            JointTorqueRegressorRecursionStep child = new JointTorqueRegressorRecursionStep(childBody, parent, this.inverseDynamicsCalculator, jointIndices);
            recursionSteps.addAll(this.buildMultiBodyTree(child, jointsToIgnore));
        }
        return recursionSteps;
    }

    public void compute() {
        this.initialRecursionStep.setSpatialInertiasToZeroRecursively();
        this.inverseDynamicsCalculator.initializeJointAccelerationMatrix(null);
        this.inverseDynamicsCalculator.initialRecursionStep.passOneRecursive();
        this.initialRecursionStep.calculateRegressorRecursively();
        this.collectJointTorqueRegressorFromRecursionSteps();
    }

    public void collectJointTorqueRegressorFromRecursionSteps() {
        int i = 0;
        for (JointTorqueRegressorRecursionStep step : this.jointTorqueRegressorRecursionSteps) {
            if (step.rigidBody.getInertia() == null) continue;
            CommonOps_DDRM.insert((DMatrix)step.regressorMatrixBlock, (DMatrix)this.jointTorqueRegressorMatrix, (int)0, (int)(i * 10));
            ++i;
        }
    }

    public void collectParameterVectorFromRecursionSteps() {
        int i = 0;
        for (JointTorqueRegressorRecursionStep step : this.jointTorqueRegressorRecursionSteps) {
            if (step.rigidBody.getInertia() == null) continue;
            CommonOps_DDRM.insert((DMatrix)step.parameterVector, (DMatrix)this.parameterVector, (int)(i * 10), (int)0);
            ++i;
        }
    }

    public void setGravitationalAcceleration(double gravity) {
        this.setGravitationalAcceleration(0.0, 0.0, gravity);
    }

    public void setGravitationalAcceleration(double gravityX, double gravityY, double gravityZ) {
        this.inverseDynamicsCalculator.setGravitationalAcceleration(gravityX, gravityY, gravityZ);
    }

    public DMatrixRMaj getParameterVector() {
        return this.parameterVector;
    }

    public DMatrixRMaj getJointTorqueRegressorMatrix() {
        return this.jointTorqueRegressorMatrix;
    }

    private class JointTorqueRegressorRecursionStep {
        private final RigidBodyBasics rigidBody;
        private final JointTorqueRegressorRecursionStep parent;
        private final List<JointTorqueRegressorRecursionStep> children = new ArrayList<JointTorqueRegressorRecursionStep>();
        private final DMatrixRMaj parameterVector;
        private InverseDynamicsCalculator inverseDynamicsCalculator;
        private SpatialInertiaParameterBasis spatialInertiaParameterBasis;
        private DMatrixRMaj regressorColumn;
        private DMatrixRMaj regressorMatrixBlock;
        private InverseDynamicsCalculator.RecursionStep inverseDynamicsRecursionStep;
        boolean isOnModifiedBranch;
        boolean isUpToDate;

        public JointTorqueRegressorRecursionStep(RigidBodyBasics rigidBody, JointTorqueRegressorRecursionStep parent, InverseDynamicsCalculator inverseDynamicsCalculator, int[] jointsToIgnore) {
            this.rigidBody = rigidBody;
            this.parent = parent;
            this.parameterVector = new DMatrixRMaj(10, 1);
            if (parent != null) {
                parent.children.add(this);
                this.spatialInertiaToParameterVector(rigidBody.getInertia(), this.parameterVector);
                this.inverseDynamicsCalculator = inverseDynamicsCalculator;
                this.spatialInertiaParameterBasis = new SpatialInertiaParameterBasis(this.rigidBody);
                this.regressorColumn = new DMatrixRMaj(inverseDynamicsCalculator.getJointTauMatrix().numRows, 1);
                this.inverseDynamicsRecursionStep = inverseDynamicsCalculator.rigidBodyToRecursionStepMap.get(rigidBody);
                this.regressorMatrixBlock = new DMatrixRMaj(inverseDynamicsCalculator.getJointTauMatrix().numRows, 10);
                this.isOnModifiedBranch = false;
                this.isUpToDate = false;
            }
        }

        public void setSpatialInertiasToZeroRecursively() {
            if (this.rigidBody.getInertia() != null) {
                this.rigidBody.getInertia().setToZero();
                this.inverseDynamicsCalculator.getBodyInertia(this.rigidBody).setToZero();
            }
            for (JointTorqueRegressorRecursionStep child : this.children) {
                child.setSpatialInertiasToZeroRecursively();
            }
        }

        public void calculateRegressorRecursively() {
            for (JointTorqueRegressorRecursionStep child : this.children) {
                child.calculateRegressorRecursively();
            }
            if (this.rigidBody.getInertia() != null) {
                this.markUpstreamAsModifiedRecursively();
                for (SpatialInertiaBasisOption basis : SpatialInertiaBasisOption.values()) {
                    this.spatialInertiaParameterBasis.setBasis(basis);
                    this.rigidBody.getInertia().set(this.spatialInertiaParameterBasis);
                    this.inverseDynamicsCalculator.getBodyInertia(this.rigidBody).set(this.spatialInertiaParameterBasis);
                    JointTorqueRegressorCalculator.this.initialRecursionStep.calculateInverseDynamicsToRootRecursively();
                    this.regressorColumn.set((DMatrixD1)this.inverseDynamicsCalculator.getJointTauMatrix());
                    this.setRegressorMatrixColumn(this.regressorColumn, basis);
                    this.rigidBody.getInertia().setToZero();
                    this.inverseDynamicsCalculator.getBodyInertia(this.rigidBody).setToZero();
                }
                JointTorqueRegressorCalculator.this.initialRecursionStep.clearModifiedMarkersRecursively();
                this.isUpToDate = false;
            }
        }

        public void calculateInverseDynamicsToRootRecursively() {
            for (JointTorqueRegressorRecursionStep child : this.children) {
                child.calculateInverseDynamicsToRootRecursively();
            }
            if (this.rigidBody.getInertia() != null && (this.isOnModifiedBranch || !this.isUpToDate)) {
                if (!this.isOnModifiedBranch) {
                    this.isUpToDate = true;
                }
                this.inverseDynamicsRecursionStep.passTwo();
            }
        }

        public void markUpstreamAsModifiedRecursively() {
            if (this.rigidBody.getInertia() != null) {
                this.isOnModifiedBranch = true;
                this.parent.markUpstreamAsModifiedRecursively();
            }
        }

        public void clearModifiedMarkersRecursively() {
            for (JointTorqueRegressorRecursionStep child : this.children) {
                child.clearModifiedMarkersRecursively();
            }
            this.isOnModifiedBranch = false;
        }

        public void setRegressorMatrixColumn(DMatrixRMaj regressorColumn, SpatialInertiaBasisOption basis) {
            CommonOps_DDRM.insert((DMatrix)regressorColumn, (DMatrix)this.regressorMatrixBlock, (int)0, (int)basis.ordinal());
        }

        private void spatialInertiaToParameterVector(SpatialInertiaBasics spatialInertia, DMatrixRMaj parameterVectorToPack) {
            parameterVectorToPack.set(0, 0, spatialInertia.getMass());
            parameterVectorToPack.set(1, 0, spatialInertia.getCenterOfMassOffset().getX());
            parameterVectorToPack.set(2, 0, spatialInertia.getCenterOfMassOffset().getY());
            parameterVectorToPack.set(3, 0, spatialInertia.getCenterOfMassOffset().getZ());
            parameterVectorToPack.set(4, 0, spatialInertia.getMomentOfInertia().getM00());
            parameterVectorToPack.set(5, 0, spatialInertia.getMomentOfInertia().getM01());
            parameterVectorToPack.set(6, 0, spatialInertia.getMomentOfInertia().getM02());
            parameterVectorToPack.set(7, 0, spatialInertia.getMomentOfInertia().getM11());
            parameterVectorToPack.set(8, 0, spatialInertia.getMomentOfInertia().getM12());
            parameterVectorToPack.set(9, 0, spatialInertia.getMomentOfInertia().getM22());
        }
    }

    static class SpatialInertiaParameterBasis
    extends SpatialInertia {
        public SpatialInertiaParameterBasis(RigidBodyBasics rigidBody) {
            super(rigidBody.getInertia().getBodyFrame(), rigidBody.getInertia().getReferenceFrame());
            this.setToZero();
        }

        public void setBasis(SpatialInertiaBasisOption basisOption) {
            this.setToZero();
            switch (basisOption) {
                case M: {
                    this.setMass(1.0);
                    break;
                }
                case MCOM_X: {
                    this.setCenterOfMassOffset(1.0, 0.0, 0.0);
                    break;
                }
                case MCOM_Y: {
                    this.setCenterOfMassOffset(0.0, 1.0, 0.0);
                    break;
                }
                case MCOM_Z: {
                    this.setCenterOfMassOffset(0.0, 0.0, 1.0);
                    break;
                }
                case I_XX: {
                    this.setMomentOfInertia(1.0, 0.0, 0.0);
                    break;
                }
                case I_XY: {
                    this.setMomentOfInertia(0.0, 1.0, 0.0, 0.0, 0.0, 0.0);
                    break;
                }
                case I_XZ: {
                    this.setMomentOfInertia(0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                    break;
                }
                case I_YY: {
                    this.setMomentOfInertia(0.0, 1.0, 0.0);
                    break;
                }
                case I_YZ: {
                    this.setMomentOfInertia(0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
                    break;
                }
                case I_ZZ: {
                    this.setMomentOfInertia(0.0, 0.0, 1.0);
                }
            }
        }

        @Override
        public void get(DMatrix matrixToPack) {
            this.get(0, 0, matrixToPack);
        }

        @Override
        public void get(int startRow, int startColumn, DMatrix matrixToPack) {
            this.getMomentOfInertia().get(startRow, startColumn, matrixToPack);
            MecanoTools.toTildeForm(1.0, (Tuple3DReadOnly)this.getCenterOfMassOffset(), false, startRow, startColumn + 3, matrixToPack);
            MecanoTools.toTildeForm(1.0, (Tuple3DReadOnly)this.getCenterOfMassOffset(), true, startRow + 3, startColumn, matrixToPack);
            startRow += 3;
            startColumn += 3;
            for (int i = 0; i < 3; ++i) {
                matrixToPack.set(startRow + i, startColumn + i, this.getMass());
                matrixToPack.set(startRow + i, startColumn + (i + 1) % 3, 0.0);
                matrixToPack.set(startRow + i, startColumn + (i + 2) % 3, 0.0);
            }
        }
    }

    public static enum SpatialInertiaBasisOption {
        M,
        MCOM_X,
        MCOM_Y,
        MCOM_Z,
        I_XX,
        I_XY,
        I_XZ,
        I_YY,
        I_YZ,
        I_ZZ;

        public static final SpatialInertiaBasisOption[] values;

        public static List<SpatialInertiaBasisOption> generateRandomBases(Random random) {
            ArrayList<SpatialInertiaBasisOption> result = new ArrayList<SpatialInertiaBasisOption>();
            for (SpatialInertiaBasisOption option : values) {
                if (!random.nextBoolean()) continue;
                result.add(option);
            }
            return result;
        }

        static {
            values = SpatialInertiaBasisOption.values();
        }
    }
}

