/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.FactorizedBodyInertia;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class CompositeRigidBodyMassMatrixCalculator {
    private final MultiBodySystemReadOnly input;
    private final CompositeRigidBodyInertia rootCompositeInertia;
    private final CompositeRigidBodyInertia[] compositeInertias;
    private final DMatrixRMaj massMatrix;
    private final DMatrixRMaj coriolisMatrix;
    private final SpatialInertia childInertia = new SpatialInertia();
    private final FactorizedBodyInertia childFactorizedInertia = new FactorizedBodyInertia();
    private final Twist intermediateTwist = new Twist();
    private final Wrench netCoriolisBodyWrench = new Wrench();
    private final SpatialForce centroidalConvectiveTerm = new SpatialForce();
    private final DMatrixRMaj centroidalConvectiveTermMatrix = new DMatrixRMaj(6, 1);
    private ReferenceFrame centroidalMomentumFrame;
    private final DMatrixRMaj centroidalMomentumMatrix;
    private boolean isMassMatrixUpToDate = false;
    private boolean enableCoriolisMatrixCalculation = false;
    private boolean isCentroidalMomentumMatrixUpToDate = false;
    private boolean isCentroidalConvectiveTermUpToDate = false;

    public CompositeRigidBodyMassMatrixCalculator(RigidBodyReadOnly rootBody) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody));
    }

    public CompositeRigidBodyMassMatrixCalculator(RigidBodyReadOnly rootBody, ReferenceFrame centroidalMomentumFrame) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody), centroidalMomentumFrame);
    }

    public CompositeRigidBodyMassMatrixCalculator(MultiBodySystemReadOnly input) {
        this(input, (ReferenceFrame)input.getRootBody().getBodyFixedFrame());
    }

    public CompositeRigidBodyMassMatrixCalculator(MultiBodySystemReadOnly input, ReferenceFrame centroidalMomentumFrame) {
        this(input, centroidalMomentumFrame, true);
    }

    public CompositeRigidBodyMassMatrixCalculator(MultiBodySystemReadOnly input, ReferenceFrame centroidalMomentumFrame, boolean considerIgnoredSubtreesInertia) {
        this.input = input;
        RigidBodyReadOnly rootBody = input.getRootBody();
        this.rootCompositeInertia = new CompositeRigidBodyInertia(rootBody, null, null);
        this.compositeInertias = this.buildMultiBodyTree(this.rootCompositeInertia, input.getJointsToIgnore()).toArray(new CompositeRigidBodyInertia[0]);
        if (considerIgnoredSubtreesInertia) {
            this.rootCompositeInertia.includeIgnoredSubtreeInertia();
        }
        int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom(input.getJointsToConsider());
        this.massMatrix = new DMatrixRMaj(nDoFs, nDoFs);
        this.coriolisMatrix = new DMatrixRMaj(nDoFs, nDoFs);
        this.centroidalMomentumMatrix = new DMatrixRMaj(6, nDoFs);
        this.setCentroidalMomentumFrame(centroidalMomentumFrame);
    }

    private List<CompositeRigidBodyInertia> buildMultiBodyTree(CompositeRigidBodyInertia parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        ArrayList<CompositeRigidBodyInertia> inertiaList = new ArrayList<CompositeRigidBodyInertia>();
        List<JointReadOnly> childrenJoints = MultiBodySystemTools.sortLoopClosureInChildrenJoints(parent.rigidBody);
        for (JointReadOnly childJoint : childrenJoints) {
            RigidBodyReadOnly childBody;
            if (jointsToIgnore.contains(childJoint) || childJoint.isLoopClosure() || (childBody = childJoint.getSuccessor()) == null) continue;
            int[] jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(childJoint);
            CompositeRigidBodyInertia child = new CompositeRigidBodyInertia(childBody, parent, jointIndices);
            inertiaList.add(child);
            inertiaList.addAll(this.buildMultiBodyTree(child, jointsToIgnore));
        }
        return inertiaList;
    }

    public void setEnableCoriolisMatrixCalculation(boolean enableCoriolisMatrixCalculation) {
        this.enableCoriolisMatrixCalculation = enableCoriolisMatrixCalculation;
    }

    public void reset() {
        this.isMassMatrixUpToDate = false;
        this.isCentroidalMomentumMatrixUpToDate = false;
        this.isCentroidalConvectiveTermUpToDate = false;
    }

    private void updateMassMatrix() {
        if (this.isMassMatrixUpToDate) {
            return;
        }
        this.massMatrix.zero();
        if (this.enableCoriolisMatrixCalculation) {
            this.coriolisMatrix.zero();
        }
        this.rootCompositeInertia.computeMassMatrix();
        this.isMassMatrixUpToDate = true;
    }

    private void updateCentroidalMomentumMatrix() {
        if (this.isCentroidalMomentumMatrixUpToDate) {
            return;
        }
        this.updateMassMatrix();
        for (CompositeRigidBodyInertia compositeInertia : this.compositeInertias) {
            compositeInertia.computeCentroidalMomentumMatrix();
        }
        this.isCentroidalMomentumMatrixUpToDate = true;
    }

    private void updateCentroidalConvectiveTerm() {
        if (this.isCentroidalConvectiveTermUpToDate) {
            return;
        }
        this.centroidalConvectiveTerm.setToZero(this.centroidalMomentumFrame);
        this.rootCompositeInertia.computeCentroidalConvectiveTerm();
        this.centroidalConvectiveTerm.get((DMatrix)this.centroidalConvectiveTermMatrix);
        this.isCentroidalConvectiveTermUpToDate = true;
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public DMatrixRMaj getMassMatrix() {
        this.updateMassMatrix();
        return this.massMatrix;
    }

    public DMatrixRMaj getCoriolisMatrix() {
        if (!this.enableCoriolisMatrixCalculation) {
            throw new UnsupportedOperationException("Coriolis matrix calculation is disabled.");
        }
        this.updateMassMatrix();
        return this.coriolisMatrix;
    }

    public void setCentroidalMomentumFrame(ReferenceFrame centroidalMomentumFrame) {
        if (centroidalMomentumFrame == this.centroidalMomentumFrame) {
            return;
        }
        this.centroidalMomentumFrame = centroidalMomentumFrame;
        this.isCentroidalMomentumMatrixUpToDate = false;
        this.isCentroidalConvectiveTermUpToDate = false;
    }

    public ReferenceFrame getCentroidalMomentumFrame() {
        return this.centroidalMomentumFrame;
    }

    public DMatrixRMaj getCentroidalMomentumMatrix() {
        this.updateCentroidalMomentumMatrix();
        return this.centroidalMomentumMatrix;
    }

    public SpatialForceReadOnly getCentroidalConvectiveTerm() {
        this.updateCentroidalConvectiveTerm();
        return this.centroidalConvectiveTerm;
    }

    public DMatrixRMaj getCentroidalConvectiveTermMatrix() {
        this.updateCentroidalConvectiveTerm();
        return this.centroidalConvectiveTermMatrix;
    }

    private class CompositeRigidBodyInertia {
        private final RigidBodyReadOnly rigidBody;
        private final SpatialInertia bodyInertia;
        private final SpatialInertia bodyInertiaAtJointFrame;
        private final CompositeRigidBodyInertia parent;
        private final List<CompositeRigidBodyInertia> children = new ArrayList<CompositeRigidBodyInertia>();
        private final int[] jointIndices;
        private final SpatialInertia compositeInertia;
        private final FactorizedBodyInertia compositeFactorizedInertia;
        private final Momentum[] F1;
        private final Momentum[] F2;
        private final Momentum[] F3;
        private final DMatrixRMaj motionSubspaceDot;
        private final Twist[] unitTwists;
        private final SpatialAcceleration[] unitTwistDots;
        private final SpatialAcceleration coriolisBodyAcceleration;
        private final RigidBodyTransform transformToParent = new RigidBodyTransform();

        public CompositeRigidBodyInertia(RigidBodyReadOnly rigidBody, CompositeRigidBodyInertia parent, int[] jointIndices) {
            this.rigidBody = rigidBody;
            this.parent = parent;
            this.jointIndices = jointIndices;
            if (parent == null) {
                this.bodyInertia = null;
                this.bodyInertiaAtJointFrame = null;
                this.compositeInertia = null;
                this.compositeFactorizedInertia = null;
                this.motionSubspaceDot = null;
                this.F1 = null;
                this.F2 = null;
                this.F3 = null;
                this.unitTwists = null;
                this.unitTwistDots = null;
                this.coriolisBodyAcceleration = new SpatialAcceleration((ReferenceFrame)this.getBodyFixedFrame(), CompositeRigidBodyMassMatrixCalculator.this.input.getInertialFrame(), this.getBodyFixedFrame());
            } else {
                parent.children.add(this);
                int nDoFs = this.getNumberOfDoFs();
                this.bodyInertia = new SpatialInertia(rigidBody.getInertia());
                this.bodyInertiaAtJointFrame = new SpatialInertia(rigidBody.getInertia());
                this.bodyInertiaAtJointFrame.changeFrame(this.getFrameAfterJoint());
                this.compositeInertia = new SpatialInertia();
                this.compositeFactorizedInertia = new FactorizedBodyInertia();
                this.motionSubspaceDot = this.getJoint().isMotionSubspaceVariable() ? new DMatrixRMaj(6, nDoFs) : null;
                this.F1 = new Momentum[nDoFs];
                this.F2 = new Momentum[nDoFs];
                this.F3 = new Momentum[nDoFs];
                this.unitTwists = new Twist[nDoFs];
                this.unitTwistDots = new SpatialAcceleration[nDoFs];
                for (int i = 0; i < nDoFs; ++i) {
                    this.F1[i] = new Momentum();
                    this.F2[i] = new Momentum();
                    this.F3[i] = new Momentum();
                    this.unitTwists[i] = new Twist();
                    this.unitTwistDots[i] = new SpatialAcceleration();
                    if (this.getJoint().isMotionSubspaceVariable()) continue;
                    this.unitTwists[i].setIncludingFrame(this.getJoint().getUnitTwists().get(i));
                    this.unitTwists[i].changeFrame(this.getFrameAfterJoint());
                }
                this.coriolisBodyAcceleration = new SpatialAcceleration();
            }
        }

        public void includeIgnoredSubtreeInertia() {
            if (!this.isRoot() && this.children.size() != this.rigidBody.getChildrenJoints().size()) {
                for (JointReadOnly jointReadOnly : this.rigidBody.getChildrenJoints()) {
                    if (!CompositeRigidBodyMassMatrixCalculator.this.input.getJointsToIgnore().contains(jointReadOnly)) continue;
                    SpatialInertia subtreeIneria = MultiBodySystemTools.computeSubtreeInertia(jointReadOnly);
                    subtreeIneria.changeFrame(this.getBodyFixedFrame());
                    this.bodyInertia.add(subtreeIneria);
                    subtreeIneria.changeFrame(this.getFrameAfterJoint());
                    this.bodyInertiaAtJointFrame.add(subtreeIneria);
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).includeIgnoredSubtreeInertia();
            }
        }

        public void computeMassMatrix() {
            CompositeRigidBodyInertia child;
            int i;
            if (!this.isRoot()) {
                if (!this.parent.isRoot()) {
                    this.getFrameAfterJoint().getTransformToDesiredFrame(this.transformToParent, this.parent.getFrameAfterJoint());
                }
                if (this.getJoint().isMotionSubspaceVariable()) {
                    for (i = 0; i < this.getNumberOfDoFs(); ++i) {
                        this.unitTwists[i].setIncludingFrame(this.getJoint().getUnitTwists().get(i));
                        this.unitTwists[i].changeFrame(this.getFrameAfterJoint());
                    }
                }
                if (CompositeRigidBodyMassMatrixCalculator.this.enableCoriolisMatrixCalculation) {
                    if (this.getJoint().isMotionSubspaceVariable()) {
                        this.getJoint().getMotionSubspaceDot((DMatrix1Row)this.motionSubspaceDot);
                    }
                    for (i = 0; i < this.getNumberOfDoFs(); ++i) {
                        this.unitTwistDots[i].setReferenceFrame(this.getFrameAfterJoint());
                        this.unitTwistDots[i].setBodyFrame(this.unitTwists[i].getBodyFrame());
                        this.unitTwistDots[i].setBaseFrame(this.unitTwists[i].getBaseFrame());
                        TwistReadOnly bodyTwist = this.getFrameAfterJoint().getTwistOfFrame();
                        if (this.getJoint().isMotionSubspaceVariable()) {
                            this.unitTwistDots[i].set(0, i, (DMatrix)this.motionSubspaceDot);
                            this.unitTwistDots[i].addCrossToAngularPart((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)this.unitTwists[i].getAngularPart());
                            this.unitTwistDots[i].addCrossToLinearPart((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DReadOnly)this.unitTwists[i].getAngularPart());
                            this.unitTwistDots[i].addCrossToLinearPart((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)this.unitTwists[i].getLinearPart());
                            continue;
                        }
                        this.unitTwistDots[i].getAngularPart().cross(bodyTwist.getAngularPart(), (FrameVector3DReadOnly)this.unitTwists[i].getAngularPart());
                        this.unitTwistDots[i].getLinearPart().cross(bodyTwist.getLinearPart(), (FrameVector3DReadOnly)this.unitTwists[i].getAngularPart());
                        this.unitTwistDots[i].addCrossToLinearPart((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)this.unitTwists[i].getLinearPart());
                    }
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).computeMassMatrix();
            }
            if (this.isRoot()) {
                return;
            }
            this.compositeInertia.setIncludingFrame(this.bodyInertiaAtJointFrame);
            for (i = 0; i < this.children.size(); ++i) {
                child = this.children.get(i);
                CompositeRigidBodyMassMatrixCalculator.this.childInertia.setIncludingFrame(child.compositeInertia);
                CompositeRigidBodyMassMatrixCalculator.this.childInertia.applyTransform((RigidBodyTransformReadOnly)child.transformToParent);
                CompositeRigidBodyMassMatrixCalculator.this.childInertia.setReferenceFrame(this.getFrameAfterJoint());
                this.compositeInertia.add(CompositeRigidBodyMassMatrixCalculator.this.childInertia);
            }
            for (i = 0; i < this.getNumberOfDoFs(); ++i) {
                this.F2[i].setReferenceFrame(this.getFrameAfterJoint());
                this.F2[i].compute(this.compositeInertia, this.unitTwists[i]);
            }
            if (CompositeRigidBodyMassMatrixCalculator.this.enableCoriolisMatrixCalculation) {
                CompositeRigidBodyMassMatrixCalculator.this.intermediateTwist.setIncludingFrame(this.getFrameAfterJoint().getTwistOfFrame());
                CompositeRigidBodyMassMatrixCalculator.this.intermediateTwist.setBodyFrame(this.getBodyFixedFrame());
                this.compositeFactorizedInertia.setIncludingFrame(this.bodyInertiaAtJointFrame, CompositeRigidBodyMassMatrixCalculator.this.intermediateTwist);
                for (i = 0; i < this.children.size(); ++i) {
                    child = this.children.get(i);
                    CompositeRigidBodyMassMatrixCalculator.this.childFactorizedInertia.setIncludingFrame(child.compositeFactorizedInertia);
                    CompositeRigidBodyMassMatrixCalculator.this.childFactorizedInertia.applyTransform(child.transformToParent);
                    CompositeRigidBodyMassMatrixCalculator.this.childFactorizedInertia.setReferenceFrame(this.getFrameAfterJoint());
                    this.compositeFactorizedInertia.add(CompositeRigidBodyMassMatrixCalculator.this.childFactorizedInertia);
                }
                for (i = 0; i < this.getNumberOfDoFs(); ++i) {
                    this.F1[i].setReferenceFrame(this.getFrameAfterJoint());
                    this.compositeInertia.transform(this.unitTwistDots[i], this.F1[i]);
                    this.compositeFactorizedInertia.addTransform(this.unitTwists[i], this.F1[i]);
                    this.F3[i].setReferenceFrame(this.getFrameAfterJoint());
                    this.compositeFactorizedInertia.transposeTransform(this.unitTwists[i], this.F3[i]);
                }
            }
            for (i = 0; i < this.getNumberOfDoFs(); ++i) {
                for (int j = 0; j < this.getNumberOfDoFs(); ++j) {
                    double massMatrix_ij = this.unitTwists[i].dot(this.F2[j]);
                    this.setSymmetricEntry(this.jointIndices[i], this.jointIndices[j], (DMatrix)CompositeRigidBodyMassMatrixCalculator.this.massMatrix, massMatrix_ij);
                }
            }
            if (CompositeRigidBodyMassMatrixCalculator.this.enableCoriolisMatrixCalculation) {
                for (i = 0; i < this.getNumberOfDoFs(); ++i) {
                    for (int j = 0; j < this.getNumberOfDoFs(); ++j) {
                        double coriolis_ij = this.unitTwists[i].dot(this.F1[j]);
                        CompositeRigidBodyMassMatrixCalculator.this.coriolisMatrix.set(this.jointIndices[i], this.jointIndices[j], coriolis_ij);
                        if (i == j) continue;
                        double coriolis_ji = this.unitTwistDots[i].dot(this.F2[j]) + this.unitTwists[i].dot(this.F3[j]);
                        CompositeRigidBodyMassMatrixCalculator.this.coriolisMatrix.set(this.jointIndices[j], this.jointIndices[i], coriolis_ji);
                    }
                }
            }
            if (CompositeRigidBodyMassMatrixCalculator.this.enableCoriolisMatrixCalculation) {
                CompositeRigidBodyInertia ancestor = this.parent;
                CompositeRigidBodyInertia previous = this;
                while (!ancestor.isRoot()) {
                    for (int j = 0; j < this.getNumberOfDoFs(); ++j) {
                        int index_j = this.jointIndices[j];
                        Momentum F1j = this.F1[j];
                        Momentum F2j = this.F2[j];
                        Momentum F3j = this.F3[j];
                        F1j.applyTransform((RigidBodyTransformReadOnly)previous.transformToParent);
                        F2j.applyTransform((RigidBodyTransformReadOnly)previous.transformToParent);
                        F3j.applyTransform((RigidBodyTransformReadOnly)previous.transformToParent);
                        F1j.setReferenceFrame(ancestor.getFrameAfterJoint());
                        F2j.setReferenceFrame(ancestor.getFrameAfterJoint());
                        F3j.setReferenceFrame(ancestor.getFrameAfterJoint());
                        for (int i2 = 0; i2 < ancestor.getNumberOfDoFs(); ++i2) {
                            int index_i = ancestor.jointIndices[i2];
                            double massMatrix_ij = ancestor.unitTwists[i2].dot(F2j);
                            this.setSymmetricEntry(index_i, index_j, (DMatrix)CompositeRigidBodyMassMatrixCalculator.this.massMatrix, massMatrix_ij);
                            double coriolis_ij = ancestor.unitTwists[i2].dot(F1j);
                            double coriolis_ji = ancestor.unitTwistDots[i2].dot(F2j) + ancestor.unitTwists[i2].dot(F3j);
                            CompositeRigidBodyMassMatrixCalculator.this.coriolisMatrix.set(index_i, index_j, coriolis_ij);
                            CompositeRigidBodyMassMatrixCalculator.this.coriolisMatrix.set(index_j, index_i, coriolis_ji);
                        }
                    }
                    previous = ancestor;
                    ancestor = ancestor.parent;
                }
            } else {
                CompositeRigidBodyInertia ancestor = this.parent;
                CompositeRigidBodyInertia previous = this;
                while (!ancestor.isRoot()) {
                    for (int j = 0; j < this.getNumberOfDoFs(); ++j) {
                        int index_j = this.jointIndices[j];
                        Momentum F2j = this.F2[j];
                        F2j.applyTransform((RigidBodyTransformReadOnly)previous.transformToParent);
                        F2j.setReferenceFrame(previous.parent.getFrameAfterJoint());
                        for (int i3 = 0; i3 < ancestor.getNumberOfDoFs(); ++i3) {
                            int index_i = ancestor.jointIndices[i3];
                            double massMatrix_ij = ancestor.unitTwists[i3].dot(F2j);
                            this.setSymmetricEntry(index_i, index_j, (DMatrix)CompositeRigidBodyMassMatrixCalculator.this.massMatrix, massMatrix_ij);
                        }
                    }
                    previous = ancestor;
                    ancestor = ancestor.parent;
                }
            }
        }

        public void computeCentroidalMomentumMatrix() {
            for (int dofIndex = 0; dofIndex < this.getNumberOfDoFs(); ++dofIndex) {
                Momentum unitMomentum = this.F2[dofIndex];
                unitMomentum.changeFrame(CompositeRigidBodyMassMatrixCalculator.this.centroidalMomentumFrame);
                unitMomentum.get(0, this.jointIndices[dofIndex], (DMatrix)CompositeRigidBodyMassMatrixCalculator.this.centroidalMomentumMatrix);
            }
        }

        public void computeCentroidalConvectiveTerm() {
            if (!this.isRoot()) {
                SpatialInertia inertia = this.bodyInertia;
                this.coriolisBodyAcceleration.setIncludingFrame(this.parent.coriolisBodyAcceleration);
                this.getJoint().getPredecessorTwist(CompositeRigidBodyMassMatrixCalculator.this.intermediateTwist);
                this.coriolisBodyAcceleration.changeFrame(this.getBodyFixedFrame(), CompositeRigidBodyMassMatrixCalculator.this.intermediateTwist, this.parent.getBodyFixedFrame().getTwistOfFrame());
                this.coriolisBodyAcceleration.setBodyFrame(this.getBodyFixedFrame());
                inertia.computeDynamicWrench(this.coriolisBodyAcceleration, this.getBodyFixedFrame().getTwistOfFrame(), CompositeRigidBodyMassMatrixCalculator.this.netCoriolisBodyWrench);
                CompositeRigidBodyMassMatrixCalculator.this.netCoriolisBodyWrench.changeFrame(CompositeRigidBodyMassMatrixCalculator.this.centroidalMomentumFrame);
                CompositeRigidBodyMassMatrixCalculator.this.centroidalConvectiveTerm.add(CompositeRigidBodyMassMatrixCalculator.this.netCoriolisBodyWrench);
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).computeCentroidalConvectiveTerm();
            }
        }

        public void setSymmetricEntry(int row, int col, DMatrix symmetricMatrix, double entry) {
            symmetricMatrix.set(row, col, entry);
            symmetricMatrix.set(col, row, entry);
        }

        private boolean isRoot() {
            return this.parent == null;
        }

        public int getNumberOfDoFs() {
            return this.getJoint().getDegreesOfFreedom();
        }

        private MovingReferenceFrame getFrameAfterJoint() {
            return this.getJoint().getFrameAfterJoint();
        }

        public MovingReferenceFrame getBodyFixedFrame() {
            return this.rigidBody.getBodyFixedFrame();
        }

        public JointReadOnly getJoint() {
            return this.rigidBody.getParentJoint();
        }

        public String toString() {
            return this.rigidBody.toString();
        }
    }
}

