/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;

public interface RevoluteTwinsJointReadOnly
extends OneDoFJointReadOnly {
    default public RevoluteJointReadOnly getActuatedJoint() {
        return this.getActuatedJointIndex() == 0 ? this.getJointA() : this.getJointB();
    }

    default public RevoluteJointReadOnly getConstrainedJoint() {
        return this.getActuatedJointIndex() == 0 ? this.getJointB() : this.getJointA();
    }

    public RevoluteJointReadOnly getJointA();

    public RevoluteJointReadOnly getJointB();

    default public RigidBodyReadOnly getBodyAB() {
        return this.getJointA().getSuccessor();
    }

    default public double computeActuatedJointQ(double q) {
        return (q - this.getConstraintOffset()) / (1.0 + this.getConstraintRatio());
    }

    default public double computeActuatedJointQd(double qDot) {
        return qDot / (1.0 + this.getConstraintRatio());
    }

    default public double computeActuatedJointQdd(double qDDot) {
        return qDDot / (1.0 + this.getConstraintRatio());
    }

    default public double computeActuatedJointTau(double tau) {
        return tau * (1.0 + this.getConstraintRatio());
    }

    public int getActuatedJointIndex();

    public DMatrix getConstraintJacobian();

    public DMatrix getConstraintConvectiveTerm();

    public double getConstraintRatio();

    public double getConstraintOffset();

    @Override
    default public boolean isMotionSubspaceVariable() {
        return true;
    }

    @Override
    default public FrameVector3DReadOnly getJointAxis() {
        return this.getActuatedJoint().getJointAxis();
    }

    @Override
    default public double getQ() {
        return this.getJointA().getQ() + this.getJointB().getQ();
    }

    @Override
    default public double getQd() {
        return this.getJointA().getQd() + this.getJointB().getQd();
    }

    @Override
    default public double getQdd() {
        return this.getJointA().getQdd() + this.getJointB().getQdd();
    }

    @Override
    default public double getJointLimitLower() {
        return RevoluteTwinsJointReadOnly.computeJointLimitLower(this);
    }

    public static double computeJointLimitLower(RevoluteTwinsJointReadOnly joint) {
        double qMinActuated = joint.getActuatedJoint().getJointLimitLower();
        double qMinConstrained = joint.getConstrainedJoint().getJointLimitLower();
        double ratio = joint.getConstraintRatio();
        double offset = joint.getConstraintOffset();
        double qMin1 = qMinActuated * (1.0 + ratio) + offset;
        double qMin2 = (qMinConstrained - offset) / ratio + qMinConstrained;
        return Math.max(qMin1, qMin2);
    }

    @Override
    default public double getJointLimitUpper() {
        return RevoluteTwinsJointReadOnly.computeJointLimitUpper(this);
    }

    public static double computeJointLimitUpper(RevoluteTwinsJointReadOnly joint) {
        double qMaxActuated = joint.getActuatedJoint().getJointLimitUpper();
        double qMaxConstrained = joint.getConstrainedJoint().getJointLimitUpper();
        double ratio = joint.getConstraintRatio();
        double offset = joint.getConstraintOffset();
        double qMax1 = qMaxActuated * (1.0 + ratio) + offset;
        double qMax2 = (qMaxConstrained - offset) / ratio + qMaxConstrained;
        return Math.min(qMax1, qMax2);
    }

    @Override
    default public double getVelocityLimitLower() {
        return RevoluteTwinsJointReadOnly.computeVelocityLimitLower(this);
    }

    public static double computeVelocityLimitLower(RevoluteTwinsJointReadOnly joint) {
        double qDotMinActuated = joint.getActuatedJoint().getVelocityLimitLower();
        double qDotMinConstrained = joint.getConstrainedJoint().getVelocityLimitLower();
        double ratio = joint.getConstraintRatio();
        return Math.max(qDotMinActuated * (1.0 + ratio), qDotMinConstrained * (1.0 + 1.0 / ratio));
    }

    @Override
    default public double getVelocityLimitUpper() {
        return RevoluteTwinsJointReadOnly.computeVelocityLimitUpper(this);
    }

    public static double computeVelocityLimitUpper(RevoluteTwinsJointReadOnly joint) {
        double qDotMaxActuated = joint.getActuatedJoint().getVelocityLimitUpper();
        double qDotMaxConstrained = joint.getConstrainedJoint().getVelocityLimitUpper();
        double ratio = joint.getConstraintRatio();
        return Math.min(qDotMaxActuated * (1.0 + ratio), qDotMaxConstrained * (1.0 + 1.0 / ratio));
    }

    @Override
    default public double getEffortLimitLower() {
        return this.getActuatedJoint().getEffortLimitLower();
    }

    @Override
    default public double getEffortLimitUpper() {
        return this.getActuatedJoint().getEffortLimitUpper();
    }
}

