/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.fourBar.FourBar;
import us.ihmc.mecano.fourBar.FourBarDiagonal;
import us.ihmc.mecano.fourBar.FourBarEdge;
import us.ihmc.mecano.fourBar.FourBarVertex;

public class FourBarTools {
    private static final double EPSILON = 1.0E-15;

    public static boolean isCrossFourBar(FourBar fourBar) {
        return fourBar.getEdgeAB().isCrossing() && fourBar.getEdgeCD().isCrossing() || fourBar.getEdgeDA().isCrossing() && fourBar.getEdgeBC().isCrossing();
    }

    public static boolean isCrossFourBar(FourBarVertex fourBarVertex) {
        FourBarVertex A = fourBarVertex;
        FourBarEdge ABEdge = A.getNextEdge();
        FourBarEdge BCEdge = ABEdge.getNext();
        FourBarEdge CDEdge = BCEdge.getNext();
        FourBarEdge DAEdge = CDEdge.getNext();
        return ABEdge.isCrossing() && CDEdge.isCrossing() || DAEdge.isCrossing() && BCEdge.isCrossing();
    }

    public static void setToMinAngle(FourBarVertex vertex) {
        vertex.setToMin();
        FourBarVertex nextVertex = vertex.getNextVertex();
        if (vertex.isConvex() == nextVertex.isConvex()) {
            nextVertex.setToMax();
        } else {
            nextVertex.setToMin();
        }
        FourBarVertex oppositeVertex = vertex.getOppositeVertex();
        if (vertex.isConvex() == oppositeVertex.isConvex()) {
            oppositeVertex.setToMin();
        } else {
            oppositeVertex.setToMax();
        }
        FourBarVertex previousVertex = vertex.getPreviousVertex();
        if (vertex.isConvex() == previousVertex.isConvex()) {
            previousVertex.setToMax();
        } else {
            previousVertex.setToMin();
        }
    }

    public static void setToMaxAngle(FourBarVertex vertex) {
        vertex.setToMax();
        FourBarVertex nextVertex = vertex.getNextVertex();
        if (vertex.isConvex() == nextVertex.isConvex()) {
            nextVertex.setToMin();
        } else {
            nextVertex.setToMax();
        }
        FourBarVertex oppositeVertex = vertex.getOppositeVertex();
        if (vertex.isConvex() == oppositeVertex.isConvex()) {
            oppositeVertex.setToMax();
        } else {
            oppositeVertex.setToMin();
        }
        FourBarVertex previousVertex = vertex.getPreviousVertex();
        if (vertex.isConvex() == previousVertex.isConvex()) {
            previousVertex.setToMin();
        } else {
            previousVertex.setToMax();
        }
    }

    public static Bound update(FourBarVertex vertex, double angle) {
        return FourBarTools.update(vertex, angle, Double.NaN, Double.NaN);
    }

    public static Bound update(FourBarVertex vertex, double angle, double angleDot) {
        return FourBarTools.update(vertex, angle, angleDot, Double.NaN);
    }

    public static Bound update(FourBarVertex vertex, double angle, double angleDot, double angleDDot) {
        double ACDt;
        double BDDt;
        double cosDBCDot;
        double cosABDDot;
        double cosBCDDot;
        Bound limit = null;
        FourBarVertex A = vertex;
        FourBarVertex B = vertex.getNextVertex();
        FourBarVertex C = vertex.getOppositeVertex();
        FourBarVertex D = vertex.getPreviousVertex();
        FourBarEdge ABEdge = A.getNextEdge();
        FourBarEdge BCEdge = B.getNextEdge();
        FourBarEdge CDEdge = C.getNextEdge();
        FourBarEdge DAEdge = D.getNextEdge();
        FourBarDiagonal ACDiag = A.getDiagonal();
        FourBarDiagonal BDDiag = B.getDiagonal();
        double AB = ABEdge.getLength();
        double BC = BCEdge.getLength();
        double CD = CDEdge.getLength();
        double DA = DAEdge.getLength();
        double BD = Double.NaN;
        double AC = Double.NaN;
        double cosDAB = Double.NaN;
        double cosBCD = Double.NaN;
        double cosDBC = Double.NaN;
        double cosABD = Double.NaN;
        double cosABC = Double.NaN;
        double sinABDSquare = Double.NaN;
        double sinABD = Double.NaN;
        double sinDBCSquare = Double.NaN;
        double sinDBC = Double.NaN;
        double sinBCDSquare = Double.NaN;
        double sinBCD = Double.NaN;
        if (angle <= A.getMinAngle() + 1.0E-15) {
            angle = A.getMinAngle();
            FourBarTools.setToMinAngle(A);
            limit = Bound.MIN;
        } else if (angle >= A.getMaxAngle() - 1.0E-15) {
            angle = A.getMaxAngle();
            FourBarTools.setToMaxAngle(A);
            limit = Bound.MAX;
        } else {
            A.setAngle(angle);
            cosDAB = EuclidCoreTools.cos((double)angle);
            BD = Math.sqrt(AB * AB + DA * DA - 2.0 * AB * DA * cosDAB);
            BDDiag.setLength(BD);
            cosBCD = FourBarTools.cosineAngleWithCosineLaw(BC, CD, BD);
            sinBCDSquare = 1.0 - cosBCD * cosBCD;
            sinBCD = Math.sqrt(sinBCDSquare);
            C.setAngle(FourBarTools.fastAcos(cosBCD, sinBCD));
            cosDBC = FourBarTools.cosineAngleWithCosineLaw(BC, BD, CD);
            cosABD = FourBarTools.cosineAngleWithCosineLaw(AB, BD, DA);
            sinABDSquare = 1.0 - cosABD * cosABD;
            sinABD = Math.sqrt(sinABDSquare);
            sinDBCSquare = 1.0 - cosDBC * cosDBC;
            sinDBC = Math.sqrt(sinDBCSquare);
            if (ABEdge.isCrossing() || BCEdge.isCrossing()) {
                if (!C.isConvex()) {
                    C.setAngle(-C.getAngle());
                }
                cosABC = EuclidCoreTools.clamp((double)(cosABD * cosDBC + sinABD * sinDBC), (double)1.0);
                B.setAngle(Math.abs(FourBarTools.fastAcos(cosABC)));
                if (!B.isConvex()) {
                    B.setAngle(-B.getAngle());
                }
                D.setAngle(-A.getAngle() - B.getAngle() - C.getAngle());
            } else {
                cosABC = EuclidCoreTools.clamp((double)(cosABD * cosDBC - sinABD * sinDBC), (double)1.0);
                B.setAngle(Math.abs(FourBarTools.fastAcos(cosABC)));
                D.setAngle(Math.PI * 2 - A.getAngle() - B.getAngle() - C.getAngle());
            }
            AC = Math.sqrt(AB * AB + BC * BC - 2.0 * AB * BC * cosABC);
            ACDiag.setLength(AC);
        }
        if (Double.isNaN(angleDot)) {
            return limit;
        }
        double sinDAB = Math.sin(A.getAngle());
        double sinABC = Math.sin(B.getAngle());
        if (EuclidCoreTools.isZero((double)angleDot, (double)1.0E-15)) {
            A.setAngleDot(0.0);
            B.setAngleDot(0.0);
            C.setAngleDot(0.0);
            D.setAngleDot(0.0);
            BDDiag.setLengthDot(0.0);
            ACDiag.setLengthDot(0.0);
            cosBCDDot = 0.0;
            cosABDDot = 0.0;
            cosDBCDot = 0.0;
            BDDt = 0.0;
            ACDt = 0.0;
        } else {
            if (limit != null) {
                cosABC = EuclidCoreTools.cos((double)B.getAngle());
                cosDAB = EuclidCoreTools.cos((double)A.getAngle());
                BD = Math.sqrt(AB * AB + DA * DA - 2.0 * AB * DA * cosDAB);
                AC = Math.sqrt(AB * AB + BC * BC - 2.0 * AB * BC * cosABC);
                cosBCD = Math.cos(C.getAngle());
                sinBCDSquare = 1.0 - cosBCD * cosBCD;
                sinBCD = Math.sqrt(sinBCDSquare);
                cosABD = FourBarTools.cosineAngleWithCosineLaw(AB, BD, DA);
                cosDBC = FourBarTools.cosineAngleWithCosineLaw(BC, BD, CD);
                sinABDSquare = 1.0 - cosABD * cosABD;
                sinABD = Math.sqrt(sinABDSquare);
                sinDBCSquare = 1.0 - cosDBC * cosDBC;
                sinDBC = Math.sqrt(sinDBCSquare);
                ACDiag.setLength(AC);
                BDDiag.setLength(BD);
            }
            A.setAngleDot(angleDot);
            BDDt = DA * AB * sinDAB * angleDot / BD;
            BDDiag.setLengthDot(BDDt);
            cosBCDDot = FourBarTools.cosineAngleDotWithCosineLaw(BC, CD, 0.0, BD, BDDt);
            C.setAngleDot(-cosBCDDot / sinBCD);
            if (!C.isConvex()) {
                C.setAngleDot(-C.getAngleDot());
            }
            cosABDDot = FourBarTools.cosineAngleDotWithCosineLaw(AB, BD, BDDt, DA, 0.0);
            double angleDtABD = -cosABDDot / sinABD;
            cosDBCDot = FourBarTools.cosineAngleDotWithCosineLaw(BC, BD, BDDt, CD, 0.0);
            double angleDtDBC = -cosDBCDot / sinDBC;
            if (ABEdge.isCrossing()) {
                angleDtABD = -angleDtABD;
            }
            if (BCEdge.isCrossing()) {
                angleDtDBC = -angleDtDBC;
            }
            B.setAngleDot(angleDtABD + angleDtDBC);
            if (!B.isConvex()) {
                B.setAngleDot(-B.getAngleDot());
            }
            D.setAngleDot(-A.getAngleDot() - B.getAngleDot() - C.getAngleDot());
            ACDt = AB * BC * sinABC * B.getAngleDot() / AC;
            ACDiag.setLengthDot(ACDt);
        }
        if (Double.isNaN(angleDDot)) {
            return limit;
        }
        if (EuclidCoreTools.isZero((double)angleDDot, (double)1.0E-15) && EuclidCoreTools.isZero((double)angleDot, (double)1.0E-15)) {
            A.setAngleDDot(0.0);
            B.setAngleDDot(0.0);
            C.setAngleDDot(0.0);
            D.setAngleDDot(0.0);
            BDDiag.setLengthDDot(0.0);
            ACDiag.setLengthDDot(0.0);
        } else {
            A.setAngleDDot(angleDDot);
            double BDDt2 = DA * AB / BD * (cosDAB * angleDot * angleDot + sinDAB * (angleDDot - BDDt * angleDot / BD));
            BDDiag.setLengthDDot(BDDt2);
            double cosBCDDt2 = FourBarTools.cosineAngleDDotWithCosineLaw(BC, CD, 0.0, 0.0, BD, BDDt, BDDt2);
            C.setAngleDDot(-(cosBCDDt2 * sinBCDSquare + cosBCDDot * cosBCDDot * cosBCD) / (sinBCDSquare * sinBCD));
            if (!C.isConvex()) {
                C.setAngleDDot(-C.getAngleDDot());
            }
            double cosABDDt2 = FourBarTools.cosineAngleDDotWithCosineLaw(AB, BD, BDDt, BDDt2, DA, 0.0, 0.0);
            double angleDt2ABD = -(cosABDDt2 * sinABDSquare + cosABDDot * cosABDDot * cosABD) / (sinABDSquare * sinABD);
            double cosDBCDt2 = FourBarTools.cosineAngleDDotWithCosineLaw(BC, BD, BDDt, BDDt2, CD, 0.0, 0.0);
            double angleDt2DBC = -(cosDBCDt2 * sinDBCSquare + cosDBCDot * cosDBCDot * cosDBC) / (sinDBCSquare * sinDBC);
            if (ABEdge.isCrossing()) {
                angleDt2ABD = -angleDt2ABD;
            }
            if (BCEdge.isCrossing()) {
                angleDt2DBC = -angleDt2DBC;
            }
            B.setAngleDDot(angleDt2ABD + angleDt2DBC);
            if (!B.isConvex()) {
                B.setAngleDDot(-B.getAngleDDot());
            }
            D.setAngleDDot(-A.getAngleDDot() - B.getAngleDDot() - C.getAngleDDot());
            double ACDt2 = AB * BC / AC * (cosABC * B.getAngleDot() * B.getAngleDot() + sinABC * (B.getAngleDDot() - ACDt * B.getAngleDot() / AC));
            ACDiag.setLengthDDot(ACDt2);
        }
        return limit;
    }

    public static void updateVertexLimits(FourBarVertex vertex) {
        double upperBound;
        double lowerBound;
        FourBarVertex A = vertex;
        FourBarEdge ABEdge = A.getNextEdge();
        FourBarEdge BCEdge = ABEdge.getNext();
        FourBarEdge CDEdge = BCEdge.getNext();
        FourBarEdge DAEdge = CDEdge.getNext();
        double AB = ABEdge.getLength();
        double BC = BCEdge.getLength();
        double CD = CDEdge.getLength();
        double DA = DAEdge.getLength();
        if (DAEdge.isCrossing()) {
            lowerBound = DA > AB && EuclidGeometryTools.isFormingTriangle((double)BC, (double)CD, (double)(DA - AB)) ? 0.0 : FourBarTools.angleWithCosineLaw(AB, DA, BC - CD);
            upperBound = DA > CD && EuclidGeometryTools.isFormingTriangle((double)AB, (double)(DA - CD), (double)BC) ? FourBarTools.angleWithCosineLaw(AB, DA - CD, BC) : Math.PI - FourBarTools.angleWithCosineLaw(BC - AB, DA, CD);
        } else if (ABEdge.isCrossing()) {
            lowerBound = AB > DA && EuclidGeometryTools.isFormingTriangle((double)BC, (double)CD, (double)(AB - DA)) ? 0.0 : FourBarTools.angleWithCosineLaw(DA, AB, CD - BC);
            upperBound = AB > BC && EuclidGeometryTools.isFormingTriangle((double)DA, (double)(AB - BC), (double)CD) ? FourBarTools.angleWithCosineLaw(DA, AB - BC, CD) : Math.PI - FourBarTools.angleWithCosineLaw(AB, CD - DA, BC);
        } else {
            double ACMax = Math.min(DA + CD, AB + BC);
            double BDMax = Math.min(BC + CD, DA + AB);
            lowerBound = DA + CD == ACMax ? FourBarTools.angleWithCosineLaw(ACMax, AB, BC) : FourBarTools.angleWithCosineLaw(ACMax, DA, CD);
            upperBound = DA + AB == BDMax ? Math.PI : FourBarTools.angleWithCosineLaw(DA, AB, BDMax);
        }
        if (A.isConvex()) {
            A.setMinAngle(lowerBound);
            A.setMaxAngle(upperBound);
        } else {
            A.setMinAngle(-upperBound);
            A.setMaxAngle(-lowerBound);
        }
    }

    public static void updateFourBarLimits(FourBarVertex vertex, double restriction) {
        if (restriction < 0.0) {
            throw new IllegalArgumentException("The restriction cannot be negative: " + restriction);
        }
        if (restriction == 0.0) {
            return;
        }
        FourBarVertex A = vertex;
        FourBarVertex B = A.getNextVertex();
        FourBarVertex C = B.getNextVertex();
        FourBarVertex D = C.getNextVertex();
        FourBarTools.update(A, A.getMinAngle() + restriction);
        A.setMinAngle(A.getAngle());
        if (A.isConvex() == B.isConvex()) {
            B.setMaxAngle(B.getAngle());
        } else {
            B.setMinAngle(B.getAngle());
        }
        if (A.isConvex() == C.isConvex()) {
            C.setMinAngle(C.getAngle());
        } else {
            C.setMaxAngle(C.getAngle());
        }
        if (A.isConvex() == D.isConvex()) {
            D.setMaxAngle(D.getAngle());
        } else {
            D.setMinAngle(D.getAngle());
        }
        FourBarTools.update(A, A.getMaxAngle() - restriction);
        A.setMaxAngle(A.getAngle());
        if (A.isConvex() == B.isConvex()) {
            B.setMinAngle(B.getAngle());
        } else {
            B.setMaxAngle(B.getAngle());
        }
        if (A.isConvex() == C.isConvex()) {
            C.setMaxAngle(C.getAngle());
        } else {
            C.setMinAngle(C.getAngle());
        }
        if (A.isConvex() == D.isConvex()) {
            D.setMinAngle(D.getAngle());
        } else {
            D.setMaxAngle(D.getAngle());
        }
    }

    public static double angleWithCosineLaw(double AB, double AC, double BC) {
        return FourBarTools.fastAcos(FourBarTools.cosineAngleWithCosineLaw(AB, AC, BC));
    }

    public static double cosineAngleWithCosineLaw(double AB, double AC, double BC) {
        double BCSquared;
        double ACSquared;
        if (AB < 0.0 || AC < 0.0 || BC < 0.0) {
            throw new IllegalArgumentException("The triangle side lengths cannot be negative: AB= " + AB + ", AC= " + AC + ", BC= " + BC);
        }
        double ABSquared = EuclidCoreTools.square((double)AB);
        double cosAngle = (ABSquared + (ACSquared = EuclidCoreTools.square((double)AC)) - (BCSquared = EuclidCoreTools.square((double)BC))) / (2.0 * AB * AC);
        if (cosAngle > 1.0) {
            cosAngle = 1.0;
        } else if (cosAngle < -1.0) {
            cosAngle = -1.0;
        }
        return cosAngle;
    }

    public static double angleDotWithCosineLaw(double AB, double AC, double ACDot, double BC, double BCDot) {
        double cosAngle = FourBarTools.cosineAngleWithCosineLaw(AB, AC, BC);
        return -FourBarTools.cosineAngleDotWithCosineLaw(AB, AC, ACDot, BC, BCDot) / Math.sqrt(1.0 - cosAngle * cosAngle);
    }

    public static double cosineAngleDotWithCosineLaw(double AB, double AC, double ACDot, double BC, double BCDot) {
        if (AB < 0.0 || AC < 0.0 || BC < 0.0) {
            throw new IllegalArgumentException("The triangle side lengths cannot be negative: AB= " + AB + ", AC= " + AC + ", BC= " + BC);
        }
        double ABSquared = EuclidCoreTools.square((double)AB);
        double ACSquared = EuclidCoreTools.square((double)AC);
        double BCSquared = EuclidCoreTools.square((double)BC);
        return (0.5 * (ACSquared - ABSquared + BCSquared) * ACDot - AC * BC * BCDot) / (ACSquared * AB);
    }

    public static double angleDDotWithCosineLaw(double AB, double AC, double ACDot, double ACDDot, double BC, double BCDot, double BCDDot) {
        double cosAngle = FourBarTools.cosineAngleWithCosineLaw(AB, AC, BC);
        double cosAngleSquared = EuclidCoreTools.square((double)cosAngle);
        double sinAngleSquared = 1.0 - cosAngleSquared;
        double sinAngle = Math.sqrt(sinAngleSquared);
        double cosAngleDot = FourBarTools.cosineAngleDotWithCosineLaw(AB, AC, ACDot, BC, BCDot);
        double cosAngleDotSquared = cosAngleDot * cosAngleDot;
        double cosAngleDDot = FourBarTools.cosineAngleDDotWithCosineLaw(AB, AC, ACDot, ACDDot, BC, BCDot, BCDDot);
        return -(cosAngleDDot * sinAngleSquared + cosAngleDotSquared * cosAngle) / (sinAngleSquared * sinAngle);
    }

    public static double cosineAngleDDotWithCosineLaw(double AB, double AC, double ACDot, double ACDDot, double BC, double BCDot, double BCDDot) {
        if (AB < 0.0 || AC < 0.0 || BC < 0.0) {
            throw new IllegalArgumentException("The triangle side lengths cannot be negative: AB= " + AB + ", AC= " + AC + ", BC= " + BC);
        }
        double ABSquared = EuclidCoreTools.square((double)AB);
        double ACSquared = EuclidCoreTools.square((double)AC);
        double ACCubed = ACSquared * AC;
        double BCSquared = EuclidCoreTools.square((double)BC);
        double BCDotSquared = EuclidCoreTools.square((double)BCDot);
        double ACDotSquared = EuclidCoreTools.square((double)ACDot);
        double cosAngleDDot = 0.5 * (ACCubed + AC * (BCSquared - ABSquared)) * ACDDot;
        cosAngleDDot += -ACSquared * (BCDotSquared + BC * BCDDot) + (ABSquared - BCSquared) * ACDotSquared + 2.0 * AC * ACDot * BC * BCDot;
        return cosAngleDDot /= ACCubed * AB;
    }

    public static double fastAcos(double cosX) {
        if (cosX == -1.0) {
            return Math.PI;
        }
        return 2.0 * Math.atan2(Math.sqrt(1.0 - cosX * cosX), 1.0 + cosX);
    }

    public static double fastAcos(double cosX, double sinX) {
        if (cosX == -1.0) {
            return Math.PI;
        }
        return 2.0 * Math.atan2(sinX, 1.0 + cosX);
    }
}

